/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.error.Error;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.Sortable;
import com.jaxfront.core.util.XMLSchemaPositionSorter;

public class ValidationErrorSorter
implements Sortable {
    private XMLSchemaPositionSorter _xmlSchemaPositionSorter;
    String[] errors = new String[]{"error", "incomplete", "warning", "info", "hint", "question"};

    public boolean compare(Object a, Object b) {
        if (a instanceof Error && b instanceof Error) {
            int i;
            Error A = (Error)a;
            Error B = (Error)b;
            String messageClassA = A.getClassification();
            String messageClassB = B.getClassification();
            int errorWeightA = 0;
            int errorWeightB = 0;
            for (i = 0; i < this.errors.length; ++i) {
                if (!this.errors[i].equals(messageClassA)) continue;
                errorWeightA = i;
                break;
            }
            for (i = 0; i < this.errors.length; ++i) {
                if (!this.errors[i].equals(messageClassB)) continue;
                errorWeightB = i;
                break;
            }
            if (errorWeightA == errorWeightB) {
                Type typeA = A.getErrorHolder();
                Type typeB = B.getErrorHolder();
                return this.getSchemaPositionSorter().compare(typeA, typeB);
            }
            if (errorWeightA < errorWeightB) {
                return true;
            }
            if (errorWeightA > errorWeightB) {
                return false;
            }
        }
        return false;
    }

    private XMLSchemaPositionSorter getSchemaPositionSorter() {
        if (this._xmlSchemaPositionSorter == null) {
            this._xmlSchemaPositionSorter = new XMLSchemaPositionSorter(false);
        }
        return this._xmlSchemaPositionSorter;
    }
}

