/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.io.FileChooseAction;
import com.jaxfront.core.util.io.FileFilter;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFileChooser;

public class FileSelector
implements FileChooseAction {
    private String _title = "";
    private FileChooseAction _aAction = null;
    public int _action = 0;
    public int _selectionMode = 2;
    private JFileChooser _fileChooser = null;
    public File[] _selection = null;
    private Color _backgroundColor = null;
    private boolean _hasSelectionChanged = false;

    public FileSelector(String title, int selectionMode) {
        this._title = title;
        this._selectionMode = selectionMode;
    }

    public FileSelector(String title) {
        this(title, 2);
    }

    public File[] getSelectedFiles() {
        return this._selection;
    }

    public File getSelectedFile() {
        if (this._selection != null && this._selection.length > 0) {
            return this._selection[0];
        }
        return null;
    }

    public URL getSelectedURL() {
        if (this._selection != null && this._selection.length > 0) {
            try {
                return this._selection[0].toURL();
            }
            catch (MalformedURLException e) {
                LogRegistry.getInstance().error(this.getClass(), e);
            }
        }
        return null;
    }

    public URL[] getSelectedURLs() {
        URL[] urls = null;
        if (this._selection != null) {
            urls = new URL[this._selection.length];
            for (int i = 0; i < this._selection.length; ++i) {
                try {
                    urls[i] = this._selection[i].toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    LogRegistry.getInstance().error(this.getClass(), e);
                }
            }
        }
        return urls;
    }

    public void setRootDir(File rootDir) {
        if (rootDir != null) {
            if (rootDir.isDirectory()) {
                this.getFileChooser().setCurrentDirectory(rootDir);
                this.getFileChooser().setSelectedFile(new File(""));
            } else {
                this.getFileChooser().setSelectedFile(rootDir);
            }
        }
    }

    public void setRootDir(String rootDir) {
        this.setRootDir(new File(rootDir));
    }

    private JFileChooser getFileChooser() {
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
        }
        return this._fileChooser;
    }

    public void showSaveDialog(Component comp) {
        JFileChooser chooser = this.getFileChooser();
        if (this.getBackgroundColor() != null) {
            chooser.setBackground(this.getBackgroundColor());
        }
        if (this._fileChooser.getSelectedFile() == null) {
            this.setRootDir(JAXFrontProperties.getInstance().getLastOpenedFolder().getFile());
        }
        chooser.setDialogType(1);
        chooser.setDialogTitle(this._title);
        this._action = chooser.showSaveDialog(comp);
        if (this._aAction == null) {
            this.handleSelection(chooser, this._action);
        } else {
            this._aAction.handleSelection(chooser, this._action);
        }
    }

    public void showOpenDialog(Component comp) {
        JFileChooser chooser = this.getFileChooser();
        if (this.getBackgroundColor() != null) {
            chooser.setBackground(this.getBackgroundColor());
        }
        if (JAXFrontProperties.getInstance().getLastOpenedFolder() != null) {
            this.setRootDir(JAXFrontProperties.getInstance().getLastOpenedFolder().getFile());
            this._fileChooser.setCurrentDirectory(new File(JAXFrontProperties.getInstance().getLastOpenedFolder().getFile()));
        }
        chooser.setDialogType(0);
        chooser.setDialogTitle(this._title);
        chooser.setFileSelectionMode(this._selectionMode);
        this._action = chooser.showOpenDialog(comp);
        if (this._aAction == null) {
            this.handleSelection(chooser, this._action);
        } else {
            this._aAction.handleSelection(chooser, this._action);
        }
    }

    public boolean hasSelectionChanged() {
        return this._hasSelectionChanged;
    }

    public void handleSelection(JFileChooser chooser, int takenAction) {
        if (takenAction == 1) {
            this._hasSelectionChanged = false;
        } else if (takenAction == 0) {
            if (chooser.getSelectedFile() != null) {
                this._selection = new File[1];
                this._selection[0] = chooser.getSelectedFile();
                if (!this.getFileChooser().getFileFilter().accept(this._selection[0])) {
                    this._selection[0] = new File(this._selection[0].getPath() + this.getFileChooser().getFileFilter().getDescription());
                }
            } else {
                this._selection = chooser.getSelectedFiles();
            }
            if (this._selection.length > 0) {
                try {
                    JAXFrontProperties.getInstance().setLastOpenedFolder(this._selection[0].toURL());
                    this._hasSelectionChanged = true;
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else if (takenAction == -1) {
            this._hasSelectionChanged = false;
        }
    }

    public void addFileFilter(FileFilter filter) {
        this.getFileChooser().addChoosableFileFilter(filter);
    }

    public void addFileFilter(String suffix, String description, boolean acceptsDirectories) {
        this.getFileChooser().addChoosableFileFilter(new FileFilter(suffix, description, acceptsDirectories));
    }

    public javax.swing.filechooser.FileFilter[] getFileFilter() {
        return this.getFileChooser().getChoosableFileFilters();
    }

    public void setCurrentFileFilter(String suffix, String description, boolean acceptsDirectories) {
        this.getFileChooser().addChoosableFileFilter(new FileFilter(suffix, description, acceptsDirectories));
    }

    public void setCurrentFileFilter(FileFilter filter) {
        this.getFileChooser().addChoosableFileFilter(filter);
    }

    public void removeFileFilter(FileFilter filter) {
        this.getFileChooser().removeChoosableFileFilter(filter);
    }

    public void setBackgroundColor(Color color) {
        this._backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this._backgroundColor;
    }
}

