/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;

public class XMLWriter {
    private Writer writer;
    private Stack stack;
    private StringBuffer attrs;
    private boolean empty;
    private boolean closed;

    public XMLWriter(Writer writer) {
        this.writer = writer;
        this.closed = true;
        this.stack = new Stack();
    }

    public XMLWriter writeEntity(String name) throws IOException {
        this.closeOpeningTag();
        this.closed = false;
        this.writer.write("<");
        this.writer.write(name);
        this.stack.add(name);
        this.empty = true;
        return this;
    }

    private void closeOpeningTag() throws IOException {
        if (!this.closed) {
            this.writeAttributes();
            this.closed = true;
            this.writer.write(">");
        }
    }

    private void writeAttributes() throws IOException {
        if (this.attrs != null) {
            this.writer.write(this.attrs.toString());
            this.attrs.setLength(0);
            this.empty = false;
        }
    }

    public XMLWriter writeAttribute(String attr, String value) {
        if (this.attrs == null) {
            this.attrs = new StringBuffer();
        }
        this.attrs.append(" ");
        this.attrs.append(attr);
        this.attrs.append("=\"");
        this.attrs.append(XMLWriter.escapeXml(value));
        this.attrs.append("\"");
        return this;
    }

    public XMLWriter endEntity() throws IOException {
        if (this.stack.empty()) {
            throw new IOException("Called endEntity too many times. ");
        }
        String name = (String)this.stack.pop();
        if (name != null) {
            if (this.empty) {
                this.writeAttributes();
                this.writer.write("/>");
            } else {
                this.writer.write("</");
                this.writer.write(name);
                this.writer.write(">");
            }
            this.empty = false;
        }
        return this;
    }

    public void close() throws IOException {
        if (!this.stack.empty()) {
            throw new IOException("Tags are not all closed. Possibly, " + this.stack.pop() + " is unclosed. ");
        }
    }

    public XMLWriter writeText(String text) throws IOException {
        this.closeOpeningTag();
        this.empty = false;
        this.writer.write(XMLWriter.escapeXml(text));
        return this;
    }

    public static String escapeXml(String str) {
        str = XMLWriter.replaceString(str, "&", "&amp;");
        str = XMLWriter.replaceString(str, "<", "&lt;");
        str = XMLWriter.replaceString(str, ">", "&gt;");
        str = XMLWriter.replaceString(str, "\"", "&quot;");
        str = XMLWriter.replaceString(str, "'", "&apos;");
        return str;
    }

    public static String replaceString(String text, String repl, String with) {
        return XMLWriter.replaceString(text, repl, with, -1);
    }

    public static String replaceString(String text, String repl, String with, int max) {
        if (text == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buffer.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        buffer.append(text.substring(start));
        return buffer.toString();
    }

    public static void main(String[] args) throws IOException {
        XMLWriter.test1();
        XMLWriter.test2();
    }

    public static void test1() throws IOException {
        StringWriter writer = new StringWriter();
        XMLWriter XMLWriter2 = new XMLWriter(writer);
        XMLWriter2.writeEntity("person").writeAttribute("name", "fred").writeAttribute("age", "12").writeEntity("phone").writeText("4254343").endEntity().writeEntity("bob").endEntity().endEntity();
        XMLWriter2.close();
        System.err.println(((Object)writer).toString());
    }

    public static void test2() throws IOException {
        StringWriter writer = new StringWriter();
        XMLWriter XMLWriter2 = new XMLWriter(writer);
        XMLWriter2.writeEntity("person");
        XMLWriter2.writeAttribute("name", "fred");
        XMLWriter2.writeAttribute("age", "12");
        XMLWriter2.writeEntity("phone");
        XMLWriter2.writeText("4254343");
        XMLWriter2.endEntity();
        XMLWriter2.writeEntity("bob");
        XMLWriter2.endEntity();
        XMLWriter2.endEntity();
        XMLWriter2.close();
        System.err.println(((Object)writer).toString());
    }
}

