/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io.cache;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.util.io.cache.DomainedObjectCache;
import sun.misc.SoftCache;

public class XUICache {
    private static final XUICache _singleton = new XUICache();
    private static final SoftCache _xuiCache = new SoftCache();

    private XUICache() {
    }

    public static synchronized XUICache getInstance() {
        return _singleton;
    }

    public static SoftCache getCache() {
        return _xuiCache;
    }

    public void cache(Object xuiURL, Document xuiDOM) {
        XUICache.getCache().put(xuiURL, (Object)xuiDOM);
    }

    public int getCacheCount() {
        return XUICache.getCache().size();
    }

    public void releaseCached(Object xuiURL) {
        Document xuiDOM = (Document)XUICache.getCache().get(xuiURL);
        if (xuiDOM != null) {
            xuiDOM.release();
        }
        XUICache.getCache().remove(xuiURL);
    }

    public void releaseCache() {
        Object[] keys = XUICache.getCache().keySet().toArray();
        Object object = null;
        for (int i = 0; i < keys.length; ++i) {
            object = keys[i];
            this.releaseCached(object);
        }
        DomainedObjectCache.releaseDomains();
    }

    public void releaseCache(String startsWith) {
        Object[] entries = XUICache.getCache().keySet().toArray();
        for (int i = 0; i < entries.length; ++i) {
            Object aKey = entries[i];
            if (!aKey.toString().startsWith("resources/" + startsWith + "/")) continue;
            this.releaseCached(aKey);
        }
    }

    public Document getCached(Object xuiURL) {
        Document xuiDOM = (Document)XUICache.getCache().get(xuiURL);
        return xuiDOM;
    }
}

