/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io.cache;

import com.jaxfront.core.util.io.ZIPCompressor;
import com.jaxfront.core.util.io.ZIPDeCompressor;
import com.jaxfront.core.util.io.cache.Cache;
import java.io.IOException;

public class ZippedCache
extends Cache {
    static Cache _singleton;

    public static ZippedCache getInstance() {
        if (_singleton == null) {
            _singleton = new ZippedCache();
        }
        return (ZippedCache)_singleton;
    }

    public void cache(String key, byte[] value) {
        try {
            super.cache(key, new ByteArrayCacheWrapper(key, value));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] getCached(String key) {
        try {
            return ((ByteArrayCacheWrapper)super.getCached(key)).getUnzippedValue();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean hasCachedObject(String key) {
        return this.hasCached(key);
    }

    class ByteArrayCacheWrapper {
        byte[] _value;
        String _key;

        public ByteArrayCacheWrapper(String key, byte[] value) throws IOException {
            this.zipValue(value);
            this._key = key;
        }

        public byte[] getValue() {
            return this._value;
        }

        public byte[] getUnzippedValue() throws IOException {
            if (this._value != null) {
                return ZIPDeCompressor.unzip(this._value);
            }
            return null;
        }

        public void setValue(byte[] value) {
            this._value = value;
        }

        public void zipValue(byte[] value) throws IOException {
            if (value != null) {
                this.setValue(ZIPCompressor.zip(value));
            }
        }
    }
}

