/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io.classloader;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.io.FileHelper;
import com.jaxfront.core.util.io.IConnectionManager;
import com.jaxfront.core.util.io.classloader.DumpClassVersions;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class DBClassLoader
extends ClassLoader {
    private static final String SLASH = "/";
    private static final String SEARCH_MASK_CLASSES_JAR = "%.jar";
    private static final String SYSTEM_MANDANT_NAME = "SYSTEM";
    private static final String CLASSES_SYSTEM = "classes/SYSTEM/";
    private static final String CLASSES_TRAIL = "classes/";
    private static final String CLASS_EXT = ".class";
    private Hashtable _classesCache = new Hashtable();
    private Hashtable _classByteCache = new Hashtable();
    private List _loadedJars = new Vector();
    private IConnectionManager _cManager;
    private static final DBClassLoader _instance = new DBClassLoader();
    private static String CLASS_NOT_FOUND = "CNF";
    private boolean _jarsLoaded = false;
    private String _mandantName;
    private long _jarByteCacheSize;
    private Hashtable _classloaders = new Hashtable();
    private boolean _isSystemLoader = false;
    private boolean _hasClasses = false;
    public static boolean _isFileMode = false;
    private Hashtable _resources = null;

    private DBClassLoader() {
        super(DBClassLoader.class.getClassLoader());
        this._mandantName = SYSTEM_MANDANT_NAME;
        this._isSystemLoader = true;
    }

    protected DBClassLoader(ClassLoader parent) {
        super(parent);
    }

    private DBClassLoader(IConnectionManager conMan) {
        super(DBClassLoader.class.getClassLoader());
        this.setConnectionManager(conMan);
        this._mandantName = SYSTEM_MANDANT_NAME;
        this._isSystemLoader = true;
    }

    private DBClassLoader(String mandantName) {
        super(DBClassLoader.class.getClassLoader());
        this._mandantName = mandantName;
    }

    private DBClassLoader(ClassLoader parentCL, String mandantName) {
        super(parentCL);
        this._mandantName = mandantName;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.findClass(className);
    }

    public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        return this.doFindClass(className, true, resolve);
    }

    public Class findClass(String className) {
        return this.doFindClass(className, true, false);
    }

    public Class doFindClass(String className, boolean invertFindSequence, boolean resolve) {
        block25: {
            if (!invertFindSequence) {
                try {
                    return this.findSystemClass(className);
                }
                catch (Exception e) {
                    try {
                        return Class.forName(className);
                    }
                    catch (ClassNotFoundException e1) {
                        // empty catch block
                    }
                }
            }
            byte[] classByte = null;
            if (this.getConnectionManager() != null) {
                Object cached;
                if (!this._jarsLoaded) {
                    this.preloadJars(this.getConnectionManager(), CLASSES_TRAIL + this._mandantName + SLASH + SEARCH_MASK_CLASSES_JAR);
                }
                if (this._hasClasses && CLASS_NOT_FOUND != (cached = this._classesCache.get(className))) {
                    Class<?> result = (Class<?>)cached;
                    if (result != null) {
                        return result;
                    }
                    try {
                        classByte = this.loadClassData(className, this.getConnectionManager(), this._mandantName);
                        if (classByte != null) {
                            result = this.defineClass(className, classByte, 0, classByte.length);
                            if (resolve) {
                                this.resolveClass(result);
                            }
                            this._classesCache.put(className, result);
                            return result;
                        }
                        this._classesCache.put(className, CLASS_NOT_FOUND);
                    }
                    catch (UnsupportedClassVersionError e) {
                        this._classesCache.put(className, CLASS_NOT_FOUND);
                        if (classByte == null) break block25;
                        try {
                            if (JAXFrontProperties.LOG_ENABLED) {
                                LogRegistry.getInstance().error(this.getClass(), e.getMessage() + " " + DumpClassVersions.dump(className, classByte));
                            }
                        }
                        catch (Exception e2) {}
                    }
                    catch (Throwable e) {
                        this._classesCache.put(className, CLASS_NOT_FOUND);
                        if (!LogRegistry.getInstance().logInfos()) break block25;
                        LogRegistry.getInstance().info(this.getClass(), e.getMessage());
                    }
                }
            }
        }
        try {
            if (!this._isSystemLoader) {
                return DBClassLoader.getInstance().loadClass(className);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (invertFindSequence) {
            try {
                return this.findSystemClass(className);
            }
            catch (Exception e) {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e1) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public Class getClass(String className, byte[] classBytes) {
        Class<?> result = null;
        if (classBytes != null) {
            result = this.defineClass(className, classBytes, 0, classBytes.length);
            this._classesCache.put(className, result);
        } else {
            this._classesCache.put(className, CLASS_NOT_FOUND);
        }
        return result;
    }

    private byte[] loadClassData(String className) throws IOException {
        File f = new File(className);
        int size = (int)f.length();
        byte[] buff = new byte[size];
        FileInputStream fis = new FileInputStream(f);
        DataInputStream dis = new DataInputStream(fis);
        dis.readFully(buff);
        dis.close();
        return buff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadByteDataFromDB(IConnectionManager conMan, String id) {
        byte[] classBytes = (byte[])this._classByteCache.get(id);
        if (classBytes != null) {
            this._classByteCache.remove(id);
            this._jarByteCacheSize -= (long)classBytes.length;
            return classBytes;
        }
        Connection con = null;
        try {
            con = conMan.getConnection("DBClassloader.loadByteDataFromDB");
            PreparedStatement ps = con.prepareStatement("SELECT DATA FROM JAX_FORM_RESOURCES WHERE ID = ?");
            ps.setString(1, id + CLASS_EXT);
            ResultSet rs = conMan.queryDB2(ps);
            if (rs.next()) {
                classBytes = rs.getBytes("DATA");
            }
            rs.close();
            conMan.close(ps);
        }
        catch (Exception e) {
        }
        finally {
            conMan.close(con);
        }
        return classBytes;
    }

    private byte[] loadByteDataFromFile(IConnectionManager conMan, String id) {
        byte[] classBytes = (byte[])this._classByteCache.get(id);
        if (classBytes != null) {
            this._classByteCache.remove(id);
            this._jarByteCacheSize -= (long)classBytes.length;
            return classBytes;
        }
        return classBytes;
    }

    private byte[] loadClassData(String className, IConnectionManager conMan, String mandant) throws IOException, SQLException {
        if (className.endsWith(CLASS_EXT)) {
            className = className.substring(0, className.length() - 6);
        }
        String classPath = CLASSES_TRAIL + mandant + SLASH + className.replace('.', '/');
        return this.loadByteDataFromDB(conMan, classPath);
    }

    public void setConnectionManager(IConnectionManager mngr) {
        this._cManager = mngr;
    }

    public IConnectionManager getConnectionManager() {
        if (this._cManager == null && !this._isSystemLoader) {
            return DBClassLoader.getInstance().getConnectionManager();
        }
        return this._cManager;
    }

    public void releaseInstance() {
        if (this._classesCache != null) {
            this._classesCache.clear();
        }
        if (this._classByteCache != null) {
            this._classByteCache.clear();
        }
        if (this._loadedJars != null) {
            this._loadedJars.clear();
        }
        this._jarsLoaded = false;
        this._cManager = null;
        this._jarByteCacheSize = 0L;
        if (this._classloaders != null) {
            this._classloaders.clear();
        }
        if (this._resources != null) {
            this._resources.clear();
        }
    }

    public static void release() {
        if (_instance != null) {
            if (DBClassLoader._instance._isSystemLoader) {
                Iterator loaders = _instance.getClassLoaders().entrySet().iterator();
                while (loaders.hasNext()) {
                    Map.Entry aE = loaders.next();
                    DBClassLoader aCL = (DBClassLoader)aE.getValue();
                    aCL.releaseInstance();
                }
            }
            _instance.releaseInstance();
        }
    }

    public static void release(String mandant) {
        if (_instance != null) {
            DBClassLoader cl = (DBClassLoader)_instance.getClassLoaders().get(mandant);
            if (cl != null) {
                cl.releaseInstance();
            }
            _instance.getClassLoaders().remove(mandant);
        }
    }

    public static synchronized DBClassLoader getInstance() {
        return _instance;
    }

    private DBClassLoader getMandantInstance(String mandantName) {
        DBClassLoader cl = (DBClassLoader)this.getClassLoaders().get(mandantName);
        if (cl == null) {
            cl = new DBClassLoader(mandantName);
            this.getClassLoaders().put(mandantName, cl);
        }
        return cl;
    }

    public static DBClassLoader getInstance(String mandantName) {
        if (mandantName == null || SYSTEM_MANDANT_NAME.equals(mandantName)) {
            return DBClassLoader.getInstance();
        }
        return DBClassLoader.getInstance().getMandantInstance(mandantName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preloadJars(IConnectionManager conMan, String id) {
        JarInputStream jis = null;
        JarEntry je = null;
        Connection con = null;
        try {
            if (LogRegistry.getInstance().logInfos()) {
                LogRegistry.getInstance().info(this.getClass(), "Preload jar for:" + id);
            }
            con = conMan.getConnection("DBClassloader.PreloadJars");
            PreparedStatement ps = con.prepareStatement("SELECT ID, DATA FROM JAX_FORM_RESOURCES WHERE ID LIKE ?");
            ps.setString(1, id);
            ResultSet rs = conMan.queryDB2(ps);
            while (rs.next()) {
                String name = rs.getString("ID");
                byte[] jarBytes = rs.getBytes("DATA");
                if (jarBytes == null) {
                    jarBytes = new byte[]{};
                }
                this._loadedJars.add(name);
                try {
                    jis = new JarInputStream(new ByteArrayInputStream(jarBytes));
                }
                catch (IOException ioe) {
                    LogRegistry.getInstance().error(this.getClass(), "Can't open jar file " + name + " message:" + ioe.getMessage());
                }
                if (jis == null) continue;
                try {
                    while ((je = jis.getNextJarEntry()) != null) {
                        String jarName = je.getName();
                        if (jarName.endsWith(CLASS_EXT)) {
                            this.preLoadClassBytes(jis, jarName);
                        } else if (!jarName.endsWith(SLASH)) {
                            this.loadResource(jis, jarName);
                        }
                        jis.closeEntry();
                    }
                }
                catch (IOException ioe) {
                    LogRegistry.getInstance().error(this.getClass(), "Badly formatted jar file");
                }
            }
            this._hasClasses = this._classByteCache.size() > 0;
            rs.close();
            conMan.close(ps);
            conMan.close(con);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                conMan.close(con);
            }
            catch (Throwable throwable) {
                conMan.close(con);
                throw throwable;
            }
        }
        this._jarsLoaded = true;
    }

    private void loadResource(JarInputStream jis, String resourceName) {
        BufferedInputStream jarBuf = new BufferedInputStream(jis);
        ByteArrayOutputStream jarOut = new ByteArrayOutputStream();
        try {
            FileHelper.write(jis, (OutputStream)jarOut);
            byte[] resourceBytes = jarOut.toByteArray();
            this.getResources().put(resourceName, resourceBytes);
        }
        catch (IOException ioe) {
            LogRegistry.getInstance().error(this.getClass(), "Error reading entry " + resourceName);
        }
    }

    private void preLoadClassBytes(JarInputStream jis, String className) {
        className = CLASSES_TRAIL + this._mandantName + SLASH + className.substring(0, className.length() - 6);
        BufferedInputStream jarBuf = new BufferedInputStream(jis);
        ByteArrayOutputStream jarOut = new ByteArrayOutputStream();
        try {
            FileHelper.write(jis, (OutputStream)jarOut);
            byte[] classBytes = jarOut.toByteArray();
            this._classByteCache.put(className, classBytes);
            this._jarByteCacheSize += (long)classBytes.length;
        }
        catch (Exception ioe) {
            LogRegistry.getInstance().error(this.getClass(), "Error reading entry " + className);
        }
    }

    public List getLoadedJars() {
        if (this._isSystemLoader) {
            Vector result = new Vector();
            result.addAll(this._loadedJars);
            List aCL = this.getAllClassLoaders();
            for (int c = 0; c < aCL.size(); ++c) {
                result.addAll(((DBClassLoader)aCL.get(c)).getLoadedJars());
            }
            return result;
        }
        return this._loadedJars;
    }

    private List getAllClassLoaders() {
        Vector result = new Vector();
        Iterator clEntries = this._classloaders.entrySet().iterator();
        while (clEntries.hasNext()) {
            result.add(clEntries.next().getValue());
        }
        return result;
    }

    public List getLoadedJarByteCacheKeys() {
        Vector result = new Vector();
        Iterator clEntries = this._classByteCache.entrySet().iterator();
        while (clEntries.hasNext()) {
            result.add(clEntries.next().getKey());
        }
        if (this._isSystemLoader) {
            List aCL = this.getAllClassLoaders();
            for (int c = 0; c < aCL.size(); ++c) {
                result.addAll(((DBClassLoader)aCL.get(c)).getLoadedJarByteCacheKeys());
            }
        }
        return result;
    }

    public long getJarByteCacheSize() {
        long size = this._jarByteCacheSize;
        if (this._isSystemLoader) {
            List aCL = this.getAllClassLoaders();
            for (int c = 0; c < aCL.size(); ++c) {
                size += ((DBClassLoader)aCL.get(c)).getJarByteCacheSize();
            }
        }
        return size;
    }

    public List getLoadedDBClasses() {
        Vector<String> result = new Vector<String>();
        Iterator clEntries = this._classesCache.entrySet().iterator();
        while (clEntries.hasNext()) {
            Map.Entry aEntry = clEntries.next();
            String key = (String)aEntry.getKey();
            Object value = aEntry.getValue();
            if (value == CLASS_NOT_FOUND) continue;
            result.add(key);
        }
        if (this._isSystemLoader) {
            List aCL = this.getAllClassLoaders();
            for (int c = 0; c < aCL.size(); ++c) {
                result.addAll(((DBClassLoader)aCL.get(c)).getLoadedDBClasses());
            }
        }
        return result;
    }

    public Hashtable getClassLoaders() {
        if (this._classloaders == null) {
            this._classloaders = new Hashtable(5);
        }
        return this._classloaders;
    }

    public Hashtable getResources() {
        if (this._resources == null) {
            this._resources = new Hashtable(5);
        }
        return this._resources;
    }

    public InputStream getResourceAsStream(String name) {
        if (this.getResources().containsKey(name)) {
            return new ByteArrayInputStream((byte[])this.getResources().get(name));
        }
        return null;
    }

    public static void setFileMode(boolean isFileMode) {
        _isFileMode = isFileMode;
    }
}

