/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io.cvsexport;

import com.jaxfront.core.dom.DOMBuilder;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.DocumentCreationException;
import com.jaxfront.core.schema.SchemaCreationException;
import com.jaxfront.core.schema.ValidationException;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.util.io.FileHelper;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.xerces.xni.parser.XMLParseException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVDocumentExporter {
    private static int maxListSize = 10;

    public static List exportFlatten(Document dom, String[] instances, boolean withHeader) throws XMLParseException, SAXException, IOException {
        return CSVDocumentExporter.exportFlatten(dom, ArrayUtil.toList(instances), withHeader);
    }

    public static List exportFlatten(Document dom, List instances, boolean withHeader) throws XMLParseException, SAXException, IOException {
        Vector result = new Vector();
        if (withHeader) {
            Vector flatHeaders = new Vector();
            CSVDocumentExporter.getFlattenHeaders(dom.getRootType(), flatHeaders);
            result.add(flatHeaders);
        }
        for (int i = 0; i < instances.size(); ++i) {
            dom.bind(DOMHelper.createDocument((String)instances.get(i)));
            Vector flat = new Vector();
            CSVDocumentExporter.getFlatten(dom.getRootType(), flat);
            result.add(flat);
        }
        return result;
    }

    public static void getFlatten(Type aType, Vector result) {
        if (aType.isSimple()) {
            String value = ((SimpleType)aType).getValue();
            if (value == null) {
                value = "";
            }
            result.add(value);
            return;
        }
        if (aType.isChoice()) {
            ((CompositeType)aType).createChoices();
        }
        if (aType.isList()) {
            CSVDocumentExporter.getFlatten((ListType)aType, result);
            return;
        }
        List childs = aType.getDirectChildren();
        int maxChilds = childs.size();
        for (int a = 0; a < maxChilds; ++a) {
            CSVDocumentExporter.getFlatten((Type)childs.get(a), result);
        }
    }

    public static void getFlatten(ListType aType, Vector result) {
        List childs = aType.getDirectChildren();
        int maxChilds = childs.size();
        int emptyChilds = 0;
        int tableSize = aType.getMaxOccurs();
        if (tableSize == -1) {
            tableSize = maxListSize;
        }
        if (maxChilds >= tableSize) {
            maxChilds = tableSize;
        } else {
            emptyChilds = tableSize - maxChilds;
        }
        for (int a = 0; a < maxChilds; ++a) {
            CSVDocumentExporter.getFlatten((Type)childs.get(a), result);
        }
        for (int e = 0; e < emptyChilds; ++e) {
            CSVDocumentExporter.getFlatten(aType.getEditingType(), result);
        }
    }

    public static void getFlattenHeaders(Type aType, Vector result) {
        if (aType.isSimple()) {
            result.add(Document.generateVarID((SimpleType)aType));
            return;
        }
        if (aType.isChoice()) {
            ((CompositeType)aType).createChoices();
        }
        if (aType.isList()) {
            CSVDocumentExporter.getFlattenHeaders((ListType)aType, result);
            return;
        }
        List childs = aType.getDirectChildren();
        for (int a = 0; a < childs.size(); ++a) {
            CSVDocumentExporter.getFlattenHeaders((Type)childs.get(a), result);
        }
    }

    public static void getFlattenHeaders(Type aType, Map<String, String> result) {
        if (aType.isSimple()) {
            String varID = Document.generateVarID((SimpleType)aType);
            result.put(varID, aType.getName());
            return;
        }
        if (aType.isChoice()) {
            ((CompositeType)aType).createChoices();
        }
        if (aType.isList()) {
            CSVDocumentExporter.getFlattenHeaders((ListType)aType, result);
            return;
        }
        List childs = aType.getDirectChildren();
        for (int a = 0; a < childs.size(); ++a) {
            CSVDocumentExporter.getFlattenHeaders((Type)childs.get(a), result);
        }
    }

    public static void getFlattenHeaders(ListType aType, Map<String, String> result) {
        List childs = aType.getDirectChildren();
        int maxChilds = childs.size();
        int emptyChilds = 0;
        int tableSize = aType.getMaxOccurs();
        if (maxChilds >= tableSize) {
            maxChilds = tableSize;
        } else {
            emptyChilds = tableSize - maxChilds;
        }
        for (int e = 0; e < emptyChilds; ++e) {
            aType.addNewChild();
        }
        for (int a = 0; a < tableSize; ++a) {
            CSVDocumentExporter.getFlattenHeaders((Type)childs.get(a), result);
        }
    }

    public static void getFlattenHeaders(ListType aType, Vector result) {
        List childs = aType.getDirectChildren();
        int maxChilds = childs.size();
        int emptyChilds = 0;
        int tableSize = aType.getMaxOccurs();
        if (maxChilds >= tableSize) {
            maxChilds = tableSize;
        } else {
            emptyChilds = tableSize - maxChilds;
        }
        for (int e = 0; e < emptyChilds; ++e) {
            aType.addNewChild();
        }
        for (int a = 0; a < tableSize; ++a) {
            CSVDocumentExporter.getFlattenHeaders((Type)childs.get(a), result);
        }
    }

    public static void main(String[] args) throws SchemaCreationException, DocumentCreationException, ValidationException, XMLParseException, SAXException, IOException {
        URL xsd = URLHelper.getUserURL("C:/Dokumente und Einstellungen/All Users/Dokumente/workspace_wdt_3_2/JAXFront Demo/examples/purchaseOrder/po.xsd");
        URL xui = URLHelper.getUserURL("C:/Dokumente und Einstellungen/All Users/Dokumente/workspace_wdt_3_2/JAXFront Demo/examples/purchaseOrder/po.xui");
        URL xml = URLHelper.getUserURL("C:/Dokumente und Einstellungen/All Users/Dokumente/workspace_wdt_3_2/JAXFront Demo/examples/purchaseOrder/po.xml");
        Document dom = DOMBuilder.getInstance().build(null, xsd, xml, xui, null);
        Vector<String> xmls = new Vector<String>();
        for (int i = 0; i < 10; ++i) {
            xmls.add(dom.serialize().toString());
        }
        CSVDocumentExporter.exportFlatten("file://c:/temp/flatten.csv", dom, xmls);
    }

    public static void exportFlatten(String file, Document dom, List instances) throws XMLParseException, SAXException, IOException {
        FileHelper fh = new FileHelper(file);
        fh.writeIntoFile(CSVDocumentExporter.exportFlatten(dom, instances).toString());
        fh.closeFileEntry();
    }

    public static StringBuffer exportFlatten(Document dom, List instances) throws XMLParseException, SAXException, IOException {
        StringBuffer result = new StringBuffer();
        List flattends = CSVDocumentExporter.exportFlatten(dom, instances, true);
        for (int i = 0; i < flattends.size(); ++i) {
            Vector elements = (Vector)flattends.get(i);
            StringBuffer resultLine = new StringBuffer();
            for (int j = 0; j < elements.size(); ++j) {
                resultLine.append("\"");
                resultLine.append((String)elements.get(j));
                resultLine.append("\"");
                resultLine.append(";");
            }
            resultLine.append(StringUtil.newLine);
            result.append(resultLine.toString());
        }
        return result;
    }
}

