/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.search;

import com.jaxfront.core.util.search.DefaultComparator;
import com.jaxfront.core.util.search.Search;
import com.jaxfront.core.util.search.SearchComparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public abstract class AbstractSearcher
implements Search {
    private int _pos = -1;
    protected Vector _result = null;
    private SearchComparator _comparator;
    protected boolean _matchCase = false;
    protected boolean _matchWord = false;
    protected boolean _isRegEx = false;
    private Hashtable _properties;
    private String _searchValue;

    public abstract boolean search(String var1);

    public void reset() {
        this._result = new Vector();
        this._pos = -1;
    }

    public Object getPrevious() {
        if (this._result != null && this._pos - 1 >= 0 && this._result.size() > this._pos - 1) {
            return this._result.get(--this._pos);
        }
        if (this._pos == 0) {
            --this._pos;
        }
        return null;
    }

    public Object getNext() {
        Object result = null;
        if (this._result != null) {
            if (this._pos + 1 >= 0 && this._pos + 1 < this._result.size()) {
                result = this._result.get(++this._pos);
            }
            if (this._pos + 1 == this._result.size()) {
                this._pos = this._result.size();
            }
        }
        return result;
    }

    public List getAll() {
        return this._result;
    }

    public void matchCase(boolean matchCase) {
        this._matchCase = matchCase;
        if (this.getComparator() != null) {
            this.getComparator().setMatchCase(matchCase);
        }
    }

    public void matchWord(boolean matchWord) {
        this._matchWord = matchWord;
        if (this.getComparator() != null) {
            this.getComparator().setMatchWord(matchWord);
        }
    }

    public void replaceNext(Object what, Object with) {
        this.initComparator();
    }

    public void replacePrevious(Object what, Object with) {
        this.initComparator();
    }

    public void replaceAll(Object what, Object with) {
        this.initComparator();
    }

    public void setComparator(SearchComparator comparator) {
        this._comparator = comparator;
    }

    public SearchComparator getComparator() {
        if (this._comparator == null) {
            this._comparator = new DefaultComparator();
        }
        return this._comparator;
    }

    protected void initComparator() {
        if (this.getComparator() != null) {
            this.getComparator().setMatchCase(this._matchCase);
            this.getComparator().setMatchWord(this._matchWord);
            this.getComparator().setIsRegEx(this._isRegEx);
        }
    }

    public void putProperty(String key, String value) {
        if (this._properties == null) {
            this._properties = new Hashtable();
        }
        this._properties.put(key, value);
    }

    public String getProperty(String key) {
        if (this._properties == null) {
            return null;
        }
        return (String)this._properties.get(key);
    }

    public void isRegEx(boolean isRegEx) {
        this._isRegEx = isRegEx;
        if (this.getComparator() != null) {
            this.getComparator().setIsRegEx(this._isRegEx);
        }
    }

    public String getSearchValue() {
        return this._searchValue;
    }

    protected void setSearchValue(String value) {
        this._searchValue = value;
    }
}

