/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.undo;

import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.RecursionVisualizer;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.undo.JAXFrontUndoManager;
import com.jaxfront.core.util.undo.JAXFrontUndoableEditWrapper;
import java.io.PrintWriter;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.commons.lang.StringEscapeUtils;

public class RecursionEventUndoableEditWrapper
extends JAXFrontUndoableEditWrapper {
    public static final short DELETE = 1;
    public static final short ADD = 2;
    private String _newV = null;
    private short _action = (short)-1;

    public RecursionEventUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, Type recursionType, short action) {
        super(manager, recursionType);
        this._sourceType = eventSource;
        this._newV = recursionType.serialize().toString();
        this._action = action;
    }

    public RecursionEventUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, String target, String itemValue, short action) {
        super(manager, target);
        this._sourceType = eventSource;
        this._newV = StringEscapeUtils.unescapeXml((String)itemValue);
        this._action = action;
    }

    public void die() {
        super.die();
        this._newV = null;
    }

    public String getPresentationName() {
        return "Shit";
    }

    public String getRedoPresentationName() {
        return super.getUndoPresentationName() + ":" + this._action;
    }

    public String getUndoPresentationName() {
        return super.getUndoPresentationName() + ":" + this._action;
    }

    public void redo() throws CannotRedoException {
        super.redo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            RecursionVisualizer visualizer = (RecursionVisualizer)TypeVisualizerFactory.getInstance().getVisualizer(tt).getImplementation();
            this.startBlocking();
            switch (this._action) {
                case 1: {
                    visualizer.deleteRecursion();
                    break;
                }
                case 2: {
                    visualizer.createRecursion();
                    tt.getDOM().getClipBoard().doPaste(tt, this._newV, null, tt.getStyle().isRepresentedAsTreeNode(), false);
                }
            }
            TypeVisualizerFactory.getInstance().populateAllVisualizerForType(tt);
            this.stopBlocking();
            this.visualizeRedo(tt);
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
        }
    }

    public void undo() throws CannotUndoException {
        super.undo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            this.startBlocking();
            RecursionVisualizer visualizer = (RecursionVisualizer)TypeVisualizerFactory.getInstance().getVisualizer(tt).getImplementation();
            switch (this._action) {
                case 1: {
                    visualizer.createRecursion();
                    tt.getDOM().getClipBoard().doPaste(tt, this._newV, null, tt.getStyle().isRepresentedAsTreeNode(), false);
                    break;
                }
                case 2: {
                    this._newV = tt.serialize().toString();
                    visualizer.deleteRecursion();
                }
            }
            this.stopBlocking();
            this.visualizeUndo(tt);
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
        }
    }

    public boolean canRedo() {
        Type tt = this.evalTargetType();
        boolean canUndo = true;
        if (tt != null) {
            switch (this._action) {
                case 1: {
                    break;
                }
            }
        }
        return !this.dead && canUndo;
    }

    public boolean canUndo() {
        Type tt = this.evalTargetType();
        boolean canUndo = true;
        if (tt != null) {
            switch (this._action) {
                case 1: {
                    break;
                }
            }
        }
        return !this.dead && canUndo;
    }

    public void serialize(PrintWriter writer) {
        super.serialize(writer);
        if (this._newV != null) {
            writer.print("<newValueType>");
            writer.print(StringEscapeUtils.escapeXml((String)this._newV));
            writer.print("</newValueType>");
        }
        writer.print("<action>");
        writer.print(this._action);
        writer.print("</action>");
    }
}

