/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xpath;

import com.jaxfront.core.type.Type;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ParentTypeIterator
implements Iterator {
    private Type node;
    private boolean _onlySerializable = false;

    public ParentTypeIterator(Type contextType, boolean listTypeIncluded, boolean editingTypeIncluded, boolean choosenTypeOnly) {
        this._onlySerializable = choosenTypeOnly;
        this.initParents(contextType);
        this.node = this.getFirstNode(contextType);
        while (!this.isXPathNode(this.node)) {
            this.node = this.getNextNode(this.node);
        }
    }

    public boolean hasNext() {
        return this.node != null;
    }

    public Object next() {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        Type aNode = this.node;
        this.node = null;
        return aNode;
    }

    private void initParents(Type aType) {
        Type aParent = aType;
        while ((aParent = aParent.getParent()) != null && aParent.isList()) {
        }
        if (aParent != null && (!this._onlySerializable || aParent.isSerializable())) {
            this.node = aParent;
        }
    }

    public void remove() {
        this.node = null;
    }

    protected Type getFirstNode(Type contextNode) {
        return this.node;
    }

    protected Type getNextNode(Type contextNode) {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        Type aNode = this.node;
        this.node = null;
        return aNode;
    }

    private boolean isXPathNode(Type node) {
        if (node == null) {
            return true;
        }
        if (node.isAttribute()) {
            return true;
        }
        if (node.isSimple()) {
            return true;
        }
        if (node.isComposite()) {
            return true;
        }
        return node.isList();
    }
}

