/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xpath;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.VectorHelper;
import com.jaxfront.core.xpath.DocumentNavigator;
import com.jaxfront.core.xpath.TypeXPath;
import com.jaxfront.core.xpath.W3CXPathExecuterImpl;
import com.jaxfront.core.xpath.XPNodeWalker;
import com.jaxfront.core.xpath.XPathDummyChoiceTypeWrapper;
import com.jaxfront.core.xpath.XPathError;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.jaxen.JaxenException;
import org.jaxen.UnresolvableException;
import org.jaxen.XPath;
import org.jaxen.XPathSyntaxException;
import org.w3c.dom.Element;

public class XPathExecuterImpl {
    public static int cacheHitCounter = 0;
    public static int naviCacheHitCounter = 0;
    public static long timeConsumption = 0L;
    public static int counter = 0;
    private static XPathExecuterImpl _singleton = null;

    public List processXPath(String xpath, Type type, boolean editingTypeInlcuded, boolean listTypeInlcuded, boolean traverseEditingType, boolean serializableTypesOnly) throws TransformerException {
        return this.processXPath(xpath, type, editingTypeInlcuded, listTypeInlcuded, traverseEditingType, serializableTypesOnly, false);
    }

    public List processXPath(String xpath, Type type, boolean editingTypeInlcuded, boolean listTypeInlcuded, boolean traverseEditingType, boolean serializableTypesOnly, boolean buildLazyChoices) throws TransformerException {
        return this.processXPath(xpath, type, editingTypeInlcuded, listTypeInlcuded, traverseEditingType, serializableTypesOnly, buildLazyChoices, false);
    }

    private void addNamespacesToXpath(XPath typeXpath, Hashtable mapping) throws JaxenException {
        Enumeration entries = mapping.keys();
        while (entries.hasMoreElements()) {
            Object uri = entries.nextElement();
            Object prefix = mapping.get(uri);
            typeXpath.addNamespace(prefix.toString(), uri.toString());
        }
    }

    public List processXPath(String xpath, Type type, boolean editingTypeInlcuded, boolean listTypeInlcuded, boolean traverseEditingType, boolean serializableTypesOnly, boolean buildLazyChoices, boolean idOnly) throws TransformerException {
        return this.processXPath(xpath, type, editingTypeInlcuded, listTypeInlcuded, traverseEditingType, serializableTypesOnly, buildLazyChoices, idOnly, false);
    }

    public List processXPath(String xpath, Type type, boolean editingTypeInlcuded, boolean listTypeInlcuded, boolean traverseEditingType, boolean serializableTypesOnly, boolean buildLazyChoices, boolean idOnly, boolean choosenOnly) throws TransformerException {
        return this.processXPath(xpath, type, editingTypeInlcuded, listTypeInlcuded, traverseEditingType, serializableTypesOnly, buildLazyChoices, idOnly, choosenOnly, false);
    }

    public List processXPath(String xpath, Type type, boolean editingTypeInlcuded, boolean listTypeInlcuded, boolean traverseEditingType, boolean serializableTypesOnly, boolean buildLazyChoices, boolean idOnly, boolean choosenOnly, boolean useXUINameSpace) throws TransformerException {
        if (JAXFrontProperties.getInstance().useOptimizedXpathEngine()) {
            List newResult = null;
            if (JAXFrontProperties.getInstance().validateOptimizedXpathEngine()) {
                List oldResult;
                newResult = this.processXPathNew(xpath, type, editingTypeInlcuded, listTypeInlcuded, traverseEditingType, serializableTypesOnly, buildLazyChoices, idOnly, choosenOnly, useXUINameSpace, false);
                if (VectorHelper.difference(newResult, oldResult = this.processXPathOld(xpath, type, editingTypeInlcuded, listTypeInlcuded, traverseEditingType, serializableTypesOnly, buildLazyChoices, idOnly, choosenOnly, useXUINameSpace, false)).size() > 0) {
                    System.out.println("Is different xpath:" + xpath);
                    List diff = VectorHelper.difference(newResult, oldResult);
                    for (int i = 0; i < diff.size(); ++i) {
                        System.out.println(((Type)diff.get(i)).getXPathLocation());
                    }
                }
            } else {
                newResult = this.processXPathNew(xpath, type, editingTypeInlcuded, listTypeInlcuded, traverseEditingType, serializableTypesOnly, buildLazyChoices, idOnly, choosenOnly, useXUINameSpace, true);
            }
            return newResult;
        }
        return this.processXPathOld(xpath, type, editingTypeInlcuded, listTypeInlcuded, traverseEditingType, serializableTypesOnly, buildLazyChoices, idOnly, choosenOnly, useXUINameSpace, false);
    }

    public List processXPathOld(String xpath, Type type, boolean editingTypeInlcuded, boolean listTypeInlcuded, boolean traverseEditingType, boolean serializableTypesOnly, boolean buildLazyChoices, boolean idOnly, boolean choosenOnly, boolean useXUINameSpace, boolean hideUnnamed) throws TransformerException {
        long start = System.currentTimeMillis();
        ++counter;
        Vector<Type> result = new Vector<Type>();
        List results = null;
        String secondXPKey = null;
        Type firstXPKey = null;
        boolean listTypeOnly = false;
        boolean textTypeOnly = false;
        Document dom = null;
        try {
            Integer intCacheKey;
            Vector cacheResult;
            if (type == null) {
                LogRegistry.getInstance().error(this.getClass(), "can't eval xpath. type is null!");
                return result;
            }
            if (type.getDOM() == null) {
                LogRegistry.getInstance().error(this.getClass(), "can't eval xpath. dom is null!");
                return result;
            }
            dom = type.getDOM();
            if (xpath == null || xpath.equals("")) {
                return result;
            }
            if (xpath.equals(".")) {
                result.add(type);
                return result;
            }
            if (traverseEditingType) {
                listTypeInlcuded = true;
                editingTypeInlcuded = true;
            }
            if (xpath.indexOf("[list]") > -1) {
                listTypeOnly = true;
                listTypeInlcuded = true;
                editingTypeInlcuded = true;
                traverseEditingType = false;
                xpath = TextTools.replace(xpath, "[list]", "");
            } else if (xpath.indexOf("[List]") > -1) {
                listTypeOnly = true;
                listTypeInlcuded = true;
                editingTypeInlcuded = true;
                traverseEditingType = false;
                xpath = TextTools.replace(xpath, "[List]", "");
            }
            if (dom != null && dom.xpCache != null && (cacheResult = (Vector)dom.xpCache.get(firstXPKey = type, secondXPKey = (intCacheKey = XPathExecuterImpl.create2CacheKey(listTypeInlcuded, idOnly, editingTypeInlcuded, traverseEditingType, serializableTypesOnly, buildLazyChoices)) + xpath)) != null) {
                ++cacheHitCounter;
                return cacheResult;
            }
            DocumentNavigator navigator = new DocumentNavigator();
            navigator.setListTypeIncluded(listTypeInlcuded);
            navigator.setIDOnly(idOnly);
            navigator.setEditingTypeIncluded(editingTypeInlcuded);
            navigator.setEditingTypeTraversalOnly(traverseEditingType);
            navigator.setOnlySerializable(serializableTypesOnly);
            navigator.setBuildLazyChoices(buildLazyChoices);
            navigator.setChoosenOnly(choosenOnly);
            navigator.setHideUnnamed(hideUnnamed);
            TypeXPath typeXpath = new TypeXPath(xpath, navigator);
            if (!JAXFrontProperties.getInstance().ignoreNamespace()) {
                if (type.getDOM() != null) {
                    Hashtable nsMapps = null;
                    nsMapps = useXUINameSpace ? type.getDOM().getXUINamespaceMappings() : type.getDOM().getXMLNamespaceMappings();
                    if (nsMapps != null && nsMapps.size() > 0) {
                        this.addNamespacesToXpath(typeXpath, type.getDOM().getXUINamespaceMappings());
                    }
                }
                if (type.getDOM() != null && type.getDOM().getSchema().getTargetNamespace() != null) {
                    typeXpath.addNamespace("", type.getDOM().getSchema().getTargetNamespace());
                }
            }
            results = typeXpath.selectNodes(type);
            for (int i = 0; i < results.size(); ++i) {
                Type aResultType = null;
                if (results.get(i) instanceof Document) {
                    aResultType = ((Document)results.get(i)).getRootType();
                } else {
                    try {
                        aResultType = (Type)results.get(i);
                        if (aResultType.getTypeClassification() == 256) {
                            aResultType = ((XPathDummyChoiceTypeWrapper)aResultType).getRealType();
                        }
                    }
                    catch (ClassCastException e) {
                        LogRegistry.getInstance().error(this.getClass(), "Xpath result is not a Type as expected! Check xPath definition:" + xpath);
                        return result;
                    }
                }
                if (listTypeOnly) {
                    if (!aResultType.isList()) continue;
                    result.add(aResultType);
                    continue;
                }
                if (textTypeOnly) {
                    SimpleType child;
                    if (!aResultType.isComposite() || (child = ((CompositeType)aResultType).getContentType()) == null) continue;
                    result.add(child);
                    continue;
                }
                if (!aResultType.isList() && !aResultType.isEditingType()) {
                    result.add(aResultType);
                    continue;
                }
                if ((!aResultType.isList() || !listTypeInlcuded) && (!aResultType.isEditingType() || !editingTypeInlcuded)) continue;
                result.add(aResultType);
            }
        }
        catch (UnresolvableException e) {
            LogRegistry.getInstance().error(this.getClass(), "XPath not resolvable (" + xpath + ") Reason:" + e.getMessage());
        }
        catch (XPathSyntaxException e) {
            LogRegistry.getInstance().error(this.getClass(), "XPath-Syntax Error for (" + xpath + ") Reason:" + e.getMultilineMessage());
        }
        catch (JaxenException e) {
            LogRegistry.getInstance().error(this.getClass(), e);
        }
        catch (ClassCastException e) {
            LogRegistry.getInstance().warn(this.getClass(), "Wrong result type! Get's not a JAXFront Type with xpath:" + xpath);
        }
        catch (Exception e) {
            LogRegistry.getInstance().warn(this.getClass(), "XPath Error for (" + xpath + ") Reason:" + e.getMessage());
        }
        if (dom != null && dom.xpCache != null) {
            dom.xpCache.put(firstXPKey, secondXPKey, result);
        }
        long stop = System.currentTimeMillis();
        timeConsumption += stop - start;
        return result;
    }

    public List processXPathNew(String xpath, Type type, boolean editingTypeInlcuded, boolean listTypeInlcuded, boolean traverseEditingType, boolean serializableTypesOnly, boolean buildLazyChoices, boolean idOnly, boolean choosenOnly, boolean useXUINameSpace, boolean doCache) throws TransformerException {
        long start = System.currentTimeMillis();
        ++counter;
        Vector<Type> result = new Vector<Type>();
        List results = null;
        String secondXPKey = null;
        Type firstXPKey = null;
        boolean listTypeOnly = false;
        boolean textTypeOnly = false;
        Document dom = null;
        try {
            Integer intCacheKey;
            Vector cacheResult;
            Type varValueType;
            if (type == null) {
                LogRegistry.getInstance().error(this.getClass(), "can't eval xpath. type is null!");
                return result;
            }
            if (type.getDOM() == null) {
                LogRegistry.getInstance().error(this.getClass(), "can't eval xpath. dom is null!");
                return result;
            }
            dom = type.getDOM();
            if (xpath == null || xpath.equals("")) {
                return result;
            }
            if (xpath.equals(".")) {
                result.add(type);
                return result;
            }
            if (dom.hasVarToTypeMapping() && (varValueType = dom.getVarToTypeMapping().get(xpath)) != null) {
                result.add(varValueType);
                return result;
            }
            if (traverseEditingType) {
                listTypeInlcuded = true;
                editingTypeInlcuded = true;
            }
            if (xpath.indexOf("[list]") > -1) {
                listTypeOnly = true;
                listTypeInlcuded = true;
                editingTypeInlcuded = true;
                traverseEditingType = false;
                xpath = TextTools.replace(xpath, "[list]", "");
            } else if (xpath.indexOf("[List]") > -1) {
                listTypeOnly = true;
                listTypeInlcuded = true;
                editingTypeInlcuded = true;
                traverseEditingType = false;
                xpath = TextTools.replace(xpath, "[List]", "");
            }
            if (doCache && dom != null && dom.xpCache != null && (cacheResult = (Vector)dom.xpCache.get(firstXPKey = type, secondXPKey = (intCacheKey = XPathExecuterImpl.create2CacheKey(listTypeInlcuded, idOnly, editingTypeInlcuded, traverseEditingType, serializableTypesOnly, buildLazyChoices)) + xpath)) != null) {
                ++cacheHitCounter;
                return cacheResult;
            }
            Hashtable nsMapps = null;
            Map nsPrefixMaps = null;
            if (!JAXFrontProperties.getInstance().ignoreNamespace() && type.getDOM() != null) {
                if (useXUINameSpace) {
                    nsMapps = type.getDOM().getXUINamespaceMappings();
                    nsPrefixMaps = type.getDOM().getXUIPrefixNamespaceMappings();
                } else {
                    nsMapps = type.getDOM().getXMLNamespaceMappings();
                    nsPrefixMaps = type.getDOM().getXUIPrefixNamespaceMappings();
                }
            }
            try {
                results = new XPNodeWalker(nsPrefixMaps).walkTypeXpath(xpath.trim(), type, traverseEditingType, editingTypeInlcuded, listTypeInlcuded, serializableTypesOnly, true, choosenOnly);
            }
            catch (XPathError e) {
                DocumentNavigator navigator = new DocumentNavigator();
                navigator.setListTypeIncluded(listTypeInlcuded);
                navigator.setIDOnly(idOnly);
                navigator.setEditingTypeIncluded(editingTypeInlcuded);
                navigator.setEditingTypeTraversalOnly(traverseEditingType);
                navigator.setOnlySerializable(serializableTypesOnly);
                navigator.setBuildLazyChoices(buildLazyChoices);
                navigator.setChoosenOnly(choosenOnly);
                TypeXPath typeXpath = new TypeXPath(xpath, navigator);
                if (!JAXFrontProperties.getInstance().ignoreNamespace()) {
                    if (type.getDOM() != null && nsMapps != null && nsMapps.size() > 0) {
                        this.addNamespacesToXpath(typeXpath, type.getDOM().getXUINamespaceMappings());
                    }
                    if (type.getDOM() != null && type.getDOM().getSchema().getTargetNamespace() != null) {
                        typeXpath.addNamespace("", type.getDOM().getSchema().getTargetNamespace());
                    }
                }
                results = typeXpath.selectNodes(type);
            }
            for (int i = 0; i < results.size(); ++i) {
                Type aResultType = null;
                if (results.get(i) instanceof Document) {
                    aResultType = ((Document)results.get(i)).getRootType();
                } else {
                    try {
                        aResultType = (Type)results.get(i);
                        if (aResultType.getTypeClassification() == 256) {
                            aResultType = ((XPathDummyChoiceTypeWrapper)aResultType).getRealType();
                        }
                    }
                    catch (ClassCastException e) {
                        LogRegistry.getInstance().error(this.getClass(), "Xpath result is not a Type as expected! Check xPath definition:" + xpath);
                        return result;
                    }
                }
                if (listTypeOnly) {
                    if (!aResultType.isList()) continue;
                    result.add(aResultType);
                    continue;
                }
                if (textTypeOnly) {
                    SimpleType child;
                    if (!aResultType.isComposite() || (child = ((CompositeType)aResultType).getContentType()) == null) continue;
                    result.add(child);
                    continue;
                }
                if (!aResultType.isList() && !aResultType.isEditingType()) {
                    result.add(aResultType);
                    continue;
                }
                if ((!aResultType.isList() || !listTypeInlcuded) && (!aResultType.isEditingType() || !editingTypeInlcuded)) continue;
                result.add(aResultType);
            }
        }
        catch (UnresolvableException e) {
            LogRegistry.getInstance().error(this.getClass(), "XPath not resolvable (" + xpath + ") Reason:" + e.getMessage());
        }
        catch (XPathSyntaxException e) {
            LogRegistry.getInstance().error(this.getClass(), "XPath-Syntax Error for (" + xpath + ") Reason:" + e.getMultilineMessage());
        }
        catch (JaxenException e) {
            LogRegistry.getInstance().error(this.getClass(), e);
        }
        catch (ClassCastException e) {
            LogRegistry.getInstance().warn(this.getClass(), "Wrong result type! Get's not a JAXFront Type with xpath:" + xpath);
        }
        catch (Exception e) {
            LogRegistry.getInstance().warn(this.getClass(), "XPath Error for (" + xpath + ") Reason:" + e.getMessage());
        }
        if (doCache && dom != null && dom.xpCache != null) {
            dom.xpCache.put(firstXPKey, secondXPKey, result);
        }
        long stop = System.currentTimeMillis();
        timeConsumption += stop - start;
        return result;
    }

    private XPathExecuterImpl() {
    }

    public static XPathExecuterImpl getInstance() {
        if (_singleton == null) {
            _singleton = new XPathExecuterImpl();
            return _singleton;
        }
        return _singleton;
    }

    public static Integer create2CacheKey(boolean listTypeIncluded, boolean idOnly, boolean editingTypeIncluded, boolean editingTypeTraversalOnly, boolean onlySerializable, boolean buildLazyChoices) {
        int key = 0;
        if (listTypeIncluded) {
            ++key;
        }
        if (idOnly) {
            key += 2;
        }
        if (editingTypeIncluded) {
            key += 4;
        }
        if (editingTypeTraversalOnly) {
            key += 8;
        }
        if (onlySerializable) {
            key += 16;
        }
        if (buildLazyChoices) {
            key += 32;
        }
        return new Integer(key);
    }

    public List processXPathXSDForm(String xpath, Type type) {
        try {
            return this.processXPathOld(xpath, type, false, false, false, false, false, false, false, false, true);
        }
        catch (TransformerException e) {
            LogRegistry.getInstance().warn(this.getClass(), e.getMessage());
            return new Vector(0);
        }
    }

    public Type getTypeForXPathXSDForm(String xpath, Type type) {
        try {
            List found = this.processXPathOld(xpath, type, false, false, false, false, false, false, false, false, true);
            if (found != null && found.size() > 0) {
                return (Type)found.get(0);
            }
        }
        catch (TransformerException e) {
            LogRegistry.getInstance().warn(this.getClass(), e.getMessage());
        }
        return null;
    }

    public static String getValueFromW3CDOM(org.w3c.dom.Document dom, String xpath) {
        String value = null;
        try {
            List foundList = W3CXPathExecuterImpl.getInstance().processXPath(dom.getDocumentElement(), xpath);
            if (foundList.size() > 0) {
                value = DOMHelper.getText((Element)foundList.get(0));
            }
        }
        catch (TransformerException e) {
            // empty catch block
        }
        return value;
    }
}

