/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xpath;

import com.jaxfront.core.xpath.XPNode;
import com.jaxfront.core.xpath.XPathError;
import com.jaxfront.core.xpath.XPathTree;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class XPathNodeExtractor {
    public static void main(String[] args) throws XPathError {
        new XPathNodeExtractor();
        List nodes = XPathNodeExtractor.tokenize("/das/ist", true);
        ((XPNode)nodes.get(nodes.size() - 1)).setUserObject("Tes");
        try {
            new XPathNodeExtractor();
            List nodea = XPathNodeExtractor.tokenize("/das[1] | /das[2] ", true);
            ((XPNode)nodea.get(nodea.size() - 1)).setUserObject("Test0");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            new XPathNodeExtractor();
            List nodeaa = XPathNodeExtractor.tokenize("/das|/das2", true);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            new XPathNodeExtractor();
            List nodeaaa = XPathNodeExtractor.tokenize("/das[1|2]", true);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        new XPathNodeExtractor();
        List nodeb = XPathNodeExtractor.tokenize("/das/ist/ein[blah[blah/test/test]]/test", true);
        ((XPNode)nodeb.get(nodeb.size() - 1)).setUserObject("Test1");
        new XPathNodeExtractor();
        List node2 = XPathNodeExtractor.tokenize("/das/ist2/ein[blah[blah/test/test]]/test", true);
        ((XPNode)node2.get(node2.size() - 1)).setUserObject("Test2");
        new XPathNodeExtractor();
        List node32 = XPathNodeExtractor.tokenize("/das/ist/ein[blah[blah/test/test]]/test3", true);
        ((XPNode)node32.get(node32.size() - 1)).setUserObject("Test3");
        for (int i = 0; i < nodes.size(); ++i) {
            XPNode node = (XPNode)nodes.get(i);
            System.out.println(node.getNodeName() + " " + node.getNodeExpression());
        }
        XPathTree tree = new XPathTree();
        tree.addNode(nodes);
        tree.addNode(node2);
        tree.addNode(node32);
        tree.addNode(nodeb);
        Vector sequence = new Vector();
        tree.getRootNode().extractUserNodesAsSequence(sequence);
        XPNode xnode = null;
        while ((xnode = XPathNodeExtractor.tokenizeNext("../../1[1]/mike:das/ist/ein[blah[blah/test/test]]/test3", xnode, true, false)) != null) {
            System.out.println(xnode.toString());
        }
    }

    public static List tokenize(String xpath, boolean check) throws XPathError {
        Vector<XPNode> nodes = new Vector<XPNode>();
        XPNode node = new XPNode("root", 0, check);
        while ((node = XPathNodeExtractor.extractNode(node._endPos, xpath, check)) != null) {
            nodes.add(node);
            if (node.getNodeExpression() == null) continue;
            XPNode expNode = new XPNode();
            expNode.setNodeName(node.getNodeExpression());
            nodes.add(expNode);
        }
        return nodes;
    }

    public static XPNode tokenizeNext(String xpath, XPNode oldNode, boolean check, boolean reuse) throws XPathError {
        return XPathNodeExtractor.tokenizeNext(xpath, oldNode, check, null, reuse);
    }

    public static XPNode tokenizeNext(String xpath, XPNode oldNode, boolean check, Map nsMapping, boolean reuse) throws XPathError {
        XPNode node = null;
        if (oldNode == null) {
            int start = 0;
            if (xpath.startsWith("/")) {
                start = 1;
            }
            node = new XPNode("root", start, check);
        } else {
            node = oldNode;
        }
        node = XPathNodeExtractor.extractNode(node, xpath, check, reuse);
        return node;
    }

    public static XPNode extractNode(int start, String xpath, boolean check) throws XPathError {
        return XPathNodeExtractor.extractNode(start, xpath, check, null);
    }

    public static XPNode extractNode(int start, String xpath, boolean check, Map nsMapping) throws XPathError {
        XPNode node = null;
        String nodeName = null;
        int lastPos = -1;
        int calculatedNodeEnd = XPathNodeExtractor.getNodeEndPos(xpath, start);
        if (calculatedNodeEnd >= 0 && start < xpath.length()) {
            nodeName = xpath.substring(start, calculatedNodeEnd);
            lastPos = calculatedNodeEnd + 1;
            node = nodeName == null ? new XPNode(xpath.substring(start), xpath.length(), check, nsMapping) : new XPNode(nodeName, lastPos, check, nsMapping);
        }
        return node;
    }

    public static XPNode extractNode(XPNode node, String xpath, boolean check, boolean reuse) throws XPathError {
        XPNode rNode = node;
        if (!reuse) {
            rNode = new XPNode();
        }
        int start = node._endPos;
        String nodeName = null;
        int lastPos = -1;
        int calculatedNodeEnd = XPathNodeExtractor.getNodeEndPos(xpath, start);
        if (calculatedNodeEnd >= 0 && start < xpath.length()) {
            nodeName = xpath.substring(start, calculatedNodeEnd);
            lastPos = calculatedNodeEnd + 1;
            if (nodeName == null) {
                rNode.parse(xpath.substring(start), check);
                rNode.setEndPos(xpath.length());
            } else {
                rNode.parse(nodeName, check);
                rNode.setEndPos(lastPos);
            }
            return rNode;
        }
        return null;
    }

    public static int getNodeEndPos(String xpath, int start) throws XPathError {
        int endPos = -1;
        int oBCount = 0;
        int cBCount = 0;
        block6: for (int i = start; i < xpath.length(); ++i) {
            char posChar = xpath.charAt(i);
            switch (posChar) {
                case '[': {
                    ++oBCount;
                    endPos = i + 1;
                    continue block6;
                }
                case ']': {
                    ++cBCount;
                    endPos = i + 1;
                    continue block6;
                }
                case '/': {
                    if (oBCount != cBCount) continue block6;
                    endPos = i;
                    return endPos;
                }
                case '|': {
                    if (oBCount == cBCount) {
                        throw new XPathError("or detected");
                    }
                }
                default: {
                    endPos = i + 1;
                }
            }
        }
        return endPos;
    }
}

