/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xsdgen;

import com.jaxfront.core.xsdgen.XURL;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DTD2XS {
    private String[] delimiter = new String[]{",|", ";/"};
    private final int meaninglessEntity = -1;
    private final int enumerationEntity = 0;
    private final int contentModelEntity = 1;
    private final int attributeListEntity = 2;
    private final int unusedEntity = 3;
    private final String schemaPrefix = "xs";
    private final String[] builtInSimpleType = new String[]{"string", "normalizedString", "token", "byte", "unsignedByte", "base64Binary", "hexBinary", "integer", "positiveInteger", "negativeInteger", "nonNegativeInteger", "nonPositiveInteger", "int", "unsignedInt", "long", "unsignedLong", "short", "unsignedShort", "decimal", "float", "double", "boolean", "time", "dateTime", "duration", "date", "gMonth", "gYear", "gYearMonth", "gDay", "gMonthDay", "Name", "QName", "NCName", "anyURI", "language", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NOTATION", "NMTOKEN", "NMTOKENS"};
    private final int maxNumComments = 1000;
    private int numComments;
    private String[] comment = new String[1000];
    private boolean ignoreComments;
    private String commentLanguage;
    private int conceptHighlight;
    private int conceptOccurrence;
    private int commentLength;
    private String conceptRelation;
    private DocumentBuilder jaxp_docbuilder;
    private TransformerFactory jaxp_transformer_factory;
    private Transformer jaxp_identity_transformer;
    private PrintStream psLog = null;
    private StringBuffer sbLog = null;

    private void log(Object item) {
        if (this.psLog != null) {
            this.psLog.print(item);
        } else if (this.sbLog != null) {
            this.sbLog.append(item);
        }
    }

    public DTD2XS(Object log) {
        if (log instanceof PrintStream) {
            this.psLog = (PrintStream)log;
        } else if (log instanceof StringBuffer) {
            this.sbLog = (StringBuffer)log;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.jaxp_docbuilder = dbf.newDocumentBuilder();
            this.jaxp_transformer_factory = TransformerFactory.newInstance();
            this.jaxp_identity_transformer = this.jaxp_transformer_factory.newTransformer();
            this.jaxp_identity_transformer.setOutputProperty("indent", "yes");
        }
        catch (Exception x) {
            this.log("\ndtd2xs: " + x);
        }
    }

    private Element simpleType(Document schema, String name, String content) {
        Element simpleType = schema.createElement("simpleType");
        if (name != null) {
            schema.getDocumentElement().appendChild(simpleType);
            simpleType.setAttribute("name", name);
            this.annotate(schema, simpleType);
        }
        Element restriction = schema.createElement("restriction");
        simpleType.appendChild(restriction);
        if (content.startsWith("(")) {
            restriction.setAttribute("base", "string");
            StringTokenizer contentTokenizer = new StringTokenizer(content, "(|)");
            while (contentTokenizer.hasMoreTokens()) {
                Element enumeration = schema.createElement("enumeration");
                restriction.appendChild(enumeration);
                enumeration.setAttribute("value", contentTokenizer.nextToken().trim());
                this.annotate(schema, enumeration);
            }
        } else {
            restriction.setAttribute("base", content.equals("CDATA") ? "string" : content);
        }
        return simpleType;
    }

    private void attributeGroup(Document schema, Element group, String content) {
        StringTokenizer contentTokenizer = new StringTokenizer(content);
        String name = null;
        while (contentTokenizer.hasMoreTokens()) {
            String lookahead;
            if (name == null) {
                name = contentTokenizer.nextToken(" \t\n\r\f");
            }
            if (name.startsWith("%") && name.endsWith(";")) {
                Element attributeGroupRef = schema.createElement("attributeGroup");
                group.appendChild(attributeGroupRef);
                attributeGroupRef.setAttribute("ref", name.substring(1, name.length() - 1));
                name = null;
                continue;
            }
            Element attribute = schema.createElement("attribute");
            group.appendChild(attribute);
            String type = contentTokenizer.nextToken(" \t\n\r\f");
            if (type.startsWith("(") && !type.endsWith(")")) {
                type = type + contentTokenizer.nextToken(")");
            }
            String use = contentTokenizer.nextToken(") \t\n\r\f");
            String value = null;
            if ("#IMPLIED #REQUIRED #FIXED".indexOf(use.toUpperCase()) < 0) {
                value = use;
                use = "#IMPLIED";
            } else if (contentTokenizer.hasMoreTokens()) {
                value = contentTokenizer.nextToken(" \t\n\r\f");
            }
            String quote = null;
            if (value != null && -1 < "\"'".indexOf(value.charAt(0))) {
                quote = String.valueOf(value.charAt(0));
            }
            if (quote != null) {
                value = !value.endsWith(quote) || value.equals(quote) ? value.substring(1, value.length()) + contentTokenizer.nextToken(quote) : value.substring(1, value.length() - 1);
                lookahead = null;
            } else {
                lookahead = value;
                value = null;
            }
            if (name.indexOf(58) < 0) {
                attribute.setAttribute("name", name);
                if (type.startsWith("%")) {
                    attribute.setAttribute("type", type.substring(1, type.length() - 1));
                } else if (type.startsWith("(")) {
                    attribute.appendChild(this.simpleType(schema, null, type));
                } else if (type.toUpperCase().equals("CDATA")) {
                    attribute.setAttribute("type", "string");
                } else {
                    attribute.setAttribute("type", type);
                }
            } else {
                attribute.setAttribute("ref", name);
            }
            this.annotate(schema, attribute);
            use = use.toUpperCase();
            if (use.equals("#REQUIRED")) {
                attribute.setAttribute("use", "required");
            }
            if (use.equals("#FIXED")) {
                attribute.setAttribute("fixed", value);
            } else if (value != null) {
                attribute.setAttribute("default", value);
            }
            name = lookahead;
        }
    }

    private int occurs(Element el, String content) {
        int length = content.length();
        if (content.endsWith("?")) {
            el.setAttribute("minOccurs", "0");
            --length;
        } else if (content.endsWith("+")) {
            el.setAttribute("maxOccurs", "unbounded");
            --length;
        } else if (content.endsWith("*")) {
            el.setAttribute("minOccurs", "0");
            el.setAttribute("maxOccurs", "unbounded");
            --length;
        }
        return length;
    }

    private Element createGroup(Document schema, String type, StringTokenizer content, int delimiterIndex) {
        Element groupType = schema.createElement(type);
        while (content.hasMoreTokens()) {
            String item = content.nextToken().trim();
            if (item.startsWith("(")) {
                groupType.appendChild(this.anonymousGroup(schema, item, delimiterIndex));
                continue;
            }
            if (item.startsWith("%")) {
                Element groupRef = schema.createElement("group");
                groupType.appendChild(groupRef);
                groupRef.setAttribute("ref", item.substring(1, this.occurs(groupRef, item) - 1));
                continue;
            }
            if (item.startsWith("#")) {
                groupType.setAttribute("_dtd2xs_mixed_", "true");
                continue;
            }
            Element elRef = schema.createElement("element");
            groupType.appendChild(elRef);
            elRef.setAttribute("ref", item.substring(0, this.occurs(elRef, item)));
        }
        return groupType;
    }

    private String hideDepth(String content, int delimiterIndex) {
        StringBuffer newContent = new StringBuffer("");
        int depth = 0;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '(') {
                newContent.append(c);
                ++depth;
                continue;
            }
            if (c == ')') {
                newContent.append(c);
                --depth;
                continue;
            }
            if (depth > 0 && c == this.delimiter[delimiterIndex].charAt(0)) {
                newContent.append(this.delimiter[1 - delimiterIndex].charAt(0));
                continue;
            }
            if (depth > 0 && c == this.delimiter[delimiterIndex].charAt(1)) {
                newContent.append(this.delimiter[1 - delimiterIndex].charAt(1));
                continue;
            }
            newContent.append(c);
        }
        return newContent.toString();
    }

    private void element(Document schema, String name, String content, int delimiterIndex) {
        Element el = schema.createElement("element");
        schema.getDocumentElement().appendChild(el);
        el.setAttribute("name", name);
        this.annotate(schema, el);
        StringTokenizer contentTokenizer = new StringTokenizer(content, "(,;|/?+* \t\n\r\f)");
        if (contentTokenizer.countTokens() == 1 && contentTokenizer.nextToken().toUpperCase().equals("#PCDATA")) {
            el.setAttribute("type", "string");
        } else {
            Element complexType = schema.createElement("complexType");
            el.appendChild(complexType);
            Element group = this.anonymousGroup(schema, content, delimiterIndex);
            complexType.appendChild(group);
        }
    }

    private void group(Document schema, String name, String content, int delimiterIndex) {
        Element namedGroup = schema.createElement("group");
        schema.getDocumentElement().appendChild(namedGroup);
        namedGroup.setAttribute("name", name);
        this.annotate(schema, namedGroup);
        namedGroup.appendChild(this.anonymousGroup(schema, content, delimiterIndex));
    }

    private Element anonymousGroup(Document schema, String content, int delimiterIndex) {
        Element atHolder = schema.createElement("atHolder");
        content = content.startsWith("(") ? content.substring(1, this.occurs(atHolder, content) - 1) : content.substring(0, this.occurs(atHolder, content));
        StringTokenizer contentTokenizer = new StringTokenizer(content = this.hideDepth(content, delimiterIndex), this.delimiter[delimiterIndex].substring(1, 2));
        Element group = contentTokenizer.countTokens() > 1 ? this.createGroup(schema, "choice", contentTokenizer, 1 - delimiterIndex) : (content.trim().toUpperCase().equals("EMPTY") ? schema.createElement("_dtd2xs_empty_") : (content.trim().toUpperCase().equals("ANY") ? schema.createElement("_dtd2xs_any_") : this.createGroup(schema, "sequence", new StringTokenizer(content, this.delimiter[delimiterIndex]), 1 - delimiterIndex)));
        if (atHolder.getAttribute("minOccurs").length() > 0) {
            group.setAttribute("minOccurs", atHolder.getAttribute("minOccurs"));
        }
        if (atHolder.getAttribute("maxOccurs").length() > 0) {
            group.setAttribute("maxOccurs", atHolder.getAttribute("maxOccurs"));
        }
        return group;
    }

    private Document transform(Document xml, InputStream xsltStream) {
        try {
            if (xsltStream == null) {
                return xml;
            }
            InputStream is = xsltStream;
            Transformer transformer = this.jaxp_transformer_factory.newTransformer(new StreamSource(is));
            Document result = this.jaxp_docbuilder.newDocument();
            transformer.transform(new DOMSource(xml), new DOMResult(result));
            result.getDocumentElement().removeAttribute("xmlns");
            result.getDocumentElement().removeAttribute("xmlns:xt");
            return result;
        }
        catch (Exception x) {
            this.log("\ndtd2xs: " + x);
            return null;
        }
    }

    private void minusAtplusNs(Document schema) {
        schema.replaceChild(this.minusAtplusNs(schema, schema.getDocumentElement()), schema.getDocumentElement());
        schema.getDocumentElement().setAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
    }

    private boolean isBuiltInSimpleType(String type) {
        for (int i = 0; i < this.builtInSimpleType.length; ++i) {
            if (!type.equals(this.builtInSimpleType[i])) continue;
            return true;
        }
        return false;
    }

    private Node minusAtplusNs(Document schema, Element e) {
        Element ee = schema.createElement("xs:" + e.getTagName());
        NamedNodeMap ats = e.getAttributes();
        for (int i = 0; i < ats.getLength(); ++i) {
            String name = ats.item(i).getNodeName();
            String value = ats.item(i).getNodeValue();
            if (name.equals("xmlns") || name.equals("_dtd2xs_mixed_")) continue;
            if ((name.equals("type") || name.equals("base")) && this.isBuiltInSimpleType(value)) {
                ee.setAttribute(name, "xs:" + value);
                continue;
            }
            ee.setAttribute(name, value);
        }
        for (Node x = e.getFirstChild(); x != null; x = x.getNextSibling()) {
            if (x.getNodeType() == 1) {
                ee.appendChild(this.minusAtplusNs(schema, (Element)x));
                continue;
            }
            ee.appendChild(x.cloneNode(true));
        }
        return ee;
    }

    private String removeComments(String dtd) {
        int commentStart;
        StringBuffer dtdWithoutComments = new StringBuffer("");
        int commentEnd = 0;
        int from = 0;
        while ((commentStart = dtd.indexOf("<!--", commentEnd)) >= 0) {
            commentEnd = dtd.indexOf("-->", commentStart) + 3;
            dtdWithoutComments.append(dtd.substring(from, commentStart));
            if (!this.ignoreComments) {
                this.comment[this.numComments] = dtd.substring(commentStart + "<!--".length(), commentEnd - "-->".length());
                if (this.comment[this.numComments].length() <= this.commentLength) {
                    ++this.numComments;
                }
            }
            from = commentEnd;
        }
        return dtdWithoutComments + dtd.substring(from, dtd.length());
    }

    private int weightOf(char c, boolean prefix) {
        if ("\n\t:".indexOf(c) >= 0) {
            return 10;
        }
        if (prefix && "<[{(\"'".indexOf(c) >= 0 || !prefix && ">]})\"'".indexOf(c) >= 0) {
            return 100;
        }
        return 1;
    }

    private boolean related(String comment, String concept) {
        int conceptStart;
        int occurrence = 0;
        boolean highlighted = false;
        int conceptEnd = 0;
        while ((conceptStart = comment.indexOf(concept, conceptEnd)) >= 0) {
            conceptEnd = conceptStart + concept.length();
            ++occurrence;
            int highlightPrefix = 0;
            for (int i = conceptStart; i > 0 && !Character.isLetterOrDigit(comment.charAt(i - 1)); --i) {
                highlightPrefix += this.weightOf(comment.charAt(i - 1), true);
                if (comment.charAt(i - 1) == '\n') break;
            }
            int highlightPostfix = 0;
            for (int i = conceptEnd; i < comment.length() && !Character.isLetterOrDigit(comment.charAt(i)); ++i) {
                highlightPostfix += this.weightOf(comment.charAt(i), false);
                if (comment.charAt(i) == '\n') break;
            }
            if (highlightPrefix <= 0 || highlightPostfix <= 0) continue;
            highlighted |= highlightPrefix + highlightPostfix >= this.conceptHighlight;
        }
        return highlighted && occurrence >= this.conceptOccurrence;
    }

    private void annotate(Document schema, Element construct) {
        String concept;
        if (this.ignoreComments || this.conceptRelation.indexOf(construct.getTagName()) < 0) {
            return;
        }
        Element annotation = schema.createElement("annotation");
        if (!construct.getAttribute("name").equals("")) {
            concept = construct.getAttribute("name");
        } else if (!construct.getAttribute("ref").equals("")) {
            concept = construct.getAttribute("ref");
        } else if (!construct.getAttribute("value").equals("")) {
            concept = construct.getAttribute("value");
        } else {
            return;
        }
        int numDocumentation = 0;
        for (int i = 0; i < this.numComments; ++i) {
            if (!this.related(this.comment[i], concept)) continue;
            this.log("\ndtd2xs: relate(" + concept + ", \"" + this.comment[i] + "\")");
            Element documentation = schema.createElement("documentation");
            annotation.appendChild(documentation);
            if (this.commentLanguage != null && !this.commentLanguage.equals("")) {
                documentation.setAttribute("xml:lang", this.commentLanguage);
            }
            documentation.appendChild(schema.createTextNode(this.comment[i]));
            ++numDocumentation;
        }
        if (numDocumentation > 0) {
            construct.appendChild(annotation);
        }
    }

    private boolean isLexicalUnit(char first, char last) {
        if (Character.isWhitespace(first) && !Character.isWhitespace(last)) {
            return false;
        }
        if (!Character.isWhitespace(first) && Character.isWhitespace(last)) {
            return false;
        }
        if (first == '(' && last != ')') {
            return false;
        }
        return first == '(' || last != ')';
    }

    private int useOf(String entityName, String entityContent, String dtd, boolean resolveEntity) {
        int entityUseStart;
        if (resolveEntity || entityContent.length() < 2 || !this.isLexicalUnit(entityContent.charAt(0), entityContent.charAt(entityContent.length() - 1))) {
            return -1;
        }
        String entityUse = "%" + entityName + ";";
        int entityUseEnd = 0;
        int entityIndex = -1;
        int elementIndex = -1;
        int attlistIndex = -1;
        boolean entityUsed = false;
        while ((entityUseStart = dtd.indexOf(entityUse, entityUseEnd)) >= 0) {
            entityUsed = true;
            entityUseEnd = entityUseStart + entityUse.length();
            if (entityIndex < 0 && -1 < (entityIndex = dtd.lastIndexOf("<!ENTITY", entityUseStart)) && dtd.indexOf(">", entityIndex) < entityUseStart) {
                entityIndex = -1;
            }
            if (elementIndex < 0 && -1 < (elementIndex = dtd.lastIndexOf("<!ELEMENT", entityUseStart)) && dtd.indexOf(">", elementIndex) < entityUseStart) {
                elementIndex = -1;
            }
            if (attlistIndex >= 0 || -1 >= (attlistIndex = dtd.lastIndexOf("<!ATTLIST", entityUseStart)) || dtd.indexOf(">", attlistIndex) >= entityUseStart) continue;
            attlistIndex = -1;
        }
        if (!entityUsed) {
            return 3;
        }
        int entityMeaning = -1;
        if (elementIndex >= 0 && attlistIndex < 0 || -1 < entityContent.indexOf("#PCDATA") || -1 < entityContent.indexOf(42) || -1 < entityContent.indexOf(63) || -1 < entityContent.indexOf(44) || -1 < entityContent.indexOf(43)) {
            entityMeaning = 1;
        } else if (-1 < "CDATA".indexOf(entityContent) || entityContent.startsWith("(") && entityContent.endsWith(")")) {
            entityMeaning = 0;
        } else if (attlistIndex >= 0 && elementIndex < 0 && new StringTokenizer(entityContent).countTokens() >= 2) {
            entityMeaning = 2;
        }
        return entityMeaning;
    }

    private String resolveEntity(String name, String content, String dtd) {
        int startUse;
        StringBuffer resolved = new StringBuffer("");
        int endUse = 0;
        while (-1 < (startUse = dtd.indexOf("%" + name + ";", endUse))) {
            resolved.append(dtd.substring(endUse, startUse));
            resolved.append(content);
            endUse = startUse + name.length() + 2;
        }
        resolved.append(dtd.substring(endUse, dtd.length()));
        return resolved.toString();
    }

    public String translate(String dtdURI, InputStream xsltStream, boolean resolveEntities, boolean ignoreComments, int commentLength, String commentLanguage, String conceptRelation, int conceptHighlight, int conceptOccurrence) {
        try {
            this.log("\ndtd2xs: dtdURI " + dtdURI);
            this.log("\ndtd2xs: resolveEntities " + resolveEntities);
            this.log("\ndtd2xs: ignoreComments " + ignoreComments);
            this.log("\ndtd2xs: commentLength " + commentLength);
            this.log("\ndtd2xs: commentLanguage " + commentLanguage);
            this.log("\ndtd2xs: conceptHighlight " + conceptHighlight);
            this.log("\ndtd2xs: conceptOccurrence " + conceptOccurrence);
            this.log("\ndtd2xs: conceptRelation " + conceptRelation);
            Document schema = this.jaxp_docbuilder.newDocument();
            schema.appendChild(schema.createElement("schema"));
            this.log("\ndtd2xs: load DTD ... ");
            String dtd = new XURL().communicate(dtdURI);
            this.log("done");
            this.log("\ndtd2xs: remove comments from DTD ... ");
            this.ignoreComments = ignoreComments;
            this.commentLength = commentLength;
            this.commentLanguage = commentLanguage;
            this.conceptRelation = conceptRelation;
            this.conceptHighlight = conceptHighlight;
            this.conceptOccurrence = conceptOccurrence;
            this.numComments = 0;
            dtd = this.removeComments(dtd);
            this.log("done");
            this.log("\ndtd2xs: DOM translation ...");
            StringTokenizer dtdTokenizer = new StringTokenizer(dtd, "<>");
            while (dtdTokenizer.hasMoreTokens()) {
                String content;
                String name;
                String decl = dtdTokenizer.nextToken();
                if (decl.startsWith("!ENTITY")) {
                    StringTokenizer entTokenizer = new StringTokenizer(decl, " \t\n\r\f%");
                    entTokenizer.nextToken();
                    name = entTokenizer.nextToken();
                    content = entTokenizer.nextToken("").trim();
                    content = content.substring(1, content.length() - 1);
                    switch (this.useOf(name, content, dtd, resolveEntities)) {
                        case 0: {
                            this.log("\ndtd2xs: simpleType[" + name + "][" + content + "]");
                            this.simpleType(schema, name, content);
                            break;
                        }
                        case 1: {
                            this.log("\ndtd2xs: group[" + name + "][" + content + "]");
                            this.group(schema, name, content, 0);
                            break;
                        }
                        case 2: {
                            this.log("\ndtd2xs: attributeGroup[" + name + "]");
                            Element atGroup = schema.createElement("attributeGroup");
                            schema.getDocumentElement().appendChild(atGroup);
                            atGroup.setAttribute("name", name);
                            this.annotate(schema, atGroup);
                            this.attributeGroup(schema, atGroup, content);
                            break;
                        }
                        case -1: {
                            this.log("\ndtd2xs: resolve[" + name + "][" + content + "]");
                            dtd = this.resolveEntity(name, content, dtd);
                            dtd = dtd.substring(dtd.indexOf(decl) + decl.length(), dtd.length());
                            dtdTokenizer = new StringTokenizer(dtd, "<>");
                        }
                    }
                    continue;
                }
                if (decl.startsWith("!ELEMENT")) {
                    StringTokenizer elTokenizer = new StringTokenizer(decl);
                    elTokenizer.nextToken();
                    name = elTokenizer.nextToken();
                    content = elTokenizer.nextToken("").trim();
                    this.element(schema, name, content, 0);
                    continue;
                }
                if (!decl.startsWith("!ATTLIST")) continue;
                StringTokenizer atTokenizer = new StringTokenizer(decl);
                atTokenizer.nextToken();
                String complexTypeRef = atTokenizer.nextToken();
                content = atTokenizer.nextToken("").trim();
                Element attributes = schema.createElement("_dtd2xs_attributes_");
                schema.getDocumentElement().appendChild(attributes);
                attributes.setAttribute("of", complexTypeRef);
                this.attributeGroup(schema, attributes, content);
            }
            this.log("\n... done");
            this.log("\ndtd2xs: complextype.xsl ... ");
            schema = this.transform(schema, xsltStream);
            this.log("done");
            this.log("\ndtd2xs: add namespace ... ");
            this.minusAtplusNs(schema);
            this.log("done");
            StringWriter sw = new StringWriter();
            this.jaxp_identity_transformer.transform(new DOMSource(schema), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception x) {
            this.log("\ndtd2xs: " + x);
            return null;
        }
    }
}

