/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xsdgen;

import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.xsdgen.DTD2XSD;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DTDGenerator
extends DefaultHandler {
    protected static int MIN_ENUMERATION_INSTANCES = 10;
    protected static int MAX_ENUMERATION_VALUES = 20;
    protected static int MIN_ENUMERATION_RATIO = 3;
    protected static int MIN_FIXED = 5;
    protected static int MIN_ID_VALUES = 10;
    protected static int MAX_ID_VALUES = 100000;
    TreeMap elementList = new TreeMap();
    Stack elementStack = new Stack();

    public static URL generate(URL xmlURL) throws Exception {
        DTDGenerator app = new DTDGenerator();
        app.run(xmlURL);
        String dtdFileName = xmlURL.getFile();
        dtdFileName = dtdFileName.substring(dtdFileName.lastIndexOf("/") + 1, dtdFileName.length());
        dtdFileName = dtdFileName.indexOf(".") != -1 ? dtdFileName.substring(0, dtdFileName.lastIndexOf(".") + 1) + "dtd" : dtdFileName + ".dtd";
        URL dtdURL = URLHelper.getUserURL(xmlURL, dtdFileName);
        String content = app.printDTD();
        File dtdFile = new File(dtdURL.toURI());
        if (!dtdFile.exists()) {
            dtdFile.createNewFile();
        }
        FileWriter fw = new FileWriter(dtdFile);
        fw.write(content);
        fw.flush();
        fw.close();
        return dtdURL;
    }

    public static URL generateXSD(URL xmlURL) throws Exception {
        URL dtdURL = DTDGenerator.generate(xmlURL);
        String[] args = new String[]{dtdURL.toString()};
        return DTD2XSD.generate(args);
    }

    private void run(URL xmlURL) {
        try {
            InputSource is = new InputSource(xmlURL.toString());
            XMLReader parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            parser.setContentHandler(this);
            parser.parse(is);
        }
        catch (FileNotFoundException nf) {
            System.err.println("File " + xmlURL.toString() + " not found");
        }
        catch (Exception err) {
            System.err.println("Failed while parsing source file");
            System.err.println(err.getMessage());
            err.printStackTrace();
            System.exit(2);
        }
    }

    private boolean isValidName(String s) {
        if (!this.isValidNMTOKEN(s)) {
            return false;
        }
        char c = s.charAt(0);
        return (c < '0' || c > '9') && c != '.' && c != '-';
    }

    private boolean isValidNMTOKEN(String s) {
        if (s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-' || c == ':' || c > '\u0080') continue;
            return false;
        }
        return true;
    }

    private String printDTD() {
        StringBuffer sb = new StringBuffer();
        Iterator e = this.elementList.keySet().iterator();
        while (e.hasNext()) {
            String elementname = (String)e.next();
            ElementDetails ed = (ElementDetails)this.elementList.get(elementname);
            TreeMap children = ed.children;
            Set childKeys = children.keySet();
            if (childKeys.size() == 0 && !ed.hasCharacterContent) {
                sb.append("<!ELEMENT " + elementname + " EMPTY >\n");
            }
            if (childKeys.size() == 0 && ed.hasCharacterContent) {
                sb.append("<!ELEMENT " + elementname + " ( #PCDATA ) >\n");
            }
            if (childKeys.size() > 0 && !ed.hasCharacterContent) {
                sb.append("<!ELEMENT " + elementname + " ( ");
                if (ed.sequenced) {
                    Enumeration c = ed.childseq.elements();
                    while (true) {
                        ChildDetails ch = (ChildDetails)c.nextElement();
                        sb.append(ch.name);
                        if (ch.repeatable && !ch.optional) {
                            sb.append("+");
                        }
                        if (ch.repeatable && ch.optional) {
                            sb.append("*");
                        }
                        if (ch.optional && !ch.repeatable) {
                            sb.append("?");
                        }
                        if (!c.hasMoreElements()) break;
                        sb.append(", ");
                    }
                    sb.append(" ) >\n");
                } else {
                    Iterator c1 = childKeys.iterator();
                    while (c1.hasNext()) {
                        sb.append((String)c1.next());
                        if (!c1.hasNext()) continue;
                        sb.append(" | ");
                    }
                    sb.append(" )* >\n");
                }
            }
            if (childKeys.size() > 0 && ed.hasCharacterContent) {
                sb.append("<!ELEMENT " + elementname + " ( #PCDATA");
                Iterator c2 = childKeys.iterator();
                while (c2.hasNext()) {
                    sb.append(" | " + (String)c2.next());
                }
                sb.append(" )* >\n");
            }
            TreeMap attlist = ed.attributes;
            boolean doneID = false;
            Iterator a = attlist.keySet().iterator();
            while (a.hasNext()) {
                String tokentype;
                String attname = (String)a.next();
                AttributeDetails ad = (AttributeDetails)attlist.get(attname);
                boolean required = ad.occurrences == ed.occurrences;
                boolean isid = ad.allNames && !doneID && ad.unique && ad.occurrences >= MIN_ID_VALUES;
                boolean isfixed = required && ad.values.size() == 1 && ad.occurrences >= MIN_FIXED;
                boolean isenum = ad.allNMTOKENs && ad.occurrences >= MIN_ENUMERATION_INSTANCES && ad.values.size() <= ad.occurrences / MIN_ENUMERATION_RATIO && ad.values.size() <= MAX_ENUMERATION_VALUES;
                sb.append("<!ATTLIST " + elementname + " " + attname + " ");
                String string = tokentype = ad.allNMTOKENs ? "NMTOKEN" : "CDATA";
                if (isid) {
                    sb.append("ID");
                    doneID = true;
                } else if (isfixed) {
                    String val = (String)ad.values.first();
                    sb.append(tokentype + " #FIXED \"" + DTDGenerator.escape(val) + "\" >\n");
                } else if (isenum) {
                    sb.append("( ");
                    Iterator v = ad.values.iterator();
                    while (v.hasNext()) {
                        sb.append((String)v.next());
                        if (!v.hasNext()) break;
                        sb.append(" | ");
                    }
                    sb.append(" )");
                } else {
                    sb.append(tokentype);
                }
                if (isfixed) continue;
                if (required) {
                    sb.append(" #REQUIRED >\n");
                    continue;
                }
                sb.append(" #IMPLIED >\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private static int escape(char[] ch, int start, int length, char[] out) {
        int o = 0;
        for (int i = start; i < start + length; ++i) {
            if (ch[i] == '<') {
                "&lt;".getChars(0, 4, out, o);
                o += 4;
                continue;
            }
            if (ch[i] == '>') {
                "&gt;".getChars(0, 4, out, o);
                o += 4;
                continue;
            }
            if (ch[i] == '&') {
                "&amp;".getChars(0, 5, out, o);
                o += 5;
                continue;
            }
            if (ch[i] == '\"') {
                "&#34;".getChars(0, 5, out, o);
                o += 5;
                continue;
            }
            if (ch[i] == '\'') {
                "&#39;".getChars(0, 5, out, o);
                o += 5;
                continue;
            }
            if (ch[i] <= '\u007f') {
                out[o++] = ch[i];
                continue;
            }
            String dec = "&#" + Integer.toString(ch[i]) + ';';
            dec.getChars(0, dec.length(), out, o);
            o += dec.length();
        }
        return o;
    }

    private static String escape(String in) {
        char[] dest = new char[in.length() * 8];
        int newlen = DTDGenerator.escape(in.toCharArray(), 0, in.length(), dest);
        return new String(dest, 0, newlen);
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        StackEntry se = new StackEntry();
        ElementDetails ed = (ElementDetails)this.elementList.get(name);
        if (ed == null) {
            ed = new ElementDetails(name);
            this.elementList.put(name, ed);
        }
        se.elementDetails = ed;
        se.sequenceNumber = -1;
        ++ed.occurrences;
        for (int a = 0; a < attributes.getLength(); ++a) {
            String attName = attributes.getQName(a);
            if (attName == null || attName.startsWith("xmlns")) continue;
            String val = attributes.getValue(a);
            AttributeDetails ad = (AttributeDetails)ed.attributes.get(attName);
            if (ad == null) {
                ad = new AttributeDetails(attName);
                ed.attributes.put(attName, ad);
            }
            if (!ad.values.contains(val)) {
                ad.values.add(val);
                if (ad.allNames && !this.isValidName(val)) {
                    ad.allNames = false;
                }
                if (ad.allNMTOKENs && !this.isValidNMTOKEN(val)) {
                    ad.allNMTOKENs = false;
                }
                if (ad.unique && ad.allNames && ad.occurrences <= MAX_ID_VALUES) {
                    ad.values.add(val);
                } else if (ad.values.size() <= MAX_ENUMERATION_VALUES) {
                    ad.values.add(val);
                }
            } else {
                ad.unique = false;
            }
            ++ad.occurrences;
        }
        if (!this.elementStack.isEmpty()) {
            boolean isFirstInGroup;
            StackEntry parent = (StackEntry)this.elementStack.peek();
            ElementDetails parentDetails = parent.elementDetails;
            int seq = parent.sequenceNumber;
            boolean bl = isFirstInGroup = parent.latestChild == null || !parent.latestChild.equals(name);
            if (isFirstInGroup) {
                ++seq;
                ++parent.sequenceNumber;
            }
            parent.latestChild = name;
            TreeMap children = parentDetails.children;
            ChildDetails c = (ChildDetails)children.get(name);
            if (c == null) {
                c = new ChildDetails();
                c.name = name;
                c.position = seq;
                c.repeatable = false;
                c.optional = false;
                children.put(name, c);
                parentDetails.childseq.addElement(c);
                if (parentDetails.occurrences != 1) {
                    c.optional = true;
                }
            } else {
                if (parentDetails.occurrences == 1 && isFirstInGroup) {
                    parentDetails.sequenced = false;
                }
                if (parentDetails.childseq.size() <= seq || !((ChildDetails)parentDetails.childseq.elementAt((int)seq)).name.equals(name)) {
                    parentDetails.sequenced = false;
                }
            }
            if (!isFirstInGroup) {
                c.repeatable = true;
            }
        }
        this.elementStack.push(se);
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        ElementDetails ed = (ElementDetails)this.elementList.get(name);
        if (ed.sequenced) {
            StackEntry se = (StackEntry)this.elementStack.peek();
            int seq = se.sequenceNumber;
            for (int i = seq + 1; i < ed.childseq.size(); ++i) {
                ((ChildDetails)ed.childseq.elementAt((int)i)).optional = true;
            }
        }
        this.elementStack.pop();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        ElementDetails ed = ((StackEntry)this.elementStack.peek()).elementDetails;
        if (!ed.hasCharacterContent) {
            for (int i = start; i < start + length; ++i) {
                if (ch[i] <= ' ') continue;
                ed.hasCharacterContent = true;
                break;
            }
        }
    }

    private class StackEntry {
        ElementDetails elementDetails;
        int sequenceNumber;
        String latestChild;

        private StackEntry() {
        }
    }

    private class AttributeDetails {
        String name;
        int occurrences;
        boolean unique;
        TreeSet values;
        boolean allNames;
        boolean allNMTOKENs;

        public AttributeDetails(String name) {
            this.name = name;
            this.occurrences = 0;
            this.unique = true;
            this.values = new TreeSet();
            this.allNames = true;
            this.allNMTOKENs = true;
        }
    }

    private class ChildDetails {
        String name;
        int position;
        boolean repeatable;
        boolean optional;

        private ChildDetails() {
        }
    }

    private class ElementDetails {
        String name;
        int occurrences;
        boolean hasCharacterContent;
        boolean sequenced;
        TreeMap children;
        Vector childseq;
        TreeMap attributes;

        public ElementDetails(String name) {
            this.name = name;
            this.occurrences = 0;
            this.hasCharacterContent = false;
            this.sequenced = true;
            this.children = new TreeMap();
            this.childseq = new Vector();
            this.attributes = new TreeMap();
        }
    }
}

