/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xui;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.nfunk.jep.type.NULL;

public class ColumnInfo
implements Serializable,
Cloneable {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_BOTTOM = 0;
    public static final int ALIGN_MIDDLE = 1;
    public static final int ALIGN_TOP = 2;
    protected Type _holder;
    private String _name;
    private int _index;
    private Vector _formulaExpressions;
    private Vector _iconExpressions;
    private int _lineWidth;
    private int _hAlign;
    private int _vAlign;
    private String _lineInfoExpression;
    private String _cssStyle;
    private String _cssHeaderStyle;
    private String _iconExpression;
    private boolean _isUsingDefaultRendering = false;
    private boolean _allowContextNavigation = false;
    private String _contextFormulaExpressionString;
    private boolean _editorAlwaysVisible;
    private FormulaExpression _contextFormulaExpression;

    private ColumnInfo() {
    }

    public ColumnInfo(Type holder, int index, String name) {
        this(holder, index, name, null);
    }

    public ColumnInfo(Type holder, int index, String name, String formulaExpression) {
        this(holder, index, name, formulaExpression, null, -1, false, false, null, -1, 1, null, null);
    }

    public ColumnInfo(Type holder, int index, String name, String formulaExpression, String iconExpression, int lineWidth, boolean allowContextNavigation, boolean editorAlwaysVisible, String contextFormExType) {
        this(holder, index, name, formulaExpression, iconExpression, lineWidth, allowContextNavigation, editorAlwaysVisible, contextFormExType, -1, 1, null, null);
    }

    public ColumnInfo(Type holder, int index, String name, String formulaExpression, String iconExpression, int lineWidth, boolean allowContextNavigation, boolean editorAlwaysVisible, String contextFormExType, int hAlign, int vAlign, String cssHeaderStyle, String cssStyle) {
        this.setHolder(holder);
        this._index = index;
        this._name = name;
        this._lineWidth = lineWidth;
        this._hAlign = hAlign;
        this._vAlign = vAlign;
        this._cssStyle = cssStyle;
        this._cssHeaderStyle = cssHeaderStyle;
        this._allowContextNavigation = allowContextNavigation;
        this._contextFormulaExpressionString = contextFormExType;
        this._editorAlwaysVisible = editorAlwaysVisible;
        this._lineInfoExpression = formulaExpression;
        this._iconExpression = iconExpression;
    }

    public void addFormulaExpression(FormulaExpression aFormulaExpression) {
        this.getFormulaExpressions().add(aFormulaExpression);
        if (this._iconExpression != null) {
            this.getIconExpressions().add(new FormulaExpression(aFormulaExpression.getSource(), this._iconExpression, false, false));
        }
    }

    public void setCSSStyle(String cssStyle) {
        this._cssStyle = cssStyle;
    }

    public String getCSSStyle() {
        return this._cssStyle;
    }

    public void setCSSHeaderStyle(String cssStyle) {
        this._cssHeaderStyle = cssStyle;
    }

    public String getCSSHeaderStyle() {
        return this._cssHeaderStyle;
    }

    public FormulaExpression getContextFormulaExpression() {
        if (this._contextFormulaExpression == null) {
            this._contextFormulaExpression = new FormulaExpression(this._holder, this._contextFormulaExpressionString);
        }
        return this._contextFormulaExpression;
    }

    public Object evalFormulaObject(int index) {
        Object[] eval = null;
        if (index >= this.getFormulaExpressions().size() || index < 0) {
            return "";
        }
        try {
            FormulaExpression iconExpression;
            String lineInfoFE;
            Type referencedKey;
            boolean useKeyRefFormula = false;
            FormulaExpression fe = (FormulaExpression)this.getFormulaExpressions().elementAt(index);
            if (fe.getSource() != null && fe.getSource().isKeyRef() && (referencedKey = ((SimpleType)fe.getSource()).getReferencedKeyType()) != null && (lineInfoFE = fe.getSource().getParent().getXUIDefinition().getStyle().getKeyRefSelectionLineInfoFE()) != null) {
                fe = new FormulaExpression(referencedKey, lineInfoFE);
                useKeyRefFormula = true;
            }
            if (fe.getExpression() != null) {
                eval = fe.evaluateObject();
            } else if (fe.getSource() != null && this.getIconExpression() == null) {
                eval = fe.getSource().getDisplayValue();
            }
            if (useKeyRefFormula) {
                fe = (FormulaExpression)this.getFormulaExpressions().elementAt(index);
                fe.setCachedResult(eval);
            }
            if (eval == NULL._null) {
                eval = "";
            }
            if (this.getIconExpressions().size() > 0 && (iconExpression = (FormulaExpression)this.getIconExpressions().elementAt(index)) != null && iconExpression.getExpression() != null) {
                Object[] newEval = new Object[]{"ICON", iconExpression.evaluateObject(), eval};
                eval = newEval;
            }
        }
        catch (FormulaException e) {
            LogRegistry.getInstance().error(this.getClass(), e.getMessage());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return eval;
    }

    public String getFormulaExpression() {
        return this._lineInfoExpression;
    }

    public String getIconExpression() {
        return this._iconExpression;
    }

    public Vector getFormulaExpressions() {
        if (this._formulaExpressions == null) {
            this.setFormulaExpressions(new Vector());
        }
        return this._formulaExpressions;
    }

    public Vector getIconExpressions() {
        if (this._iconExpressions == null) {
            this._iconExpressions = new Vector();
        }
        return this._iconExpressions;
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public int getHorizontalAlign() {
        return this._hAlign;
    }

    public int getVerticalAlign() {
        return this._vAlign;
    }

    public void setLineWidth(int lineWidth) {
        this._lineWidth = lineWidth;
    }

    public void setHorizontalAlign(int align) {
        this._hAlign = align;
    }

    public void setVerticalAlign(int align) {
        this._vAlign = align;
    }

    public String getHAlign() {
        switch (this._hAlign) {
            case 0: {
                return "left";
            }
            case 1: {
                return "center";
            }
            case 2: {
                return "right";
            }
        }
        return "left";
    }

    public String getHAlignHeader() {
        switch (this._hAlign) {
            case 0: {
                return "left";
            }
            case 1: {
                return "center";
            }
            case 2: {
                return "right";
            }
        }
        return "left";
    }

    public String getVAlign() {
        switch (this._vAlign) {
            case 2: {
                return "top";
            }
            case 1: {
                return "middle";
            }
            case 0: {
                return "bottom";
            }
        }
        return "top";
    }

    public String getVAlignHeader() {
        switch (this._vAlign) {
            case 2: {
                return "top";
            }
            case 1: {
                return "middle";
            }
            case 0: {
                return "bottom";
            }
        }
        return "middle";
    }

    public String getName() {
        String context = "lineInfo";
        return this.getName(context);
    }

    public String getNamePDF() {
        String context = "lineInfo_pdf";
        return this.getName(context);
    }

    private String getName(String context) {
        String defaultName = "Header " + this._index;
        if (this._holder != null) {
            if (this.isUsingDefaultRendering()) {
                this._name = this._holder.getXUIDefinition().getStyle().getCaptionTitleLabel();
            } else {
                Type parList = this._holder.getParentList();
                if (parList == null) {
                    parList = this._holder;
                }
                this._name = parList.getXUIDefinition().getStyle().getNLS(null, context, String.valueOf(this._index), null);
                if (this._name == null && context != null) {
                    this._name = context.equals("lineInfo_pdf") ? this.getName() : this._holder.getXUIDefinition().getStyle().getCaptionTitleLabel();
                }
            }
        }
        if (this._name == null) {
            this._name = defaultName;
        }
        return this._name;
    }

    public String getToolTip(Type currentType) {
        String context = "toolTip";
        String defaultName = "Header " + this._index;
        String toolTip = this._holder.getXUIDefinition().getStyle().getNLS(defaultName, context, String.valueOf(this._index), null);
        if (toolTip != null && toolTip.equals(defaultName)) {
            toolTip = this._holder.getXUIDefinition().getStyle().getNLS(defaultName, context, String.valueOf(this._index) + "_formula", null);
            if (toolTip != null && toolTip.equals(defaultName)) {
                toolTip = null;
            } else {
                FormulaExpression formulaExpression = new FormulaExpression(currentType, toolTip);
                if (formulaExpression != null) {
                    try {
                        toolTip = formulaExpression.evaluate();
                    }
                    catch (FormulaException ex) {
                        LogRegistry.getInstance().error(this.getClass(), ex.getMessage());
                    }
                }
            }
        }
        if (this.isUsingDefaultRendering() && this._holder != null) {
            toolTip = null;
        }
        return toolTip;
    }

    public boolean isUsingDefaultRendering() {
        return this._isUsingDefaultRendering;
    }

    public boolean isEditorAlwaysVisible() {
        return this._editorAlwaysVisible;
    }

    public boolean isXUIcontrolled() {
        return this._lineInfoExpression != null;
    }

    public void setFormulaExpressions(Vector new_formulaExpressions) {
        this._formulaExpressions = new_formulaExpressions;
    }

    public void setIconExpressions(Vector iconExpressions) {
        this._iconExpressions = iconExpressions;
    }

    public void setUsingDefaultRendering(boolean new_isUsingDefaultRendering) {
        this._isUsingDefaultRendering = new_isUsingDefaultRendering;
    }

    public void swapFormula(int from, int to) {
        if (this._formulaExpressions != null && this._formulaExpressions.size() >= to) {
            Object o = this._formulaExpressions.remove(from);
            this._formulaExpressions.add(to, o);
        }
    }

    public void updateLine(Type type, long modus) {
        if (modus == 2L) {
            FormulaExpression formula;
            int i;
            if (this._formulaExpressions != null) {
                for (i = this._formulaExpressions.size() - 1; i >= 0; --i) {
                    formula = (FormulaExpression)this._formulaExpressions.elementAt(i);
                    if (!formula.isReleased() && formula.getSource() != type && !formula.getSource().isDerivedFrom(type)) continue;
                    this._formulaExpressions.remove(i);
                    break;
                }
            }
            if (this._iconExpressions != null) {
                for (i = this._iconExpressions.size() - 1; i >= 0; --i) {
                    formula = (FormulaExpression)this._iconExpressions.elementAt(i);
                    if (!formula.isReleased() && formula.getSource() != type && !formula.getSource().isDerivedFrom(type)) continue;
                    this._iconExpressions.remove(i);
                    break;
                }
            }
        }
    }

    public boolean allowContextNavigation() {
        return this._allowContextNavigation;
    }

    public void reset() {
        if (this._iconExpressions != null) {
            this._iconExpressions.clear();
        }
        if (this._formulaExpressions != null) {
            this._formulaExpressions.clear();
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        ColumnInfo clone = (ColumnInfo)super.clone();
        if (this._iconExpressions != null) {
            clone._iconExpressions = (Vector)this._iconExpressions.clone();
        }
        if (this._formulaExpressions != null) {
            clone._formulaExpressions = (Vector)this._formulaExpressions.clone();
        }
        return clone;
    }

    public String toString() {
        int f;
        StringBuffer toString = new StringBuffer();
        toString.append(" -> ColumnInfo Holder:" + this._holder.getXPathLocation());
        if (this._formulaExpressions != null) {
            for (f = 0; f < this._formulaExpressions.size(); ++f) {
                toString.append("\n    .FormulaExpression Source:" + ((FormulaExpression)this._formulaExpressions.get(f)).getSource().getXPathLocation());
            }
        }
        if (this._iconExpressions != null) {
            for (f = 0; f < this._iconExpressions.size(); ++f) {
                toString.append("\n    .IconExpression Source:" + ((FormulaExpression)this._iconExpressions.get(f)).getSource().getXPathLocation());
            }
        }
        return toString.toString();
    }

    public ColumnInfo copy(Type type) {
        ColumnInfo copy = null;
        copy = new ColumnInfo();
        copy._allowContextNavigation = this._allowContextNavigation;
        copy._contextFormulaExpression = this._contextFormulaExpression;
        copy._contextFormulaExpressionString = this._contextFormulaExpressionString;
        copy._editorAlwaysVisible = this._editorAlwaysVisible;
        copy._iconExpression = this._iconExpression;
        copy._index = this._index;
        copy._isUsingDefaultRendering = this._isUsingDefaultRendering;
        copy._lineInfoExpression = this._lineInfoExpression;
        copy._lineWidth = this._lineWidth;
        copy._hAlign = this._hAlign;
        copy._vAlign = this._vAlign;
        copy._cssStyle = this._cssStyle;
        copy._cssHeaderStyle = this._cssHeaderStyle;
        copy._name = this._name;
        copy._formulaExpressions = null;
        copy.setHolder(type);
        copy._iconExpressions = null;
        return copy;
    }

    public Type getHolder() {
        return this._holder;
    }

    protected void setHolder(Type holder) {
        this._holder = holder;
    }

    protected Type evalHolder() {
        Type eval = null;
        if (this._lineInfoExpression != null && this._lineInfoExpression.length() > 0 && this._lineInfoExpression.indexOf("node(") >= 0) {
            try {
                HashSet refs = this._holder.getDOM().getController().getMathEvaluator().evaluateReferencedNodes(this._holder, this._lineInfoExpression, true);
                Iterator holderRefs = refs.iterator();
                if (holderRefs.hasNext()) {
                    eval = (Type)holderRefs.next();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return eval;
    }

    public Object getCachedValue(int index) {
        Object result = ((FormulaExpression)this.getFormulaExpressions().elementAt(index)).getCachedResult();
        if (result == null) {
            result = this.evalFormulaObject(index);
        }
        return result;
    }
}

