/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xui;

import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.DoubleKeyHashtable;
import com.jaxfront.core.util.DoubleKeyHashtableUnsynced;
import com.jaxfront.core.util.TextTools;
import java.util.Iterator;

public class DefaultXUIPropertyInitializer {
    public static final int UNDEFINED_BRANCH = -1;
    public static final int COMPONENT_STYLE_BRANCH = 0;
    public static final int COMPONENT_BEHAVIOR_BRANCH = 1;
    public static final int GLOBAL_STYLE_BRANCH = 2;
    public static final int GLOBAL_BEHAVIOR_BRANCH = 3;
    public static final int GLOBAL_GENERAL_BRANCH = 4;
    public static final int GLOBAL = 5;

    public DoubleKeyHashtable initializeDefaultProperties(Type xuiSchemaRootType) {
        DoubleKeyHashtableUnsynced defaultContainer = new DoubleKeyHashtableUnsynced();
        this.initializeDefaultProperties(defaultContainer, xuiSchemaRootType, -1);
        return defaultContainer;
    }

    private void initializeDefaultProperties(DoubleKeyHashtable defaultContainer, Type type, int branchType) {
        String xpathLoc = type.getXPathLocation();
        int relPathSplit = 0;
        if (xpathLoc != null && branchType == -1) {
            if (xpathLoc.equals("/XUI/global")) {
                branchType = 5;
            } else if (xpathLoc.equals("/XUI/component/style")) {
                branchType = 0;
            } else if (xpathLoc.equals("/XUI/component/behaviour")) {
                branchType = 1;
            }
        }
        if (type.isSimple()) {
            switch (branchType) {
                case 5: {
                    relPathSplit = "/XUI/global".length();
                    break;
                }
                case 0: {
                    relPathSplit = "/XUI/component/style".length();
                    break;
                }
                case 1: {
                    relPathSplit = "/XUI/component/behaviour".length();
                    break;
                }
                default: {
                    relPathSplit = xpathLoc.lastIndexOf("/");
                }
            }
            SimpleType st = (SimpleType)type;
            String xpath = TextTools.replace(st.getXPathLocation(), "@", "");
            if (st.getDefaultValue() != null) {
                defaultContainer.put(xpath.substring(0, relPathSplit), xpath.substring(relPathSplit + 1), st.getDefaultValue());
            }
        } else if (type.isComposite()) {
            Iterator childIterator = ((CompositeType)type).getComposites().iterator();
            while (childIterator.hasNext()) {
                this.initializeDefaultProperties(defaultContainer, (Type)childIterator.next(), branchType);
            }
        } else if (type.isList()) {
            this.initializeDefaultProperties(defaultContainer, ((ListType)type).getEditingType(), branchType);
        }
    }
}

