/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xui;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.FingerPrint;
import com.jaxfront.core.dom.IJAXFrontEntityResolver;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.ListModificationException;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypeController;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.type.VirtualType;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.LanguageEnhancedProperties;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.TreeSort;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.util.XPathSorter;
import com.jaxfront.core.xui.NLSChangeEvent;
import com.jaxfront.core.xui.NLSChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.parser.XMLInputSource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NLS
extends LanguageEnhancedProperties {
    private static final char EMPTY_CHAR = ' ';
    public static final String CUSTOM_IDENTIFIER = "custom";
    public static final String LANG_INDEPENDENT_IDENTIFIER = "all";
    public static final String XPATH_DELIMITER = "?%(";
    public static final String LABEL_DELIMITER = "?\ufffd(";
    public static final String UNDEFINED_VALUE = "undefined";
    public static final String CLOSING_DELIMITER = ")";
    public static final char TAG_DELIMITER = JAXFrontProperties.getInstance().getNLSTagDelimiter();
    private String _language;
    private String _resourceID;
    private boolean _hasChanged;
    private boolean _isInitializing;
    private Vector _nlsListener = null;
    private static int miniCacheEnd = 4;
    private Object[] smallCashKey = new Object[miniCacheEnd + 1];
    private Object[] smallCashValue = new Object[miniCacheEnd + 1];
    private int lastCI = -1;
    public static final String CONTEXT_TREE_ENTRY = "treeEntry";
    public static final String CONTEXT_LABEL = "label";
    public static final String CONTEXT_PAGING = "paging";
    public static final String CONTEXT_CHOICE = "choice";
    public static final String CONTEXT_CAPTION = "caption";
    public static final String CONTEXT_HELP = "help";
    public static final String CONTEXT_WATERMARK = "watermark";
    public static final String CONTEXT_MESSAGE = "message";
    public static final String CONTEXT_SERIAL_LIST_ADD = "serial_add";
    public static final String CONTEXT_PRINTING = "printing";
    public static final String CONTEXT_LINE_INFO = "lineInfo";
    public static final String CONTEXT_LINE_INFO_PDF = "lineInfo_pdf";
    public static final String CONTEXT_DIALOG = "dialog";
    public static final String CONTEXT_CONTEXTDIALOG = "contextdialog";
    public static final String CONTEXT_DELETION_MESSAGE = "deletionConfirmationMessage";
    public static final String CONTEXT_MESSAGE_FORMULA = "formula";
    public static final String CONTEXT_LINE_INFO_TOOLTIP = "toolTip";
    public static final String CONTEXT_MODE_VALIDATION_MESSAGE = "validationMessage";
    public static final String CLASSIFICATION_TOOL_TIP = "tooltip";
    public static final String REFERENCE_KEY_IDENTIFIER_OPEN = "<REF>";
    public static final String REFERENCE_KEY_IDENTIFIER_CLOSE = "</REF>";
    static /* synthetic */ Class class$com$jaxfront$core$xui$NLS;

    public NLS(String nlsContentStream, String id) {
        this._isInitializing = true;
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(this.getClass(), new StringBuffer().append("Load NLS file (").append(id).append(") from string content.").toString());
        }
        StringReader reader = new StringReader(nlsContentStream);
        LanguageEnhancedProperties nlsProperties = new LanguageEnhancedProperties();
        try {
            nlsProperties.load(reader);
            this.putAll((Map)nlsProperties);
        }
        catch (IOException ex) {
            LogRegistry.getInstance().warn(this.getClass(), new StringBuffer().append("Load NLS file (").append(id).append(") from string content. Failed: ").append(ex.getLocalizedMessage()).toString());
        }
        this._isInitializing = false;
    }

    public NLS(NLS nls) {
        super(nls.size(), 0.9f);
        this._isInitializing = true;
        this.putAll((Map)nls);
        this.setResourceID(nls.getResourceID());
        this._language = nls.getLanguage();
        this._isInitializing = false;
    }

    public NLS() {
    }

    public NLS(URL xsdURL, FingerPrint fingerPrint, String language) {
        this(xsdURL, fingerPrint, language, null, true);
    }

    public NLS(URL xsdURL, FingerPrint fingerPrint, String language, String[] nlsLanguageSequence) {
        this(xsdURL, fingerPrint, language, nlsLanguageSequence, true);
    }

    public NLS(URL xsdURL, FingerPrint fingerPrint, String language, String[] nlsLanguageSequence, boolean handleIncludes) {
        this(xsdURL, fingerPrint, language, nlsLanguageSequence, handleIncludes, false);
    }

    public NLS(URL xsdURL, FingerPrint fingerPrint, String language, String[] nlsLanguageSequence, boolean handleIncludes, boolean includesOnly) {
        this(xsdURL, null, fingerPrint, language, nlsLanguageSequence, handleIncludes, includesOnly);
    }

    public NLS(URL xsdURL, Document uiDoc, FingerPrint fingerPrint, String language, String[] nlsLanguageSequence, boolean handleIncludes, boolean includesOnly) {
        this._language = language;
        this.initialize(xsdURL, uiDoc, fingerPrint, null, handleIncludes, includesOnly, 0, nlsLanguageSequence);
    }

    public static boolean hasIncludedNLS(Document uiDoc) {
        return uiDoc != null && uiDoc.getRootType().getChild("nls").getDirectChildrenSize() > 0;
    }

    public static boolean hasIncludedNLS(org.w3c.dom.Document w3cUIDoc) {
        return w3cUIDoc != null && DOMHelper.getChild(null, w3cUIDoc.getDocumentElement(), "nls") != null;
    }

    private void initialize(URL xsdURL, Document uiDoc, FingerPrint fingerPrint, String lookupName, boolean handleIncludes, boolean includesOnly, int recursionDepth, String[] nlsLanguageSequence) {
        URL baseURL;
        String appContext;
        JAXFrontProperties jaxProps;
        this._isInitializing = true;
        if (nlsLanguageSequence == null) {
            nlsLanguageSequence = new String[]{this._language};
        }
        if (((jaxProps = JAXFrontProperties.getInstance(appContext = uiDoc != null ? uiDoc.getAppContext() : null)).useEmbeddedNLS() || NLS.hasIncludedNLS(uiDoc)) && uiDoc != null) {
            this.initializeEmbedded(uiDoc, handleIncludes, includesOnly);
        }
        if ((baseURL = fingerPrint.getXUIURL()) == null) {
            baseURL = xsdURL;
        }
        if (baseURL != null) {
            ++recursionDepth;
            if (handleIncludes && fingerPrint.getIncludedFingerPrints() != null && fingerPrint.getIncludedFingerPrints().size() > 0) {
                Iterator iterator = fingerPrint.getIncludedFingerPrints().iterator();
                int counter = 0;
                String innerLookupName = null;
                while (iterator.hasNext()) {
                    Vector incl = fingerPrint.getIncludes();
                    innerLookupName = incl != null && incl.size() > counter ? (String)incl.get(counter) : null;
                    FingerPrint inclFP = (FingerPrint)iterator.next();
                    inclFP.setNLSReadingSequence(fingerPrint.getNLSReadingSequence(null));
                    this.initialize(baseURL, uiDoc, inclFP, innerLookupName, handleIncludes, includesOnly, recursionDepth, nlsLanguageSequence);
                    ++counter;
                }
            }
            if (!jaxProps.useEmbeddedNLS()) {
                if (fingerPrint != null && jaxProps.isNLSReadingFieldScope()) {
                    nlsLanguageSequence = ArrayUtil.invert(nlsLanguageSequence);
                }
                for (int ls = 0; ls < nlsLanguageSequence.length; ++ls) {
                    String currentLang = nlsLanguageSequence[ls];
                    String fileNameAll = URLHelper.createNLSFileName(baseURL, LANG_INDEPENDENT_IDENTIFIER);
                    String fileName = URLHelper.createNLSFileName(baseURL, currentLang);
                    String fileNameCustomAll = URLHelper.createNLSFileName(baseURL, "all_custom");
                    String fileNameCustom = URLHelper.createNLSFileName(baseURL, new StringBuffer().append(currentLang).append("_").append(CUSTOM_IDENTIFIER).toString());
                    URL nlsLookupURL = URLHelper.createNLSURL(baseURL, currentLang);
                    if (lookupName != null) {
                        fileNameAll = URLHelper.createNameWithSuffix(null, lookupName, LANG_INDEPENDENT_IDENTIFIER, ".nls");
                        fileName = URLHelper.createNameWithSuffix(null, lookupName, currentLang, ".nls");
                        fileNameCustomAll = URLHelper.createNameWithSuffix(null, lookupName, "all_custom", ".nls");
                        fileNameCustom = URLHelper.createNameWithSuffix(null, lookupName, new StringBuffer().append(currentLang).append("_").append(CUSTOM_IDENTIFIER).toString(), ".nls");
                    }
                    boolean succeedNLS = false;
                    boolean succeedAllNLS = false;
                    boolean succeedCustomNLS = false;
                    boolean succeedCustomAllNLS = false;
                    if (fingerPrint.getEntityResolver() != null) {
                        if (fingerPrint.getEntityResolver() instanceof IJAXFrontEntityResolver) {
                            ((IJAXFrontEntityResolver)fingerPrint.getEntityResolver()).setLookupClassLoader(false);
                        }
                        InputStream is = null;
                        try {
                            XMLInputSource allXmlInputSource = fingerPrint.getEntityResolver().resolveEntity((XMLResourceIdentifier)new XMLResourceIdentifierImpl(null, fileNameAll, null, null));
                            if (allXmlInputSource != null) {
                                is = allXmlInputSource.getByteStream();
                                succeedAllNLS = this.loadNLSFromLocation(includesOnly, recursionDepth, is);
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        try {
                            XMLInputSource xmlInputSource = fingerPrint.getEntityResolver().resolveEntity((XMLResourceIdentifier)new XMLResourceIdentifierImpl(null, fileName, null, null));
                            if (xmlInputSource != null) {
                                is = xmlInputSource.getByteStream();
                                succeedNLS = this.loadNLSFromLocation(includesOnly, recursionDepth, is);
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        if (jaxProps.allowCustomXUI()) {
                            XMLInputSource customXmlInputSource;
                            try {
                                customXmlInputSource = fingerPrint.getEntityResolver().resolveEntity((XMLResourceIdentifier)new XMLResourceIdentifierImpl(null, fileNameCustomAll, null, null));
                                if (customXmlInputSource != null) {
                                    is = customXmlInputSource.getByteStream();
                                    succeedCustomAllNLS = this.loadNLSFromLocation(includesOnly, recursionDepth, is);
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                customXmlInputSource = fingerPrint.getEntityResolver().resolveEntity((XMLResourceIdentifier)new XMLResourceIdentifierImpl(null, fileNameCustom, null, null));
                                if (customXmlInputSource != null) {
                                    is = customXmlInputSource.getByteStream();
                                    succeedCustomNLS = this.loadNLSFromLocation(includesOnly, recursionDepth, is);
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if (fingerPrint.getEntityResolver() instanceof IJAXFrontEntityResolver) {
                            ((IJAXFrontEntityResolver)fingerPrint.getEntityResolver()).setLookupClassLoader(true);
                        }
                    } else {
                        succeedAllNLS = this.loadNLSFromLocation(includesOnly, recursionDepth, fileNameAll, nlsLookupURL);
                        succeedNLS = this.loadNLSFromLocation(includesOnly, recursionDepth, fileName, nlsLookupURL);
                        if (jaxProps.allowCustomXUI()) {
                            URL nlsLookupURLCustomALl = URLHelper.createNLSURL(baseURL, "all_custom");
                            succeedCustomAllNLS = this.loadNLSFromLocation(includesOnly, recursionDepth, fileNameCustom, nlsLookupURLCustomALl);
                            URL nlsLookupURLCustom = URLHelper.createNLSURL(baseURL, new StringBuffer().append(currentLang).append("_").append(CUSTOM_IDENTIFIER).toString());
                            succeedCustomNLS = this.loadNLSFromLocation(includesOnly, recursionDepth, fileNameCustom, nlsLookupURLCustom);
                        }
                    }
                    if (jaxProps.isNLSReadingFieldScope() || !succeedNLS && !succeedCustomNLS) continue;
                    fingerPrint.setLastLoadedLanguage(currentLang);
                    break;
                }
            }
        }
        this._isInitializing = false;
    }

    private boolean loadNLSFromLocation(boolean includesOnly, int recursionDepth, String fileName, URL nlsLookupURL) {
        if (nlsLookupURL != null) {
            if (includesOnly) {
                if (recursionDepth > 1) {
                    return this.addNLSEntries(fileName, nlsLookupURL);
                }
            } else {
                return this.addNLSEntries(fileName, nlsLookupURL);
            }
        }
        return false;
    }

    private boolean loadNLSFromLocation(boolean includesOnly, int recursionDepth, InputStream is) {
        if (is != null) {
            if (includesOnly) {
                if (recursionDepth > 1) {
                    return this.addNLSEntries(is);
                }
            } else {
                return this.addNLSEntries(is);
            }
        }
        return false;
    }

    private void initializeEmbedded(Document uiDoc, boolean handleIncludes, boolean includesOnly) {
        ListType nlsList = (ListType)uiDoc.getRootType().getDirectChild("nls");
        Iterator nlsIterator = nlsList.getList().iterator();
        Type nls = null;
        ListType contentList = null;
        Type content2 = null;
        String contentLanguage = null;
        String nlsContent = null;
        Iterator contentIterator = null;
        while (nlsIterator.hasNext()) {
            nls = (Type)nlsIterator.next();
            contentList = (ListType)nls.getDirectChild("content");
            for (Type content2 : contentList.getList()) {
                contentLanguage = content2.getDirectChildValue("language");
                if (!this._language.equals(contentLanguage) || (nlsContent = content2.getDirectChildValue("text()")) == null) continue;
                if (handleIncludes) {
                    if (includesOnly) {
                        if (!nls.isIncluded()) continue;
                        this.addNLSEntries(new StringReader(nlsContent));
                        continue;
                    }
                    this.addNLSEntries(new StringReader(nlsContent));
                    continue;
                }
                if (nls.isIncluded()) continue;
                this.addNLSEntries(new StringReader(nlsContent));
            }
        }
    }

    protected boolean addNLSEntries(String fileName, URL nlsURL) {
        boolean succeed = false;
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(fileName);
            if (is == null) {
                is = JAXFrontProperties.getInstance().getURLResolver().resolveURL(nlsURL);
            }
            succeed = this.addNLSEntries(new InputStreamReader(is, JAXFrontProperties.getDefaultFileEncoding()));
            is.close();
        }
        catch (IOException ex) {
            succeed = false;
        }
        return succeed;
    }

    protected boolean addNLSEntries(InputStream is) {
        return this.addNLSEntries(new InputStreamReader(is));
    }

    protected boolean addNLSEntries(Reader reader) {
        try {
            LanguageEnhancedProperties nlsProperties = new LanguageEnhancedProperties();
            nlsProperties.load(reader);
            this.putAll((Map)nlsProperties);
            this.resolveReferences();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    private void resolveReferences() {
        for (Map.Entry entry : this.entrySet()) {
            String value = (String)entry.getValue();
            Stack<String> stack = new Stack<String>();
            entry.setValue(this.resolveNestedReferences(value, stack));
        }
    }

    private String resolveNestedReferences(String value, Stack<String> stack) {
        if (value.contains(REFERENCE_KEY_IDENTIFIER_OPEN)) {
            List references = StringUtil.getAllBetween(value, REFERENCE_KEY_IDENTIFIER_OPEN, REFERENCE_KEY_IDENTIFIER_CLOSE);
            for (String refKey : references) {
                if (!stack.isEmpty() && refKey.equalsIgnoreCase((String)stack.firstElement())) {
                    value = new StringBuffer().append("Error: You have a circular reference with key: ").append(refKey).toString();
                    continue;
                }
                if (!this.containsKey(refKey) || !value.contains(refKey)) continue;
                stack.push(refKey);
                value = StringUtil.replace(value, new StringBuffer().append(REFERENCE_KEY_IDENTIFIER_OPEN).append(refKey).append(REFERENCE_KEY_IDENTIFIER_CLOSE).toString(), this.get(refKey));
                value = this.resolveNestedReferences(value, stack);
            }
        }
        return value;
    }

    public String get(String key) {
        key = TextTools.removeChar(key, ' ');
        return this.get(null, key, null);
    }

    public String get(String key, String defaultVal) {
        String value = this.get(key);
        if (value == null) {
            value = defaultVal;
        }
        return value;
    }

    @Override
    public synchronized void putAll(Map t) {
        if (t != null) {
            for (Map.Entry e : t.entrySet()) {
                String key = TextTools.unEscapeNLSEntities(e.getKey().toString());
                String value = TextTools.unEscapeNLSEntities(e.getValue().toString());
                Object replacement = this.put(key, value);
            }
        }
    }

    public String get(Type source, String key) {
        return this.get(source, key, null);
    }

    public String get(Type source, String key, String[] variables) {
        String text = (String)super.get(key);
        if (text == null) {
            return null;
        }
        if (variables != null) {
            text = NLS.replaceVariables(text, variables);
        }
        if (source != null) {
            text = NLS.replaceXPathPointers(source, text);
        }
        return text;
    }

    public static String replaceVariables(String text, String[] variables) {
        return StringUtil.replace(text, '%', variables);
    }

    public static String replaceXPathPointers(Type source, String text) {
        Vector<String> variables = new Vector<String>();
        if (text != null && text.length() > 0) {
            StringTokenizer st = new StringTokenizer(text, " ");
            while (st.hasMoreElements()) {
                String variable = st.nextToken();
                if (!variable.startsWith(XPATH_DELIMITER) && (!variable.startsWith(LABEL_DELIMITER) || variable.length() <= 1)) continue;
                variables.add(variable);
            }
            if (variables.size() > 0) {
                for (int i = 0; i < variables.size(); ++i) {
                    String variable = (String)variables.get(i);
                    String xpath = null;
                    boolean isLabel = false;
                    if (variable == null) continue;
                    if (variable.startsWith(LABEL_DELIMITER)) {
                        isLabel = true;
                    }
                    if ((xpath = variable.substring(3, variable.lastIndexOf(CLOSING_DELIMITER))) == null || xpath.length() <= 0) continue;
                    List list = TypePathExecuter.getInstance().processXPath(source, xpath);
                    Type varType = null;
                    if (list.size() > 0) {
                        varType = (Type)list.get(0);
                    }
                    if (varType == null) continue;
                    String varContent = null;
                    if (isLabel) {
                        varContent = varType.getXUIDefinition().getStyle().getLabelText();
                        varContent = varContent.trim();
                    } else {
                        varContent = ((SimpleType)varType).getValue();
                        if (varContent == null) {
                            varContent = UNDEFINED_VALUE;
                        }
                    }
                    text = text.endsWith(variable) ? TextTools.replace(text, variable, varContent) : TextTools.replace(text, variable, varContent, " ");
                }
            } else {
                return text;
            }
        }
        return text;
    }

    public boolean hasChanged() {
        return this._hasChanged;
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        Object previous = super.setProperty(key, value);
        if (previous != null) {
            if (!previous.equals(value)) {
                this.setHasChanged(true);
            }
        } else if (value != null) {
            this.setHasChanged(true);
        }
        return previous;
    }

    @Override
    public synchronized void save(OutputStream out, String header) {
        super.save(out, header);
        this.setHasChanged(false);
    }

    @Override
    public synchronized void store(OutputStream out, String header) throws IOException {
        super.store(out, header);
        this.setHasChanged(false);
    }

    @Override
    public synchronized void store(Writer out, String header) throws IOException {
        super.store(out, header);
        this.setHasChanged(false);
    }

    public static String getNLSHeader() {
        return "NLS (National Language Support) JAXFront V2.77 (10-2011-01)";
    }

    private Vector getSortedNLSList(String rootTypeName) {
        Vector<String> stringVector = new Vector<String>();
        Vector<Object> sortedVector = new Vector();
        for (String key : this.keySet()) {
            String value = this.get(key);
            String nlsEntry = new StringBuffer().append(TextTools.escapeNLSEntities(key)).append("=").append(TextTools.escapeNLSEntities(value)).toString();
            stringVector.add(nlsEntry);
        }
        sortedVector = rootTypeName != null ? TreeSort.sort(stringVector, new XPathSorter(rootTypeName)) : stringVector;
        return sortedVector;
    }

    public void store(Type contentType) throws IOException {
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(this.getClass(), new StringBuffer().append("Store NLS-File to XUI (").append(contentType.getXPathLocation()).append(CLOSING_DELIMITER).toString());
        }
        StringWriter sw = new StringWriter();
        this.store(sw, NLS.getNLSHeader());
        contentType.setDirectChildValue("text()", sw.getBuffer().toString());
    }

    public void storeAsSortedNLS(File file, String rootTypeName) throws IOException {
        Vector sortedVector = this.getSortedNLSList(rootTypeName);
        FileOutputStream out = new FileOutputStream(file);
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(this.getClass(), new StringBuffer().append("Store NLS-File (").append(file.getAbsolutePath()).append(CLOSING_DELIMITER).toString());
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, JAXFrontProperties.getDefaultFileEncoding()));
        writer.write(new StringBuffer().append("#").append(NLS.getNLSHeader()).toString());
        writer.newLine();
        writer.write(new StringBuffer().append("#").append(new Date().toString()).toString());
        writer.newLine();
        Iterator iterator = sortedVector.iterator();
        while (iterator.hasNext()) {
            writer.write((String)iterator.next());
            writer.newLine();
        }
        writer.flush();
        this.setHasChanged(false);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return this.put(key, value, null, null);
    }

    public synchronized Object put(Object key, Object value, Type sourceType, Object raiser) {
        Object previous;
        if (key instanceof String) {
            key = TextTools.replace((String)key, " ", "");
        }
        if ((previous = super.put(key, value)) != null) {
            if (!previous.equals(value)) {
                this.setHasChanged(true);
            }
        } else if (value != null) {
            this.setHasChanged(true);
        }
        if (this.hasChanged()) {
            this.fireNLSChanged(new NLSChangeEvent((String)key, (String)value, sourceType, raiser));
        }
        return previous;
    }

    public static String createParamNLSKey(Type nlsType, String paramSuffix, int ruleIndex, int actionIndex, int paramIndex) {
        StringBuffer context = new StringBuffer(paramSuffix);
        if (ruleIndex >= 0) {
            context.append(ruleIndex);
            if (actionIndex >= 0) {
                context.append("-");
                context.append(actionIndex);
            }
        }
        String subId = new StringBuffer().append(paramIndex).append("").toString();
        if (paramIndex < 0) {
            subId = null;
        }
        return NLS.createKeyForXUIEditor(nlsType, context.toString(), subId, null);
    }

    public static String createParamNLSKey(Type nlsType) {
        Object userObject;
        boolean isMainAction = nlsType.getParent("mainAction") != null;
        String ruleSuffix = "rule-main-";
        if (!isMainAction) {
            ruleSuffix = "rule-inverse-";
        }
        int paramIndex = nlsType.getParentList().getList().indexOf(nlsType.getParent("param"));
        Type ruleType = nlsType.getParent("rule");
        ListType ruleListType = (ListType)ruleType.getParent();
        int ruleIndex = ruleListType.getList().indexOf(ruleType);
        Type actionType = nlsType.getParent("action");
        ListType actionListType = (ListType)actionType.getParent();
        int actionIndex = actionListType.getList().indexOf(actionType);
        Type componentParent = nlsType.getParent("component");
        if (componentParent != null && (userObject = componentParent.getUserObject()) == null) {
            TypeController.updateXUICompUserObject(nlsType);
        }
        return NLS.createParamNLSKey(nlsType, ruleSuffix, ruleIndex, actionIndex, paramIndex);
    }

    @Override
    public synchronized Object remove(Object key) {
        Object oldKey = super.remove(key);
        if (oldKey != null) {
            this.setHasChanged(true);
        }
        return oldKey;
    }

    public void removeNLS(String xpath) {
        Iterator foundNls = this.getAllNLSFor(xpath).iterator();
        while (foundNls.hasNext()) {
            this.remove(foundNls.next());
        }
    }

    public void swapAllNLSWithPartitialKey(String sourceKey, String destKey) {
        String tempKey = new StringBuffer().append(destKey).append("ThisIsACopy").toString();
        this.replaceAllNLSWithPartitialKey(destKey, tempKey);
        this.replaceAllNLSWithPartitialKey(sourceKey, destKey);
        this.replaceAllNLSWithPartitialKey(tempKey, sourceKey);
    }

    public void removeAllNLSWithPartitialKey(String sourceKey) {
        Vector allMainParamsNls = this.getAllNLSWithKey(sourceKey);
        for (int i = 0; i < allMainParamsNls.size(); ++i) {
            String mainKey = (String)allMainParamsNls.get(i);
            this.remove(mainKey);
        }
    }

    public void replaceAllNLSWithPartitialKey(String sourceKey, String destKey) {
        Vector allMainParamsNls = this.getAllNLSWithKey(sourceKey);
        for (int i = 0; i < allMainParamsNls.size(); ++i) {
            String mainKey = (String)allMainParamsNls.get(i);
            String mainValue = this.get(mainKey);
            String newMainKey = StringUtil.replace(mainKey, sourceKey, destKey);
            this.remove(mainKey);
            this.put(newMainKey, mainValue);
        }
    }

    public void insertRelativeNLS(URL location, String relativeTo) throws IOException {
        Properties nlsProps = new Properties();
        nlsProps.load(JAXFrontProperties.getInstance().getURLResolver().resolveURL(location));
        Enumeration<Object> nlsEnum = nlsProps.keys();
        while (nlsEnum.hasMoreElements()) {
            String key = (String)nlsEnum.nextElement();
            String value = (String)nlsProps.get(key);
            this.put(new StringBuffer().append(relativeTo).append(key).toString(), value);
        }
    }

    public Properties extractRelativeNLS(String relativeTo) {
        Properties nlsProps = new Properties();
        Vector nlsKeys = this.getAllNLSFor(relativeTo);
        for (int i = 0; i < nlsKeys.size(); ++i) {
            String key = (String)nlsKeys.get(i);
            String value = this.get(key);
            nlsProps.put(key.subSequence(key.indexOf(TAG_DELIMITER), key.length()), value);
        }
        return nlsProps;
    }

    public String getFormula(Type source, String context, String subId) {
        String nls = this.get(NLS.nlsKey(source, context, subId, CONTEXT_MESSAGE_FORMULA));
        return nls;
    }

    public boolean hasFormula(Type source, String context, String subId) {
        String nls = this.get(NLS.nlsKey(source, context, subId, CONTEXT_MESSAGE_FORMULA));
        return nls != null;
    }

    public String getTranslation(Type source, String defaultNLS, String context, String subId, String classification) {
        String relativeXPath;
        if (source.isEmpty()) {
            return null;
        }
        if (source.isVirtual()) {
            source = ((VirtualType)source).getSourceType();
        }
        String nls = null;
        String prefixedXPath = source.getPrefixedXPathLocation();
        String nlsKey = NLS.nlsKey(source, prefixedXPath, context, subId, classification);
        nls = this.get(nlsKey);
        if (nls == null && source.getVarName() != null) {
            nlsKey = NLS.nlsKey(source, source.getVarName(), context, subId, classification);
            nls = this.get(nlsKey);
        }
        if (nls == null && !(relativeXPath = TypePathExecuter.getRelativeXPathLocation(source.getPrefixedXPathLocation())).equals(prefixedXPath)) {
            nlsKey = NLS.nlsKey(source, relativeXPath, context, subId, classification);
            nls = this.get(nlsKey);
        }
        if (nls == null && source.getDOM().getGlobalDefinition().useGlobalUIDefintions()) {
            nls = this.getGlobalNLS(source, context, subId, classification);
        }
        if (nls != null && classification != null && classification.equals(CONTEXT_MESSAGE_FORMULA)) {
            try {
                nls = source.getDOM().getController().getMathEvaluator().evaluateString(source, source, null, nls, false, null);
            }
            catch (Exception ex) {
                LogRegistry.getInstance().error(this.getClass(), ex.getMessage());
            }
        }
        if (nls != null) {
            return nls;
        }
        if (defaultNLS != null) {
            return defaultNLS;
        }
        return null;
    }

    public Object searchInCacheArray(Object o) {
        int s = this.smallCashKey.length;
        for (int i = s - 1; i >= 0; --i) {
            if (this.smallCashKey[i] != o) continue;
            return this.smallCashValue[i];
        }
        return null;
    }

    public void clearSmallCash() {
        this.smallCashKey = new Object[miniCacheEnd + 1];
        this.smallCashValue = new Object[miniCacheEnd + 1];
    }

    public void putInCacheArray(Object key, Object value) {
        int newCI = this.lastCI + 1;
        if (newCI > miniCacheEnd) {
            newCI = 0;
        }
        this.smallCashKey[newCI] = key;
        this.smallCashValue[newCI] = value;
    }

    private String getGlobalNLS(Type source, String context, String subId, String classification) {
        String nls = null;
        String[] globalXPaths = (String[])this.searchInCacheArray(source);
        if (globalXPaths == null) {
            globalXPaths = DOMHelper.getGlobalParentXPathsUpTo(source);
            this.putInCacheArray(source, globalXPaths);
        }
        for (int counter = 0; globalXPaths.length > counter; ++counter) {
            String nlsKey = NLS.nlsKey(source, globalXPaths[counter], context, subId, classification);
            nls = this.get(nlsKey);
            if (nls == null) continue;
            return nls;
        }
        return null;
    }

    public static String getNLSPageLayoutContext(Type type) {
        Type pagingType = type.getParent(CONTEXT_PAGING);
        if (pagingType != null) {
            int index = pagingType.getParentList().getList().indexOf(pagingType);
            return new StringBuffer().append("pageLayout_").append(String.valueOf(index)).toString();
        }
        return "tableLayout";
    }

    public static String nlsKey(Type source, String xpath, String context, String subId, String classification) {
        StringBuilder key = null;
        if (xpath == null) {
            xpath = NLS.resolveKeyXPath(source);
        }
        if (xpath == null) {
            if (LogRegistry.getInstance().logWarnings()) {
                LogRegistry.getInstance().warn(class$com$jaxfront$core$xui$NLS == null ? (class$com$jaxfront$core$xui$NLS = NLS.class$("com.jaxfront.core.xui.NLS")) : class$com$jaxfront$core$xui$NLS, "Error try to create a nls key entry with null object!");
            }
            key = new StringBuilder();
        } else {
            key = new StringBuilder(xpath);
        }
        if (context != null && context.length() > 0) {
            key.append(TAG_DELIMITER);
            key.append(context);
        }
        if (subId != null && subId.length() > 0) {
            key.append(TAG_DELIMITER);
            key.append(subId);
        }
        if (classification != null && classification.length() > 0) {
            key.append(TAG_DELIMITER);
            key.append(classification);
        }
        return key.toString();
    }

    public static String nlsKey(Type source, String context, String subId, String classification) {
        return NLS.nlsKey(source, null, context, subId, classification);
    }

    private void setHasChanged(boolean hasChanged) {
        if (!this._isInitializing) {
            this._hasChanged = hasChanged;
        }
    }

    public Vector getAllNLSFor(Type aType) {
        return this.getAllNLSFor(NLS.resolveKeyXPath(aType));
    }

    public Vector getAllNLSFor(String typeXPath) {
        Vector<String> result = new Vector<String>();
        for (String element : this.keySet()) {
            int underScorePos = element.indexOf(TAG_DELIMITER);
            if (underScorePos <= 0 || !element.substring(0, underScorePos).equals(typeXPath)) continue;
            result.add(element);
        }
        return result;
    }

    public Vector getAllNLSWithKey(String startsWith) {
        Vector<String> result = new Vector<String>();
        for (String element : this.keySet()) {
            if (!element.startsWith(startsWith)) continue;
            result.add(element);
        }
        return result;
    }

    public Vector getAllNLSFor(Type aType, String context, boolean contextStartsWith) {
        return this.getAllNLSFor(NLS.resolveKeyXPath(aType), context, contextStartsWith);
    }

    public Vector getAllNLSFor(String typeXPath, String context, boolean contextStartsWith) {
        Vector<String> result = new Vector<String>();
        for (String element : this.keySet()) {
            String nlsXpath;
            int firstTagPos = element.indexOf(TAG_DELIMITER);
            if (firstTagPos <= 0 || !(nlsXpath = element.substring(0, firstTagPos)).equals(typeXPath)) continue;
            if (context != null) {
                int secondTagPos = element.indexOf(TAG_DELIMITER, firstTagPos + 1);
                if (secondTagPos <= 0) continue;
                String nlsContext = element.substring(firstTagPos + 1, secondTagPos);
                if (contextStartsWith) {
                    if (!nlsContext.startsWith(context)) continue;
                    result.add(element);
                    continue;
                }
                if (!nlsContext.equals(context)) continue;
                result.add(element);
                continue;
            }
            result.add(element);
        }
        return result;
    }

    public Hashtable convertAllNLSFor(Type sourceType, Type targetType, boolean updateNLS) {
        return this.convertAllNLSFor(NLS.resolveKeyXPath(sourceType), NLS.resolveKeyXPath(targetType), updateNLS);
    }

    public Hashtable copyAllNLS(Type sourceType, Type targetType) {
        return this.copyAllNLS(NLS.resolveKeyXPath(sourceType), NLS.resolveKeyXPath(targetType));
    }

    public Hashtable copyAllNLS(String sourceXPath, String targetXpath) {
        Hashtable newNLS = this.convertAllNLSFor(sourceXPath, targetXpath, false);
        this.putAll((Map)newNLS);
        return newNLS;
    }

    public void copyNLSWithKey(String sourceKey, String targetKey) {
        String sourceValue = this.get(sourceKey);
        if (sourceValue != null) {
            this.put(targetKey, sourceValue);
        }
    }

    public void copyNLSStartingWithKey(String sourceKey, String targetKey) {
        Vector sourceKeys = this.getAllNLSWithKey(sourceKey);
        for (int i = 0; i < sourceKeys.size(); ++i) {
            String aNlsKey = (String)sourceKeys.get(i);
            String sourceValue = this.get(aNlsKey);
            if (sourceValue == null) continue;
            String targetNLSKey = new StringBuffer().append(targetKey).append(aNlsKey.substring(sourceKey.length())).toString();
            this.put(targetNLSKey, sourceValue);
        }
    }

    public void moveAllListEntryNLS(ListType list, String context, int from, int to) {
        String listXPath = NLS.createTargetXPathForXUIEditor(list);
        String convertedSourceXPath = NLS.convertFromGlobalXPath(listXPath);
        int tempIndex = -1;
        this.moveAllListEntryNLS(convertedSourceXPath, context, to, tempIndex, true);
        this.moveAllListEntryNLS(convertedSourceXPath, context, from, to, true);
        this.moveAllListEntryNLS(convertedSourceXPath, context, tempIndex, from, true);
    }

    public static boolean isInContext(String key, String context) {
        int secondTagDel;
        if (context.equals("*")) {
            return true;
        }
        int firstTagDel = key.indexOf(TAG_DELIMITER);
        return firstTagDel >= 0 && (secondTagDel = key.indexOf(TAG_DELIMITER, firstTagDel + 1)) >= 0 && key.substring(firstTagDel + 1, secondTagDel).equals(context);
    }

    public void moveAllListEntryNLS(String xpath, String context, int from, int to, boolean removeSource) {
        Vector sourceNLSKeys = this.getAllNLSFor(xpath);
        for (int i = 0; i < sourceNLSKeys.size(); ++i) {
            String sourceKey = (String)sourceNLSKeys.get(i);
            int listIndexPos = -1;
            int listIndexEndPos = -1;
            int formTagLength = new StringBuffer().append(TAG_DELIMITER).append(CONTEXT_MESSAGE_FORMULA).toString().length();
            if (sourceKey.endsWith(new StringBuffer().append(TAG_DELIMITER).append(CONTEXT_MESSAGE_FORMULA).toString())) {
                listIndexPos = sourceKey.substring(0, sourceKey.length() - formTagLength - 1).lastIndexOf(TAG_DELIMITER);
                listIndexEndPos = sourceKey.length() - formTagLength;
            } else {
                listIndexPos = sourceKey.lastIndexOf(TAG_DELIMITER);
                listIndexEndPos = sourceKey.length();
            }
            if (listIndexPos < 0 || !NLS.isInContext(sourceKey, context)) continue;
            String listIndex = sourceKey.substring(listIndexPos + 1, listIndexEndPos);
            try {
                if (Integer.parseInt(listIndex) != from) continue;
                String newSourceKey = new StringBuffer().append(sourceKey.substring(0, listIndexPos + 1)).append(to).append(sourceKey.substring(listIndexEndPos)).toString();
                String sourceValue = this.get(sourceKey);
                if (removeSource) {
                    this.remove(sourceKey);
                }
                this.put(newSourceKey, sourceValue);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public Hashtable convertAllNLSFor(String sourceXPath, String targetXPath, boolean updateNLS) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String convertedSourceXPath = NLS.convertFromGlobalXPath(sourceXPath);
        Vector sourceNLSKeys = this.getAllNLSFor(convertedSourceXPath);
        for (int i = 0; i < sourceNLSKeys.size(); ++i) {
            String sourceNLSKey = sourceNLSKeys.get(i).toString();
            String value = this.get(sourceNLSKey);
            String targetNLSKey = sourceNLSKey;
            if (!sourceXPath.equals(targetXPath)) {
                targetNLSKey = TextTools.replace(sourceNLSKey, convertedSourceXPath, targetXPath);
            }
            result.put(targetNLSKey, value);
            if (!updateNLS) continue;
            this.put(targetNLSKey, value);
            this.remove(sourceNLSKey);
        }
        return result;
    }

    public static String convertFromGlobalXPath(String xpath) {
        if (xpath.startsWith("global:")) {
            if (!xpath.startsWith("/", "global:".length())) {
                return new StringBuffer().append("/").append(xpath.substring("global:".length())).toString();
            }
            return xpath.substring("global:".length());
        }
        return xpath;
    }

    public static String resolveKeyXPath(Type type) {
        String xpath = type.getXUIDefinition().getXUIXPath();
        if (xpath != null && xpath.startsWith("global:")) {
            xpath = TextTools.replace(xpath, "global:", "/");
        }
        return xpath;
    }

    public static String resolveKeyXPathFromXuiComponent(Type xuiType) {
        Type component = xuiType.getParent("component");
        if (component != null) {
            return component.getDirectChildValue("xpath");
        }
        return NLS.resolveKeyXPath(xuiType.getXUIDefinition().getTargetType());
    }

    public static String createKeyForXUIEditor(Type type, String context, String subId, String classification) {
        String key = "";
        Type targetType = null;
        if (type != null && type.getDOM() != null && type.getDOM().getRootType().getName().equals("PDF_XUI")) {
            targetType = type.getDOM().getRootType();
        } else {
            targetType = type.getXUIDefinition().getTargetType();
            if (targetType == null) {
                targetType = type;
            }
        }
        if (targetType != null) {
            Type componentParent = type.getParent("component");
            String xpath = null;
            xpath = componentParent != null ? componentParent.getDirectChildValue("xpath") : targetType.getXPathLocation();
            String prefix = targetType.getSchemaType().getNamespacePrefix();
            String globalPrefixed = new StringBuffer().append("global:").append(prefix).append(":").toString();
            if (prefix != null && prefix.length() > 0 && xpath.startsWith(globalPrefixed)) {
                xpath = new StringBuffer().append("global:").append(xpath.substring(globalPrefixed.length())).toString();
            }
            key = NLS.nlsKey(targetType, xpath, context, subId, classification);
        }
        return NLS.convertFromGlobalXPath(key);
    }

    public static String createTargetXPathForXUIEditor(Type type) {
        Type targetType = null;
        String xpath = null;
        targetType = type.getDOM().getRootType().getName().equals("PDF_XUI") ? type.getDOM().getRootType() : (type.getXUIDefinition().getTargetType() != null ? type.getXUIDefinition().getTargetType() : type);
        if (targetType != null) {
            Type componentParent = type.getParent("component");
            xpath = componentParent != null ? componentParent.getDirectChildValue("xpath") : targetType.getXPathLocation();
        }
        return xpath;
    }

    private void fireNLSChanged(NLSChangeEvent event) {
        for (int i = 0; i < this.getNLSListener().size(); ++i) {
            ((NLSChangeListener)this.getNLSListener().get(i)).nlsChanged(event);
        }
    }

    public void addNLSChangeListener(NLSChangeListener listener) {
        this.getNLSListener().add(listener);
    }

    public void removeNLSChangeListener(NLSChangeListener listener) {
        this.getNLSListener().remove(listener);
    }

    public List getNLSListener() {
        if (this._nlsListener == null) {
            this._nlsListener = new Vector();
        }
        return this._nlsListener;
    }

    public String getLanguage() {
        return this._language;
    }

    public static String getSubId(Type type) {
        if (type.getName().equals(CONTEXT_LINE_INFO)) {
            return String.valueOf(type.getParentList().getList().indexOf(type));
        }
        if (type.getName().equals(CONTEXT_MESSAGE)) {
            return String.valueOf(type.getParent("rule").getParentList().getList().indexOf(type));
        }
        if (type.getName().equals("cell")) {
            return type.getDirectChildValue("dimension");
        }
        return null;
    }

    public static String getContext(Type type) {
        if (type.getName().equals(CONTEXT_TREE_ENTRY)) {
            return CONTEXT_TREE_ENTRY;
        }
        if (type.getName().equals(CONTEXT_CAPTION)) {
            return CONTEXT_CAPTION;
        }
        if (type.getName().equals("serial")) {
            return CONTEXT_SERIAL_LIST_ADD;
        }
        if (type.getName().equals(CONTEXT_PRINTING)) {
            return CONTEXT_PRINTING;
        }
        if (type.getName().equals(CONTEXT_HELP)) {
            return CONTEXT_HELP;
        }
        if (type.getName().equals("leaf")) {
            return CONTEXT_LABEL;
        }
        if (type.getName().equals(CONTEXT_LINE_INFO)) {
            if (type.getParent(CONTEXT_PRINTING) != null) {
                return CONTEXT_LINE_INFO_PDF;
            }
            return CONTEXT_LINE_INFO;
        }
        if (type.getParent().getParent().getName().equals("mode")) {
            return CONTEXT_MODE_VALIDATION_MESSAGE;
        }
        if (type.getParent().getName().equals(CONTEXT_MESSAGE)) {
            return CONTEXT_MESSAGE;
        }
        if (type.getParent().getName().equals("editMode")) {
            return CONTEXT_DIALOG;
        }
        if (type.getParent().getName().equals("context")) {
            return CONTEXT_CONTEXTDIALOG;
        }
        if (type.getName().equals(CONTEXT_DELETION_MESSAGE)) {
            return CONTEXT_DELETION_MESSAGE;
        }
        if (type.getName().equals(CONTEXT_LINE_INFO_TOOLTIP)) {
            return CONTEXT_LINE_INFO_TOOLTIP;
        }
        if (type.getName().equals(CONTEXT_CHOICE)) {
            return CONTEXT_LABEL;
        }
        if (type.getName().equals(CONTEXT_PAGING)) {
            return CONTEXT_PAGING;
        }
        return null;
    }

    public static void removeStoredEmbeddedNLS(Document uiDOM) throws IOException {
        Type nlsChild = uiDOM.getRootType().getDirectChild("nls");
        if (nlsChild != null) {
            try {
                nlsChild.removeAll();
            }
            catch (ListModificationException listModificationException) {
                // empty catch block
            }
        }
    }

    public static void storeEmbeddedNLS(Document uiDOM, NLS nls) throws IOException {
        String language = nls.getLanguage();
        ListType nlsList = (ListType)uiDOM.getRootType().getChild("nls");
        if (nlsList != null) {
            Type nlsType = null;
            ListType contentListType = null;
            Type contentType = null;
            if (nlsList.size() == 0) {
                nlsType = nlsList.addNewChild();
                contentListType = (ListType)nlsType.getDirectChild("content");
                contentType = contentListType.addNewChild();
                contentType.setDirectChildValue("language", language);
            } else {
                nlsType = (Type)nlsList.get(0);
                contentListType = (ListType)nlsType.getDirectChild("content");
                List tempContentList = TypePathExecuter.getInstance().processXPath(contentListType, new StringBuffer().append(".//@language[.='").append(language).append("']").toString());
                if (tempContentList.size() == 0) {
                    contentType = contentListType.addNewChild();
                    contentType.setDirectChildValue("language", language);
                } else {
                    contentType = ((Type)tempContentList.get(0)).getParent();
                }
            }
            if (contentType != null) {
                nls.store(contentType);
            }
        }
    }

    public String getResourceID() {
        return this._resourceID;
    }

    public void setResourceID(String id) {
        this._resourceID = id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

