/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.util.Stack;
import org.nfunk.jep.Node;
import org.nfunk.jep.Parser;
import org.nfunk.jep.ParserTreeConstants;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.function.Logical;
import org.nfunk.jep.type.NULL;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Parser parser;
    public static int count;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(Parser p, int i) {
        this(i);
        this.parser = p;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(ParserVisitor visitor, Object data) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public Object childrenFastFailAccept(Stack theStack, ParserVisitor visitor, Object data, boolean isAnd) {
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                this.children[i].jjtAccept(visitor, data);
                Object lastEvalResult = theStack.peek();
                if (++i >= this.children.length) continue;
                boolean isTrue = false;
                if (lastEvalResult instanceof Boolean) {
                    isTrue = (Boolean)theStack.peek();
                } else if (lastEvalResult instanceof Double) {
                    boolean bl = isTrue = (Double)theStack.peek() > 0.0;
                }
                if (isAnd) {
                    if (isTrue) continue;
                    while (i < this.children.length) {
                        theStack.push(Logical._false);
                        ++i;
                    }
                    continue;
                }
                if (!isTrue) continue;
                while (i < this.children.length) {
                    theStack.push(Logical._true);
                    ++i;
                }
            }
        }
        return data;
    }

    public Object childrenFastFailIfAccept(Stack theStack, ParserVisitor visitor, Object data) {
        if (this.children != null && this.children.length == 3) {
            boolean isTrue;
            this.children[0].jjtAccept(visitor, data);
            Object lastEvalResult = theStack.peek();
            boolean bl = isTrue = lastEvalResult == Boolean.TRUE;
            if (!isTrue && lastEvalResult instanceof Double) {
                boolean bl2 = isTrue = (Double)theStack.peek() > 0.0;
            }
            if (isTrue) {
                this.children[1].jjtAccept(visitor, data);
                theStack.push(NULL._null);
            } else {
                theStack.push(NULL._null);
                this.children[2].jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public String toString() {
        return ParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public int getId() {
        return this.id;
    }
}

