/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.helpers;

import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.swing.helpers.JAXFrontDocument;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public abstract class NumericDocument
extends PlainDocument
implements JAXFrontDocument {
    private boolean _bypass = false;
    private boolean _useErrorSound = true;
    private boolean _allowInvalidMinValues = true;
    private double _maxInclValue;
    private double _maxExclValue;
    private int _totalDigit = -1;
    private double _minInclValue;
    private double _minExclValue;
    private Double _minValue;
    private Double _maxValue;
    protected short _whiSpaType = (short)-1;
    protected double _defaultMaxValue = Double.POSITIVE_INFINITY;
    protected double _defaultMinValue = Double.NEGATIVE_INFINITY;
    private int _maxLengthOfCharacter = -1;
    private DecimalFormatSymbols _decimalSymbols = null;

    public NumericDocument(boolean useErrorSound) {
        this._useErrorSound = useErrorSound;
    }

    public NumericDocument(boolean useErrorSound, int maxLengthOfCharacter) {
        this._useErrorSound = useErrorSound;
        this._maxLengthOfCharacter = maxLengthOfCharacter;
    }

    public NumericDocument(boolean useErrorSound, int maxLengthOfCharacter, short whiteSpaceType) {
        this(useErrorSound, maxLengthOfCharacter);
        this._whiSpaType = whiteSpaceType;
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        block10: {
            if (this.isBypassing()) {
                super.insertString(offs, str, a);
                return;
            }
            if (str == null) {
                return;
            }
            String proposedResult = null;
            if (this.getLength() == 0) {
                proposedResult = str;
            } else {
                StringBuffer currentBuffer = new StringBuffer(this.getText(0, this.getLength()));
                currentBuffer.insert(offs, str);
                proposedResult = currentBuffer.toString();
            }
            try {
                this.parse(proposedResult);
                String textContent = this.getText(0, this.getLength());
                int contLength = this.getLength();
                if (textContent != null) {
                    contLength = TextTools.applyWhiteSpaceRestriction((String)textContent, (int)this._whiSpaType).length();
                }
                if (this._maxLengthOfCharacter == -1) {
                    super.insertString(offs, str, a);
                } else if (contLength + str.length() <= this._maxLengthOfCharacter) {
                    super.insertString(offs, str, a);
                }
            }
            catch (Exception e) {
                if (!this._useErrorSound) break block10;
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public abstract void parse(String var1) throws NumberFormatException;

    public void remove(int offs, int len) throws BadLocationException {
        if (this.isBypassing()) {
            super.remove(offs, len);
            return;
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = "";
        if (len + offs <= currentText.length()) {
            afterOffset = currentText.substring(len + offs, currentText.length());
        }
        String proposedResult = null;
        proposedResult = beforeOffset + afterOffset;
        try {
            this.parse(proposedResult);
            super.remove(offs, len);
        }
        catch (Exception e) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void setMaxInclValue(double maxInclValue) {
        this._maxInclValue = maxInclValue;
    }

    public void setMaxExclValue(double maxExclValue) {
        this._maxExclValue = maxExclValue;
    }

    public void setTotalDigit(int totalDigit) {
        this._totalDigit = totalDigit;
    }

    public int getTotalDigit() {
        return this._totalDigit;
    }

    public void setMinInclValue(double minInclValue) {
        this._minInclValue = minInclValue;
    }

    public void setMinExclValue(double minExclValue) {
        this._minExclValue = minExclValue;
    }

    public double getMaxInclValue() {
        return this._maxInclValue;
    }

    public double getMaxExclValue() {
        return this._maxExclValue;
    }

    public double getMinInclValue() {
        return this._minInclValue;
    }

    public double getMinExclValue() {
        return this._minExclValue;
    }

    public void setDefaultMinValue(double defaultMinValue) {
        this._defaultMinValue = defaultMinValue;
    }

    public void setDefaultMaxValue(double defaultMaxValue) {
        this._defaultMaxValue = defaultMaxValue;
    }

    public double getDefaultMinValue() {
        return this._defaultMinValue;
    }

    public double getDefaultMaxValue() {
        return this._defaultMaxValue;
    }

    public double getMinValue() {
        if (this._minValue == null) {
            double newMinValue = this.getDefaultMinValue();
            if (this.getMinExclValue() != Double.NaN && this.getMinInclValue() != Double.NaN) {
                double minIncl;
                double minExcl = this.getMinExclValue();
                newMinValue = minExcl < (minIncl = this.getMinInclValue()) ? minIncl : minExcl;
            } else if (this.getMinExclValue() != Double.NaN && this.getMinInclValue() == Double.NaN) {
                newMinValue = this.getMinExclValue();
            } else if (this.getMinExclValue() == Double.NaN && this.getMinInclValue() != Double.NaN) {
                newMinValue = this.getMinInclValue();
            }
            this._minValue = new Double(newMinValue);
            if (this._minValue.isNaN()) {
                this._minValue = new Double(this.getDefaultMinValue());
            }
        }
        return this._minValue;
    }

    public double getMaxValue() {
        if (this._maxValue == null) {
            double newMaxValue = this.getDefaultMaxValue();
            if (this.getMaxExclValue() != Double.NaN && this.getMaxInclValue() != Double.NaN) {
                double maxIncl;
                double maxExcl = this.getMaxExclValue();
                newMaxValue = maxExcl > (maxIncl = this.getMaxInclValue()) ? maxIncl : maxExcl;
            } else if (this.getMaxExclValue() != Double.NaN && this.getMaxInclValue() == Double.NaN) {
                newMaxValue = this.getMaxExclValue();
            } else if (this.getMaxExclValue() == Double.NaN && this.getMaxInclValue() != Double.NaN) {
                newMaxValue = this.getMaxInclValue();
            }
            this._maxValue = new Double(newMaxValue);
            if (this._maxValue.isNaN()) {
                this._maxValue = new Double(this.getDefaultMaxValue());
            }
        }
        return this._maxValue;
    }

    public boolean isMaxExcl() {
        return this.getMaxExclValue() != Double.NaN && this.getMaxExclValue() == this.getMaxValue();
    }

    public boolean isMinExcl() {
        return this.getMinExclValue() != Double.NaN && this.getMinExclValue() == this.getMinValue();
    }

    public boolean isMinIncl() {
        return this.getMinInclValue() != Double.NaN && this.getMinInclValue() == this.getMinValue();
    }

    public boolean isMaxIncl() {
        return this.getMaxInclValue() != Double.NaN && this.getMaxInclValue() == this.getMaxValue();
    }

    public void setAllowInvalidMinValues(boolean allow) {
        this._allowInvalidMinValues = allow;
    }

    public boolean allowInvalidMinValues() {
        return this._allowInvalidMinValues;
    }

    public void setDecimalSymbols(DecimalFormatSymbols symbols) {
        this._decimalSymbols = symbols;
    }

    public DecimalFormatSymbols getDecimalSymbols() {
        if (this._decimalSymbols == null) {
            String lang = JAXFrontProperties.getInstance().getLanguage();
            DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(new Locale(lang));
            this._decimalSymbols = format.getDecimalFormatSymbols();
        }
        return this._decimalSymbols;
    }

    public void setBypassing(boolean bypass) {
        this._bypass = bypass;
    }

    public boolean isBypassing() {
        return this._bypass;
    }

    public boolean isIntDocument() {
        return false;
    }
}

