/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class JLocaleChooser
extends JComboBox
implements ItemListener {
    private Locale[] _locales;
    private Locale _locale;
    private int _localeCount;

    public JLocaleChooser() {
        this.addItemListener(this);
        this._locales = Calendar.getAvailableLocales();
        this._localeCount = this._locales.length;
        for (int i = 0; i < this._localeCount; ++i) {
            if (this._locales[i].getCountry().length() <= 0) continue;
            this.addItem(this._locales[i].getDisplayName());
        }
        this.setLocale(Locale.getDefault());
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void itemStateChanged(ItemEvent iEvt) {
        int i;
        String item = (String)iEvt.getItem();
        for (i = 0; i < this._localeCount && !this._locales[i].getDisplayName().equals(item); ++i) {
        }
        this.setLocale(this._locales[i], false);
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("LocaleChooser");
        frame.getContentPane().add(new JLocaleChooser());
        frame.pack();
        frame.setVisible(true);
    }

    public void setLocale(Locale l) {
        this.setLocale(l, true);
    }

    private void setLocale(Locale l, boolean select) {
        Locale oldLocale = this._locale;
        this._locale = l;
        int n = 0;
        if (select) {
            for (int i = 0; i < this._localeCount; ++i) {
                if (this._locales[i].getCountry().length() <= 0) continue;
                if (this._locales[i].equals(this._locale)) {
                    this.setSelectedIndex(n);
                }
                ++n;
            }
        }
        this.firePropertyChange("locale", oldLocale, this._locale);
    }
}

