/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.tools.HRefMouseAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.Document;

public class MultiLineLabel
extends JTextArea {
    private final int INDENT_BETWEEN_LETTER_AND_UNDERLINE = 3;
    private boolean _useUnderline = false;
    private String _text = null;
    private UIDefaults defaults = UIManager.getLookAndFeelDefaults();
    private HRefMouseAdapter _mouseAdapter;

    public MultiLineLabel() {
    }

    public MultiLineLabel(int rows, int columns) {
        super(rows, columns);
    }

    public MultiLineLabel(String text) {
        this(text, false);
    }

    public MultiLineLabel(String text, int rows, int columns) {
        super(text, rows, columns);
    }

    public MultiLineLabel(Document doc) {
        super(doc);
    }

    public MultiLineLabel(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
    }

    public MultiLineLabel(String text, boolean useUnderline) {
        this._text = text;
        this._useUnderline = useUnderline;
        this.init();
    }

    private void init() {
        this.setEnabled(false);
        this.setEditable(false);
        this.setOpaque(false);
        this.setFocusable(false);
        this.setText(this._text);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setBackground(this.defaults.getColor("Label.background"));
        this.setFont(UIManager.getFont("Label.font"));
        this.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        if (this._text != null && (this._text.startsWith("http:") || this._text.startsWith("https:"))) {
            this._mouseAdapter = new HRefMouseAdapter(this, this._text);
            this.addMouseListener(this._mouseAdapter);
        }
    }

    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
    }

    public Dimension getPreferredSize() {
        Dimension pDim = super.getPreferredSize();
        pDim.setSize(pDim.width, pDim.height + 3);
        return pDim;
    }

    public Dimension getSize() {
        return super.getSize();
    }

    private boolean useSeparator() {
        return this._useUnderline;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.useSeparator()) {
            Color endColor = this.defaults.getColor("Label.background");
            Color startColor = null;
            if (endColor != null) {
                startColor = endColor.darker();
            } else {
                startColor = Color.LIGHT_GRAY;
                endColor = Color.WHITE;
            }
            GUITools.drawHorizontalGradient(g, startColor, endColor, 0, (int)super.getPreferredSize().getHeight(), (int)super.getPreferredSize().getWidth() - 10, 1);
        }
    }

    public void release() {
        if (this._mouseAdapter != null) {
            this.removeMouseListener(this._mouseAdapter);
        }
    }
}

