/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleGroupList;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.FlipOrientationTableModel;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.xui.TableInfo;
import com.jaxfront.swing.ui.beans.ZebraCellRenderer;
import com.jaxfront.swing.ui.tools.ColumnFitAdapter;
import com.jaxfront.swing.ui.tools.SortingHeader;
import com.jaxfront.swing.ui.tools.TableSorter;
import com.jaxfront.swing.ui.visualizers.AbstractListTypeTable;
import com.jaxfront.swing.ui.visualizers.AbstractListTypeView;
import com.jaxfront.swing.ui.wrapper.JAXJTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class RowHeadedTable
extends JScrollPane
implements TableColumnModelListener,
TableModelListener,
ActionListener,
MouseListener {
    private CustomizedColumnModel _columnModel;
    private CustomizedColumnModel _columnModelFlipped;
    private int _noOfDisplayableRows;
    private TableSorter _sorter;
    private Vector columnMovements = null;
    private JTable _rowHeaderTable;
    private FlipOrientationTableModel _model;
    private JAXJTable _dataTable;
    private ListSelectionModel _currentSelectionModel;
    private JButton _flipButton;
    private JButton _tableActionButton;
    private AbstractListTypeView _view;
    private Action _tableCornerAction;

    public RowHeadedTable(FlipOrientationTableModel tm, AbstractListTypeView view, int noOfDisplayableRows) {
        this._model = tm;
        this._view = view;
        this.setNoOfDisplayableRows(noOfDisplayableRows);
        if (view.getModel().getXUIDefinition().getStyle().getTableInfo() == null || view.getModel().getXUIDefinition().getStyle().getTableInfo().allowFlippingOnTheFly()) {
            this.setVerticalScrollBarPolicy(22);
            this.setHorizontalScrollBarPolicy(32);
        } else {
            this.setVerticalScrollBarPolicy(20);
            this.setHorizontalScrollBarPolicy(30);
        }
        this.init();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._flipButton) {
            int selectedIndex = -1;
            if (this._model.isFlipped()) {
                this._model.setFlipped(false);
                selectedIndex = this.getDataTable().getSelectedColumn();
            } else {
                this._model.setFlipped(true);
                selectedIndex = this.getDataTable().getSelectedRow();
            }
            this.init();
            if (selectedIndex > -1) {
                this.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
                this.scrollToSelection(selectedIndex);
            }
            if (this._view != null) {
                this._view.applyAutoColWidth();
            }
        }
    }

    public void columnAdded(TableColumnModelEvent e) {
    }

    public void columnMarginChanged(ChangeEvent e) {
    }

    public void columnMoved(TableColumnModelEvent e) {
        if (this.isFlipped() && this._dataTable.getSelectedColumn() > -1) {
            this.addColumnMovement(e.getFromIndex(), e.getToIndex());
        }
    }

    public void columnRemoved(TableColumnModelEvent e) {
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    public JAXJTable getDataTable() {
        return this._dataTable;
    }

    public FlipOrientationTableModel getModel() {
        return this._model;
    }

    public ListSelectionModel getSelectionModel() {
        return this._currentSelectionModel;
    }

    private void init() {
        this.getViewport().setFocusable(false);
        this.getHorizontalScrollBar().setFocusable(false);
        this.getVerticalScrollBar().setFocusable(false);
        this.initDataTable();
        this.initTableCorners();
        if (this._model.showRowHeaders() || this._model.isFlipped()) {
            int rowHeaderWidth = this.initRowHeaderWidth();
            this.setRowHeaderView(new TableRowHeader(this._dataTable, rowHeaderWidth));
        } else {
            this.setRowHeaderView(null);
        }
        this.setViewportView(this._dataTable);
        this.initSelectableItems();
        this._view.showUpDownButtons(this.showUpDownButtons());
        this.getModel().addTableModelListener((TableModelListener)this);
    }

    public void refresh() {
        int sAI = this.getSelectionModel().getAnchorSelectionIndex();
        int sLSI = this.getSelectionModel().getLeadSelectionIndex();
        int sMASI = this.getSelectionModel().getMaxSelectionIndex();
        int sMISI = this.getSelectionModel().getMinSelectionIndex();
        this.getModel().removeTableModelListener((TableModelListener)this);
        this.initDataTable();
        this.initTableCorners();
        if (this._model.showRowHeaders() || this._model.isFlipped()) {
            int rowHeaderWidth = this.initRowHeaderWidth();
            this.setRowHeaderView(new TableRowHeader(this._dataTable, rowHeaderWidth));
        } else {
            this.setRowHeaderView(null);
        }
        this.setViewportView(this._dataTable);
        this.initSelectableItems();
        this.getModel().addTableModelListener((TableModelListener)this);
        this.getModel().getTableInfo().updateLineInfos(this.getModel().getListType());
        this.getModel().fireTableStructureChanged();
        this.getSelectionModel().setAnchorSelectionIndex(sAI);
        this.getSelectionModel().setLeadSelectionIndex(sLSI);
        this.getSelectionModel().setSelectionInterval(sMISI, sMASI);
        if (this.isFlipped() && this._view != null) {
            this._view.applyAutoColWidth();
        }
    }

    private void initDataTable() {
        CustomizedColumnModel oldCm = this._model.isFlipped() ? this._columnModelFlipped : this._columnModel;
        CustomizedColumnModel cm = new CustomizedColumnModel(oldCm);
        if (this._model.isFlipped()) {
            this._columnModelFlipped = cm;
        } else {
            this._columnModel = cm;
        }
        if (this._model.isCellEditableEnabled()) {
            this._dataTable = new AbstractListTypeTable(false);
            this._dataTable.setDefaultPackerBehaviour(0, this._model.getTableInfo().isAltColFitMethod(), true, false);
            this._dataTable.setPackEnabled(this._model.getTableInfo().allowAutoColFit());
            ((AbstractListTypeTable)this._dataTable).setFlipped(this._model.isFlipped());
            if (this.getModel().getListType().getList() != null && this.getModel().getListType().getList().size() > 0) {
                this._dataTable.setFocusable(true);
            } else {
                this._dataTable.setFocusable(false);
            }
        } else {
            this._dataTable = new DisabledItemTable();
            this._dataTable.setFocusable(false);
        }
        this._dataTable.putClientProperty("language", this._view.getDOM().getLanguage());
        if (this._sorter == null) {
            this._sorter = new TableSorter(this._model, this._dataTable);
        }
        if (this.useSortingHeader()) {
            this._sorter.addMouseListenerToHeaderInTable(this._dataTable);
        }
        this._dataTable.setColumnModel(cm);
        this._dataTable.setModel(this._sorter);
        this._dataTable.getTableHeader().setUpdateTableInRealTime(true);
        this._dataTable.getTableHeader().setReorderingAllowed(this._model.getTableInfo().allowReOrdering());
        this._dataTable.setDefaultRenderer(Object.class, new ZebraCellRenderer(this._model.getTableInfo().useZebraLook()));
        if (this._view != null) {
            if (this.getModel().isCellEditableEnabled() || this._view.isDialogEditMode()) {
                this._dataTable.addMouseListener(this._view);
            }
            if (this._view.getPopUpListener() != null) {
                this._dataTable.addMouseListener(this._view.getPopUpListener());
            }
        }
        this._dataTable.getTableHeader().addMouseListener(this);
        this._dataTable.getColumnModel().addColumnModelListener(this);
        DefaultListSelectionModel m = new DefaultListSelectionModel();
        m.setValueIsAdjusting(false);
        this._dataTable.setSelectionModel(m);
        int selectionMode = 0;
        selectionMode = this._model.getTableInfo().getSelectionMode().equals("single") ? 0 : 2;
        this._dataTable.setSelectionMode(selectionMode);
        this._dataTable.setCellSelectionEnabled(true);
        if (this._model.getTableInfo().isSelectionOnly()) {
            this._dataTable.setCellSelectionEnabled(false);
        }
        if (this._model.getTableInfo().isDialogEditMode()) {
            this._dataTable.setCellSelectionEnabled(false);
        }
        if (this.getModel().getTableInfo() != null && this.getModel().getTableInfo().getLineInfos().size() == 1) {
            this._dataTable.setAutoResizeMode(4);
        } else {
            this._dataTable.setAutoResizeMode(0);
        }
        this._dataTable.getTableHeader().addMouseListener(new ColumnFitAdapter());
        if (this._dataTable.getTableHeader().getDefaultRenderer() instanceof JLabel) {
            JLabel l = (JLabel)((Object)this._dataTable.getTableHeader().getDefaultRenderer());
            this._dataTable.getTableHeader().setFont(this._dataTable.getTableHeader().getFont().deriveFont(1));
            l.setPreferredSize(new Dimension(0, 16));
        }
    }

    private int initRowHeaderWidth() {
        int rows = this._model.getRowCount();
        int cols = this._model.getColumnCount();
        int maxWidth = 0;
        String value = null;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (this.isFlipped()) {
            for (int i = 0; i < rows; ++i) {
                value = this._model.getValueAt(i, 0).toString();
                if (fm.stringWidth(value) <= maxWidth) continue;
                maxWidth = fm.stringWidth(value);
            }
        } else {
            for (int c = 0; c < cols; ++c) {
                maxWidth = this._model.getStrategy().getWidth();
            }
        }
        return maxWidth + 20;
    }

    private void initSelectableItems() {
        if (this._currentSelectionModel != null) {
            this._currentSelectionModel.removeListSelectionListener(this._view);
        }
        if (this._model.isFlipped()) {
            this._dataTable.setColumnSelectionAllowed(true);
            this._dataTable.setRowSelectionAllowed(false);
            this._currentSelectionModel = this._dataTable.getColumnModel().getSelectionModel();
        } else {
            this._dataTable.setRowSelectionAllowed(true);
            this._dataTable.setColumnSelectionAllowed(false);
            this._currentSelectionModel = this._dataTable.getSelectionModel();
        }
        this._currentSelectionModel.addListSelectionListener(this._view);
    }

    private void initTableCorners() {
        TableInfo info = this._model.getTableInfo();
        if (info.allowFlippingOnTheFly()) {
            this._flipButton = new JButton(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/flip_16x16.gif"));
            this._flipButton.setFocusable(false);
            this._flipButton.setEnabled(true);
            this._flipButton.addActionListener(this);
            this.setCorner("UPPER_RIGHT_CORNER", this._flipButton);
        }
        if (info.allowAutoColFit()) {
            this._tableActionButton = new JButton(this.getTableCornerAction());
            this._tableActionButton.setFocusable(false);
            this._tableActionButton.setEnabled(true);
            this.setCorner("UPPER_LEFT_CORNER", this._tableActionButton);
        }
    }

    private Action getTableCornerAction() {
        if (this._tableCornerAction == null) {
            this._tableCornerAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    if (RowHeadedTable.this._dataTable != null) {
                        RowHeadedTable.this._dataTable.pack(0, RowHeadedTable.this._model.getTableInfo().isAltColFitMethod(), true, true, RowHeadedTable.this._model.getTableInfo().getDefaultWidth());
                    }
                }
            };
            this._tableCornerAction.putValue("SmallIcon", JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/fitTo_16x16.gif"));
        }
        return this._tableCornerAction;
    }

    public boolean isFlipped() {
        return this._model.isFlipped();
    }

    public void setEnabled(boolean enabled) {
        if (this._rowHeaderTable != null) {
            this._rowHeaderTable.setEnabled(enabled);
        }
        if (this._dataTable != null) {
            this._dataTable.setEnabled(enabled);
        }
    }

    public boolean showUpDownButtons() {
        TableInfo info = this._model.getTableInfo();
        if (this._model.isFlipped()) {
            return false;
        }
        return info.allowReOrdering();
    }

    public void release() {
        this._rowHeaderTable = null;
        if (this._sorter != null) {
            this._sorter.release();
            this._sorter = null;
        }
        if (this._model != null) {
            this._model.release();
            this._model = null;
        }
        this._dataTable = null;
        this._currentSelectionModel = null;
        this._flipButton = null;
        this._view = null;
    }

    public void scrollToSelection(int rowIndex) {
        if (rowIndex > -1) {
            int currentXPos = (int)this.getViewport().getViewPosition().getX();
            int currentYPos = (int)this.getViewport().getViewPosition().getY();
            if (!this.isFlipped()) {
                int viewPortHeight = this.getViewport().getHeight();
                int rowHeight = this.getDataTable().getRowHeight();
                int targetYPos = rowHeight * rowIndex;
                int currentYPosAndHeight = viewPortHeight + currentYPos - rowHeight;
                if (currentYPos > targetYPos) {
                    this.getViewport().setViewPosition(new Point(currentXPos, targetYPos));
                } else if (currentYPosAndHeight < targetYPos) {
                    this.getViewport().setViewPosition(new Point(currentXPos, targetYPos - viewPortHeight + rowHeight));
                }
            } else {
                int viewPortWidth = this.getViewport().getWidth();
                int targetColumnWidth = this.getDataTable().getColumnModel().getColumn(rowIndex).getWidth();
                int colCount = this.getDataTable().getColumnCount();
                int selectedColumn = this.getDataTable().getSelectedRow();
                int targetXPos = 0;
                if (rowIndex < colCount) {
                    for (int a = 0; a < rowIndex; ++a) {
                        targetXPos += this.getDataTable().getColumnModel().getColumn(a).getWidth();
                    }
                }
                if (currentXPos + viewPortWidth < targetXPos + targetColumnWidth) {
                    this.getViewport().setViewPosition(new Point(targetXPos - viewPortWidth + targetColumnWidth, currentYPos));
                } else if (currentXPos > targetXPos) {
                    this.getViewport().setViewPosition(new Point(targetXPos, currentYPos));
                }
            }
        }
    }

    private boolean useSortingHeader() {
        if (this._view.getModel().getXUIDefinition().getStyle().getTableInfo() != null && this._view.getModel().getXUIDefinition().getStyle().getTableInfo().allowSorting() && !this._model.isFlipped()) {
            if (this._view.getModel() instanceof SimpleGroupList) {
                if (this._view.getModel().getXUIDefinition().getStyle().isDialogMode() || this._view.getModel().getXUIDefinition().getStyle().getTableInfo().isSelectionOnly()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private void setNoOfDisplayableRows(int noOfDisplayableRows) {
        this._noOfDisplayableRows = noOfDisplayableRows;
    }

    public void tableChanged(TableModelEvent arg0) {
        if (this.getModel().isCellEditableEnabled() && this.getModel().getListType() != null && this.getModel().getListType().getList() != null && this.getModel().getListType().getList().size() > 0) {
            this.getDataTable().setFocusable(true);
        } else {
            this.getDataTable().setFocusable(false);
        }
    }

    private void doMoveAction(int from, int to) {
        ListType listType = this._model.getListType();
        int selectedIndex = this._dataTable.getSelectedRow();
        if (selectedIndex >= 0 || selectedIndex < listType.getList().size()) {
            if (this._dataTable.isEditing()) {
                this._dataTable.getCellEditor().stopCellEditing();
            }
            int originalFrom = ((TableSorter)this._dataTable.getModel()).getOriginalRowIndex(from);
            int originalTo = ((TableSorter)this._dataTable.getModel()).getOriginalRowIndex(to);
            listType.swap(originalFrom, originalTo);
            this._model.swapFormula(originalFrom, originalTo);
            this._dataTable.getSelectionModel().setSelectionInterval(selectedIndex + 1, selectedIndex + 1);
        }
    }

    public int getNoOfDisplayableRows() {
        return this._noOfDisplayableRows;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.getDataTable().getTableHeader()) {
            for (int i = 0; i < this.getColumnMovements().size(); ++i) {
                int to;
                String move = (String)this.getColumnMovements().get(i);
                int from = Integer.parseInt(move.substring(0, move.indexOf(":")));
                if (from == (to = Integer.parseInt(move.substring(move.indexOf(":") + 1)))) continue;
                this.doMoveAction(from, to);
            }
            this.clearColumnMovements();
        }
    }

    private void clearColumnMovements() {
        this.getColumnMovements().clear();
    }

    private void addColumnMovement(int from, int to) {
        if (from != to) {
            this.getColumnMovements().add(from + ":" + to);
        }
    }

    private Vector getColumnMovements() {
        if (this.columnMovements == null) {
            this.columnMovements = new Vector();
        }
        return this.columnMovements;
    }

    class DisabledItemTable
    extends JAXJTable {
        DisabledItemTable() {
        }

        public boolean isCellSelected(int row, int column) {
            Type type = ZebraCellRenderer.getListItemType(row, column, this);
            if (type != null && type.getClientProperty("listItem-disabled") != null) {
                return false;
            }
            return super.isCellSelected(row, column);
        }
    }

    class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        private JTable myTable;
        private Border mySelectedBorder;
        private Border myNormalBorder;
        private Font mySelectedFont;
        private Font myNormalFont;

        public RowHeaderRenderer(JTable table) {
            this.myTable = table;
            this.myNormalBorder = UIManager.getBorder("TableHeader.cellBorder");
            this.mySelectedBorder = BorderFactory.createRaisedBevelBorder();
            JTableHeader header = table.getTableHeader();
            this.myNormalFont = header.getFont();
            this.mySelectedFont = this.myNormalFont.deriveFont(this.myNormalFont.getStyle() | 1);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setOpaque(true);
            this.setHorizontalAlignment(4);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.myTable.getSelectionModel().isSelectedIndex(index)) {
                this.setFont(this.mySelectedFont);
                this.setBorder(this.mySelectedBorder);
            } else {
                this.setFont(this.myNormalFont);
                this.setBorder(this.myNormalBorder);
            }
            if (isSelected) {
                this.myTable.setSelectionBackground(this.myTable.getSelectionBackground());
                this.myTable.setSelectionForeground(this.myTable.getSelectionForeground());
                this.setBackground(this.myTable.getSelectionBackground());
                this.setForeground(this.myTable.getSelectionForeground());
            } else {
                this.setForeground(this.myTable.getTableHeader().getForeground());
                this.setBackground(this.myTable.getTableHeader().getBackground());
            }
            String label = null;
            if (RowHeadedTable.this.isFlipped()) {
                label = RowHeadedTable.this.getModel().getRowName(index);
            } else if (index < RowHeadedTable.this.getModel().getRowHeaders().size()) {
                label = RowHeadedTable.this.getModel().getRowHeaders().get(index).toString();
            }
            this.setText(label);
            return this;
        }
    }

    class TableRowHeader
    extends JList {
        private JTable _table;

        public TableRowHeader(JTable table, int width) {
            super(new TableRowHeaderModel(table));
            this._table = table;
            this.setFixedCellHeight(table.getRowHeight());
            this.setFixedCellWidth(width);
            this.setCellRenderer(new RowHeaderRenderer(table));
            this.setBackground(UIManager.getDefaults().getColor("Label.Background"));
            this.setSelectionModel(table.getSelectionModel());
            this.setFocusable(false);
        }

        public Rectangle getCellBounds(int index0, int index1) {
            int height;
            int y;
            Rectangle rect0 = this._table.getCellRect(index0, 0, true);
            Rectangle rect1 = this._table.getCellRect(index1, 0, true);
            if (rect0.y < rect1.y) {
                y = rect0.y;
                height = rect1.y + rect1.height - y;
            } else {
                y = rect1.y;
                height = rect0.y + rect0.height - y;
            }
            return new Rectangle(0, y, this.getFixedCellWidth(), height);
        }
    }

    class TableRowHeaderModel
    extends AbstractListModel {
        private JTable table;

        public TableRowHeaderModel(JTable table) {
            this.table = table;
        }

        public int getSize() {
            return this.table.getRowCount();
        }

        public Object getElementAt(int index) {
            return new Integer(index++);
        }
    }

    private class CustomizedColumnModel
    extends DefaultTableColumnModel {
        private int[] _widths;

        public CustomizedColumnModel(CustomizedColumnModel cm) {
            if (cm != null) {
                this.initializeWidths(cm);
            }
        }

        public void addColumn(TableColumn tc) {
            if (tc.getHeaderValue() != null) {
                try {
                    int modelIndex = tc.getModelIndex();
                    int width = this._widths != null ? (modelIndex >= this._widths.length ? RowHeadedTable.this._model.getTableInfo().getDefaultWidth() : this._widths[tc.getModelIndex()]) : this.initializeWidth(tc.getModelIndex());
                    tc.setWidth(width);
                    tc.setPreferredWidth(width);
                    if (RowHeadedTable.this.useSortingHeader()) {
                        tc.setHeaderRenderer(new SortingHeader());
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                super.addColumn(tc);
            }
        }

        public TableColumn getColumn(int columnIndex) {
            if (columnIndex != -1) {
                if (columnIndex >= this.tableColumns.size()) {
                    int newColumnIndex = columnIndex - 1;
                    return this.getColumn(newColumnIndex);
                }
                return super.getColumn(columnIndex);
            }
            return null;
        }

        private int initializeWidth(int index) {
            int width = 10;
            if (RowHeadedTable.this._model.isFlipped()) {
                width = RowHeadedTable.this._model.getTableInfo().getDefaultWidth();
            } else if (index >= 0 && index < RowHeadedTable.this._model.getTableInfo().getLineInfos().size()) {
                width = RowHeadedTable.this._model.getTableInfo().getWidthForLine(index);
            }
            return width;
        }

        private void initializeWidths(CustomizedColumnModel cm) {
            this._widths = new int[cm.getColumnCount()];
            for (int i = 0; i < cm.getColumnCount(); ++i) {
                TableColumn column = cm.getColumn(i);
                this._widths[i] = column.getWidth();
            }
        }
    }
}

