/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TreeNode;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.ImageHelper;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.search.DefaultTypeSearcher;
import com.jaxfront.core.util.search.Search;
import com.jaxfront.core.util.search.SearchComparator;
import com.jaxfront.core.util.search.SearchResultProcessor;
import com.jaxfront.core.util.search.TypeComparator;
import com.jaxfront.core.xui.ButtonEnabling;
import com.jaxfront.core.xui.ListInfo;
import com.jaxfront.core.xui.StyleDefinition;
import com.jaxfront.swing.ui.editor.AbstractPopUpMenu;
import com.jaxfront.swing.ui.editor.NavigationTree;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.tools.search.Find;
import com.jaxfront.swing.ui.tools.search.RuleTypeListRenderer;
import com.jaxfront.swing.ui.tools.search.TypeSearchResultProcessor;
import com.jaxfront.swing.ui.visualizers.AbstractListTypeView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.BevelBorder;
import javax.swing.tree.TreePath;

public class DefaultPopUpMenu
extends AbstractPopUpMenu {
    private boolean isSelectionOnly = false;
    private boolean allowAdding = false;
    private boolean allowCopying = false;
    private boolean allowDeleting = false;
    private boolean allowSearch = false;
    private ListInfo tableInfo;
    protected JMenu _choiceMenu;
    private Action _searchTypeAction;
    private DefaultTypeSearcher _searcher;
    private SearchResultProcessor _resultProcessor;

    public DefaultPopUpMenu(NavigationTree tree, TreeNode treeNode) {
        super(tree, treeNode);
        boolean isMultiSelect;
        boolean bl = isMultiSelect = this.getTree().getSelectionCount() > 1;
        if (isMultiSelect) {
            this.initializeMultiSelect();
        } else {
            this.initialize();
        }
    }

    protected void initialize() {
        JMenuItem item;
        String menuText = null;
        String typeText = null;
        this.checkEnabling(this.getType());
        this.setBorder(new BevelBorder(0));
        this.addPopupMenuListener(this.getTree());
        if (this.getType().getParent() != null && this.getType().getParent().isList()) {
            if (!this.getType().getParentList().getEditingType().isChoice()) {
                typeText = this.getType().getParentList().getEditingType().getVisualName();
                if (this.getType().getParentList().getEditingType().getStyle().hasTreeLabelFormulaExpression()) {
                    typeText = this.getType().getParentList().getEditingType().getStyle().getCaptionTitleLabel();
                }
                if (typeText != null && typeText.equals("NULL")) {
                    typeText = this.getType().getParentList().getEditingType().getName();
                }
                item = new JMenuItem();
                menuText = GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_add", "Add") + " (" + typeText + ") " + GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_add_before", "before");
                item.setText(menuText);
                item.setActionCommand("ADD_BEFORE_NODE");
                item.addActionListener(this.getTree());
                item.setEnabled(this.allowAdding);
                item.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/insertRow-before.gif"));
                this.add(item);
                item = new JMenuItem();
                menuText = GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_add", "Add") + " (" + typeText + ") " + GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_add_after", "after");
                item.setText(menuText);
                item.setActionCommand("ADD_AFTER_NODE");
                item.addActionListener(this.getTree());
                item.setEnabled(this.allowAdding);
                item.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/insertRow-after.gif"));
                this.add(item);
                this.addSeparator();
            }
            item = new JMenuItem();
            menuText = GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_copy", "Copy");
            item.setText(menuText);
            item.setActionCommand("COPY_NODE");
            item.addActionListener(this.getTree());
            item.setEnabled(this.allowCopying);
            item.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/copy_16x16.gif"));
            this.add(item);
            item = new JMenuItem();
            menuText = GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_delete", "Delete");
            item.setText(menuText);
            item.setActionCommand("REMOVE_NODE");
            item.addActionListener(this.getTree());
            item.setEnabled(this.allowDeleting);
            item.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/delete_16x16.gif"));
            this.add(item);
            this.addSeparator();
            AbstractListTypeView listView = (AbstractListTypeView)TypeVisualizerFactory.getInstance().getVisualizer((Type)this.getType().getParentList()).getImplementation();
            if (listView != null && this.getType().getParentList().size() > 1) {
                listView.initForTreeMenu(this);
                listView.getMoveUpAction().setEnabled(true);
                listView.getMoveDownAction().setEnabled(true);
            }
        }
        if (this.getType().isList()) {
            Type editingType = ((ListType)this.getType()).getEditingType();
            if (editingType.isChoice()) {
                menuText = GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_add", "Add");
                this._choiceMenu = new JMenu(menuText);
                String[] choices = ((CompositeType)editingType).getRelevantChoiceNames();
                String visualText = null;
                for (int i = 0; i < choices.length; ++i) {
                    ImageIcon icon;
                    item = new JMenuItem();
                    visualText = typeText = choices[i];
                    Type choiceType = editingType.getDirectChild(typeText);
                    if (choiceType == null) {
                        if (editingType.isAbstract()) {
                            choiceType = DOMHelper.getDerivedType((Type)editingType, (String)typeText, (boolean)false);
                            choiceType.setDOM(editingType.getDOM());
                        }
                        if (choiceType != null) {
                            visualText = choiceType.getXUIDefinition().getStyle().getTreeLabelText();
                        }
                    }
                    item.setText(visualText);
                    if (this.isSelectionOnly) {
                        item.setEnabled(false);
                    }
                    item.putClientProperty("NODE_NAME_PROPERTY", typeText);
                    item.setActionCommand("ADD_NODE");
                    item.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/new_16x16.gif"));
                    item.addActionListener(this.getTree());
                    if (choiceType != null && choiceType.getStyle().getTreeIcon() != null && (icon = JAXFrontProperties.getImageIcon((URL)choiceType.getDOM().getFingerPrint().getXUIURL(), (String)choiceType.getStyle().getTreeIcon())) != null) {
                        item.setIcon(icon);
                    }
                    this._choiceMenu.add(item);
                }
                this.add(this._choiceMenu);
            } else {
                item = new JMenuItem();
                typeText = editingType.getVisualName();
                if (editingType.getStyle().hasTreeLabelFormulaExpression()) {
                    typeText = editingType.getStyle().getCaptionTitleLabel();
                }
                if (typeText != null && typeText.equals("NULL")) {
                    typeText = editingType.getName();
                }
                menuText = GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_add", "Add") + " (" + typeText + ")";
                item.setActionCommand("ADD_NODE");
                item.setText(menuText);
                item.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/new_16x16.gif"));
                item.setEnabled(this.allowAdding);
                item.putClientProperty("NODE_NAME_PROPERTY", typeText);
                item.addActionListener(this.getTree());
                this.add(item);
            }
            if (this.tableInfo != null && !this.isSelectionOnly && this.tableInfo.allowReOrdering() && this.tableInfo.allowSorting()) {
                JMenu sortPopUp = new JMenu(GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_sort", "Sort"));
                JMenuItem sortItem = new JMenuItem();
                menuText = GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_sort_asc", "Sort Asc");
                sortItem.setText(menuText);
                sortItem.setActionCommand("SORT_ASC");
                sortItem.addActionListener(this.getTree());
                sortItem.setIcon(ImageHelper.getInstance().getImageIcon("com/jaxfront/core/images/files/arrowDown_16x16.gif"));
                sortPopUp.add(sortItem);
                sortItem = new JMenuItem();
                menuText = GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_sort_des", "Sort Desc");
                sortItem.setText(menuText);
                sortItem.setActionCommand("SORT_DES");
                sortItem.setIcon(ImageHelper.getInstance().getImageIcon("com/jaxfront/core/images/files/arrowUp_16x16.gif"));
                sortItem.addActionListener(this.getTree());
                sortPopUp.add(sortItem);
                this.add(sortPopUp);
            }
        } else if (this.getType().isComposite() && ((CompositeType)this.getType()).isRecursive() && !this.getType().hasRecursionBeenBuilt()) {
            item = new JMenuItem();
            if (this.getComponentCount() > 0) {
                this.addSeparator();
            }
            if ((typeText = this.getType().getVisualName()) != null && typeText.equals("NULL")) {
                typeText = this.getType().getName();
            }
            menuText = GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_add", "Add") + " (" + typeText + ")";
            item.setActionCommand("ADD_RECURSIVE_NODE");
            this.isSelectionOnly = this.getType().getDirectChild(typeText) != null;
            item.setText(menuText);
            if (this.isSelectionOnly) {
                item.setEnabled(false);
            }
            item.putClientProperty("NODE_NAME_PROPERTY", typeText);
            item.addActionListener(this.getTree());
            this.add(item);
        }
        if (!this.getType().isSimple()) {
            if (this.getComponentCount() > 0) {
                this.addSeparator();
            }
            item = new JMenuItem();
            item.setActionCommand("COPY_CONTENT");
            item.setText(GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_copy_content", "copy content"));
            item.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/copy_16x16.gif"));
            item.addActionListener(this.getTree());
            this.add(item);
            this._pasteContentItem = new JMenuItem();
            this._pasteContentItem.setActionCommand("PASTE_CONTENT");
            this._pasteContentItem.setEnabled(!this.isSelectionOnly);
            this._pasteContentItem.setText(GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_paste_content", "paste content"));
            this._pasteContentItem.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/pasteContent_16x16.gif"));
            this._pasteContentItem.addActionListener(this.getTree());
            this.add(this._pasteContentItem);
            this.addSeparator();
            if (this.allowSearch || this.getType().getStyle().isTreeEntryAllowSearch()) {
                item = new JMenuItem();
                item.setAction(this.getSearchTypeAction());
                this.add(item);
            }
            if (this.getType().getStyle().isTreeEntryAllowExpColapse() && !this.getTreeNode().isLeaf()) {
                item = new JMenuItem();
                menuText = GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "tooltip_expand_collapse", "expand / collapse Item");
                item.setText(menuText);
                item.setActionCommand("EXP_COL_NODE");
                item.addActionListener(this.getTree());
                item.setEnabled(true);
                item.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/expand_16x16.gif"));
                this.add(item);
            }
        }
    }

    private void initializeMultiSelect() {
        String menuText = null;
        this.setBorder(new BevelBorder(0));
        this.addPopupMenuListener(this.getTree());
        this.checkEnabling(this.getType());
        if (this.getType().getParent() != null && this.getType().getParent().isList()) {
            JMenuItem item = new JMenuItem();
            menuText = GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_copy", "Copy");
            item.setText(menuText);
            item.setActionCommand("COPY_NODES");
            item.addActionListener(this.getTree());
            item.setEnabled(this.allowCopying);
            this.add(item);
            item = new JMenuItem();
            menuText = GUIComponentNLS.getInstance().getNLSText(this.getType().getDOM(), "button_delete", "Delete");
            item.setText(menuText);
            item.setActionCommand("REMOVE_NODES");
            item.addActionListener(this.getTree());
            TreePath[] paths = this.getTree().getSelectionPaths();
            Type cParent = null;
            for (int i = 0; i < paths.length; ++i) {
                TreeNode aSNode = (TreeNode)paths[i].getLastPathComponent();
                Type aSType = aSNode.getType();
                boolean aMSCanBeDeleted = this.checkEnabling((Type)aSType)._canDelete;
                if (cParent == null) {
                    cParent = aSType.getParent();
                    if (cParent.isList() && aMSCanBeDeleted) continue;
                    this.allowDeleting = false;
                    return;
                }
                if (aSType.getParent() == cParent && aMSCanBeDeleted) continue;
                this.allowDeleting = false;
                return;
            }
            item.setEnabled(this.allowDeleting);
            this.add(item);
        }
    }

    public JMenuItem add(Action a) {
        return super.add(a);
    }

    public JMenuItem add(JMenuItem menuItem) {
        this._isEmpty = false;
        return super.add(menuItem);
    }

    public Component add(Component comp) {
        this._isEmpty = false;
        return super.add(comp);
    }

    public ButtonEnabling checkEnabling(Type forType) {
        ButtonEnabling be = StyleDefinition.checkEnabling((Type)forType);
        this.allowAdding = be._canAdd;
        this.allowCopying = be._canCopy;
        this.allowDeleting = be._canDelete;
        this.isSelectionOnly = be._selectionOnly;
        this.tableInfo = be._listInfo;
        if (forType.getParent() != null && forType.getParent().isList()) {
            ListType lm = (ListType)forType.getParent();
            this.allowAdding = this.allowAdding && !lm.violateCardinality(1);
            this.allowCopying = this.allowAdding && this.allowCopying;
            this.allowDeleting = this.allowDeleting && !lm.violateCardinality(-1) && lm.getDirectChildren().size() > 0;
        }
        return be;
    }

    protected Action getSearchTypeAction() {
        if (this._searchTypeAction == null) {
            this._searchTypeAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText("button_search", "Search"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/search_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    Find find = Find.getSharedInstance(GUITools.createDialogFor((JComponent)DefaultPopUpMenu.this.getType().getDOM().getEditor()));
                    find.setResultProcessor(DefaultPopUpMenu.this.getResultProcessor());
                    find.setListRenderer(new RuleTypeListRenderer());
                    DefaultPopUpMenu.this.getSearcher().setComparator((SearchComparator)new TypeComparator());
                    find.showFind(DefaultPopUpMenu.this.getSearcher());
                    find.showFindTab();
                }
            };
        }
        return this._searchTypeAction;
    }

    public Search getSearcher() {
        if (this._searcher == null) {
            this._searcher = new DefaultTypeSearcher(this.getType());
            this._searcher.setSearchDirective(2);
        }
        return this._searcher;
    }

    public SearchResultProcessor getResultProcessor() {
        if (this._resultProcessor == null) {
            this._resultProcessor = new TypeSearchResultProcessor();
        }
        return this._resultProcessor;
    }

    public void addSeparator() {
        if (this.getComponentCount() > 0 && !(this.getComponent(this.getComponentCount() - 1) instanceof JPopupMenu.Separator)) {
            super.addSeparator();
        }
    }
}

