/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.error.Error;
import com.jaxfront.core.error.ErrorTypeComparator;
import com.jaxfront.core.type.ErrorController;
import com.jaxfront.core.type.TypeController;
import com.jaxfront.core.type.ValidationChangeEvent;
import com.jaxfront.core.type.ValidationChangeListener;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.swing.ui.beans.MessageTable;
import com.jaxfront.swing.ui.editor.AbstractEditorPanel;
import com.jaxfront.swing.ui.editor.TypeWorkspace;
import com.jaxfront.swing.ui.tools.FocusHelper;
import com.jaxfront.swing.ui.tools.GUITools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ErrorMessageStatusBar
extends JPanel
implements ActionListener,
ValidationChangeListener,
MouseListener {
    private static final String COMPONENT_FOCUS_IMAGE = "com/jaxfront/core/images/files/focusComponent_24x24.gif";
    private JButton _focusComponentButton;
    private JButton _messageTypeButton;
    private JComboBox _comboBox;
    private TypeWorkspace _workspace;
    private AbstractEditorPanel _editor;
    private JDialog _dialog;
    private MessageTable _messageTable;
    private TreeSet _treeSet = new TreeSet(new ErrorTypeComparator());
    private JPanel _messageTablePanel;

    public ErrorMessageStatusBar(TypeWorkspace workspace, AbstractEditorPanel editor) {
        this._workspace = workspace;
        this._editor = editor;
        this.init();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._comboBox) {
            Error error = (Error)this._comboBox.getSelectedItem();
            if (this._comboBox.getSelectedItem() != null) {
                Error errorToShow = (Error)this._comboBox.getSelectedItem();
                this._focusComponentButton.setToolTipText(errorToShow.getHolderXPath());
                this.setErrorIcon(error);
                this._messageTypeButton.setEnabled(true);
                this._comboBox.setEnabled(true);
                this._focusComponentButton.setEnabled(true);
            } else {
                this._messageTypeButton.setEnabled(false);
                this._comboBox.setEnabled(false);
                this._focusComponentButton.setEnabled(false);
            }
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        Dimension d = new Dimension(26, 26);
        this._workspace.getDOM().getController().getErrorController().addValidationChangeListener((ValidationChangeListener)this);
        this._comboBox = new JComboBox();
        this._comboBox.setBackground(Color.lightGray);
        this._comboBox.setForeground(Color.blue);
        this._comboBox.addActionListener(this);
        this._comboBox.setPreferredSize(d);
        this._comboBox.setMinimumSize(new Dimension(0, 0));
        this._comboBox.setEnabled(false);
        JTextField statusTextField = (JTextField)this._comboBox.getEditor().getEditorComponent();
        statusTextField.setEnabled(false);
        statusTextField.setDisabledTextColor(Color.blue);
        statusTextField.setBackground(Color.lightGray);
        this._focusComponentButton = new JButton(JAXFrontProperties.getImageIcon((String)COMPONENT_FOCUS_IMAGE));
        this._focusComponentButton.addMouseListener(this);
        this._focusComponentButton.setEnabled(false);
        this._focusComponentButton.setPreferredSize(d);
        this._focusComponentButton.setMaximumSize(d);
        this._focusComponentButton.setMinimumSize(d);
        this._focusComponentButton.setSize(d);
        this._focusComponentButton.setRequestFocusEnabled(false);
        this._messageTypeButton = new JButton();
        this._messageTypeButton.addMouseListener(this);
        this._messageTypeButton.setVisible(true);
        this._messageTypeButton.setEnabled(false);
        this._messageTypeButton.setPreferredSize(d);
        this._messageTypeButton.setMaximumSize(d);
        this._messageTypeButton.setMinimumSize(d);
        this._messageTypeButton.setSize(d);
        this._messageTypeButton.setRequestFocusEnabled(false);
        this.add((Component)this._messageTypeButton, "West");
        this.add((Component)this._comboBox, "Center");
        this.add((Component)this._focusComponentButton, "East");
        this.initializeValidationErrors(this._workspace.getDOM().getController());
    }

    public void release() {
        if (this._workspace != null && this._workspace.getDOM() != null && this._workspace.getDOM().getController() != null) {
            this._workspace.getDOM().getController().getErrorController().removeValidationChangeListener((ValidationChangeListener)this);
        }
        this._workspace = null;
        if (this._dialog != null) {
            this._dialog.setVisible(false);
            this._dialog.dispose();
            this._dialog = null;
        }
        if (this._messageTablePanel != null) {
            this._messageTablePanel.setVisible(false);
            this._messageTablePanel = null;
        }
        if (this._messageTable != null) {
            this._messageTable.release();
            this._messageTable = null;
        }
    }

    private void removeMessage(Error error) {
        ComboBoxModel model = this._comboBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!model.getElementAt(i).equals(error)) continue;
            this._comboBox.removeItemAt(i);
            break;
        }
        if (this._comboBox.getItemCount() > 0) {
            this._comboBox.setSelectedIndex(0);
        }
        this._treeSet.remove(error);
    }

    public void reset() {
        this._comboBox.removeAllItems();
    }

    private void showMessage(Error error) {
        if (error != null) {
            ComboBoxModel model = this._comboBox.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                if (!model.getElementAt(i).equals(error)) continue;
                this._comboBox.removeItemAt(i);
                break;
            }
            if (error.isNeedingUserAcceptance()) {
                this._messageTypeButton.setEnabled(true);
                this._comboBox.setEnabled(false);
                this._focusComponentButton.setEnabled(false);
            } else {
                this._messageTypeButton.setEnabled(false);
                this._comboBox.setEnabled(true);
                this._focusComponentButton.setEnabled(true);
            }
            this._focusComponentButton.setToolTipText(error.getHolderXPath());
            if (!this._workspace.getDOM().getGlobalDefinition().isUsingChronErrorSequence()) {
                this._treeSet.add(error);
                this._comboBox.removeAllItems();
                Iterator it = this._treeSet.iterator();
                while (it.hasNext()) {
                    Error tempError = (Error)it.next();
                    this._comboBox.addItem(tempError);
                }
                this._comboBox.setSelectedItem(error);
                this.setErrorIcon(error);
            } else {
                this._comboBox.addItem(error);
                this._comboBox.setSelectedItem(error);
                this.setErrorIcon(error);
            }
        }
    }

    private void updateAll(ValidationChangeEvent event) {
        block7: {
            this._comboBox.removeAllItems();
            TypeController controller = ((Document)event.getSource()).getController();
            ErrorController errorController = controller.getErrorController();
            if (!errorController.hasValidationErrors()) break block7;
            Enumeration typeErrors = errorController.getErrors().elements();
            if (!this._workspace.getDOM().getGlobalDefinition().isUsingChronErrorSequence()) {
                this._treeSet = new TreeSet(new ErrorTypeComparator());
                while (typeErrors.hasMoreElements()) {
                    Vector errors = (Vector)typeErrors.nextElement();
                    for (int i = 0; i < errors.size(); ++i) {
                        Error error = (Error)errors.get(i);
                        this._treeSet.add(error);
                    }
                }
                Iterator it = this._treeSet.iterator();
                while (it.hasNext()) {
                    Error tempError = (Error)it.next();
                    this._comboBox.addItem(tempError);
                }
            } else {
                while (typeErrors.hasMoreElements()) {
                    Vector errors = (Vector)typeErrors.nextElement();
                    for (int i = 0; i < errors.size(); ++i) {
                        Error error = (Error)errors.get(i);
                        this._comboBox.addItem(error);
                    }
                }
            }
        }
    }

    private void setErrorIcon(Error error) {
        if (error != null && this._messageTypeButton != null) {
            this._messageTypeButton.setIcon(error.getMessageIcon());
        } else {
            this._messageTypeButton.setIcon(null);
        }
    }

    public void validationChanged(ValidationChangeEvent event) {
        if (event.isResolved()) {
            this.removeMessage(event.getError());
        } else if (event.isResolvedAll()) {
            this.reset();
        } else if (event.isFullDOMValidation()) {
            this.updateAll(event);
        } else if (event.isOccuring()) {
            this.showMessage(event.getError());
        }
        if (this._comboBox.getItemCount() == 0) {
            this.setErrorIcon(null);
            this._messageTypeButton.setEnabled(false);
            this._comboBox.setEnabled(false);
            this._focusComponentButton.setEnabled(false);
        } else {
            this._comboBox.setEnabled(true);
            this._focusComponentButton.setEnabled(true);
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        Error error = (Error)this._comboBox.getSelectedItem();
        if (error != null) {
            if (e.getSource() == this._messageTypeButton) {
                if (e.getClickCount() == 1) {
                    if (error.isNeedingUserAcceptance()) {
                        this.removeMessage(error);
                        if (this._comboBox.getItemCount() == 0) {
                            this.setErrorIcon(null);
                            this._focusComponentButton.setEnabled(false);
                            this._comboBox.setEnabled(false);
                            this._messageTypeButton.setEnabled(false);
                        } else {
                            this._comboBox.setEnabled(true);
                            this._focusComponentButton.setEnabled(true);
                        }
                        error.resetError();
                        error.getErrorHolder().getDOM().getController().getErrorController().removeError(error);
                    }
                } else if (e.getClickCount() == 2) {
                    this.getErrorMessagesDialog().show();
                }
            } else if (e.getSource() == this._focusComponentButton) {
                FocusHelper.focus(error.getErrorHolder());
            }
        }
    }

    private JDialog getErrorMessagesDialog() {
        if (this._dialog == null) {
            this._dialog = GUITools.createDialogFor(this);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.setModal(false);
            this._dialog.getContentPane().setLayout(new BorderLayout());
            this._dialog.setTitle("Validation messages");
            this._dialog.setBounds(new Double(this.getBounds().getCenterX()).intValue(), new Double(this.getBounds().getCenterY()).intValue(), new Double(this.getBounds().getWidth()).intValue() - 100, new Double(this.getBounds().getHeight()).intValue() + 200);
            this._dialog.getContentPane().add((Component)this.getMessageTablePanel(), "Center");
            GUITools.centerRelativeToParentFrame(this, this._dialog);
        }
        return this._dialog;
    }

    public MessageTable getMessageTable() {
        if (this._messageTable == null) {
            this._messageTable = new MessageTable(this._workspace, this._editor);
        }
        return this._messageTable;
    }

    public JComponent getMessageTablePanel() {
        if (this._messageTablePanel == null) {
            this._messageTablePanel = new JPanel();
            this._messageTablePanel.setFocusable(false);
            this._messageTablePanel.setLayout(new BorderLayout());
            JScrollPane scrollPane = new JScrollPane(this.getMessageTable());
            scrollPane.setFocusable(false);
            scrollPane.getViewport().setFocusable(false);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            this._messageTablePanel.add((Component)scrollPane, "Center");
        }
        return this._messageTablePanel;
    }

    private void initializeValidationErrors(TypeController controller) {
        if (controller.getErrorController().hasValidationErrors()) {
            Enumeration typeErrors = controller.getErrorController().getErrors().elements();
            int i = 0;
            while (typeErrors.hasMoreElements()) {
                Vector errors = (Vector)typeErrors.nextElement();
                for (int j = 0; j < errors.size(); ++j) {
                    Error error = (Error)errors.get(j);
                    this.showMessage(error);
                }
                ++i;
            }
        }
    }
}

