/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.alphase.lic.License;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.LicenseChecker;
import com.jaxfront.swing.ui.tools.FontTools;
import com.jaxfront.swing.ui.tools.HeaderPanel;
import com.jaxfront.swing.ui.tools.LicenseCheckerDialog;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class StatusBar
extends JPanel
implements ActionListener {
    private Frame _editor;
    private ImageIcon _bannerImageIcon;
    private String _licenseText;
    private Color _startColor;
    private Color _endColor;
    private String _text;
    private JPanel _textPanel;
    private JPanel _busyPanel;
    private JPanel _timePanel;
    private JPanel _licensePanel;
    private JButton _licenseButton;
    private Thread _busyThread;
    private Component _component;
    private boolean _evaluationDaysLeftDone;
    private int _evaluationDaysLeft;
    private LicenseCheckerDialog _licenceDialog;
    private HeaderPanel _bannerPanel;
    private boolean _allowEnterLicense = true;
    private URL _serverAddress;

    public StatusBar(Frame editor) {
        this(editor, null);
    }

    public StatusBar(Frame editor, String bannerIcon) {
        this(editor, bannerIcon, null);
    }

    public StatusBar(Frame editor, String bannerIcon, String licenseText) {
        this(editor, bannerIcon, licenseText, null);
    }

    public StatusBar(Frame editor, String bannerIcon, String licenseText, Color startColor) {
        this(editor, bannerIcon, licenseText, startColor, null);
    }

    public StatusBar(Frame editor, String bannerIcon, String licenseText, Color startColor, Color endColor) {
        this(editor, JAXFrontProperties.getImageIcon((String)StatusBar.getBannerIconName(bannerIcon)), licenseText, startColor, endColor);
    }

    public StatusBar(Frame editor, ImageIcon bannerIcon, String licenseText, Color startColor, Color endColor) {
        this(editor, bannerIcon, licenseText, startColor, endColor, true);
    }

    public StatusBar(Frame editor, ImageIcon bannerIcon, String licenseText, Color startColor, Color endColor, boolean allowEnterLicense) {
        this._editor = editor;
        this._bannerImageIcon = bannerIcon;
        this._licenseText = licenseText;
        this._startColor = startColor;
        this._endColor = endColor;
        this._allowEnterLicense = allowEnterLicense;
        this.initialize();
    }

    private void initialize() {
        String colSpec = "0:g(0.9),50px,40px,40px";
        String rowSpec = "20px";
        if (this._bannerImageIcon != null && this.getLicenseFooterBanner() != null) {
            rowSpec = "20px,28px";
        }
        FormLayout formLayout = new FormLayout(colSpec, rowSpec);
        this.setLayout(formLayout);
        this._textPanel = new JPanel();
        this._licenseButton = new JButton();
        String imageName = "com/jaxfront/core/images/files/unlock_16x16.gif";
        if (this.getEvaluationDaysLeft() > 0) {
            imageName = "com/jaxfront/core/images/files/lock_16x16.gif";
            this._licenseButton.setToolTipText(this.getEvaluationDaysLeft() + " day(s) left for evaluation.");
        }
        this._licenseButton.setIcon(JAXFrontProperties.getImageIcon((String)imageName));
        colSpec = "3px,20px,20px";
        rowSpec = "20px";
        this._licensePanel = new JPanel(new FormLayout(colSpec, rowSpec));
        this._licenseButton.setBorder(null);
        this._licenseButton.setFocusable(false);
        this._licenseButton.addActionListener(this);
        this._licensePanel.add((Component)this._licenseButton, "2,1");
        this._busyPanel = new JPanel();
        this._timePanel = new JPanel(new BorderLayout());
        this.add((Component)this._textPanel, "1,1");
        this.add((Component)this._busyPanel, "2,1");
        this.add((Component)this._licensePanel, "3,1");
        this.add((Component)this._timePanel, "4,1");
        if (this._bannerImageIcon != null && this.getLicenseFooterBanner() != null) {
            this.add((Component)this.getLicenseFooterBanner(), "1,2,4,1,F,C");
        }
    }

    private HeaderPanel getLicenseFooterBanner() {
        License lic = LicenseChecker.getLicense();
        boolean isCommunityLicense = true;
        String licenseText = this.getLicenseText();
        if (lic != null) {
            licenseText = lic.Product;
            if (licenseText != null && licenseText.indexOf("Community Edition") == -1) {
                isCommunityLicense = false;
            } else {
                licenseText = this.getLicenseText();
            }
        }
        if (!isCommunityLicense) {
            return null;
        }
        this._bannerPanel = new HeaderPanel(null, licenseText, 0, 2, 0, Color.black, this.getStartColor(), this.getEndColor(), 0, FontTools.getFont("Verdana", 10.0f).deriveFont(1), this._bannerImageIcon);
        return this._bannerPanel;
    }

    public void setLink(String httpLink) {
        if (this._bannerPanel != null) {
            this._bannerPanel.setLink(httpLink);
        }
    }

    public void startProcess(Component component, String text) {
        this._component = component;
        if (this._component != null) {
            this._component.setCursor(new Cursor(3));
        }
        this._text = text;
        this._busyThread = new Thread(new ProgressBar(this._busyPanel));
        this._busyThread.start();
    }

    public void setText(String text) {
        this._text = text;
        this.drawText(text);
    }

    public void endProcess() {
        this._busyThread = null;
        if (this._component != null) {
            this._component.setCursor(new Cursor(0));
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.GRAY);
        g.draw3DRect(0, 0, this._textPanel.getWidth(), this._textPanel.getHeight() * 2 - 2, true);
        g.draw3DRect(this._busyPanel.getX() + 2, 0, this._busyPanel.getWidth() - 2, this._busyPanel.getHeight() * 2 - 2, true);
        g.draw3DRect(this._licensePanel.getX() + 2, 0, this._licensePanel.getWidth() - 2, 18, true);
        g.draw3DRect(this._timePanel.getX() + 2, 0, this._timePanel.getWidth() - 4, this._timePanel.getHeight() * 2 - 2, true);
        if (this.getEvaluationDaysLeft() != -1) {
            Font textFont = FontTools.getDefaultFont().deriveFont(8);
            g.setFont(textFont);
            g.setColor(Color.gray);
            g.drawString(String.valueOf(this.getEvaluationDaysLeft()), this._licensePanel.getX() + 22, this._licensePanel.getWidth() - 26);
            this._evaluationDaysLeftDone = true;
        }
    }

    private void drawText(String text) {
        Graphics g;
        this.clearText();
        if (text != null && (g = this._textPanel.getGraphics()) != null) {
            Font textFont = FontTools.getDefaultFont().deriveFont(8);
            g.setFont(textFont);
            g.setColor(Color.gray);
            g.drawString(text, 2, (int)textFont.getSize2D() - 2);
        }
    }

    private void clearText() {
        if (this._textPanel != null && this._textPanel.getGraphics() != null) {
            this._textPanel.getGraphics().clearRect(2, 0, this._textPanel.getWidth() - 4, this._textPanel.getHeight());
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._licenseButton) {
            this.showLicenseDialog();
        }
    }

    private int getEvaluationDaysLeft() {
        if (!this._evaluationDaysLeftDone) {
            this._evaluationDaysLeft = LicenseChecker.getEvaluationDaysLeft();
            this._evaluationDaysLeftDone = true;
        }
        return this._evaluationDaysLeft;
    }

    public void showLicenseDialog() {
        this.showLicenseDialog(this._editor);
    }

    public void showLicenseDialog(Frame frame) {
        this.showLicenseDialog(frame, false, false);
    }

    public void showLicenseDialog(Frame frame, boolean closeByError, boolean closeIfInvalid) {
        this.getLicenseDialog(frame, closeByError, closeIfInvalid).show();
    }

    private LicenseCheckerDialog getLicenseDialog(Frame frame, boolean closeByError, boolean closeIfInvalid, boolean allowEnterLicense) {
        if (this._licenceDialog == null) {
            this._licenceDialog = new LicenseCheckerDialog(frame, GUIComponentNLS.getInstance().getNLSText("license_manager_title", "JAXFront License Manager"), closeByError, closeIfInvalid, this.getLicenseError(), this._allowEnterLicense);
        }
        return this._licenceDialog;
    }

    private LicenseCheckerDialog getLicenseDialog(Frame frame, boolean closeByError, boolean closeIfInvalid) {
        return this.getLicenseDialog(frame, closeByError, closeIfInvalid, true);
    }

    private int getLicenseError() {
        if (LicenseChecker.getLicense() != null) {
            return LicenseChecker.getLicense().LicenseVal;
        }
        return 0;
    }

    private static String getBannerIconName(String imageName) {
        if (imageName == null) {
            imageName = "com/jaxfront/core/images/files/jaxfront-banner.gif";
        }
        return imageName;
    }

    private String getLicenseText() {
        if (this._licenseText == null) {
            this._licenseText = " Free Community Edition";
        }
        return this._licenseText;
    }

    private Color getStartColor() {
        if (this._startColor == null) {
            this._startColor = Color.BLACK;
        }
        return this._startColor;
    }

    private Color getEndColor() {
        if (this._endColor == null) {
            this._endColor = UIManager.getColor("Panel.background");
        }
        return this._endColor;
    }

    public void setServerAddress(URL url) {
        this._serverAddress = url;
        this._timePanel.removeAll();
        JButton button = null;
        if (url != null) {
            button = new JButton();
            button.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/greenBall.gif"));
            button.setToolTipText("Connected to: " + url.getHost() + "/" + url.getPath());
        } else {
            button = new JButton();
            button.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/redBall.gif"));
            button.setToolTipText("Not connected");
        }
        this._timePanel.add((Component)button, "Center");
        this._timePanel.updateUI();
    }

    private class ProgressBar
    implements Runnable {
        private JPanel _panel;
        private Image _panelImage;
        private Graphics _panelGraphics;

        public ProgressBar(JPanel panel) {
            this._panel = panel;
        }

        public void run() {
            Thread myThread = Thread.currentThread();
            if (StatusBar.this._text != null) {
                StatusBar.this.drawText(StatusBar.this._text);
            }
            while (StatusBar.this._busyThread == myThread) {
                int blockWidth = (this._panel.getWidth() - 8) / 10;
                int x = 0;
                int y = 0;
                if (this._panelImage == null) {
                    this._panelImage = StatusBar.this.createImage(this._panel.getWidth(), this._panel.getHeight());
                    this._panelGraphics = this._panel.getGraphics();
                    this._panelGraphics.setFont(StatusBar.this.getFont());
                }
                for (int i = 0; i < 10 && StatusBar.this._busyThread == myThread; ++i) {
                    x = i * blockWidth + 6;
                    y = 1;
                    this._panelGraphics.setColor(Color.green);
                    this._panelGraphics.fillRect(x, y, blockWidth, this._panel.getHeight() - 2);
                    try {
                        Thread.sleep(300L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this._panelGraphics.clearRect(5, 0, this._panel.getWidth() - 5, this._panel.getHeight());
            }
            if (this._panelGraphics != null && this._panel != null) {
                this._panelGraphics.clearRect(5, 0, this._panel.getWidth() - 5, this._panel.getHeight());
            }
            this._panelImage = null;
            StatusBar.this.clearText();
            StatusBar.this.updateUI();
        }
    }
}

