/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.io.FileHelper;
import com.jaxfront.core.util.search.Search;
import com.jaxfront.swing.ui.editor.AbstractFrame;
import com.jaxfront.swing.ui.tools.Dialog;
import com.jaxfront.swing.ui.tools.search.Find;
import com.jaxfront.swing.ui.tools.search.TextComponentSearcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public class TextDialog
extends AbstractFrame {
    private JEditorPane _textArea;
    private Action _saveAsAction;
    private Action _exitAction;
    private Action _findAction;
    private JMenuBar _menuBar;
    private JMenu _fileMenu;

    public TextDialog(String title) {
        this.setTitle(title);
        this.init();
    }

    private void init() {
        this.initAction();
        this.initMenuBar();
        ImageIcon iconWhite = JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/xcentric_16x16.gif");
        this.setIconImage(iconWhite.getImage());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JScrollPane scroller = new JScrollPane(this.getTextArea());
        container.add((Component)scroller, "Center");
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent event) {
                int keyCode = event.getKeyCode();
                int modifier = event.getModifiers();
                if (event.getSource() == TextDialog.this._textArea && keyCode == 70 && modifier == 2) {
                    TextDialog.this.showFind();
                }
                return false;
            }
        });
        this.setSize(800, 600);
    }

    public void showFind() {
        Find find = Find.getSharedInstance(this);
        TextComponentSearcher textSearchar = new TextComponentSearcher(this._textArea);
        find.setResultProcessor(textSearchar);
        find.showFind((Search)textSearchar);
    }

    private void initAction() {
        this._exitAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText("button_close", "Close"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/close_16x16.gif")){

            public void actionPerformed(ActionEvent e) {
                TextDialog.this.setVisible(false);
            }
        };
        this._findAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText("button_find", "Find"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/find_16x16.gif")){

            public void actionPerformed(ActionEvent e) {
                TextDialog.this.showFind();
            }
        };
        this._saveAsAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText("button_save", "Save"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/saveFile_16x16.gif")){

            public void actionPerformed(ActionEvent e) {
                TextDialog.this.saveFileChooser();
            }
        };
    }

    private void initMenuBar() {
        this._menuBar = new JMenuBar();
        this._fileMenu = new JMenu(GUIComponentNLS.getInstance().getNLSText("menu_title_file", "File"));
        this._fileMenu.add(this._saveAsAction);
        this._fileMenu.addSeparator();
        this._fileMenu.add(this._findAction);
        this._fileMenu.addSeparator();
        this._fileMenu.add(this._exitAction);
        this._menuBar.add(this._fileMenu);
        this.setJMenuBar(this._menuBar);
    }

    private JEditorPane getTextArea() {
        if (this._textArea == null) {
            this._textArea = new JEditorPane();
            this._textArea.setCaretPosition(0);
            this._textArea.setEditable(false);
        }
        return this._textArea;
    }

    public void setText(String text) {
        this.getTextArea().setText(text);
        this.getTextArea().setCaretPosition(0);
    }

    public void prettyPrint() {
    }

    private void saveFileChooser() {
        try {
            JFileChooser fc = new JFileChooser();
            class XMLFileFilter
            extends FileFilter {
                XMLFileFilter() {
                }

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.endsWith(".xml");
                }

                public String getDescription() {
                    return "*.xml";
                }
            }
            fc.addChoosableFileFilter(new XMLFileFilter());
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                FileHelper.save((String)this._textArea.getText(), (File)file, (String)"utf-8");
            }
        }
        catch (IOException e) {
            Dialog.showErrorDialog(e.getMessage());
        }
    }

    protected JComponent initializeWorkspace() {
        return null;
    }
}

