/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.focus;

import java.awt.Component;
import java.awt.Window;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;

public class MyLayoutComparator
implements Comparator,
Serializable {
    private static final int ROW_TOLERANCE = 10;
    private boolean horizontal = true;
    private boolean leftToRight = true;

    public MyLayoutComparator(boolean horizontal, boolean leftToRight) {
        this.horizontal = horizontal;
        this.leftToRight = leftToRight;
    }

    public int compare(Object o1, Object o2) {
        Component a = (Component)o1;
        Component b = (Component)o2;
        if (a == b) {
            return 0;
        }
        if (a.getParent() != b.getParent()) {
            LinkedList<Component> aAncestory = new LinkedList<Component>();
            while (a != null) {
                aAncestory.add(a);
                if (a instanceof Window) break;
                a = a.getParent();
            }
            if (a == null) {
                throw new ClassCastException(a.toString());
            }
            LinkedList<Component> bAncestory = new LinkedList<Component>();
            while (b != null) {
                bAncestory.add(b);
                if (b instanceof Window) break;
                b = b.getParent();
            }
            if (b == null) {
                throw new ClassCastException(b.toString());
            }
            ListIterator aIter = aAncestory.listIterator(aAncestory.size());
            ListIterator bIter = bAncestory.listIterator(bAncestory.size());
            do {
                if (!aIter.hasPrevious()) {
                    return -1;
                }
                a = (Component)aIter.previous();
                if (!bIter.hasPrevious()) {
                    return 1;
                }
                b = (Component)bIter.previous();
            } while (a == b);
        }
        int ax = a.getX();
        int ay = a.getY();
        int bx = b.getX();
        int by = b.getY();
        if (this.horizontal) {
            if (this.leftToRight) {
                if (Math.abs(ay - by) < 10) {
                    return ax < bx ? -1 : 1;
                }
                return ay < by ? -1 : 1;
            }
            if (Math.abs(ay - by) < 10) {
                return ax > bx ? -1 : 1;
            }
            return ay < by ? -1 : 1;
        }
        if (this.leftToRight) {
            if (Math.abs(ax - bx) < 10) {
                return ay < by ? -1 : 1;
            }
            return ax < bx ? -1 : 1;
        }
        if (Math.abs(ax - bx) < 10) {
            return ay < by ? -1 : 1;
        }
        return ax > bx ? -1 : 1;
    }
}

