/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.focus;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;

public class TabbingTest
extends JFrame {
    public TabbingTest() {
        super("Tabbing Test");
        GridBagLayout gridbag = new GridBagLayout();
        JPanel panel1 = new JPanel(gridbag);
        this.init(panel1, gridbag);
        panel1.setFocusCycleRoot(true);
        panel1.setFocusTraversalPolicy(new SettableLayoutFocusTraversalPolicy());
        GridBagLayout gridbag2 = new GridBagLayout();
        JPanel panel11 = new JPanel(gridbag2);
        this.init(panel11, gridbag2);
        panel11.setFocusCycleRoot(true);
        panel11.setFocusTraversalPolicy(new SettableLayoutFocusTraversalPolicy());
        panel1.add(panel11);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)new Button("Okay"), "South");
        JPanel panel3 = new JPanel();
        panel3.setLayout(new FlowLayout());
        panel3.add(new Button("button 1"));
        panel3.add(new Button("button 2"));
        panel3.add(new Button("button 3"));
        panel2.add((Component)panel3, "North");
        JPanel panel4 = new JPanel();
        panel4.setLayout(new GridLayout(2, 2));
        panel4.add(new JLabel("label 1"));
        panel4.add(new JTextField("button 2"));
        panel4.add(new JLabel("label 2"));
        panel4.add(new JTextField("button 3"));
        panel2.add((Component)panel4, "Center");
        panel2.add((Component)panel1, "East");
        Container content = this.getContentPane();
        content.add(panel2);
        this.setFocusTraversalPolicy(new UniversalFocusTraversalPolicy());
        this.pack();
        this.setVisible(true);
    }

    protected void makebutton(String name, JPanel panel1, GridBagLayout gridbag, GridBagConstraints c) {
        JTextField button = new JTextField(name);
        gridbag.setConstraints(button, c);
        panel1.add(button);
    }

    public void init(JPanel panel1, GridBagLayout gridbag) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        this.makebutton("Button1", panel1, gridbag, c);
        this.makebutton("Button2", panel1, gridbag, c);
        this.makebutton("Button3", panel1, gridbag, c);
        c.gridwidth = 0;
        this.makebutton("Button4", panel1, gridbag, c);
        c.weightx = 0.0;
        this.makebutton("Button5", panel1, gridbag, c);
        c.gridwidth = -1;
        this.makebutton("Button6", panel1, gridbag, c);
        c.gridwidth = 0;
        this.makebutton("Button7", panel1, gridbag, c);
        c.gridwidth = 1;
        c.gridheight = 2;
        c.weighty = 1.0;
        this.makebutton("Button8", panel1, gridbag, c);
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.gridheight = 1;
        this.makebutton("Button9", panel1, gridbag, c);
        this.makebutton("Button10", panel1, gridbag, c);
    }

    public static void main(String[] args) {
        new TabbingTest();
    }

    class SettableLayoutFocusTraversalPolicy
    extends UniversalFocusTraversalPolicy {
        protected Comparator myComparator;

        public SettableLayoutFocusTraversalPolicy() {
            this.myComparator = new MyLayoutComparator(false, true);
            this.setComparator(this.myComparator);
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent == this.getLastComponent(focusCycleRoot)) {
                final Container cycleRoot = focusCycleRoot;
                final Container higherFocusCycle = focusCycleRoot.getFocusCycleRootAncestor();
                if (higherFocusCycle != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Component lookahead;
                            KeyboardFocusManager FocusManager2 = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                            FocusTraversalPolicy focusPolicy = higherFocusCycle.getFocusTraversalPolicy();
                            Component current = lookahead = focusPolicy.getLastComponent(higherFocusCycle);
                            while (lookahead.getFocusCycleRootAncestor() != cycleRoot) {
                                current = lookahead;
                                lookahead = focusPolicy.getComponentBefore(higherFocusCycle, lookahead);
                            }
                            current.requestFocus();
                        }
                    });
                    return aComponent;
                }
            }
            return super.getComponentAfter(focusCycleRoot, aComponent);
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent == this.getFirstComponent(focusCycleRoot)) {
                final Container cycleRoot = focusCycleRoot;
                final Container higherFocusCycle = focusCycleRoot.getFocusCycleRootAncestor();
                if (higherFocusCycle != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Component lookahead;
                            KeyboardFocusManager FocusManager2 = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                            FocusTraversalPolicy focusPolicy = higherFocusCycle.getFocusTraversalPolicy();
                            Component current = lookahead = focusPolicy.getFirstComponent(higherFocusCycle);
                            while (lookahead.getFocusCycleRootAncestor() != cycleRoot) {
                                current = lookahead;
                                lookahead = focusPolicy.getComponentAfter(higherFocusCycle, lookahead);
                            }
                            current.requestFocus();
                        }
                    });
                    return null;
                }
            }
            return super.getComponentBefore(focusCycleRoot, aComponent);
        }
    }

    class UniversalFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        UniversalFocusTraversalPolicy() {
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            Component comp = super.getComponentBefore(focusCycleRoot, aComponent);
            if (comp.getFocusCycleRootAncestor() != focusCycleRoot) {
                Container cycleRoot = comp.getFocusCycleRootAncestor();
                KeyboardFocusManager FocusManager2 = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                FocusTraversalPolicy focusPolicy = cycleRoot.getFocusTraversalPolicy();
                comp = focusPolicy.getLastComponent(cycleRoot);
            }
            return comp;
        }
    }

    class MyLayoutComparator
    implements Comparator,
    Serializable {
        private static final int ROW_TOLERANCE = 10;
        private boolean horizontal = true;
        private boolean leftToRight = true;

        public MyLayoutComparator(boolean horizontal, boolean leftToRight) {
            this.horizontal = horizontal;
            this.leftToRight = leftToRight;
        }

        public int compare(Object o1, Object o2) {
            Component a = (Component)o1;
            Component b = (Component)o2;
            if (a == b) {
                return 0;
            }
            if (a.getParent() != b.getParent()) {
                LinkedList<Component> aAncestory = new LinkedList<Component>();
                while (a != null) {
                    aAncestory.add(a);
                    if (a instanceof Window) break;
                    a = a.getParent();
                }
                if (a == null) {
                    throw new ClassCastException(a.toString());
                }
                LinkedList<Component> bAncestory = new LinkedList<Component>();
                while (b != null) {
                    bAncestory.add(b);
                    if (b instanceof Window) break;
                    b = b.getParent();
                }
                if (b == null) {
                    throw new ClassCastException(b.toString());
                }
                ListIterator aIter = aAncestory.listIterator(aAncestory.size());
                ListIterator bIter = bAncestory.listIterator(bAncestory.size());
                do {
                    if (!aIter.hasPrevious()) {
                        return -1;
                    }
                    a = (Component)aIter.previous();
                    if (!bIter.hasPrevious()) {
                        return 1;
                    }
                    b = (Component)bIter.previous();
                } while (a == b);
            }
            int ax = a.getX();
            int ay = a.getY();
            int bx = b.getX();
            int by = b.getY();
            if (this.horizontal) {
                if (this.leftToRight) {
                    if (Math.abs(ay - by) < 10) {
                        return ax < bx ? -1 : 1;
                    }
                    return ay < by ? -1 : 1;
                }
                if (Math.abs(ay - by) < 10) {
                    return ax > bx ? -1 : 1;
                }
                return ay < by ? -1 : 1;
            }
            if (this.leftToRight) {
                if (Math.abs(ax - bx) < 10) {
                    return ay < by ? -1 : 1;
                }
                return ax < bx ? -1 : 1;
            }
            if (Math.abs(ax - bx) < 10) {
                return ay < by ? -1 : 1;
            }
            return ax > bx ? -1 : 1;
        }
    }
}

