/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.layout;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class ActionTabPlaf
extends BasicTabbedPaneUI {
    Action[] _actions;
    private int addWidth = -1;
    private int maxW = 0;
    private int widthActionOffset = 5;
    private int maxH = 0;
    private int _textOffset = 0;
    private int _txtOrientation = 0;

    protected LayoutManager createLayoutManager() {
        return new ActionPlafLayout();
    }

    public ActionTabPlaf() {
    }

    public ActionTabPlaf(Action[] actions) {
        this._actions = actions;
    }

    public ActionTabPlaf(Action[] actions, int txtOrientation) {
        this._actions = actions;
        this._txtOrientation = txtOrientation;
    }

    public ActionTabPlaf(Action[] actions, int txtOrientation, int textOffset) {
        this._actions = actions;
        this._txtOrientation = txtOrientation;
        this._textOffset = textOffset;
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        this.calculateMaxWidths();
        Insets defaultInsets = (Insets)super.getTabInsets(tabPlacement, tabIndex).clone();
        defaultInsets.right += this.addWidth;
        defaultInsets.top += 4;
        defaultInsets.bottom += 4;
        return defaultInsets;
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, this._txtOrientation, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        textRect.x += this._textOffset;
        super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
    }

    public void calculateMaxWidths() {
        if (this.addWidth == -1) {
            int overall = 0;
            if (this._actions != null && this._actions.length > 0) {
                for (int t = 0; t < this._actions.length; ++t) {
                    Action aAction = this._actions[t];
                    Icon aIcon = (Icon)aAction.getValue("SmallIcon");
                    this.maxW = Math.max(this.maxW, aIcon.getIconWidth());
                    this.maxH = Math.max(this.maxH, aIcon.getIconHeight());
                    overall += this.maxW;
                }
            }
            this.addWidth = overall + this.widthActionOffset;
        }
    }

    class ActionPlafLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        ArrayList buttonsPerTab;

        ActionPlafLayout() {
            super(ActionTabPlaf.this);
            this.buttonsPerTab = new ArrayList();
        }

        public void layoutContainer(Container parent) {
            JButton aTabButton;
            int t;
            ArrayList tabButtons;
            int i;
            super.layoutContainer(parent);
            while (ActionTabPlaf.this.tabPane.getTabCount() > this.buttonsPerTab.size()) {
                ArrayList<ActionButton> tabButtons2 = new ArrayList<ActionButton>(1);
                this.buttonsPerTab.add(tabButtons2);
                for (i = ActionTabPlaf.this._actions.length - 1; i >= 0; --i) {
                    ActionButton abut = new ActionButton(this.buttonsPerTab.size(), ActionTabPlaf.this._actions[i]);
                    abut.setBorder(BorderFactory.createEmptyBorder());
                    abut.setContentAreaFilled(false);
                    abut.setText(null);
                    tabButtons2.add(abut);
                }
            }
            Rectangle rect = new Rectangle();
            for (i = 0; i < ActionTabPlaf.this.tabPane.getTabCount(); ++i) {
                rect = ActionTabPlaf.this.getTabBounds(i, rect);
                tabButtons = (ArrayList)this.buttonsPerTab.get(i);
                for (t = 0; t < tabButtons.size(); ++t) {
                    aTabButton = (JButton)tabButtons.get(t);
                    aTabButton.setLocation(rect.x + rect.width - (ActionTabPlaf.this.maxW * (t + 1) + 3), rect.y + 5);
                    if (aTabButton.getIcon() != null) {
                        aTabButton.setSize(ActionTabPlaf.this.maxW + 1, ActionTabPlaf.this.maxH + 1);
                    } else {
                        aTabButton.setSize(18, 18);
                    }
                    ActionTabPlaf.this.tabPane.add(aTabButton);
                }
            }
            while (i < this.buttonsPerTab.size()) {
                tabButtons = (ArrayList)this.buttonsPerTab.get(i);
                for (t = 0; t < tabButtons.size(); ++t) {
                    aTabButton = (JButton)tabButtons.get(t);
                    ActionTabPlaf.this.tabPane.remove(aTabButton);
                }
                ++i;
            }
        }

        class ActionButton
        extends JButton
        implements UIResource {
            private int tabPos;

            public ActionButton(int index, Action aAction) {
                super(aAction);
                this.tabPos = -1;
                this.tabPos = index - 1;
                this.setMargin(new Insets(0, 0, 0, 0));
                this.addMouseListener(new MouseAdapter(){

                    public void mouseEntered(MouseEvent e) {
                        ActionButton.this.setForeground(new Color(255, 0, 0));
                    }

                    public void mouseExited(MouseEvent e) {
                        ActionButton.this.setForeground(new Color(0, 0, 0));
                    }

                    public void mousePressed(MouseEvent e) {
                        ActionButton.this.getAction().putValue("selectedIndex", ActionButton.this.getTabPos());
                        super.mousePressed(e);
                    }
                });
            }

            public int getTabPos() {
                return this.tabPos;
            }
        }
    }
}

