/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.swing.ui.tools.FunctionalTitleBorder;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ImageIcon;

public class BorderActionSet {
    private String _name;
    private Action _inverseAction;
    private Action _action;
    private Image _actionImage;
    private Image _inverseActionImage;
    private Image _actionImageShadowed;
    private Image _inverseActionImageShadowed;
    private Rectangle _uiRange;
    private static final byte[] NULL_IMAGE_DEF = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final ImageIcon emptyIcon = new ImageIcon(NULL_IMAGE_DEF);
    public static final int _imageSpace = 3;
    private String _toolTipText;
    private boolean _toggled = false;
    private boolean _visible = true;
    private boolean _enabled = true;
    private boolean _actionEnabled = true;
    private boolean _willToggle = false;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_RIGHT = 1;
    private int _alignment = 0;

    public BorderActionSet(String name, Action action, Action inverseAction, Image actionImage, Image inverseActionImage, Image actionImageShadowed, Image inverseActionImageShadowed, String toolTipText, int alignment) {
        this._name = name;
        this._action = action;
        this._inverseAction = inverseAction;
        this._actionImage = actionImage;
        this._inverseActionImage = inverseActionImage;
        this._actionImageShadowed = actionImageShadowed;
        this._inverseActionImageShadowed = inverseActionImageShadowed;
        this.setToolTipText(toolTipText);
        this.setAlignment(alignment);
    }

    Action getAction() {
        return this._action;
    }

    Action getInverseAction() {
        return this._inverseAction;
    }

    Image getActionImage() {
        if (this._actionImage == null) {
            this._actionImage = emptyIcon.getImage();
        }
        return this._actionImage;
    }

    public void fireActualAction(ActionEvent ae) {
        if (this.isEnabled() && this.isActionEnabled()) {
            if (!this.isToggled()) {
                if (this.getAction() != null) {
                    this.getAction().actionPerformed(ae);
                }
            } else if (this.getInverseAction() != null) {
                this.getInverseAction().actionPerformed(ae);
            } else if (this.getAction() != null) {
                this.getAction().actionPerformed(ae);
            }
            this.setToggled(!this.isToggled());
        }
    }

    public void fireAction(ActionEvent ae, boolean useInverse) {
        if (this.isEnabled() && this.isActionEnabled()) {
            if (!useInverse) {
                if (this.getAction() != null) {
                    this.getAction().actionPerformed(ae);
                }
            } else if (this.getInverseAction() != null) {
                this.getInverseAction().actionPerformed(ae);
            } else if (this.getAction() != null) {
                this.getAction().actionPerformed(ae);
            }
            this.setToggled(!this.isToggled());
        }
    }

    Rectangle getPaintRectangle() {
        int x = this.getUIRange().x;
        int y = this.getUIRange().y;
        int height = this.getActionImageToBeDisplayed().getHeight(null);
        int width = this.getActionImageToBeDisplayed().getWidth(null);
        return new Rectangle(x, y, width, height);
    }

    Image getActionImageToBeDisplayed() {
        if (this.isEnabled() && this.isActionEnabled()) {
            if (this.willToggled()) {
                if (this.isToggled() && this.getInverseActionImageShadowed() != null) {
                    return this.getInverseActionImageShadowed();
                }
                if (this.getActionImageShadowed() != null) {
                    return this.getActionImageShadowed();
                }
            }
            if (!this.isToggled()) {
                return this.getActionImage();
            }
            if (this.getInverseActionImage() != null) {
                return this.getInverseActionImage();
            }
            return this.getActionImage();
        }
        if (!this.isEnabled()) {
            return FunctionalTitleBorder.createDisabledIcon(new ImageIcon(this.getActionImage())).getImage();
        }
        if (!this.isActionEnabled()) {
            return this.getActionImage();
        }
        return this.getActionImage();
    }

    Image getInverseActionImage() {
        return this._inverseActionImage;
    }

    void setUIRange(Rectangle uiRange) {
        this._uiRange = uiRange;
    }

    Rectangle getUIRange() {
        if (this._uiRange == null) {
            this.setUIRange(new Rectangle(0, 0, 0, 0));
        }
        return this._uiRange;
    }

    public boolean isMouseInRange(Point p, Component rootComponent) {
        if (this.getAlignment() == 0) {
            return this.getUIRange().contains(p);
        }
        Rectangle range = this.getPaintRectangle();
        Rectangle rootCompRect = rootComponent.getBounds();
        range.x = rootCompRect.width - range.x - 5;
        return range.contains(p);
    }

    void setToggled(boolean toggled) {
        this._toggled = toggled;
    }

    void setWillToggled(boolean willToggle) {
        this._willToggle = willToggle;
    }

    boolean isToggled() {
        return this._toggled;
    }

    boolean willToggled() {
        return this._willToggle;
    }

    public void setAlignment(int alignment) {
        this._alignment = alignment;
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void setActionImageShadowed(Image actionImageShadowed) {
        this._actionImageShadowed = actionImageShadowed;
    }

    public String getToolTipText() {
        return this._toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        this._toolTipText = toolTipText != null && toolTipText.length() == 0 ? null : toolTipText;
    }

    public Image getActionImageShadowed() {
        return this._actionImageShadowed;
    }

    public void setInverseActionImageShadowed(Image inverseActionImageShadowed) {
        this._inverseActionImageShadowed = inverseActionImageShadowed;
    }

    public Image getInverseActionImageShadowed() {
        return this._inverseActionImageShadowed;
    }

    protected void setName(String name) {
        this._name = name;
    }

    protected String getName() {
        return this._name;
    }

    public void setVisible(boolean visible) {
        this._visible = visible;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setActionEnabled(boolean enabled) {
        this._actionEnabled = enabled;
    }

    public boolean isActionEnabled() {
        boolean enabled = this._actionEnabled;
        if (this.getAction() != null) {
            enabled &= this.getAction().isEnabled();
        }
        if (this.getInverseAction() != null) {
            enabled &= this.getInverseAction().isEnabled();
        }
        return enabled;
    }
}

