/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.type.Type;
import com.jaxfront.swing.helpers.JAXFrontDocument;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.text.JTextComponent;

public class CalculatorHandler
implements FocusListener,
KeyListener {
    JTextComponent _tc = null;
    String _origText = null;
    Type _aBaseType = null;
    Color _origColor = null;

    public CalculatorHandler(JTextComponent tc, Type aBaseType) {
        this._tc = tc;
        ((JAXFrontDocument)((Object)this._tc.getDocument())).setBypassing(true);
        this._origText = this._tc.getText();
        this._origColor = this._tc.getCaretColor();
        this._tc.setCaretColor(Color.red);
        this._aBaseType = aBaseType;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.handleAbort();
        this.end();
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.handleAbort();
            this.end();
        }
        if (e.isControlDown() && e.getKeyCode() == 75 || e.getKeyCode() == 10) {
            e.consume();
            this.handle();
            this.end();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void end() {
        this._tc.setCaretColor(this._origColor);
        this._tc.removeFocusListener(this);
        this._tc.removeKeyListener(this);
    }

    public void handle() {
        Object or;
        ((JAXFrontDocument)((Object)this._tc.getDocument())).setBypassing(false);
        String text = this._tc.getText();
        String calc = null;
        if (text != null && text.length() > 0 && !text.equals(this._origText) && (or = MathEvaluator.getInstance().evaluateUser(text, this._aBaseType)) != null) {
            calc = or instanceof Number ? ((Number)or).doubleValue() + "" : or.toString();
        }
        if (calc != null) {
            if (calc.endsWith(".0")) {
                calc = calc.substring(0, calc.length() - 2);
            }
            this._tc.setText(calc);
        } else if (this._origText != null && !this._origText.equals(text)) {
            this._tc.setText(this._origText);
        }
    }

    public void handleAbort() {
        String text = this._tc.getText();
        if (text == this._origText) {
            return;
        }
        if (this._origText != null && text != null && text.equals(this._origText)) {
            return;
        }
        if (this._origText != null) {
            this._tc.setText(this._origText);
        }
        ((JAXFrontDocument)((Object)this._tc.getDocument())).setBypassing(false);
    }
}

