/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.ui.FontParams;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.xui.TableCell;
import java.awt.Color;
import java.awt.Font;

public class FontFactory {
    private static FontFactory _instance = null;

    public static Font createLabelFont(TableCell tableCell) {
        String family = tableCell.getLabelFontName();
        int fontStyle = FontParams.getFontStyleAsInt((String)tableCell.getLabelFontStyle());
        int fontSize = FontParams.getFontSizeAsInt((Integer)tableCell.getLabelFontSize());
        Color fontColor = tableCell.getLabelFontColor();
        return FontFactory.getLabelFontDefinition(family, fontStyle, fontSize, fontColor).createFont();
    }

    public static Font createHeaderFont(TableCell tableCell) {
        String family = tableCell.getLabelFontName();
        int fontStyle = FontParams.getFontStyleAsInt((String)tableCell.getLabelFontStyle());
        int fontSize = FontParams.getFontSizeAsInt((Integer)tableCell.getLabelFontSize());
        Color fontColor = tableCell.getLabelFontColor();
        return FontFactory.getHeaderFontDefinition(family, fontStyle, fontSize, fontColor).createFont();
    }

    public static Font createHeaderFont(String family, int fontStyle, int fontSize, Color color) {
        return FontFactory.getHeaderFontDefinition(family, fontStyle, fontSize, color).createFont();
    }

    public Font createFont(String fontDefinition) {
        return new FontParams(fontDefinition).createFont();
    }

    public Font createFont(FontParams fontDefinition) {
        return fontDefinition.createFont();
    }

    public Font createFont(FontParams fontDefinition, String componentType) {
        return fontDefinition.createFont(componentType);
    }

    public Font createFont(String fontDefinition, String componentType) {
        return new FontParams(fontDefinition).createFont(componentType);
    }

    public static void main(String[] args) {
        JAXFrontProperties.printSwingDefaults();
        FontFactory.getInstance().createFont("Arial,Bold,12");
        FontFactory.getInstance().createFont("Arial,12");
        FontFactory.getInstance().createFont("Arial,Bold");
        FontFactory.getInstance().createFont("Arial,Bold,12");
        FontFactory.getInstance().createFont("Arial,Bold,13");
    }

    public static FontFactory getInstance() {
        if (_instance == null) {
            _instance = new FontFactory();
        }
        return _instance;
    }

    public static String createFontDefiniton(String fontName, int fontStyle, int fontSize) {
        StringBuffer defintion = new StringBuffer();
        defintion.append(fontName);
        defintion.append(",");
        if (fontStyle >= 0) {
            defintion.append(FontParams.getFontStyleAsString((int)fontStyle));
            defintion.append(",");
        }
        if (fontSize >= 0) {
            defintion.append(fontSize);
            defintion.append(",");
        }
        return defintion.toString();
    }

    public static FontParams getLabelFontDefinition() {
        if (JAXFrontProperties.getInstance().getLabelFontDefinition() == null) {
            return FontParams.getDefaultParams((String)"Label.font");
        }
        return new FontParams(JAXFrontProperties.getInstance().getLabelFontDefinition());
    }

    public static FontParams getHeaderFontModernDefinition() {
        if (JAXFrontProperties.getInstance().getHeaderFontModernDefinition() == null) {
            return FontFactory.getHeaderFontDefinition();
        }
        return new FontParams(JAXFrontProperties.getInstance().getHeaderFontModernDefinition());
    }

    public static FontParams getHeaderFontClassicDefinition() {
        if (JAXFrontProperties.getInstance().getHeaderFontClassicDefinition() == null) {
            return FontFactory.getHeaderFontDefinition();
        }
        return new FontParams(JAXFrontProperties.getInstance().getHeaderFontClassicDefinition());
    }

    public static FontParams getTabFontDefinition() {
        if (JAXFrontProperties.getInstance().getTabFontDefinition() == null) {
            return FontParams.getDefaultParams((String)"TabbedPane.font");
        }
        return new FontParams(JAXFrontProperties.getInstance().getTabFontDefinition());
    }

    public static FontParams getHeaderFontDefinition() {
        if (JAXFrontProperties.getInstance().getHeaderFontDefinition() == null) {
            return FontParams.getDefaultParams((String)"Label.font");
        }
        return new FontParams(JAXFrontProperties.getInstance().getHeaderFontDefinition());
    }

    public static FontParams getTitleBorderFontDefinition() {
        if (JAXFrontProperties.getInstance().getTitleBorderFontDefinition() == null) {
            return FontParams.getDefaultParams((String)"TitledBorder.font");
        }
        return new FontParams(JAXFrontProperties.getInstance().getTitleBorderFontDefinition());
    }

    public static FontParams getHintFontDefinition() {
        if (JAXFrontProperties.getInstance().getHintFontDefinition() == null) {
            return FontParams.getDefaultParams((String)"TextField.font");
        }
        return new FontParams(JAXFrontProperties.getInstance().getHintFontDefinition());
    }

    public static FontParams getMessageFontDefinition() {
        if (JAXFrontProperties.getInstance().getMessageFontDefinition() == null) {
            return FontParams.getDefaultParams((String)"Label.font");
        }
        return new FontParams(JAXFrontProperties.getInstance().getMessageFontDefinition());
    }

    public static FontParams getCaptionFontDefinition() {
        if (JAXFrontProperties.getInstance().getCaptionFontDefinition() == null) {
            return FontParams.getDefaultParams((String)"Label.font");
        }
        return new FontParams(JAXFrontProperties.getInstance().getCaptionFontDefinition());
    }

    public static FontParams getTreeEntryFontDefinition() {
        if (JAXFrontProperties.getInstance().getTreeEntryFontDefinition() == null) {
            return FontParams.getDefaultParams((String)"Tree.font");
        }
        return new FontParams(JAXFrontProperties.getInstance().getTreeEntryFontDefinition());
    }

    public static FontParams getButtonFontDefinition() {
        String param = JAXFrontProperties.getInstance().getButtonFontDefinition();
        if (param == null) {
            return FontParams.getDefaultParams((String)"Button.font");
        }
        return new FontParams(param);
    }

    public static FontParams getRadioButtonFontDefinition() {
        String param = JAXFrontProperties.getInstance().getRadioButtonFontDefinition();
        if (param == null) {
            return FontParams.getDefaultParams((String)"RadioButton.font");
        }
        return new FontParams(param);
    }

    public static FontParams getComboboxFontDefinition() {
        String param = JAXFrontProperties.getInstance().getComboboxFontDefinition();
        if (param == null) {
            return FontParams.getDefaultParams((String)"ComboBox.font");
        }
        return new FontParams(param);
    }

    public static FontParams getCheckboxFontDefinition() {
        String param = JAXFrontProperties.getInstance().getCheckboxFontDefinition();
        if (param == null) {
            return FontParams.getDefaultParams((String)"CheckBox.font");
        }
        return new FontParams(param);
    }

    public static FontParams getListFontDefinition() {
        String param = JAXFrontProperties.getInstance().getListFontDefinition();
        if (param == null) {
            return FontParams.getDefaultParams((String)"List.font");
        }
        return new FontParams(param);
    }

    public static FontParams getTreeEntryFolderFontDefinition() {
        if (JAXFrontProperties.getInstance().getTreeEntryFolderFontDefinition() == null) {
            return FontFactory.getTreeEntryFontDefinition();
        }
        return new FontParams(JAXFrontProperties.getInstance().getTreeEntryFolderFontDefinition());
    }

    public static FontParams getTableFontDefinition() {
        if (JAXFrontProperties.getInstance().getTableFontDefinition() == null) {
            return FontParams.getDefaultParams((String)"Table.font");
        }
        return new FontParams(JAXFrontProperties.getInstance().getTableFontDefinition());
    }

    public static FontParams getPopupFontDefinition() {
        if (JAXFrontProperties.getInstance().getPopupFontDefinition() == null) {
            return FontParams.getDefaultParams((String)"PopupMenu.font");
        }
        return new FontParams(JAXFrontProperties.getInstance().getPopupFontDefinition());
    }

    public static FontParams getOptionPaneFontDefinition() {
        if (JAXFrontProperties.getInstance().getOptionPaneFontDefinition() == null) {
            return FontParams.getDefaultParams((String)"OptionPane.font");
        }
        return new FontParams(JAXFrontProperties.getInstance().getOptionPaneFontDefinition());
    }

    public static FontParams getMenuItemFontDefinition() {
        if (JAXFrontProperties.getInstance().getMenuItemFontDefinition() == null) {
            return FontParams.getDefaultParams((String)"MenuItem.font");
        }
        return new FontParams(JAXFrontProperties.getInstance().getMenuItemFontDefinition());
    }

    public static FontParams getMenuFontDefinition() {
        if (JAXFrontProperties.getInstance().getMenuFontDefinition() == null) {
            return FontParams.getDefaultParams((String)"Menu.font");
        }
        return new FontParams(JAXFrontProperties.getInstance().getMenuFontDefinition());
    }

    public static FontParams getLabelFontDefinition(String family, int style, int size, Color color) {
        FontParams params = FontFactory.getLabelFontDefinition();
        params.updateFontDefinition(family, style, size, color);
        return params;
    }

    public static FontParams getHeaderFontDefinition(String family, int style, int size, Color color) {
        FontParams params = FontFactory.getHeaderFontDefinition();
        params.updateFontDefinition(family, style, size, color);
        return params;
    }

    public static FontParams getTextFieldFontDefinition() {
        if (JAXFrontProperties.getInstance().getTextFieldFontDefinition() == null) {
            return FontParams.getDefaultParams((String)"TextField.font");
        }
        return new FontParams(JAXFrontProperties.getInstance().getTextFieldFontDefinition());
    }

    public static FontParams getTextFieldFontDefinition(String family, int style, int size) {
        FontParams params = FontFactory.getTextFieldFontDefinition();
        params.updateFontDefinition(family, style, size);
        return params;
    }
}

