/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.Action;
import com.jaxfront.core.rule.DefaultActionImpl;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.ListVisualizer;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.ui.tableModel.JAXDataTable;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.xui.FormLayoutInfo;
import com.jaxfront.core.xui.TableCell;
import com.jaxfront.swing.ui.beans.MultiLineLabel;
import com.jaxfront.swing.ui.focus.SettableLayoutFocusTraversalPolicy;
import com.jaxfront.swing.ui.focus.VisualizerFocusComparator;
import com.jaxfront.swing.ui.tools.FontFactory;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.tools.HRefMouseAdapter;
import com.jaxfront.swing.ui.tools.HeaderPanel;
import com.jaxfront.swing.ui.tools.HyperTextLabel;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.visualizers.AbstractView;
import com.jaxfront.swing.ui.visualizers.GeneralActionListener;
import com.jaxfront.swing.ui.visualizers.SimpleTypeListView;
import com.jaxfront.swing.ui.wrapper.JAXJButton;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class FormLayoutBuilder
implements ListVisualizer {
    private boolean _uiReleased;

    public static JPanel applyTableLayout(Container container, Type model, Type context, FormLayoutInfo layout, JPanel aComponentHolderPanel) {
        if (layout != null) {
            List cols = layout.getColumns();
            double[] col = new double[cols.size()];
            for (int i = 0; i < cols.size(); ++i) {
                col[i] = (Double)cols.get(i);
            }
            List rows = layout.getRows();
            double[] row = new double[rows.size()];
            for (int i = 0; i < rows.size(); ++i) {
                row[i] = (Double)rows.get(i);
            }
            String columnSpec = null;
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < col.length; ++i) {
                double colSize = col[i];
                if (colSize < 1.0) {
                    if (colSize == -1.0) {
                        buffer.append("fill:default:grow");
                    } else if (colSize == -2.0) {
                        buffer.append("pref");
                    } else {
                        buffer.append("0:g(");
                        buffer.append(colSize);
                        buffer.append(")");
                    }
                } else {
                    buffer.append((int)colSize + "px");
                }
                if (i == col.length - 1) continue;
                buffer.append(",");
            }
            if (buffer.length() > 0) {
                columnSpec = buffer.toString();
            }
            String rowSpec = null;
            buffer = new StringBuffer();
            for (int j = 0; j < row.length; ++j) {
                double rowSize = row[j];
                if (rowSize < 1.0) {
                    if (rowSize == -1.0) {
                        buffer.append("fill:default:grow");
                    } else if (rowSize == -2.0) {
                        buffer.append("pref");
                    } else {
                        buffer.append("p:g(");
                        buffer.append(rowSize);
                        buffer.append(")");
                    }
                } else {
                    buffer.append((int)rowSize + "px");
                }
                if (j == row.length - 1) continue;
                buffer.append(",");
            }
            if (buffer.length() > 0) {
                rowSpec = buffer.toString();
            }
            FormLayout tableLayout = new FormLayout(columnSpec, rowSpec);
            JPanel tablePanel = new JPanel(tableLayout);
            tablePanel.setName("tablePanel");
            List cellList = layout.getCells();
            for (int i = 0; i < cellList.size(); ++i) {
                FormLayoutBuilder.addTableCell(container, model, context, (TableCell)cellList.get(i), tablePanel, null);
            }
            return tablePanel;
        }
        return null;
    }

    public static void addXPathLabelToVisualizer(JComponent labelComp, Type cellRefType, Type context) {
        Visualizer visualizer;
        if (cellRefType != null && (visualizer = TypeVisualizerFactory.getInstance().getVisualizer(cellRefType, context)) != null) {
            labelComp.setVisible(visualizer.getModel().getXUIDefinition().getStyle().isVisibleAtRuntime());
            ((AbstractView)visualizer.getImplementation()).setTableLableComponent(labelComp);
        }
    }

    public static JComponent addTableCell(Container container, Type model, Type context, TableCell cell, JPanel tablePanel, JComponent editingType) {
        Font labelFont;
        String href;
        AbstractView fvv;
        String toolTip = cell.getToolTipText();
        String label = cell.getLabel();
        JComponent component = null;
        boolean isFocusCell = false;
        Type cellRefType = cell.getXPathReferencedType();
        if (context == null) {
            context = model;
        }
        if (cell.getLabelType().equals("xpath")) {
            if (cellRefType != null && cellRefType.isRenderable()) {
                Visualizer visualizer = TypeVisualizerFactory.getInstance().getVisualizer(cellRefType, context);
                component = (JComponent)visualizer.getImplementation();
                component.setToolTipText(toolTip);
                if (component instanceof AbstractSimpleTypeView || component instanceof SimpleTypeListView) {
                    component = ((AbstractView)component).getEditorComponent();
                }
                if (cellRefType.isSimple() && ((SimpleType)cellRefType).isBoolean()) {
                    String dimension = cell.getDimension();
                    if (dimension != null && dimension.length() > 0) {
                        StringTokenizer tokenizer = new StringTokenizer(dimension, ",");
                        int counter = 0;
                        String[] values = new String[tokenizer.countTokens()];
                        while (tokenizer.hasMoreTokens()) {
                            values[counter] = tokenizer.nextToken().trim();
                            ++counter;
                        }
                        if (values.length > 2 && values[2] != null && values[2].equalsIgnoreCase("F")) {
                            values[2] = "L";
                            dimension = "";
                            for (int a = 0; a < values.length; ++a) {
                                dimension = dimension + values[a];
                                if (a == values.length - 1) continue;
                                dimension = dimension + ",";
                            }
                        }
                    }
                    if (dimension != null && dimension.length() > 0) {
                        cell.setDimension(dimension);
                    }
                }
            } else if (LogRegistry.getInstance().logWarnings()) {
                LogRegistry.getInstance().warn(FormLayoutBuilder.class, "no target type found for cell:" + cell.toString());
            }
            isFocusCell = true;
        } else if (cell.getLabelType().equals("label") || cell.getLabelType().equals("text") || cell.getLabelType().equals("link")) {
            if (cellRefType == null || cellRefType.isRenderable()) {
                if (cell.hasFormula()) {
                    cell.getDimension();
                    if (cell.getType() != null) {
                        fvv = (AbstractView)TypeVisualizerFactory.getInstance().getVisualizer(cell.getType(), context);
                        fvv.getEditorComponent().setToolTipText(toolTip);
                        fvv.getEditorComponent().setFont(FontFactory.createLabelFont(cell));
                        fvv.getEditorComponent().setForeground(cell.getLabelFontColor());
                        component = fvv;
                    }
                } else {
                    href = cell.getLabelHRef();
                    JComponent aCellLabel = null;
                    if (href == null && !cell.getLabelType().equals("link")) {
                        aCellLabel = new MultiLineLabel(label, false);
                    } else {
                        aCellLabel = new HyperTextLabel(label, true);
                        aCellLabel.addMouseListener(new HRefMouseAdapter(aCellLabel, href));
                    }
                    aCellLabel.setToolTipText(toolTip);
                    aCellLabel.setFont(FontFactory.createLabelFont(cell));
                    aCellLabel.setForeground(cell.getLabelFontColor());
                    component = aCellLabel;
                    FormLayoutBuilder.addXPathLabelToVisualizer(component, cellRefType, context);
                }
            }
            if (component != null) {
                JPanel newComponent = new JPanel(new BorderLayout());
                newComponent.setBorder(new EmptyBorder(0, 5, 0, 5));
                newComponent.add((Component)component, "Center");
                component = newComponent;
            }
        } else if (cell.getLabelType().equals("label_multiline")) {
            if (cellRefType == null || cellRefType.isRenderable()) {
                href = cell.getLabelHRef();
                component = new MultiLineLabel(label, false);
                component.setFont(FontFactory.createLabelFont(cell));
                component.setForeground(cell.getLabelFontColor());
                component.setToolTipText(toolTip);
                if (href != null) {
                    component.addMouseListener(new HRefMouseAdapter(component, href));
                }
                FormLayoutBuilder.addXPathLabelToVisualizer(component, cellRefType, context);
            }
        } else if (cell.getLabelType().equals("header")) {
            labelFont = FontFactory.createHeaderFont(cell);
            String imageURL = null;
            String headerLabel = cell.getLabel();
            Color startColor = null;
            Type cellType = cell.getType();
            if (cell.getFormula() != null && cell.getFormula().getExpression() != null && cell.getFormula().getExpression().indexOf("image(") != -1) {
                imageURL = cell.getFormula().getExpression().substring(7, cell.getFormula().getExpression().length() - 2);
                startColor = cell.getLabelFontColor();
                headerLabel = null;
                cellType = null;
            }
            Color endColor = null;
            if (cell.getCSSStyle() != null && cell.getCSSStyle().equals("no-gradient")) {
                endColor = startColor;
            }
            HeaderPanel header = GUITools.createHeader(cellType, headerLabel, labelFont.getSize() + 5, imageURL, null, startColor, endColor);
            header.setPopupMenuEnabled(false);
            header.setFont(labelFont);
            header.setTextColor(cell.getLabelFontColor());
            header.setToolTipText(toolTip);
            component = header;
        } else if (cell.getLabelType().startsWith("separator")) {
            if (cell.getLabelType().equals("separator_vertical")) {
                labelFont = FontFactory.createLabelFont(cell);
                HeaderPanel sep = GUITools.createSeparatorVertical(null, cell.getLabel());
                sep.setPopupMenuEnabled(false);
                sep.setFont(labelFont);
                sep.setTextColor(cell.getLabelFontColor());
                component = sep;
            } else if (cell.getLabelType().equals("separator_modern")) {
                Font modernFont = FontFactory.getHeaderFontModernDefinition().updateFont(cell).createFont();
                HeaderPanel sep = GUITools.createSeparatorModern(cell.getType(), cell.getLabel(), modernFont.getSize() + 5);
                sep.setPopupMenuEnabled(false);
                sep.setFont(modernFont);
                sep.setTextColor(cell.getLabelFontColor());
                component = sep;
            } else {
                Font classicFont = FontFactory.getHeaderFontClassicDefinition().updateFont(cell).createFont();
                if (cell.getLabelType().equals("separator_label_multiline")) {
                    component = new MultiLineLabel(cell.getLabel(), true);
                    component.setFont(classicFont);
                    component.setForeground(cell.getLabelFontColor());
                } else {
                    HeaderPanel sep = GUITools.createSeparatorClassic(cell.getType(), cell.getLabel(), classicFont.getSize() + 5);
                    sep.setPopupMenuEnabled(false);
                    sep.setFont(classicFont);
                    sep.setTextColor(cell.getLabelFontColor());
                    component = sep;
                }
            }
            component.setToolTipText(toolTip);
        } else if (cell.getLabelType().equals("image")) {
            component = new JLabel(JAXFrontProperties.getImageIcon((URL)model.getDOM().getFingerPrint().getXUIURL(), (String)cell.getURL()));
            ((JLabel)component).setText(cell.getLabel());
            if (component != null) {
                component.setToolTipText(toolTip);
            }
        } else if (cell.isButton() && !cell.getLabelType().equals("selector") && !cell.getLabelType().equals("action")) {
            Font buttonFont = FontFactory.getButtonFontDefinition().updateFont(cell).createFont();
            component = FormLayoutBuilder.createButton(model, cell.getLabel(), cell.getLabelType(), cell.getText(), cell.getRuleId());
            component.setFont(buttonFont);
            if (component != null) {
                component.setToolTipText(toolTip);
            }
            isFocusCell = true;
        } else if (cell.hasFormula() && cell.getType() != null) {
            fvv = (AbstractView)TypeVisualizerFactory.getInstance().getVisualizer(cell.getType(), context);
            fvv.getEditorComponent().setToolTipText(toolTip);
            fvv.getEditorComponent().setFont(FontFactory.createLabelFont(cell));
            fvv.getEditorComponent().setForeground(cell.getLabelFontColor());
            component = fvv;
        }
        if (component != null) {
            try {
                if (isFocusCell) {
                    FormLayoutBuilder.applyFocus(container, component, cell);
                }
                tablePanel.add((Component)component, cell.getDimension());
            }
            catch (IndexOutOfBoundsException e) {
                LogRegistry.getInstance().warn(FormLayoutBuilder.class, "can't add cell" + cell.getDimension().toString() + " to tablelayout " + model.getXPathLocation() + " Message:" + e.getMessage());
            }
        }
        return component;
    }

    public static void applyFocus(Container container, JComponent focusComponent, TableCell focusCell) {
        Integer focusIndex = focusCell.getFocusIndex();
        if (focusIndex != null) {
            if (container.getFocusTraversalPolicy() == null) {
                container.setFocusTraversalPolicy(new SettableLayoutFocusTraversalPolicy((Comparator)new VisualizerFocusComparator()));
                container.setFocusCycleRoot(true);
            }
            if (focusIndex >= 0 && container.getFocusTraversalPolicy() != null) {
                Vector focusableComponents = new Vector();
                GUITools.searchFocusableComponents(focusComponent, focusableComponents);
                for (int i = 0; i < focusableComponents.size(); ++i) {
                    JComponent focComp = (JComponent)focusableComponents.get(i);
                    focComp.putClientProperty("focusIndex", new Float((double)focusIndex.floatValue() + (double)i * 1.0E-4));
                }
            }
        }
    }

    public static JButton createButton(Type model, String buttonName, String actionClassString, String commandName) {
        return FormLayoutBuilder.createButton(model, buttonName, actionClassString, commandName, null);
    }

    public static JButton createButton(Type model, String buttonName, String actionClassString, String commandName, String ruleId) {
        JAXJButton userButton;
        block2: {
            userButton = null;
            try {
                Class<?> actionClass = Class.forName(actionClassString);
                userButton = new JAXJButton(buttonName);
                userButton.addActionListener(FormLayoutBuilder.getAction(model, actionClass, commandName));
            }
            catch (Throwable t) {
                LogRegistry.getInstance().warn(FormLayoutBuilder.class, " action class: " + t.getMessage() + " for button: " + buttonName + " could not be initialised using default");
                if (userButton != null) break block2;
                userButton = new JAXJButton(buttonName);
                DefaultActionImpl defAct = (DefaultActionImpl)FormLayoutBuilder.getAction(model, DefaultActionImpl.class, commandName);
                defAct.setRuleId(ruleId);
                userButton.addActionListener((ActionListener)defAct);
            }
        }
        return userButton;
    }

    public static ActionListener getAction(Type model, Class actionClass) {
        return FormLayoutBuilder.getAction(model, actionClass, null);
    }

    public static ActionListener getAction(Type model, Class actionClass, String commandName) {
        ActionListener listener;
        block9: {
            listener = null;
            if (ActionListener.class.isAssignableFrom(actionClass) || Action.class.isAssignableFrom(actionClass)) {
                try {
                    if (ActionListener.class.isAssignableFrom(actionClass)) {
                        listener = (ActionListener)actionClass.newInstance();
                        if (listener instanceof javax.swing.Action) {
                            javax.swing.Action myAction = (javax.swing.Action)listener;
                            if (commandName != null) {
                                myAction.putValue("ACTION_NAME", commandName);
                            }
                            myAction.putValue("ACTION_DOM", model.getDOM());
                            myAction.putValue("ACTION_SOURCE", model);
                        }
                        break block9;
                    }
                    listener = new GeneralActionListener(model, actionClass, commandName);
                }
                catch (InstantiationException ie) {
                    LogRegistry.getInstance().warn(FormLayoutBuilder.class, "Error while instanciating: " + actionClass);
                }
                catch (IllegalAccessException ia) {
                    LogRegistry.getInstance().warn(FormLayoutBuilder.class, "Error while accessing: " + actionClass);
                }
            } else if (LogRegistry.getInstance().logWarnings()) {
                LogRegistry.getInstance().warn(FormLayoutBuilder.class, "ActionClass: " + actionClass + " is not derived from javax.swing.Action or com.jaxfront.core.rule.Action");
            }
        }
        return listener;
    }

    public void addTab(Type type) {
    }

    public JAXDataTable getDataTable() {
        return null;
    }

    public JDialog getEditDialog(Type selectedType, Type context) {
        return null;
    }

    public Type getSelectedType() {
        return null;
    }

    public void removeTab(Type type) {
    }

    public void resetView() {
    }

    public void selectType(Type type) {
    }

    public void showModel(Type type) {
    }

    public void showUpDownButtons(boolean showUpDownButtons) {
    }

    public Type getContext() {
        return null;
    }

    public void setContext(Type type) {
    }

    public Visualizer getImplementation() {
        return null;
    }

    public String getLabelText() {
        return null;
    }

    public Type getModel() {
        return null;
    }

    public void jumpTo() {
    }

    public void markError() {
    }

    public void populateModel() {
    }

    public void populateView() {
    }

    public void postInitialization() {
    }

    public void release() {
        this._uiReleased = true;
    }

    public void removeLabel() {
    }

    public void resetError() {
    }

    public void setApplicationRequired(boolean required) {
    }

    public void setEditable(boolean enabled) {
    }

    public void setEnabled(boolean enabled) {
    }

    public void setLabelColor(Color color) {
    }

    public void setLabelText(String text) {
    }

    public void setModel(Type type) {
    }

    public void setRequired(boolean required) {
    }

    public void setVisible(boolean visible) {
    }

    public void showLabel(boolean show) {
    }

    public ListType getListModel() {
        return (ListType)this.getModel();
    }

    public boolean isViewReleased() {
        return this._uiReleased;
    }

    public void selectType(Type type, boolean isUserAction) {
    }

    public int getRendererType() {
        return 1;
    }

    public void refresh() {
    }
}

