/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.io.BrowserControl;
import com.jaxfront.swing.ui.tools.BorderActionSet;
import com.jaxfront.swing.ui.tools.CollapsiblePanel;
import com.jaxfront.swing.ui.tools.FontFactory;
import com.jaxfront.swing.ui.tools.FunctionalTitleBorder;
import com.jaxfront.swing.ui.tools.GenericAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class FunctionalPanel
extends CollapsiblePanel {
    private String _httpURL;
    private JPopupMenu _popUpMenu;
    private Visualizer _visualizer;
    private Action _pasteContentAction;
    private Action _copyContentAction;
    BorderActionSet _expandCollapseActionSet;
    BorderActionSet _setUserSerializableActionSet;
    Action _cutPasteAction;
    FunctionalTitleBorder _functionalBorder;

    public FunctionalPanel(Visualizer visualizer, JComponent content) {
        super(content);
        this._visualizer = visualizer;
        this.setBorder(this.getFunctionalBorder());
    }

    public FunctionalPanel(Visualizer content) {
        super((JPanel)content);
        this._visualizer = content;
        this.setBorder(this.getFunctionalBorder());
    }

    public FunctionalPanel(JComponent content) {
        super(content);
        this.setBorder(this.getFunctionalBorder());
    }

    public FunctionalPanel(Visualizer visualizer, JComponent content, String titel) {
        this(visualizer, content);
        this.setBorderTitle(titel);
    }

    public FunctionalPanel(Visualizer content, String titel) {
        this(content);
        this.setBorderTitle(titel);
    }

    public BorderActionSet getExpandCollapseBorderActionSet() {
        if (this._expandCollapseActionSet == null) {
            String copyPastePopupText = GUIComponentNLS.getInstance().getNLSText(this.getLanguage(), "tooltip_expand_collapse", "expand / collapse Item");
            this._expandCollapseActionSet = new BorderActionSet("collapse", new GenericAction("collapse", this, "collapse"), new GenericAction("expand", this, "expand"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/collapseWindow.gif").getImage(), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/expandWindow.gif").getImage(), null, null, copyPastePopupText, 0);
        }
        return this._expandCollapseActionSet;
    }

    private Action getCutPasteBorderAction() {
        if (this._cutPasteAction == null) {
            this._cutPasteAction = new GenericAction("cutPaste", this, "cutPaste");
        }
        return this._cutPasteAction;
    }

    public void collapseInitially() {
        this.getFunctionalBorder().toggleActionSet(this.getExpandCollapseBorderActionSet(), true);
        super.collapse();
    }

    public void expandInitially() {
        this.getFunctionalBorder().toggleActionSet(this.getExpandCollapseBorderActionSet(), false);
        super.expand();
    }

    public void setExpandState(boolean expanded) {
        if (expanded) {
            this.expandInitially();
        } else {
            this.collapseInitially();
        }
    }

    public void cutPaste() {
        Point mousePoint = FunctionalTitleBorder.getLastMouseLocation();
        this.getPasteContentAction().setEnabled(this._visualizer.getModel().getDOM().getClipBoard().canPaste(this._visualizer.getModel()));
        this.getPopUpMenu().show(this, mousePoint.x, mousePoint.y);
    }

    public void setOptional(boolean optional) {
        if (optional) {
            this.getFunctionalBorder().addBorderAction(this.getExpandCollapseBorderActionSet(), 1);
        } else {
            this.getFunctionalBorder().removeBorderAction(this.getExpandCollapseBorderActionSet());
        }
    }

    public JComponent getContentPanel() {
        return super.getContentPanel();
    }

    public String getToolTipText(MouseEvent event) {
        if (this.getFunctionalBorder() != null) {
            return this.getFunctionalBorder().getToolTipText(event);
        }
        return super.getToolTipText(event);
    }

    public void setContentPanel(JPanel newContent) {
        super.setContentPanel(newContent);
    }

    public void openURL() {
        BrowserControl.displayURL((String)this._httpURL);
    }

    public void setLinkedBorderTitle(String httpURL) {
        this._httpURL = httpURL;
        this.getFunctionalBorder().setTitleAction(new GenericAction("openURL", this, "openURL"), 1);
    }

    public void setBorderTitleToolTip(String toolTip) {
        this.getFunctionalBorder().setToolTipText(toolTip);
    }

    public void setBorderTitle(String title) {
        this.getFunctionalBorder().setTitle(title);
    }

    public FunctionalTitleBorder getFunctionalBorder() {
        if (this._functionalBorder == null) {
            this._functionalBorder = new FunctionalTitleBorder("", this);
            this._functionalBorder.setTitleAction(this.getCutPasteBorderAction(), 3);
            this._functionalBorder.setTitleFont(FontFactory.getTitleBorderFontDefinition().createFont());
        }
        return this._functionalBorder;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("TestBorder");
        JPanel aPanel = new JPanel();
        aPanel.add(new JButton("buttonjwingscheiss"));
        FunctionalPanel panel = new FunctionalPanel(aPanel);
        panel.setOptional(true);
        panel.setBorderTitleToolTip("true");
        panel.setBorderTitle("name");
        panel.setLinkedBorderTitle("name");
        panel.setBorderTitleCaptionIndent(122.0f);
        panel.getFunctionalBorder().addBorderAction(FunctionalPanel.getExpandCollapseBorderSet(panel));
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)panel, "Center");
        f.setSize(300, 300);
        f.setVisible(true);
    }

    private JPopupMenu getPopUpMenu() {
        if (this._popUpMenu == null) {
            this._popUpMenu = new JPopupMenu("------");
            this._popUpMenu.add(new JMenuItem(this.getCopyContentAction()));
            this._popUpMenu.add(new JMenuItem(this.getPasteContentAction()));
        }
        return this._popUpMenu;
    }

    private String getLanguage() {
        if (this._visualizer != null) {
            return this._visualizer.getModel().getDOM().getLanguage();
        }
        return null;
    }

    public void setBorderTitleCaptionIndent(float indent) {
        this.getFunctionalBorder().setCaptionIndent(indent);
    }

    Action getCopyContentAction() {
        if (this._copyContentAction == null) {
            this._copyContentAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText(this.getLanguage(), "button_copy_content", "copy content"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/copy_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    if (FunctionalPanel.this._visualizer != null) {
                        FunctionalPanel.this._visualizer.getModel().getDOM().getClipBoard().copy(FunctionalPanel.this._visualizer.getModel());
                    }
                }
            };
        }
        return this._copyContentAction;
    }

    Action getPasteContentAction() {
        if (this._pasteContentAction == null) {
            this._pasteContentAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText(this.getLanguage(), "button_paste_content", "paste content"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/pasteContent_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    if (FunctionalPanel.this._visualizer != null) {
                        FunctionalPanel.this._visualizer.getModel().getDOM().getClipBoard().paste(FunctionalPanel.this._visualizer.getModel(), null, false, false);
                        FunctionalPanel.this._visualizer.getModel().getDOM().validateKeyRefIntegrity(true);
                        if (FunctionalPanel.this.isCollapsed()) {
                            FunctionalPanel.this._functionalBorder.doAction(this, "changeUserSerialization", true);
                        }
                    }
                }
            };
        }
        return this._pasteContentAction;
    }
}

