/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.swing.ui.tools.BorderActionSet;
import com.jaxfront.swing.ui.tools.CollapsiblePanel;
import com.jaxfront.swing.ui.tools.GenericAction;
import com.jaxfront.swing.ui.tools.TitledBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;

public class FunctionalTitleBorder
extends TitledBorder
implements MouseListener,
MouseMotionListener {
    private static Point _lastMouseLoc = new Point();
    private boolean _isEnabled = true;
    private boolean _visible = true;
    private boolean _listenerInitialized = false;
    private Component _rootComponent;
    private Vector _registeredBorderActions;
    private static final int _imageYOffset = 1;
    public static final int _imageXOffset = 5;
    int _titelH = 0;
    int _titelW = 0;
    private String _toolTipText;
    private Action _titleActionLeftMouse;
    private Action _titleActionRightMouse;
    private Action _titleActionCenterMouse;

    public FunctionalTitleBorder(String borderTitle) {
        super(borderTitle);
    }

    public FunctionalTitleBorder(String borderTitle, Component parent) {
        super(borderTitle);
        this.setRootComponent(parent);
    }

    public FunctionalTitleBorder(Border aBorder) {
        super(aBorder);
    }

    public FunctionalTitleBorder(Border aBorder, String borderTitle) {
        super(aBorder, borderTitle);
    }

    public FunctionalTitleBorder(Border newBorder, String borderTitle, int aTitleJustification, int aTitlePosition) {
        super(newBorder, borderTitle, aTitleJustification, aTitlePosition);
    }

    public FunctionalTitleBorder(Border newBorder, String borderTitle, int aTitleJustification, int aTitlePosition, Font aTitleFont) {
        super(newBorder, borderTitle, aTitleJustification, aTitlePosition, aTitleFont);
    }

    public FunctionalTitleBorder(Border newBorder, String borderTitle, int aTitleJustification, int aTitlePosition, Font aTitleFont, Color aTitleColor) {
        super(newBorder, borderTitle, aTitleJustification, aTitlePosition, aTitleFont, aTitleColor);
    }

    private void initRootListeners(Component rootComponent) {
        if (rootComponent != null && !this._listenerInitialized) {
            this.removeRootListeners();
            rootComponent.addMouseListener(this);
            rootComponent.addMouseMotionListener(this);
            if (rootComponent instanceof JComponent) {
                ToolTipManager.sharedInstance().registerComponent((JComponent)rootComponent);
            }
            this._listenerInitialized = true;
        }
    }

    private void removeRootListeners() {
        if (this.getRootComponent() != null) {
            this.getRootComponent().removeMouseListener(this);
            this.getRootComponent().removeMouseMotionListener(this);
            if (this._rootComponent instanceof JComponent) {
                ToolTipManager.sharedInstance().registerComponent((JComponent)this.getRootComponent());
            }
        }
    }

    public void resetAllActions() {
        for (int i = 0; i < this.getRegisteredBorderActions().size(); ++i) {
            BorderActionSet aSet = (BorderActionSet)this.getRegisteredBorderActions().get(i);
            aSet.setWillToggled(false);
        }
        if (this.getRegisteredBorderActions().size() > 0) {
            this.getRootComponent().repaint();
        }
    }

    public BorderActionSet getActionInRange(Point p) {
        for (int i = 0; i < this.getRegisteredBorderActions().size(); ++i) {
            BorderActionSet aSet = (BorderActionSet)this.getRegisteredBorderActions().get(i);
            if (!aSet.isVisible() || !aSet.isMouseInRange(p, this.getRootComponent())) continue;
            return aSet;
        }
        return null;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this._visible) {
            Rectangle actionAreaRectLeft = FunctionalTitleBorder.getActionAreaRectangle(this.getRegisteredBorderActions(), 0);
            Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
            this.TEXT_INSET_H = actionAreaRectLeft.width + 5;
            super.paintBorder(c, g, x, y, width, height);
            for (int i = this.getRegisteredBorderActions().size() - 1; i >= 0; --i) {
                BorderActionSet aSet = (BorderActionSet)this.getRegisteredBorderActions().get(i);
                if (!aSet.isVisible()) continue;
                Rectangle range = aSet.getPaintRectangle();
                int newX = 0;
                newX = aSet.getAlignment() == 0 ? range.x : grooveRect.width - range.x;
                int drawedX = newX;
                int drawedY = range.y;
                if (aSet.willToggled() && aSet.isEnabled() && aSet.isActionEnabled()) {
                    drawedX = newX + 2;
                    drawedY = range.y + 1;
                }
                g.drawImage(aSet.getActionImageToBeDisplayed(), drawedX, drawedY, null, null);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            super.setTitleColor(Color.black);
        } else {
            super.setTitleColor(Color.gray);
        }
        this._isEnabled = enabled;
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.getRootComponent() && this.isEnabled()) {
            if (e.getButton() == 1) {
                BorderActionSet aSet = this.getActionInRange(e.getPoint());
                if (aSet != null) {
                    aSet.setWillToggled(true);
                    this.getRootComponent().repaint();
                } else if (this.isInTitelBox(e.getPoint()) && this._titleActionLeftMouse != null) {
                    this._titleActionLeftMouse.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "mousePressed"));
                }
            } else if (e.getButton() == 2) {
                if (this.isInTitelBox(e.getPoint()) && this._titleActionCenterMouse != null) {
                    this._titleActionCenterMouse.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "mousePressed"));
                }
            } else if (e.getButton() == 3 && this.isInTitelBox(e.getPoint()) && this._titleActionRightMouse != null) {
                this._titleActionRightMouse.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "mousePressed"));
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.getRootComponent() && this.isEnabled() && e.getButton() == 1) {
            BorderActionSet aSet = this.getActionInRange(e.getPoint());
            if (aSet != null && aSet.isEnabled()) {
                aSet.setWillToggled(false);
                aSet.fireActualAction(new ActionEvent(e.getSource(), e.getID(), "mouseClicked"));
                this.getRootComponent().repaint();
            } else {
                this.resetAllActions();
            }
        }
    }

    public void doAction(Object source, String borderActionSetName) {
        if (this.isEnabled()) {
            BorderActionSet aSet = this.getBorderAction(borderActionSetName);
            if (aSet != null && aSet.isEnabled()) {
                aSet.setWillToggled(false);
                aSet.fireActualAction(new ActionEvent(source, 500, "mouseClicked"));
                this.getRootComponent().repaint();
            } else {
                this.resetAllActions();
            }
        }
    }

    public void doAction(Object source, String borderActionSetName, boolean useInverse) {
        if (this.isEnabled()) {
            BorderActionSet aSet = this.getBorderAction(borderActionSetName);
            if (aSet != null && aSet.isEnabled()) {
                aSet.setWillToggled(false);
                aSet.fireAction(new ActionEvent(source, 500, "mouseClicked"), useInverse);
                this.getRootComponent().repaint();
            } else {
                this.resetAllActions();
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("TestBorder");
        JPanel aPanel = new JPanel();
        aPanel.add(new JButton("buttonjwingscheiss"));
        FunctionalTitleBorder border = new FunctionalTitleBorder("Blah");
        border.setToolTipText("bubbleTextBubble");
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel(aPanel);
        border.addBorderAction(CollapsiblePanel.getExpandCollapseBorderSet(collapsiblePanel));
        border.setRootComponent(collapsiblePanel);
        border.setTitleAction(new GenericAction("button1", border, "button1"), 1);
        border.setTitleAction(new GenericAction("button2", border, "button2"), 2);
        border.setTitleAction(new GenericAction("button3", border, "button3"), 3);
        collapsiblePanel.setBorder(border);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)collapsiblePanel, "Center");
        f.setSize(300, 300);
        f.setVisible(true);
    }

    public Vector getRegisteredBorderActions() {
        if (this._registeredBorderActions == null) {
            this._registeredBorderActions = new Vector();
        }
        return this._registeredBorderActions;
    }

    public void addBorderAction(BorderActionSet aSet) {
        this.initRootListeners(this.getRootComponent());
        this.getRegisteredBorderActions().add(aSet);
        FunctionalTitleBorder.initActionDimensions(this.getRegisteredBorderActions());
        if (this.getRootComponent() != null) {
            this.getRootComponent().repaint();
        }
    }

    public void addBorderAction(BorderActionSet aSet, int alignment) {
        aSet.setAlignment(alignment);
        this.initRootListeners(this.getRootComponent());
        this.getRegisteredBorderActions().add(aSet);
        FunctionalTitleBorder.initActionDimensions(this.getRegisteredBorderActions());
        if (this.getRootComponent() != null) {
            this.getRootComponent().repaint();
        }
    }

    public static final Dimension calculateActionAreaDimension(Vector actionSets) {
        int x = 0;
        int y = 0;
        for (int i = 0; i < actionSets.size(); ++i) {
            BorderActionSet aSet = (BorderActionSet)actionSets.get(i);
            if (aSet.getActionImage() == null) continue;
            x += aSet.getActionImage().getWidth(null) + 3;
            y += aSet.getActionImage().getHeight(null);
        }
        return new Dimension(x, y);
    }

    public static final int getActionAreaX(Vector actionSets) {
        if (actionSets.size() > 0) {
            BorderActionSet aSet = (BorderActionSet)actionSets.get(0);
            return aSet.getUIRange().x;
        }
        return 0;
    }

    private static final Rectangle getActionAreaRectangle(Vector actionSets, int alignment) {
        int width = 0;
        int height = 0;
        for (int i = 0; i < actionSets.size(); ++i) {
            BorderActionSet aSet = (BorderActionSet)actionSets.get(i);
            if (aSet.getActionImage() == null || aSet.getAlignment() != alignment) continue;
            width += aSet.getActionImage().getWidth(null) + 3;
            int newHeight = aSet.getActionImage().getHeight(null);
            height = height <= newHeight ? newHeight : height;
        }
        return new Rectangle(0, 0, width, height);
    }

    private static final void initActionDimensions(Vector actionSets) {
        BorderActionSet aSet;
        int i;
        int x = 5;
        int y = 1;
        for (i = 0; i < actionSets.size(); ++i) {
            aSet = (BorderActionSet)actionSets.get(i);
            if (aSet.getActionImage() == null || aSet.getAlignment() != 0 || !aSet.isVisible()) continue;
            int oldx = x;
            int width = aSet.getActionImage().getWidth(null);
            int height = aSet.getActionImage().getWidth(null);
            x += aSet.getActionImage().getWidth(null) + 3;
            aSet.setUIRange(new Rectangle(oldx, y, width, height));
        }
        x = -1;
        y = 1;
        for (i = 0; i < actionSets.size(); ++i) {
            aSet = (BorderActionSet)actionSets.get(i);
            if (aSet.getActionImage() == null || aSet.getAlignment() != 1 || !aSet.isVisible()) continue;
            int width = aSet.getActionImage().getWidth(null);
            int height = aSet.getActionImage().getWidth(null);
            if (x == -1) {
                x = 2;
            }
            aSet.setUIRange(new Rectangle(x += aSet.getActionImage().getWidth(null) + 3, y, width, height));
        }
    }

    public void setRootComponent(Component rootComponent) {
        this.initRootListeners(rootComponent);
        this._rootComponent = rootComponent;
    }

    public Component getRootComponent() {
        return this._rootComponent;
    }

    public BorderActionSet addBorderAction(String name, Action mainAction, Action inverseAction, Image mainImage, Image inverseImage, Image actionImageShadowed, Image inverseActionImageShadowed, String toolTipText, int alignment) {
        BorderActionSet aBorderAction = new BorderActionSet(name, mainAction, inverseAction, mainImage, inverseImage, actionImageShadowed, inverseActionImageShadowed, toolTipText, alignment);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public BorderActionSet addBorderActionSeparator(Image mainImage, int alignment) {
        BorderActionSet aBorderAction = new BorderActionSet("Separator", null, null, mainImage, null, null, null, null, alignment);
        aBorderAction.setActionEnabled(false);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public BorderActionSet addBorderActionSeparator(int alignment) {
        return this.addBorderActionSeparator(JAXFrontProperties.getImage((String)"com/jaxfront/core/images/files/verticalLine_6x16.gif"), alignment);
    }

    public BorderActionSet addBorderAction(String name, Action mainAction, Image mainImage, Image actionImageShadowed, String toolTipText, int alignment) {
        BorderActionSet aBorderAction = new BorderActionSet(name, mainAction, null, mainImage, null, actionImageShadowed, null, toolTipText, alignment);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public BorderActionSet addBorderAction(String name, Action mainAction, Image mainImage, String toolTipText, int alignment) {
        BorderActionSet aBorderAction = new BorderActionSet(name, mainAction, null, mainImage, null, null, null, toolTipText, alignment);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public BorderActionSet addBorderAction(Action mainAction, int alignment) {
        ImageIcon mainImage = (ImageIcon)mainAction.getValue("SmallIcon");
        String name = mainAction.getValue("Name") != null ? mainAction.getValue("Name").toString() : "not set";
        String toolTipText = mainAction.getValue("ShortDescription") != null ? mainAction.getValue("ShortDescription").toString() : "";
        BorderActionSet aBorderAction = new BorderActionSet(name, mainAction, null, mainImage.getImage(), null, null, null, toolTipText, alignment);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public BorderActionSet addBorderAction(Action mainAction, Action inverseAction, Image actionImageShadowed, Image inverseActionImageShadowed, int alignment) {
        ImageIcon mainImage = (ImageIcon)mainAction.getValue("SmallIcon");
        String name = mainAction.getValue("Name") != null ? mainAction.getValue("Name").toString() : "not set";
        String toolTipText = mainAction.getValue("ShortDescription") != null ? mainAction.getValue("ShortDescription").toString() : "";
        ImageIcon inverseImage = (ImageIcon)mainAction.getValue("SmallIcon");
        BorderActionSet aBorderAction = new BorderActionSet(name, mainAction, inverseAction, mainImage.getImage(), inverseImage.getImage(), actionImageShadowed, inverseActionImageShadowed, toolTipText, alignment);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public BorderActionSet addBorderAction(Action mainAction, Action inverseAction, int alignment) {
        ImageIcon mainImage = (ImageIcon)mainAction.getValue("SmallIcon");
        String name = mainAction.getValue("Name") != null ? mainAction.getValue("Name").toString() : "not set";
        String toolTipText = mainAction.getValue("ShortDescription") != null ? mainAction.getValue("ShortDescription").toString() : "";
        ImageIcon inverseImage = (ImageIcon)inverseAction.getValue("SmallIcon");
        BorderActionSet aBorderAction = new BorderActionSet(name, mainAction, inverseAction, mainImage.getImage(), inverseImage.getImage(), null, null, toolTipText, alignment);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public BorderActionSet addBorderAction(String name, Action mainAction, Action inverseAction, Image mainImage, Image inverseImage, String toolTipText, int alignment) {
        BorderActionSet aBorderAction = new BorderActionSet(name, mainAction, inverseAction, mainImage, inverseImage, null, null, toolTipText, alignment);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public void removeBorderAction(String name) {
        for (int i = this.getRegisteredBorderActions().size() - 1; i >= 0; --i) {
            BorderActionSet aSet = (BorderActionSet)this.getRegisteredBorderActions().get(i);
            if (!aSet.getName().equals(name)) continue;
            this.removeBorderAction(aSet);
            break;
        }
    }

    public BorderActionSet getBorderAction(String name) {
        for (int i = this.getRegisteredBorderActions().size() - 1; i >= 0; --i) {
            BorderActionSet aSet = (BorderActionSet)this.getRegisteredBorderActions().get(i);
            if (!aSet.getName().equals(name)) continue;
            return aSet;
        }
        return null;
    }

    public void removeBorderAction(BorderActionSet aSet) {
        this.getRegisteredBorderActions().remove(aSet);
        FunctionalTitleBorder.initActionDimensions(this.getRegisteredBorderActions());
        if (this.getRootComponent() != null) {
            this.getRootComponent().repaint();
        }
    }

    public void toggleActionSet(BorderActionSet aSet, boolean toogle) {
        aSet.setToggled(toogle);
        this.getRootComponent().repaint();
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (e.getSource() == this.getRootComponent()) {
            FunctionalTitleBorder.setLastMouseLocation(e.getPoint());
        }
    }

    public String getToolTipText(MouseEvent e) {
        BorderActionSet aSet = this.getActionInRange(e.getPoint());
        if (aSet != null) {
            return aSet.getToolTipText();
        }
        if (this.isInTitelBox(e.getPoint())) {
            return this.getToolTipText();
        }
        return null;
    }

    public void setToolTipText(String toolTipText) {
        this.initRootListeners(this.getRootComponent());
        this._toolTipText = toolTipText;
    }

    public String getToolTipText() {
        return this._toolTipText;
    }

    public void release() {
        this.removeRootListeners();
        this.setRootComponent(null);
    }

    public void setTitleAction(Action titleAction, int mouseButton) {
        this.initRootListeners(this.getRootComponent());
        switch (mouseButton) {
            case 1: {
                this._titleActionLeftMouse = titleAction;
                break;
            }
            case 2: {
                this._titleActionCenterMouse = titleAction;
                break;
            }
            case 3: {
                this._titleActionRightMouse = titleAction;
                break;
            }
            default: {
                this._titleActionLeftMouse = titleAction;
            }
        }
    }

    public static ImageIcon createDisabledIcon(ImageIcon icon) {
        ImageIcon result = null;
        if (icon != null) {
            result = new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
        }
        return result;
    }

    public void setVisible(String borderActionName, boolean isActive) {
        BorderActionSet aSet = this.getBorderAction(borderActionName);
        if (aSet != null) {
            FunctionalTitleBorder.initActionDimensions(this.getRegisteredBorderActions());
            aSet.setVisible(isActive);
        }
    }

    public void setVisible(boolean visible) {
        Vector actions = this.getRegisteredBorderActions();
        for (int i = 0; i < actions.size(); ++i) {
            BorderActionSet aSet = (BorderActionSet)actions.get(i);
            FunctionalTitleBorder.initActionDimensions(this.getRegisteredBorderActions());
            aSet.setVisible(visible);
        }
        this._visible = visible;
    }

    public boolean isVisible(String borderActionName) {
        BorderActionSet aSet = this.getBorderAction(borderActionName);
        if (aSet != null) {
            return aSet.isVisible();
        }
        return false;
    }

    public Action getTitleAction(int mouseButton) {
        switch (mouseButton) {
            case 1: {
                return this._titleActionLeftMouse;
            }
            case 2: {
                return this._titleActionCenterMouse;
            }
            case 3: {
                return this._titleActionRightMouse;
            }
        }
        return this._titleActionLeftMouse;
    }

    private static void setLastMouseLocation(Point mouseLoc) {
        _lastMouseLoc = mouseLoc;
    }

    public static Point getLastMouseLocation() {
        return _lastMouseLoc;
    }
}

