/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.swing.ui.tools.HeaderPanel;
import com.jaxfront.swing.ui.wrapper.JAXJDialog;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class GUITools {
    private static Double _defaultComponentHeight = null;
    private static Color _labelEndColor = UIManager.getLookAndFeelDefaults().getColor("Label.background");
    private static Color _titelColor = (Color)UIManager.getDefaults().get("TitledBorder.titleColor");
    private static int _topSpacing = 5;
    private static int _bottonSpacing = 5;
    public static final byte[] NULL_IMAGE_DEF = new byte[]{0};
    public static final ImageIcon EMPTY_ICON = new ImageIcon(NULL_IMAGE_DEF);
    public static final Random random = new Random();

    private GUITools() {
    }

    public static void centerWindow(Window w) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        w.setLocation((screen.width - w.getBounds().width) / 2, (screen.height - w.getBounds().height) / 2);
    }

    public static void centerRelativeToParentFrame(Component frame, Component component) {
        int componentWidth = component.getWidth();
        int componentHeight = component.getHeight();
        Component frameWindow = null;
        frameWindow = frame instanceof JFrame ? frame : (frame != null ? SwingUtilities.getRoot(frame.getParent()) : SwingUtilities.getRoot(component.getParent()));
        if (frameWindow != null) {
            int parentWidth = frameWindow.getWidth();
            int parentHeight = frameWindow.getHeight();
            int parentLocationX = frameWindow.getLocation().x;
            int parentLocationY = frameWindow.getLocation().y;
            double x = (parentWidth - componentWidth) / 2 + parentLocationX;
            double y = (parentHeight - componentHeight) / 2 + parentLocationY;
            component.setLocation((int)x, (int)y);
        }
    }

    public static void centerRelativeToParent(Component parent, Component component) {
        int componentWidth = component.getWidth();
        int componentHeight = component.getHeight();
        int parentWidth = parent.getWidth();
        int parentHeight = parent.getHeight();
        int parentLocationX = parent.getLocation().x;
        int parentLocationY = parent.getLocation().y;
        double x = (parentWidth - componentWidth) / 2 + parentLocationX;
        double y = (parentHeight - componentHeight) / 2 + parentLocationY;
        component.setLocation((int)(x > 0.0 ? x : 0.0), (int)(y > 0.0 ? y : 0.0));
    }

    public static void centerRelativeToParentWindow(Window window, Dialog dialog) {
        int componentWidth = dialog.getWidth();
        int componentHeight = dialog.getHeight();
        Component frameWindow = null;
        frameWindow = window instanceof JFrame ? window : (window != null ? SwingUtilities.getRoot(window.getParent()) : SwingUtilities.getRoot(dialog.getParent()));
        if (frameWindow != null) {
            Point point = frameWindow.getLocation();
            int parentWidth = frameWindow.getWidth();
            int parentHeight = frameWindow.getHeight();
            int parentLocationX = frameWindow.getLocation().x;
            int parentLocationY = frameWindow.getLocation().y;
            double x = (parentWidth - componentWidth) / 2 + parentLocationX;
            double y = (parentHeight - componentHeight) / 2 + parentLocationY;
            dialog.setLocation((int)x, (int)y);
        }
    }

    public static String convertToISODate(Calendar cal) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setTimeZone(cal.getTimeZone());
        String dateString = dateFormat.format(cal.getTime());
        return dateString;
    }

    public static void setBoundRelativeToParent(Component component, Rectangle relativeBounds) {
        if (component.getParent() != null) {
            int parentLocationX = component.getParent().getLocationOnScreen().x;
            int parentLocationY = component.getParent().getLocationOnScreen().y;
            double x = parentLocationX + relativeBounds.x;
            double y = parentLocationY + relativeBounds.y;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            x = x + 20.0 > (double)screenSize.width ? (double)(screenSize.width - relativeBounds.width) : x;
            y = y + 20.0 > (double)screenSize.height ? (double)(screenSize.height - relativeBounds.height) : y;
            component.setBounds((int)(x > 0.0 ? x : 0.0), (int)(y > 0.0 ? y : 0.0), relativeBounds.width, relativeBounds.height);
        } else {
            component.setBounds(relativeBounds);
        }
    }

    public static String convertToISODate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = dateFormat.format(date);
        return dateString;
    }

    public static Date createDateFromIso(String isoDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return dateFormat.parse(isoDate);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public static Visualizer getParentVisualizer(Component c) {
        for (Component p = c; p != null; p = p.getParent()) {
            if (!(p instanceof Visualizer)) continue;
            return (Visualizer)p;
        }
        return null;
    }

    public static Stack getAllParents(Component c) {
        Stack<Component> result = new Stack<Component>();
        for (Component p = c; p != null; p = p.getParent()) {
            result.push(p);
        }
        return result;
    }

    public static Color getRandomColor() {
        return Color.getHSBColor(random.nextFloat(), 0.4f, 1.0f);
    }

    public static Color getRandomGrayColor() {
        return Color.getHSBColor(random.nextFloat(), 0.0f, 1.0f);
    }

    public static Vector getAllParentsAsVector(Component c) {
        Vector<Component> result = new Vector<Component>();
        for (Component p = c; p != null; p = p.getParent()) {
            result.add(p);
        }
        return result;
    }

    public static Component getFirstListParent(Component c) {
        for (Component p = c; p != null; p = p.getParent()) {
            Visualizer vis;
            if (!(p instanceof Visualizer) || !((Visualizer)p).getModel().isList() || (vis = (Visualizer)p).getModel().getXUIDefinition(true) == null || vis.getModel().getXUIDefinition(true).getStyle().isListTableVisible()) continue;
            return p;
        }
        return null;
    }

    public static HeaderPanel createHeader(Type type, String text) {
        return GUITools.createHeader(type, text, null);
    }

    public static HeaderPanel createHeader(Type type, String text, int height, String imageURL, Color textColor, Color startColor, Color endColor) {
        if (type != null) {
            if (textColor == null) {
                textColor = type.getDOM().getGlobalDefinition().getHeaderTextColor();
            }
            if (startColor == null) {
                startColor = type.getDOM().getGlobalDefinition().getHeaderStartColor();
            }
            if (endColor == null) {
                endColor = type.getDOM().getGlobalDefinition().getHeaderEndColor();
            }
        }
        if (imageURL != null && imageURL.length() > 0) {
            if (URLHelper.getUserURL((String)imageURL) != null) {
                return new HeaderPanel(type, text, height, _topSpacing, _bottonSpacing, textColor, startColor, endColor, 0, (Font)UIManager.getDefaults().get("Label.font"), new ImageIcon(URLHelper.getUserURL((String)imageURL)));
            }
            return null;
        }
        return new HeaderPanel(type, text, height, _topSpacing, _bottonSpacing, textColor, startColor, endColor, 0);
    }

    public static HeaderPanel createHeader(Type type, String text, int height, String imageURL) {
        Color textColor = new Color(204, 204, 255);
        Color startColor = new Color(102, 102, 153);
        Color endColor = new Color(204, 204, 204);
        if (type != null) {
            textColor = type.getDOM().getGlobalDefinition().getHeaderTextColor();
            startColor = type.getDOM().getGlobalDefinition().getHeaderStartColor();
            endColor = type.getDOM().getGlobalDefinition().getHeaderEndColor();
        }
        return GUITools.createHeader(type, text, height, imageURL, textColor, startColor, endColor);
    }

    public static JAXJDialog createDialogFor(Component component, boolean modal, String componentName) {
        JAXJDialog _dialog = null;
        Component root = SwingUtilities.getRoot(component);
        if (root == null) {
            _dialog = new JAXJDialog();
            _dialog.setModal(modal);
        } else if (root instanceof JFrame) {
            _dialog = new JAXJDialog((Frame)((JFrame)root), modal);
        } else if (root instanceof Dialog) {
            _dialog = new JAXJDialog((Dialog)root, modal);
        } else {
            _dialog = new JAXJDialog();
            _dialog.setModal(modal);
        }
        _dialog.setName(componentName);
        _dialog.setTitle(componentName);
        if (componentName != null && JAXFrontProperties.getInstance().getGUIMetrics(componentName) != null) {
            _dialog.setBounds(JAXFrontProperties.getInstance().getGUIMetrics((Component)_dialog));
        }
        return _dialog;
    }

    public static void applyDialogGUIPersistency(Component containerComp, Component contentComp) {
        GUITools.applyDialogGUIPersistency(null, containerComp, contentComp, containerComp.getName());
    }

    public static void applyDialogGUIPersistency(Component containerComp, Component contentComp, String componentName) {
        GUITools.applyDialogGUIPersistency(null, containerComp, contentComp, componentName);
    }

    public static void applyDialogGUIPersistency(Type type, Component containerComp, Component contentComp, String componentName) {
        if (componentName != null && JAXFrontProperties.getInstance().getGUIMetrics(componentName) != null) {
            containerComp.setBounds(JAXFrontProperties.getInstance().getGUIMetrics(componentName));
        } else {
            int pwidth = contentComp.getPreferredSize().width + 20;
            int pheight = contentComp.getPreferredSize().height + 40;
            int x = 0;
            int y = 0;
            Rectangle bounds = null;
            bounds = containerComp.getParent() != null ? containerComp.getParent().getBounds() : new Rectangle(x, y, pwidth, pheight);
            x = (int)bounds.getX();
            y = (int)bounds.getY();
            if (type != null && type.getXUIDefinition().getStyle().isDialogMode()) {
                Point dialogLocation = type.getXUIDefinition().getStyle().getTableInfo().getDialogLocation();
                Dimension dialogSize = type.getXUIDefinition().getStyle().getTableInfo().getDialogSize();
                if (dialogSize != null && dialogSize.width > -1 && dialogSize.height > -1) {
                    containerComp.setSize(dialogSize.width, dialogSize.height);
                } else {
                    containerComp.setSize(pwidth, pheight);
                }
                if (dialogLocation.x <= 0 && dialogLocation.y <= 0) {
                    GUITools.centerRelativeToParent(containerComp.getParent(), containerComp);
                } else {
                    x = (int)bounds.getX() + dialogLocation.x;
                    y = (int)bounds.getY() + dialogLocation.y;
                    containerComp.setLocation(x, y);
                }
            } else {
                containerComp.setSize(pwidth, pheight);
                GUITools.centerRelativeToParent(containerComp.getParent(), containerComp);
            }
        }
    }

    public static HeaderPanel createHeader(Type type, String text, String imageURL) {
        Color textColor = new Color(204, 204, 255);
        Color startColor = new Color(102, 102, 153);
        Color endColor = new Color(204, 204, 204);
        if (type != null) {
            textColor = type.getDOM().getGlobalDefinition().getHeaderTextColor();
            startColor = type.getDOM().getGlobalDefinition().getHeaderStartColor();
            endColor = type.getDOM().getGlobalDefinition().getHeaderEndColor();
        }
        if (imageURL != null && imageURL.length() > 0) {
            if (URLHelper.getUserURL((String)imageURL) != null) {
                return new HeaderPanel(type, text, 2, _topSpacing, _bottonSpacing, textColor, new ImageIcon(URLHelper.getUserURL((String)imageURL)));
            }
            return null;
        }
        return new HeaderPanel(type, text, 16, _topSpacing, _bottonSpacing, textColor, startColor, endColor, 0);
    }

    public static HeaderPanel createSeparatorClassic(Type type, String text) {
        return new HeaderPanel(type, text, 1, _topSpacing, 10, null, Color.lightGray, _labelEndColor, 1);
    }

    public static HeaderPanel createSeparatorClassic(Type type, String text, int height) {
        Color startColor = Color.gray;
        Color endColor = UIManager.getColor("Panel.background");
        return new HeaderPanel(type, text, height, _topSpacing, 10, null, startColor, endColor, 1);
    }

    public static HeaderPanel createSeparatorModern(Type type, String text) {
        return new HeaderPanel(type, text, 1, _topSpacing, 10, null, Color.lightGray, Color.lightGray, 2);
    }

    public static HeaderPanel createSeparatorModern(Type type, String text, int height) {
        return new HeaderPanel(type, text, height, _topSpacing, 10, null, Color.lightGray, Color.lightGray, 2);
    }

    public static HeaderPanel createSeparatorVertical(Type type, String text) {
        return new HeaderPanel(type, text, 1, _topSpacing, 10, null, Color.lightGray, Color.lightGray, 3);
    }

    public static void draw3dRect(Graphics g, int x, int y, int w, int h, boolean raised) {
        Color backup = g.getColor();
        Color low1 = new Color(0, 0, 0);
        Color low2 = new Color(128, 128, 128);
        Color high1 = new Color(255, 255, 255);
        Color high2 = new Color(224, 224, 224);
        g.setColor(raised ? high1 : low1);
        g.drawLine(x, y, x + w - 1, y);
        g.drawLine(x, y, x, y + h - 1);
        g.setColor(raised ? high2 : low2);
        g.drawLine(x + 1, y + 1, x + w - 2, y + 1);
        g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
        g.setColor(raised ? low1 : high1);
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        g.setColor(raised ? low2 : high2);
        g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
        g.setColor(backup);
    }

    public static void drawHorizontalGradient(Graphics graphics, Color color1, Color color2, int x, int y, int width, int height) {
        if (width == 0) {
            return;
        }
        if (color1 == null) {
            color1 = _titelColor;
        }
        if (color2 == null) {
            color2 = _labelEndColor;
        }
        int r1 = color1.getRed();
        int g1 = color1.getGreen();
        int b1 = color1.getBlue();
        int r2 = color2.getRed();
        int g2 = color2.getGreen();
        int b2 = color2.getBlue();
        for (int i = 0; i < width; ++i) {
            int r = r1 + (r2 - r1) * i / width;
            int g = g1 + (g2 - g1) * i / width;
            int b = b1 + (b2 - b1) * i / width;
            graphics.setColor(new Color(r, g, b));
            graphics.drawLine(x + i, y, x + i, y + height);
        }
    }

    public static void drawGradient(Graphics graphics, Color color1, Color color2, int x1, int y1, int x2, int y2) {
        if (color1 == null) {
            color1 = _titelColor;
        }
        graphics.setColor(color1);
        graphics.drawLine(x1, y1, x2, y2);
    }

    public static void drawImage(Graphics graphics, ImageIcon icon, int x, int y) {
        if (icon != null) {
            graphics.drawImage(icon.getImage(), x, y, icon.getImageObserver());
        }
    }

    public static void drawLabel(Graphics g, String caption, int x, int y, Color fg, Color bg) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        FontMetrics fm = g.getFontMetrics();
        g.setColor(bg);
        g.fillRect(x, y, fm.stringWidth(caption) + 8, fm.getHeight());
        g.setColor(Color.black);
        g.drawRect(x, y, fm.stringWidth(caption) + 8, fm.getHeight());
        g.setColor(fg);
        g.drawString(caption, x + 4, y + fm.getAscent() + fm.getLeading() / 2);
    }

    public static void drawLight3dRect(Graphics g, int x, int y, int w, int h, boolean raised) {
        Color backup = g.getColor();
        Color low = new Color(128, 128, 128);
        Color high = new Color(255, 255, 255);
        g.setColor(raised ? high : low);
        g.drawLine(x, y, x + w - 1, y);
        g.drawLine(x, y, x, y + h - 1);
        g.setColor(raised ? low : high);
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        g.setColor(backup);
    }

    public static void drawVerticalGradient(Graphics graphics, Color color1, Color color2, int x, int y, int width, int height) {
        if (height == 0) {
            return;
        }
        int r1 = color1.getRed();
        int g1 = color1.getGreen();
        int b1 = color1.getBlue();
        int r2 = color2.getRed();
        int g2 = color2.getGreen();
        int b2 = color2.getBlue();
        for (int i = 0; i < height; ++i) {
            int r = r1 + (r2 - r1) * i / height;
            int g = g1 + (g2 - g1) * i / height;
            int b = b1 + (b2 - b1) * i / height;
            graphics.setColor(new Color(r, g, b));
            graphics.drawLine(x, y + i, x + width, y + i);
        }
    }

    public static void resizeFullscreen(Window w, boolean removeBorder) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Insets insets = removeBorder ? w.getInsets() : new Insets(0, 0, 0, 0);
        w.setBounds(-insets.left, -insets.top, screen.width + insets.left + insets.right, screen.height + insets.top + insets.bottom);
    }

    public static void setToolTip(JComponent c, String text) {
        String s = "<html><body bgcolor=#FFFF99><font color=#000000 size=2 face=tahoma,helvetica>&nbsp;" + text + "&nbsp;" + "</body></html>";
        c.setToolTipText(s);
    }

    public static double getDefaultComponentHeight() {
        if (_defaultComponentHeight == null) {
            _defaultComponentHeight = new Double(new JTextField().getPreferredSize().getHeight());
        }
        return _defaultComponentHeight;
    }

    public static Rectangle getComponentPositionRelativeToFrame(JComponent component) {
        Component rootComponent;
        if (component != null && component.isVisible() && (rootComponent = SwingUtilities.getRoot(component)) instanceof Window) {
            try {
                Point pointOnScreen = component.getLocationOnScreen();
                int positionToFrameY = pointOnScreen.y - rootComponent.getLocation().y;
                int positionToFrameX = pointOnScreen.x - rootComponent.getLocation().x;
                if (positionToFrameY < 50) {
                    return new Rectangle(positionToFrameX, 0, component.getWidth(), component.getHeight());
                }
                return new Rectangle(positionToFrameX, positionToFrameY + 50, component.getWidth(), component.getHeight());
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void scrollToTopComponent(JComponent component, JScrollPane scrollPane, JPanel innerPanel) {
        if (component != null && scrollPane != null && innerPanel != null) {
            int viewPortHeight = scrollPane.getViewport().getHeight();
            int innerPanelHeight = innerPanel.getHeight();
            int viewPortPositionY = scrollPane.getViewport().getViewPosition().y;
            int absComponentPosY = component.getY();
            int relComponentPosY = component.getY() - scrollPane.getY();
            if (innerPanelHeight - viewPortHeight >= viewPortPositionY && (relComponentPosY + viewPortHeight < innerPanelHeight || relComponentPosY > viewPortPositionY && innerPanelHeight - viewPortHeight != viewPortPositionY)) {
                scrollPane.getViewport().setViewPosition(new Point(0, component.getY()));
            }
        }
    }

    public static JComponent createIndentedComponent(JComponent component, int topIndent, int bottomIndent, int leftIndent, int rightIndent) {
        if (component != null) {
            if (topIndent < 0) {
                topIndent = 0;
            }
            if (bottomIndent < 0) {
                bottomIndent = 0;
            }
            if (leftIndent < 0) {
                leftIndent = 0;
            }
            if (rightIndent < 0) {
                rightIndent = 0;
            }
            String columnSpec = "" + leftIndent + ",f:p:grow(100)," + rightIndent;
            String rowSpec = "" + topIndent + ",f:p:g," + bottomIndent;
            FormLayout formLayout = new FormLayout(columnSpec, rowSpec);
            JPanel componentHolderPanel = new JPanel(formLayout);
            componentHolderPanel.add((Component)component, "2,2");
            return componentHolderPanel;
        }
        return null;
    }

    public static void showAsModal(final Frame frame, final Frame owner) {
        frame.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                owner.setEnabled(false);
            }

            public void windowClosed(WindowEvent e) {
                owner.setEnabled(true);
                owner.removeWindowListener(this);
            }
        });
        owner.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                if (frame.isShowing()) {
                    frame.setExtendedState(0);
                    frame.toFront();
                } else {
                    owner.removeWindowListener(this);
                }
            }
        });
        frame.setVisible(true);
        try {
            new EventPump(frame).start();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static JDialog createDialogFor(Component component, boolean modal) {
        JAXJDialog _dialog = null;
        Component root = SwingUtilities.getRoot(component);
        if (root == null) {
            _dialog = new JAXJDialog();
            _dialog.setModal(modal);
        } else if (root instanceof JFrame) {
            _dialog = new JAXJDialog((Frame)((JFrame)root), modal);
        } else if (root instanceof Dialog) {
            _dialog = new JAXJDialog((Dialog)root, modal);
        } else {
            _dialog = new JAXJDialog();
            _dialog.setModal(modal);
        }
        return _dialog;
    }

    public static JDialog createDialogFor(Component component) {
        return GUITools.createDialogFor(component, false);
    }

    public static boolean acceptAsFocus(JComponent comp) {
        return comp.isVisible() && comp.isFocusable();
    }

    public static void searchFocusableComponents(JComponent comp, List result) {
        if (comp instanceof JComboBox && GUITools.acceptAsFocus(comp)) {
            result.add(comp);
        } else if (comp instanceof JRadioButton && GUITools.acceptAsFocus(comp)) {
            result.add(comp);
        } else if (comp instanceof JButton && GUITools.acceptAsFocus(comp)) {
            result.add(comp);
        } else if (comp instanceof JTextComponent && GUITools.acceptAsFocus(comp)) {
            result.add(comp);
        } else if (comp instanceof JCheckBox && GUITools.acceptAsFocus(comp)) {
            result.add(comp);
        } else if (comp instanceof JMenuItem && GUITools.acceptAsFocus(comp)) {
            result.add(comp);
        }
        Component[] comps = comp.getComponents();
        for (int c = 0; c < comps.length; ++c) {
            if (!(comps[c] instanceof JComponent)) continue;
            JComponent jcomp = (JComponent)comps[c];
            GUITools.searchFocusableComponents(jcomp, result);
        }
    }

    public static void applySWTSwingModalDialog(JDialog dialog) {
        GUITools.applySWTSwingModalDialog(null, dialog);
    }

    public static void applySWTSwingModalDialog(Document dom, JDialog dialog) {
        try {
            Class[] params;
            Method methodToInvoke;
            Class<?> eclipseUtilClass = Class.forName("com.jaxfront.eclipse.Utils");
            if (eclipseUtilClass != null && (methodToInvoke = eclipseUtilClass.getMethod("applyModalDialog", params = new Class[]{Document.class, JDialog.class})) != null) {
                methodToInvoke.invoke(eclipseUtilClass, dom, dialog);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static class EventPump
    implements InvocationHandler {
        Frame frame;

        public EventPump(Frame frame) {
            this.frame = frame;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.frame.isShowing() ? Boolean.TRUE : Boolean.FALSE;
        }

        public void start() throws Exception {
            Class<?> clazz = Class.forName("java.awt.Conditional");
            Object conditional = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
            Method pumpMethod = Class.forName("java.awt.EventDispatchThread").getDeclaredMethod("pumpEvents", clazz);
            pumpMethod.setAccessible(true);
            pumpMethod.invoke((Object)Thread.currentThread(), conditional);
        }
    }
}

