/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.swing.ui.wrapper.JAXJSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.apache.xerces.xni.parser.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class JAXJSplitPanePanel
extends JComponent {
    protected int splitType = -1;
    protected String target = null;
    protected WeakReference targetType = null;
    protected String id = null;
    private Vector spChilds = new Vector(2);
    private JAXJSplitPane splitPane = null;
    private JAXJSplitPanePanel spParent = null;

    public JAXJSplitPanePanel(boolean isRoot) {
        this.init(isRoot);
    }

    public JAXJSplitPanePanel() {
        this.setLayout(new BorderLayout());
    }

    public void init(boolean isRoot) {
        this.setLayout(new BorderLayout());
        this.setId("0");
        this.setPreferredSize(new Dimension(500, 500));
    }

    public void setSplitterParent(JAXJSplitPanePanel parent) {
        this.spParent = parent;
    }

    public JAXJSplitPanePanel getSplitterParent() {
        return this.spParent;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean isSplitRoot() {
        return "0".equals(this.getId());
    }

    private JAXJSplitPanePanel getRootSplitter() {
        JAXJSplitPanePanel parent = this;
        JAXJSplitPanePanel start = this;
        while ((start = start.getSplitterParent()) != null) {
            parent = start;
        }
        return parent;
    }

    public Type getTargetType() {
        if (this.targetType != null) {
            return (Type)this.targetType.get();
        }
        return null;
    }

    public void setTargetType(Type reference, Type context) {
        if (reference == null) {
            this.removeAll();
            this.target = null;
            this.targetType = null;
        } else {
            this.target = reference.getXPathLocation();
            this.targetType = new WeakReference<Type>(reference);
            JComponent vis = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer(reference, context);
            vis.setMinimumSize(new Dimension(0, 0));
            this.add(new JScrollPane(vis));
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public String getTarget() {
        return this.target;
    }

    protected Vector getSplitterChilds() {
        return this.spChilds;
    }

    public void registerSplitterChild(JAXJSplitPanePanel child) {
        this.getSplitterChilds().add(child);
    }

    protected void setSplitPane(JAXJSplitPane splitPane) {
        this.splitPane = splitPane;
    }

    public JAXJSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void buildLayout(Type type, String definition) throws XMLParseException, SAXException, IOException {
        Document dom = DOMHelper.createDocument((String)definition);
        this.buildLayout(type, dom.getDocumentElement());
    }

    public void buildLayout(Type baseType, Element child) throws XMLParseException, SAXException, IOException {
        Type targetType;
        String id = child.getAttribute("id");
        this.setId(id);
        String type = child.getAttribute("type");
        String dividerLocation = child.getAttribute("dividerLocation");
        String absolutLocation = child.getAttribute("absolutLocation");
        String targetXPath = child.getAttribute("target");
        if (type != null && type.length() > 0) {
            this.splitType = Integer.parseInt(type);
        }
        if (this.splitType != -1) {
            this.createSplit(this.splitType);
            if (dividerLocation != null && dividerLocation.length() > 0) {
                if ("false".equalsIgnoreCase(absolutLocation)) {
                    dividerLocation = "0." + dividerLocation;
                }
                if (StringUtil.isInteger((String)dividerLocation)) {
                    this.getSplitPane().setDividerLocation(Integer.parseInt(dividerLocation));
                } else {
                    this.getSplitPane().setDividerLocation(Double.parseDouble(dividerLocation));
                }
            }
        } else if (targetXPath != null && targetXPath.length() > 0 && (targetType = baseType.getDOM().getType(targetXPath)) != null) {
            JComponent vis = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer(targetType, baseType);
            vis.setMinimumSize(new Dimension(0, 0));
            this.add((Component)new JScrollPane(vis), "Center");
        }
        List splitChilds = DOMHelper.getChildren(null, (Element)child, (String)"splitPanel");
        for (int sc = 0; sc < splitChilds.size(); ++sc) {
            ((JAXJSplitPanePanel)this.getSplitterChilds().get(sc)).buildLayout(baseType, (Element)splitChilds.get(sc));
        }
    }

    protected void createSplit(int type) {
        if (type < 0) {
            return;
        }
        this.setSplitPane(new JAXJSplitPane(type));
        JAXJSplitPanePanel firstP = new JAXJSplitPanePanel();
        this.getSplitPane().setOneTouchExpandable(true);
        this.getSplitPane().add(firstP);
        this.registerSplitterChild(firstP);
        firstP.setSplitterParent(this);
        JAXJSplitPanePanel secP = new JAXJSplitPanePanel();
        this.getSplitPane().add(secP);
        this.registerSplitterChild(secP);
        secP.setSplitterParent(this);
        this.add((Component)this.getSplitPane(), "Center");
        this.splitType = type;
    }
}

