/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;

public abstract class Scrolling {
    public static final int VIEWPORT = 0;
    public static final int UNCHANGED = 1;
    public static final int FIRST = 2;
    public static final int CENTER = 3;
    public static final int LAST = 4;
    public static final int NONE = 0;
    public static final int TOP = 1;
    public static final int VCENTER = 2;
    public static final int BOTTOM = 4;
    public static final int LEFT = 8;
    public static final int HCENTER = 16;
    public static final int RIGHT = 32;
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);

    private Scrolling() {
    }

    public static void scroll(JComponent c, int part) {
        Scrolling.scroll(c, part & 0x38, part & 7);
    }

    public static void scroll(JComponent c, int horizontal, int vertical) {
        Rectangle visible = c.getVisibleRect();
        Rectangle bounds = c.getBounds();
        switch (vertical) {
            case 1: {
                visible.y = 0;
                break;
            }
            case 2: {
                visible.y = (bounds.height - visible.height) / 2;
                break;
            }
            case 4: {
                visible.y = bounds.height - visible.height;
            }
        }
        switch (horizontal) {
            case 8: {
                visible.x = 0;
                break;
            }
            case 16: {
                visible.x = (bounds.width - visible.width) / 2;
                break;
            }
            case 32: {
                visible.x = bounds.width - visible.width;
            }
        }
        c.scrollRectToVisible(visible);
    }

    public static void scroll(JComponent c, Rectangle r, int bias) {
        Scrolling.scroll(c, r, bias, bias);
    }

    public static void scroll(JComponent c, Rectangle r, int horizontalBias, int verticalBias) {
        Rectangle visible = c.getVisibleRect();
        Rectangle dest = new Rectangle(r);
        if (dest.width > visible.width && horizontalBias != 0) {
            if (horizontalBias == 1) {
                if (dest.x <= visible.x && dest.x + dest.width >= visible.x + visible.width) {
                    dest.x = visible.x;
                    dest.width = visible.width;
                }
            } else {
                if (horizontalBias == 3) {
                    dest.x += (dest.width - visible.width) / 2;
                } else if (horizontalBias == 4) {
                    dest.x += dest.width - visible.width;
                }
                dest.width = visible.width;
            }
        }
        if (dest.height > visible.height && verticalBias != 0) {
            if (verticalBias == 1) {
                if (dest.y <= visible.y && dest.y + dest.height >= visible.y + visible.height) {
                    dest.y = visible.y;
                    dest.height = visible.height;
                }
            } else {
                if (verticalBias == 3) {
                    dest.y += (dest.height - visible.height) / 2;
                } else if (verticalBias == 4) {
                    dest.y += dest.height - visible.height;
                }
                dest.height = visible.height;
            }
        }
        if (!visible.contains(dest)) {
            c.scrollRectToVisible(dest);
        }
    }

    public static void scrollHorizontally(JComponent c, Rectangle r) {
        Scrolling.scrollHorizontally(c, r.x, r.x + r.width);
    }

    public static void scrollHorizontally(JComponent c, int from, int to) {
        Rectangle visible = c.getVisibleRect();
        if (visible.x <= from && visible.x + visible.width >= to) {
            return;
        }
        visible.x = from;
        visible.width = to - from;
        c.scrollRectToVisible(visible);
    }

    public static void scrollHorizontally(JComponent c, Rectangle r, int bias) {
        Scrolling.scrollHorizontally(c, r.x, r.x + r.width, bias);
    }

    public static void scrollHorizontally(JComponent c, int from, int to, int bias) {
        Rectangle visible = c.getVisibleRect();
        Rectangle dest = new Rectangle(visible);
        dest.x = from;
        dest.width = to - from;
        if (dest.width > visible.width && bias != 0) {
            if (bias == 1) {
                if (dest.x <= visible.x && dest.x + dest.width >= visible.x + visible.width) {
                    dest.x = visible.x;
                    dest.width = visible.width;
                }
            } else {
                if (bias == 3) {
                    dest.x += (dest.width - visible.width) / 2;
                } else if (bias == 4) {
                    dest.x += dest.width - visible.width;
                }
                dest.width = visible.width;
            }
        }
        if (!visible.contains(dest)) {
            c.scrollRectToVisible(dest);
        }
    }

    public static void scrollVertically(JComponent c, Rectangle r) {
        Scrolling.scrollVertically(c, r.y, r.y + r.height);
    }

    public static void scrollVertically(JComponent c, int from, int to) {
        Rectangle visible = c.getVisibleRect();
        if (visible.y <= from && visible.y + visible.height >= to) {
            return;
        }
        visible.y = from;
        visible.height = to - from;
        c.scrollRectToVisible(visible);
    }

    public static void scrollVertically(JComponent c, Rectangle r, int bias) {
        Scrolling.scrollVertically(c, r.y, r.y + r.height, bias);
    }

    public static void scrollVertically(JComponent c, int from, int to, int bias) {
        Rectangle visible = c.getVisibleRect();
        Rectangle dest = new Rectangle(visible);
        dest.y = from;
        dest.height = to - from;
        if (dest.height > visible.height && bias != 0) {
            if (bias == 1) {
                if (dest.y <= visible.y && dest.y + dest.height >= visible.y + visible.height) {
                    dest.y = visible.y;
                    dest.height = visible.height;
                }
            } else {
                if (bias == 3) {
                    dest.y += (dest.height - visible.height) / 2;
                } else if (bias == 4) {
                    dest.y += dest.height - visible.height;
                }
                dest.height = visible.height;
            }
        }
        if (!visible.contains(dest)) {
            c.scrollRectToVisible(dest);
        }
    }

    public static void center(JComponent c, Rectangle r, boolean withInsets) {
        Rectangle visible = c.getVisibleRect();
        visible.x = r.x - (visible.width - r.width) / 2;
        visible.y = r.y - (visible.height - r.height) / 2;
        Rectangle bounds = c.getBounds();
        Insets i = withInsets ? EMPTY_INSETS : c.getInsets();
        bounds.x = i.left;
        bounds.y = i.top;
        bounds.width -= i.left + i.right;
        bounds.height -= i.top + i.bottom;
        if (visible.x < bounds.x) {
            visible.x = bounds.x;
        }
        if (visible.x + visible.width > bounds.x + bounds.width) {
            visible.x = bounds.x + bounds.width - visible.width;
        }
        if (visible.y < bounds.y) {
            visible.y = bounds.y;
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            visible.y = bounds.y + bounds.height - visible.height;
        }
        c.scrollRectToVisible(visible);
    }

    public static void centerHorizontally(JComponent c, Rectangle r, boolean withInsets) {
        Scrolling.centerHorizontally(c, r.x, r.x + r.width, withInsets);
    }

    public static void centerHorizontally(JComponent c, int from, int to, boolean withInsets) {
        Rectangle bounds = c.getBounds();
        Insets i = withInsets ? EMPTY_INSETS : c.getInsets();
        bounds.x = i.left;
        bounds.y = i.top;
        bounds.width -= i.left + i.right;
        bounds.height -= i.top + i.bottom;
        Rectangle visible = c.getVisibleRect();
        visible.x = from - (visible.width + from - to) / 2;
        if (visible.x < bounds.x) {
            visible.x = bounds.x;
        }
        if (visible.x + visible.width > bounds.x + bounds.width) {
            visible.x = bounds.x + bounds.width - visible.width;
        }
        c.scrollRectToVisible(visible);
    }

    public static void centerVertically(JComponent c, Rectangle r, boolean withInsets) {
        Scrolling.centerVertically(c, r.y, r.y + r.height, withInsets);
    }

    public static void centerVertically(JComponent c, int from, int to, boolean withInsets) {
        Rectangle bounds = c.getBounds();
        Insets i = withInsets ? EMPTY_INSETS : c.getInsets();
        bounds.x = i.left;
        bounds.y = i.top;
        bounds.width -= i.left + i.right;
        bounds.height -= i.top + i.bottom;
        Rectangle visible = c.getVisibleRect();
        visible.y = from - (visible.height + from - to) / 2;
        if (visible.y < bounds.y) {
            visible.y = bounds.y;
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            visible.y = bounds.y + bounds.height - visible.height;
        }
        c.scrollRectToVisible(visible);
    }

    public static boolean isVisible(JComponent c, Rectangle r) {
        return c.getVisibleRect().contains(r);
    }

    public static boolean isHorizontallyVisible(JComponent c, int from, int to) {
        Rectangle visible = c.getVisibleRect();
        return visible.x <= from && visible.x + visible.width >= to;
    }

    public static boolean isHorizontallyVisible(JComponent c, Rectangle r) {
        Rectangle visible = c.getVisibleRect();
        return visible.x <= r.x && visible.x + visible.width >= r.x + r.width;
    }

    public static boolean isVerticallyVisible(JComponent c, int from, int to) {
        Rectangle visible = c.getVisibleRect();
        return visible.y <= from && visible.y + visible.height >= to;
    }

    public static boolean isVerticallyVisible(JComponent c, Rectangle r) {
        Rectangle visible = c.getVisibleRect();
        return visible.y <= r.y && visible.y + visible.height >= r.y + r.height;
    }
}

