/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.util.JAXFrontProperties;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class SortingHeader
extends JButton
implements TableCellRenderer,
MouseListener {
    public static final Integer ASCENDING = new Integer(-1);
    public static final Integer DESCENDING = new Integer(0);
    private int[] _columns;
    private int _pressedColumn = -1;
    protected SortingHeader rendererComponent = this;
    protected int column;
    protected boolean mousePressed = false;

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table != null) {
            JTableHeader header;
            if (this._columns == null) {
                this._columns = new int[table.getColumnCount()];
                for (int i = 0; i < this._columns.length; ++i) {
                    this._columns[i] = -1;
                }
            }
            if ((header = table.getTableHeader()) != null) {
                this.rendererComponent.setForeground(header.getForeground());
                this.rendererComponent.setBackground(header.getBackground());
                this.rendererComponent.setFont(header.getFont());
                header.addMouseListener(this.rendererComponent);
            }
        }
        this.setColumn(column);
        if (value instanceof String) {
            this.rendererComponent.setText((String)value);
        }
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        if (column == this._pressedColumn) {
            if (this._columns[column] == DESCENDING) {
                this.rendererComponent.setHorizontalTextPosition(10);
                this.rendererComponent.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowDown_9x6.gif"));
            } else {
                this.rendererComponent.setHorizontalTextPosition(10);
                this.rendererComponent.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowUp_9x6.gif"));
            }
        } else {
            this.rendererComponent.setIcon(null);
        }
        return this.rendererComponent;
    }

    protected void setColumn(int column) {
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    protected void handleClickEvent(MouseEvent e) {
        if (this.mousePressed) {
            this.mousePressed = false;
            JTableHeader header = (JTableHeader)e.getSource();
            JTable tableView = header.getTable();
            TableColumnModel columnModel = tableView.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            if (viewColumn != -1) {
                int column = tableView.convertColumnIndexToModel(viewColumn);
                this._columns[viewColumn] = this._columns[viewColumn] == DESCENDING ? ASCENDING.intValue() : DESCENDING.intValue();
                this._pressedColumn = viewColumn;
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.handleClickEvent(e);
        ((JTableHeader)e.getSource()).repaint();
    }

    public void mousePressed(MouseEvent e) {
        this.mousePressed = true;
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public int getSortSequence(int column) {
        return this._columns[column];
    }
}

