/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools.mask;

import com.jaxfront.swing.ui.tools.mask.MaskDocument;
import com.jaxfront.swing.ui.tools.mask.MaskElement;
import com.jaxfront.swing.ui.tools.mask.MaskLiteral;
import com.jaxfront.swing.ui.tools.mask.MaskMacros;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class JMaskField
extends JTextField
implements DocumentListener,
KeyListener,
FocusListener {
    protected MaskMacros macros;
    protected MaskDocument doc;
    protected boolean bspace;
    protected boolean delete;
    protected int pos = -1;

    public JMaskField(String mask) {
        this(mask, new MaskMacros(), '_');
    }

    public JMaskField(String mask, MaskMacros macros) {
        this(mask, macros, '_');
    }

    public JMaskField(String mask, MaskMacros macros, char templateChar) {
        this.setMacros(macros);
        this.doc = new MaskDocument(mask, macros, templateChar);
        this.doc.addDocumentListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.setDocument(this.doc);
        this.setText("");
        this.setPreferredSize(new Dimension(128, 23));
    }

    public MaskMacros getMacros() {
        return this.macros;
    }

    public void setMacros(MaskMacros macros) {
        this.macros = macros;
    }

    private void adjustCaretForward(int pos) {
        while (this.isLiteral(pos)) {
            ++pos;
        }
        if (pos > this.doc.getLength()) {
            pos = this.doc.getLength();
        }
        this.setCaretPosition(pos);
    }

    private void adjustCaretBackward(int pos) {
        while (this.isLiteral(pos - 1)) {
            --pos;
        }
        if (pos <= 0) {
            this.adjustCaretForward(0);
        } else {
            this.setCaretPosition(pos);
        }
    }

    private boolean isLiteral(int pos) {
        if (pos < 0 || pos >= this.doc.pattern.size()) {
            return false;
        }
        MaskElement rule = this.doc.getRule(pos);
        if (rule instanceof MaskLiteral) {
            char literal = ((MaskLiteral)rule).chr;
            return !this.doc.macros.containsMacro(literal);
        }
        return false;
    }

    public void focusLost(FocusEvent event) {
        this.pos = this.getCaretPosition();
    }

    public void focusGained(FocusEvent event) {
        if (this.pos < 0) {
            this.adjustCaretForward(0);
        } else {
            this.setCaretPosition(this.pos);
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        this.bspace = event.getKeyCode() == 8;
        this.delete = event.getKeyCode() == 127;
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void removeUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        int pos = event.getOffset();
        int len = event.getLength();
        if (this.bspace) {
            this.adjustCaretBackward(pos);
        } else if (this.delete) {
            this.setCaretPosition(pos);
        } else {
            this.adjustCaretForward(pos + 1);
        }
    }

    public void setText(String t) {
        try {
            Document doc = this.getDocument();
            if (doc instanceof MaskDocument) {
                doc.remove(0, doc.getLength());
                doc.insertString(0, t, null);
            } else if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).replace(0, doc.getLength(), t, null);
            } else {
                doc.remove(0, doc.getLength());
                doc.insertString(0, t, null);
            }
        }
        catch (BadLocationException e) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
    }
}

