/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools.mask;

import com.jaxfront.swing.ui.tools.mask.MaskElement;
import com.jaxfront.swing.ui.tools.mask.MaskParser;
import java.util.Enumeration;
import java.util.Hashtable;

public class MaskMacros {
    protected Hashtable table;
    protected MaskParser parser = new MaskParser();

    public MaskMacros() {
        this.table = new Hashtable();
    }

    public void addMacro(char key, String macro) {
        MaskElement element = this.parser.parseMacro(macro);
        this.table.put(new Character(key), element);
    }

    public void removeMacro(char key) {
        this.table.remove(new Character(key));
    }

    public MaskElement getMacro(char key) {
        return (MaskElement)this.table.get(new Character(key));
    }

    public boolean containsMacro(char key) {
        return this.table.containsKey(new Character(key));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("macros\n{\n");
        Enumeration keys = this.table.keys();
        Enumeration enumeration = this.table.elements();
        while (keys.hasMoreElements()) {
            Character key = (Character)keys.nextElement();
            MaskElement element = (MaskElement)enumeration.nextElement();
            buffer.append(" " + key.charValue() + "=");
            buffer.append(((Object)element).toString() + "\n");
        }
        buffer.append("}\n");
        return buffer.toString();
    }

    public static void main(String[] args) {
        MaskMacros macros = new MaskMacros();
        macros.addMacro('@', "[a-zA-Z]");
        macros.addMacro('#', "[0-9]");
        System.out.println(macros);
    }
}

