/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools.mask;

import com.jaxfront.swing.ui.tools.mask.MaskCondition;
import com.jaxfront.swing.ui.tools.mask.MaskElement;
import com.jaxfront.swing.ui.tools.mask.MaskException;
import com.jaxfront.swing.ui.tools.mask.MaskExpression;
import com.jaxfront.swing.ui.tools.mask.MaskSet;
import com.jaxfront.swing.ui.tools.mask.MaskToken;
import com.jaxfront.swing.ui.tools.mask.MaskTokenizer;

public class MaskParser {
    public MaskElement parseMacro(String text) {
        MaskTokenizer tokenizer = new MaskTokenizer("&|![]() ", "");
        tokenizer.tokenize(text);
        return this.parseCondition(tokenizer);
    }

    public MaskElement parseCondition(MaskTokenizer tokenizer) {
        MaskElement node = this.parseExpression(tokenizer);
        if (tokenizer.hasMoreTokens()) {
            MaskToken next = tokenizer.nextToken();
            if (next.equals('|')) {
                return new MaskCondition(false, node, this.parseCondition(tokenizer));
            }
            if (next.equals('&')) {
                return new MaskCondition(true, node, this.parseCondition(tokenizer));
            }
        }
        tokenizer.ignoreToken();
        return node;
    }

    private MaskElement parseExpression(MaskTokenizer tokenizer) {
        MaskToken token = tokenizer.nextToken();
        if (token.equals('(')) {
            MaskElement node = this.parseCondition(tokenizer);
            MaskParser.expect(tokenizer.nextToken(), ')');
            return new MaskExpression(node);
        }
        tokenizer.ignoreToken();
        return this.parseSet(tokenizer);
    }

    private MaskElement parseSet(MaskTokenizer tokenizer) {
        MaskParser.expect(tokenizer.nextToken(), '[');
        MaskToken token = tokenizer.nextToken();
        boolean negate = token.equals('!');
        if (negate) {
            token = tokenizer.nextToken();
        }
        MaskParser.expect(tokenizer.nextToken(), ']');
        return new MaskSet(negate, this.expandSet(token.text));
    }

    private String expandSet(String text) {
        int i = 0;
        StringBuffer buffer = new StringBuffer();
        while (i < text.length()) {
            if (i < text.length() - 2 && text.charAt(i + 1) == '-') {
                int to;
                int from = text.charAt(i);
                if (from > (to = text.charAt(i + 2))) {
                    int temp = from;
                    from = to;
                    to = temp;
                }
                for (int c = from; c <= to; ++c) {
                    buffer.append((char)c);
                }
                i += 3;
                continue;
            }
            buffer.append(text.charAt(i));
            ++i;
        }
        return buffer.toString();
    }

    public static void expect(MaskToken token, char chr) {
        if (!token.equals(chr)) {
            throw new MaskException("Syntax error: '" + chr + "' expected at " + token.pos);
        }
    }

    public static void main(String[] args) {
        MaskParser parser = new MaskParser();
        MaskElement element = parser.parseMacro("[0-9]");
        System.out.println(element);
        System.out.println(element.match('3'));
    }
}

