/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools.search;

import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.Queue;
import com.jaxfront.core.util.search.EqualityField;
import com.jaxfront.core.util.search.Search;
import com.jaxfront.core.util.search.SearchFilterListener;
import com.jaxfront.core.util.search.SearchResultProcessor;
import com.jaxfront.swing.ui.tools.Dialog;
import com.jaxfront.swing.ui.tools.VerticalTabbedPane;
import com.jaxfront.swing.ui.tools.search.SelectionTableModel;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class Find
extends JDialog
implements ActionListener,
ListSelectionListener,
SearchFilterListener,
TableModelListener,
ChangeListener,
KeyListener {
    private static final String EQUALITY_FIELD = "EqualityField";
    private static final int COMPONENT_GAP = 10;
    private static final Border EMPTY_BORDER = new EmptyBorder(5, 5, 5, 5);
    private static Find sharedFindReplace;
    private JLabel replaceLabel;
    private JComboBox replaceData;
    private JButton replaceButton;
    private JButton replaceAllButton;
    private JPanel replacePanel;
    private static Queue _replaceValues;
    private JLabel findLabel;
    private JComboBox findData;
    private JCheckBox matchCase;
    private JCheckBox matchWord;
    private JCheckBox isRegEx;
    private JRadioButton searchUp;
    private JRadioButton searchDown;
    private JButton findNextButton;
    private JButton closeButton;
    private JPanel findPanel;
    private JPanel optionPanel;
    private JPanel commandPanel;
    private static Queue _searchedValues;
    private Search _searcher;
    private SearchResultProcessor _resultProcessor;
    private boolean _searchPerformed = false;
    private JTabbedPane _findTab;
    private JPanel _findPanel;
    private JPanel _filterPanel;
    private JPanel _resultPanel;
    private JList _resultList;
    private JTable _filterList;
    private JPanel matchPanel;
    private List _equalityFields;
    private ListCellRenderer _customListRenderer = null;
    private boolean _suppress;

    public Find(Frame owner) {
        super(owner);
        this.init();
    }

    public Find(java.awt.Dialog owner) {
        super(owner);
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(1);
        this.findData = new JComboBox<Object>(Find.getSearchedValues().toInverseArray());
        this.findData.setEditable(true);
        JTextComponent editor = (JTextComponent)this.findData.getEditor().getEditorComponent();
        editor.addKeyListener(this);
        String colSpec = "100px,10px,200px";
        String rowSpec = "pref";
        this.findLabel = new JLabel(GUIComponentNLS.getInstance().getNLSText("label_findWhat", "Find what") + ":");
        this.findLabel.setDisplayedMnemonic('N');
        this.findLabel.setLabelFor(this.findData);
        this.findPanel = new JPanel(new FormLayout(colSpec, rowSpec));
        this.findPanel.setBorder(EMPTY_BORDER);
        this.findPanel.add((Component)this.findLabel, "1,1,F,C");
        this.findPanel.add((Component)this.findData, "3,1,F,C");
        this.replaceData = new JComboBox<Object>(Find.getReplaceValues().toInverseArray());
        this.replaceData.setEditable(true);
        this.replaceLabel = new JLabel(GUIComponentNLS.getInstance().getNLSText("label_replaceWith", "Replace with") + ":");
        this.replaceLabel.setDisplayedMnemonic('P');
        this.replaceLabel.setLabelFor(this.replaceData);
        this.replacePanel = new JPanel(new FormLayout(colSpec, rowSpec));
        this.replacePanel.setBorder(EMPTY_BORDER);
        this.replacePanel.add((Component)this.replaceLabel, "1,1,F,C");
        this.replacePanel.add((Component)this.replaceData, "3,1,F,C");
        this.matchPanel = new JPanel();
        this.matchPanel.setLayout(new GridLayout(2, 1));
        this.matchCase = new JCheckBox(GUIComponentNLS.getInstance().getNLSText("button_matchCase", "Match case"));
        this.matchCase.setMnemonic('C');
        this.matchWord = new JCheckBox(GUIComponentNLS.getInstance().getNLSText("button_matchWord", "Match word"));
        this.matchWord.setMnemonic('W');
        this.isRegEx = new JCheckBox("isRegEx");
        this.isRegEx.setMnemonic('R');
        this.matchPanel.add(this.matchCase);
        this.matchPanel.add(this.matchWord);
        this.matchPanel.add(this.isRegEx);
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new GridLayout(2, 1));
        this.searchDown = new JRadioButton(GUIComponentNLS.getInstance().getNLSText("button_searchDown", "Search Down"));
        this.searchDown.setMnemonic('D');
        this.searchDown.setSelected(true);
        this.searchUp = new JRadioButton(GUIComponentNLS.getInstance().getNLSText("button_searchUp", "Search Up"));
        this.searchUp.setMnemonic('U');
        searchPanel.add(this.searchDown);
        searchPanel.add(this.searchUp);
        ButtonGroup searchGroup = new ButtonGroup();
        searchGroup.add(this.searchDown);
        searchGroup.add(this.searchUp);
        this.optionPanel = new JPanel();
        this.optionPanel.setLayout(new GridLayout(1, 2));
        this.optionPanel.setBorder(new TitledBorder(GUIComponentNLS.getInstance().getNLSText("label_options", "Options")));
        this.optionPanel.add(this.matchPanel);
        this.optionPanel.add(searchPanel);
        this.commandPanel = new JPanel();
        this.findNextButton = this.createButton(this.commandPanel, GUIComponentNLS.getInstance().getNLSText("button_findNext", "Find next"), 'F');
        this.replaceButton = this.createButton(this.commandPanel, GUIComponentNLS.getInstance().getNLSText("button_replace", "Replace"), 'R');
        this.replaceAllButton = this.createButton(this.commandPanel, GUIComponentNLS.getInstance().getNLSText("button_replaceAll", "Replace All"), 'a');
        this.closeButton = this.createButton(this.commandPanel, GUIComponentNLS.getInstance().getNLSText("button_close", "Close"), ' ');
        this.closeButton.setEnabled(true);
        this.findData.addActionListener(this);
        this.matchCase.addActionListener(this);
        this.matchWord.addActionListener(this);
        this.isRegEx.addActionListener(this);
        this.searchUp.addActionListener(this);
        this.searchDown.addActionListener(this);
        this._findPanel = new JPanel();
        this._findPanel.setLayout(new BoxLayout(this._findPanel, 1));
        this._findPanel.setBorder(EMPTY_BORDER);
        this._findPanel.add(this.findPanel);
        this._findPanel.add(this.replacePanel);
        this._findPanel.add(this.optionPanel);
        this._findPanel.add(this.commandPanel);
        this._findTab = VerticalTabbedPane.createTabbedPane(2);
        VerticalTabbedPane.addTab(this._findTab, "find", this._findPanel);
        this._resultPanel = new JPanel(new BorderLayout());
        this._resultPanel.add((Component)new JScrollPane(this.getResultList()), "Center");
        VerticalTabbedPane.addTab(this._findTab, "result", this._resultPanel);
        this._filterPanel = new JPanel(new BorderLayout());
        this._filterPanel.add((Component)new JScrollPane(this.getFilterList()), "Center");
        this._filterPanel.setPreferredSize(this._findPanel.getPreferredSize());
        VerticalTabbedPane.addTab(this._findTab, "filter", this._filterPanel);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this._findTab, "Center");
        this.setContentPane(topPanel);
        this.getRootPane().setDefaultButton(this.findNextButton);
        FocusAdapter resetDefaultButton = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Find.this.getRootPane().setDefaultButton(Find.this.findNextButton);
            }
        };
        this.findData.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("comboBoxEdited")) {
                    boolean state = Find.this.getFindString().length() > 0;
                    Find.getSearchedValues().enqueueUnique((Object)Find.this.getFindString());
                    Find.this.findNextButton.setEnabled(state);
                    Find.this.replaceButton.setEnabled(state);
                    Find.this.replaceAllButton.setEnabled(state);
                    Object findObject = Find.this.findData.getEditor().getItem();
                    if (findObject != null && !findObject.equals(Find.this.getFindString())) {
                        Find.this.resetSearchVariables();
                        Find.this.maintainFindComboBox();
                    }
                }
            }
        });
        this.replaceData.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("comboBoxEdited")) {
                    Find.getReplaceValues().enqueueUnique((Object)Find.this.getReplaceString());
                    Find.this.maintainReplaceComboBox();
                }
            }
        });
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Find.this.processClose();
            }
        };
        this.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0, false);
        AbstractAction enterAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Find.this.processFindNext();
            }
        };
        this.getRootPane().getInputMap(2).put(enterKeyStroke, "ENTER");
        this.getRootPane().getActionMap().put("ENTER", enterAction);
        this.setTitle(GUIComponentNLS.getInstance().getNLSText("dialog_find", "Find"));
    }

    public static Find getSharedInstance(Frame owner) {
        if (sharedFindReplace == null) {
            sharedFindReplace = new Find(owner);
            sharedFindReplace.setLocationRelativeTo(owner);
        } else if (sharedFindReplace.getOwner() != owner) {
            sharedFindReplace.setVisible(false);
            sharedFindReplace = new Find(owner);
            sharedFindReplace.setLocationRelativeTo(owner);
        }
        return sharedFindReplace;
    }

    public String getReplaceString() {
        Object replaceText = this.replaceData.getSelectedItem();
        return replaceText != null ? replaceText.toString() : "";
    }

    public static Find getSharedInstance(java.awt.Dialog owner) {
        if (sharedFindReplace == null) {
            sharedFindReplace = new Find(owner);
            sharedFindReplace.setLocationRelativeTo(owner);
        } else if (sharedFindReplace.getOwner() != owner) {
            sharedFindReplace.setVisible(false);
            sharedFindReplace = new Find(owner);
            sharedFindReplace.setLocationRelativeTo(owner);
        }
        return sharedFindReplace;
    }

    void maintainReplaceComboBox() {
        this.replaceData.removeAllItems();
        Object[] previousItems = Find.getReplaceValues().toInverseArray();
        for (int i = 0; i < previousItems.length; ++i) {
            this.replaceData.addItem(previousItems[i]);
        }
    }

    private void showReplaceComponents(boolean value) {
        this.replacePanel.setVisible(value);
        this.replaceButton.setVisible(value);
        this.replaceAllButton.setVisible(value);
    }

    public void showFind(Search searcher) {
        this.clearResultList();
        this.showReplaceComponents(false);
        if (searcher != null) {
            this.setSearcher(searcher);
        }
        this.updateComparePanel();
        this.pack();
        this.setVisible(true);
        this.findData.requestFocus();
        this.resetSearchVariables();
        this.setFindString(this.getFindString());
    }

    public void showFind() {
        this.showFind(null);
    }

    public List getEqualityFields() {
        if (this._equalityFields == null) {
            this._equalityFields = new Vector();
        }
        return this._equalityFields;
    }

    public void updateComparePanel() {
        this.releaseComparePanel();
        if (this.getSearcher() != null && this.getSearcher().getComparator().getEqualityFields() != null) {
            List equalityFields = this.getSearcher().getComparator().getEqualityFields();
            for (int i = 0; i < equalityFields.size(); ++i) {
                EqualityField eqField = (EqualityField)equalityFields.get(i);
                JCheckBox field = new JCheckBox(eqField._name);
                field.putClientProperty(EQUALITY_FIELD, eqField);
                field.addChangeListener(this);
                field.setSelected(eqField._selected);
                this.getEqualityFields().add(field);
                this.matchPanel.add(field);
            }
        }
    }

    public void releaseComparePanel() {
        List equalityFields = this.getEqualityFields();
        for (int i = 0; i < equalityFields.size(); ++i) {
            JCheckBox field = (JCheckBox)equalityFields.get(i);
            this.matchPanel.remove(field);
            field.removeChangeListener(this);
        }
        equalityFields.clear();
    }

    public void showFindTab() {
        this._findTab.setSelectedComponent(this._findPanel);
    }

    public void showFilterTab() {
        this._findTab.setSelectedComponent(this._filterPanel);
    }

    public void showResultTab() {
        this._findTab.setSelectedComponent(this._resultPanel);
    }

    public void setFindTabVisible(boolean visible) {
        if (visible) {
            VerticalTabbedPane.addTab(this._findTab, "find", this._findPanel);
        } else {
            this._findTab.remove(this._findPanel);
        }
    }

    public void setFilterTabVisible(boolean visible) {
        if (visible) {
            VerticalTabbedPane.addTab(this._findTab, "filter", this._filterPanel);
        } else {
            this._findTab.remove(this._filterPanel);
        }
    }

    public void setResultTabVisible(boolean visible) {
        if (visible) {
            VerticalTabbedPane.addTab(this._findTab, GUIComponentNLS.getInstance().getNLSText("button_find", "button_find"), this._resultPanel);
        } else {
            this._findTab.remove(this._resultPanel);
        }
    }

    public void showReplace(Search searcher) {
        this.clearResultList();
        this.setTitle(GUIComponentNLS.getInstance().getNLSText("dialog_findAndReplace", "Find and Replace"));
        this.setSearcher(searcher);
        this.showReplaceComponents(true);
        this.pack();
        this.setVisible(true);
        this.findData.requestFocus();
        this.resetSearchVariables();
    }

    public void doFindNext() {
        this.processFindNext();
    }

    public String getFindString() {
        Object findText = this.findData.getSelectedItem();
        return findText != null ? findText.toString() : "";
    }

    void maintainFindComboBox() {
        Object selected = this.findData.getSelectedItem();
        this.findData.removeAllItems();
        Object[] previousItems = Find.getSearchedValues().toInverseArray();
        for (int i = 0; i < previousItems.length; ++i) {
            this.findData.addItem(previousItems[i]);
        }
        this.findData.setSelectedItem(selected);
    }

    public void setFindString(String find) {
        this.resetSearchVariables();
        this.findData.getModel().setSelectedItem(find);
        boolean state = find.length() > 0;
        this.findNextButton.setEnabled(state);
        this.replaceButton.setEnabled(state);
        this.replaceAllButton.setEnabled(state);
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.findNextButton) {
            if (!this.processFindNext()) {
                Dialog.showInformationDialog(this, "No more items!");
            }
        } else if (o == this.replaceButton) {
            this.processReplace();
        } else if (o == this.replaceAllButton) {
            this.processReplaceAll();
        } else if (o != this.findData) {
            if (o == this.matchCase) {
                this.resetSearchVariables();
            } else if (o == this.matchWord) {
                this.resetSearchVariables();
            } else if (o == this.isRegEx) {
                this.resetSearchVariables();
            } else if (o != this.searchUp && o != this.searchDown && o == this.closeButton) {
                this.processClose();
            }
        }
    }

    public static Queue getReplaceValues() {
        if (_replaceValues == null) {
            _replaceValues = new Queue(10);
        }
        return _replaceValues;
    }

    private boolean processReplace() {
        return false;
    }

    private void processReplaceAll() {
    }

    private JButton createButton(JPanel panel, String label, char mnemonic) {
        JButton button = new JButton(label);
        button.setMnemonic(mnemonic);
        button.setEnabled(false);
        button.addActionListener(this);
        panel.add(button);
        return button;
    }

    private void setResultData(List results) {
        DefaultListModel resultModel = new DefaultListModel();
        for (int i = 0; results != null && i < results.size(); ++i) {
            resultModel.addElement(results.get(i));
        }
        this.getResultList().setModel(resultModel);
    }

    private void setFilterData(List filters) {
        SelectionTableModel resultModel = new SelectionTableModel();
        for (int i = 0; filters != null && i < filters.size(); ++i) {
            resultModel.addRow(new Object[]{new Boolean(true), filters.get(i)});
        }
        this.getFilterList().setModel(resultModel);
        resultModel.addTableModelListener(this);
    }

    private boolean processFindNext() {
        Object result = null;
        if (this.getSearcher() != null) {
            String needle = this.getFindString();
            this.getSearcher().matchWord(this.matchWord.isSelected());
            this.getSearcher().matchCase(this.matchCase.isSelected());
            this.getSearcher().isRegEx(this.isRegEx.isSelected());
            if (!this._searchPerformed) {
                this.applyEqualitySelection();
                List selectedFilterValues = ((SelectionTableModel)this.getFilterList().getModel()).getSelectedValues();
                this.getSearcher().getComparator().getFilter().setFilterValues(selectedFilterValues);
                this.getResultList().removeAll();
                this.getSearcher().search(needle);
                this._searchPerformed = true;
                this.setResultData(this.getSearcher().getAll());
            }
            result = this.searchDown() ? this.getSearcher().getNext() : this.getSearcher().getPrevious();
            this._suppress = true;
            this.delegateResultSelection(result);
            this._suppress = false;
        }
        return result != null;
    }

    private boolean searchDown() {
        return this.searchDown.isSelected();
    }

    private void processClose() {
        this.setVisible(false);
    }

    private void applyEqualitySelection() {
        Vector<EqualityField> fields = new Vector<EqualityField>();
        for (int i = 0; this.getSearcher() != null && i < this.getEqualityFields().size(); ++i) {
            JCheckBox box = (JCheckBox)this.getEqualityFields().get(i);
            if (box.getClientProperty(EQUALITY_FIELD) == null) continue;
            EqualityField eqField = (EqualityField)box.getClientProperty(EQUALITY_FIELD);
            eqField._selected = box.isSelected();
            fields.add(eqField);
        }
        this.getSearcher().getComparator().setEqualityFields(fields);
    }

    private void resetSearchVariables() {
        if (this.getSearcher() != null) {
            this.getSearcher().reset();
        }
        this._searchPerformed = false;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        JTextPane text = new JTextPane();
        DefaultCaret selected = new DefaultCaret(){

            public void focusLost(FocusEvent e) {
                this.setVisible(false);
            }
        };
        selected.setBlinkRate(text.getCaret().getBlinkRate());
        text.setCaret(selected);
        try {
            text.read(new FileReader(new File("FindReplace.java")), (Object)"");
        }
        catch (IOException e) {
            System.out.println(e);
        }
        text.getDocument().putProperty("__EndOfLine__", "\n");
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new JScrollPane(text));
        frame.setSize(400, 400);
        frame.setVisible(true);
    }

    public static Queue getSearchedValues() {
        if (_searchedValues == null) {
            _searchedValues = new Queue(10);
        }
        return _searchedValues;
    }

    public static void releaseSharedInstance() {
        if (sharedFindReplace != null) {
            sharedFindReplace.setVisible(false);
        }
        sharedFindReplace = null;
    }

    public void setSearcher(Search searcher) {
        this._searcher = searcher;
        if (this._searcher != null && this._searcher.getComparator() != null) {
            List filterValues = this._searcher.getComparator().getFilter().getFilterValues();
            if (filterValues != null && filterValues.size() > 0) {
                this.setFilterData(filterValues);
                this.setFilterTabVisible(true);
            } else {
                this.setFilterTabVisible(false);
            }
        } else {
            this.setFilterTabVisible(false);
        }
    }

    public Search getSearcher() {
        return this._searcher;
    }

    public void setResultProcessor(SearchResultProcessor _resultProcessor) {
        this._resultProcessor = _resultProcessor;
    }

    public SearchResultProcessor getResultProcessor() {
        return this._resultProcessor;
    }

    private void delegateResultSelection(Object resultObject) {
        this.getResultList().setSelectedValue(resultObject, true);
        if (this.getResultProcessor() != null) {
            this.getResultProcessor().process(resultObject);
        }
    }

    private JList getResultList() {
        if (this._resultList == null) {
            this._resultList = new JList();
            this._resultList.addListSelectionListener(this);
        }
        return this._resultList;
    }

    private JTable getFilterList() {
        if (this._filterList == null) {
            this._filterList = new JTable();
            this._filterList.setModel(new SelectionTableModel());
        }
        return this._filterList;
    }

    private void clearResultList() {
        if (this._resultList != null && this._resultList.getModel() != null && this._resultList.getModel() instanceof DefaultListModel) {
            ((DefaultListModel)this._resultList.getModel()).removeAllElements();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this._resultList && !e.getValueIsAdjusting() && !this._suppress) {
            this.delegateResultSelection(this._resultList.getSelectedValue());
        }
    }

    public void setListRenderer(ListCellRenderer customListRenderer) {
        this.getResultList().setCellRenderer(customListRenderer);
        this._customListRenderer = customListRenderer;
    }

    public void tableChanged(TableModelEvent e) {
        this.resetSearchVariables();
    }

    public void stateChanged(ChangeEvent e) {
        this.resetSearchVariables();
    }

    public void filterAdded(Object filter) {
        this.getFilterList().getModel();
    }

    public void filterRemoved(Object filter) {
        this.getFilterList().getModel();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.resetSearchVariables();
        if (e.getSource() == this.findData.getEditor().getEditorComponent()) {
            boolean state = this.findData.getEditor().getItem().toString().length() > 0;
            this.findNextButton.setEnabled(state);
            this.replaceButton.setEnabled(state);
            this.replaceAllButton.setEnabled(state);
        }
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.processFindNext();
        }
    }
}

