/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools.search;

import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.PrintfFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class RuleTypeListRenderer
extends JLabel
implements ListCellRenderer {
    private PrintfFormat typePrintFormat = new PrintfFormat("Path: %-26.46s | Value: %s)");

    public RuleTypeListRenderer() {
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setOpaque(true);
        this.setHorizontalAlignment(2);
        this.setFont(new Font("Dialog", 0, 11));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null && value instanceof Type) {
            Type node = (Type)value;
            String nodeValue = "";
            if (node.isSimple()) {
                nodeValue = node.getDisplayValue();
            }
            this.setIcon(((AbstractType)node).getMessageContextIcon());
            if (node != null) {
                this.setText(this.typePrintFormat.sprintf(new Object[]{node.getShortCaption(), nodeValue}));
            } else {
                this.setText(node.toString());
            }
        } else {
            this.setText(value == null ? "" : value.toString());
        }
        this.setBackground(isSelected ? Color.gray : Color.lightGray);
        this.setForeground(isSelected ? Color.white : Color.black);
        return this;
    }
}

