/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tooltip;

import com.jaxfront.swing.ui.tooltip.PlafMacros;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;

public class MultiLineToolTipUI
extends ToolTipUI {
    static MultiLineToolTipUI SINGLETON = new MultiLineToolTipUI();
    static boolean DISPLAY_ACCELERATOR = true;
    int accelerator_offset = 15;
    int inset = 3;

    private MultiLineToolTipUI() {
    }

    public static void initialize() {
        String key = "ToolTipUI";
        Class<?> cls = SINGLETON.getClass();
        String name = cls.getName();
        UIManager.put(key, name);
        UIManager.put(name, cls);
    }

    public static ComponentUI createUI(JComponent c) {
        return SINGLETON;
    }

    public void installUI(JComponent c) {
        LookAndFeel.installColorsAndFont(c, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(c, "ToolTip.border");
    }

    public void uninstallUI(JComponent c) {
        LookAndFeel.uninstallBorder(c);
    }

    public static void setDisplayAcceleratorKey(boolean val) {
        DISPLAY_ACCELERATOR = val;
    }

    public Dimension getPreferredSize(JComponent c) {
        Font font = c.getFont();
        FontMetrics fontMetrics = c.getFontMetrics(font);
        int fontHeight = fontMetrics.getHeight();
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        String[] lines = PlafMacros.breakupLines(tipText);
        int num_lines = lines.length;
        int height = num_lines * fontHeight;
        int width = 0;
        for (int i = 0; i < num_lines; ++i) {
            String keyText;
            int onewidth = fontMetrics.stringWidth(lines[i]);
            if (DISPLAY_ACCELERATOR && i == num_lines - 1 && !(keyText = this.getAcceleratorString((JToolTip)c)).equals("")) {
                onewidth += fontMetrics.stringWidth(keyText) + this.accelerator_offset;
            }
            width = Math.max(width, onewidth);
        }
        return new Dimension(width + this.inset * 2, height + this.inset * 2);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public void paint(Graphics g, JComponent c) {
        Font font = c.getFont();
        FontMetrics fontMetrics = c.getFontMetrics(font);
        Dimension dimension = c.getSize();
        int fontHeight = fontMetrics.getHeight();
        int fontAscent = fontMetrics.getAscent();
        String tipText = ((JToolTip)c).getTipText();
        String[] lines = PlafMacros.breakupLines(tipText);
        int num_lines = lines.length;
        g.setColor(c.getBackground());
        g.fillRect(0, 0, dimension.width, dimension.height);
        g.setColor(c.getForeground());
        int i = 0;
        int height = 2 + fontAscent;
        while (i < num_lines) {
            String keyText;
            g.drawString(lines[i], this.inset, height);
            if (DISPLAY_ACCELERATOR && i == num_lines - 1 && !(keyText = this.getAcceleratorString((JToolTip)c)).equals("")) {
                Font smallFont = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
                g.setFont(smallFont);
                g.drawString(keyText, fontMetrics.stringWidth(lines[i]) + this.accelerator_offset, height);
            }
            ++i;
            height += fontHeight;
        }
    }

    public String getAcceleratorString(JToolTip tip) {
        JComponent comp = tip.getComponent();
        if (comp == null) {
            return "";
        }
        KeyStroke[] keys = comp.getRegisteredKeyStrokes();
        String controlKeyStr = "";
        KeyStroke postTip = KeyStroke.getKeyStroke(112, 2);
        for (int i = 0; i < keys.length; ++i) {
            if (postTip.equals(keys[i])) continue;
            char c = (char)keys[i].getKeyCode();
            int mod = keys[i].getModifiers();
            if (mod == 2) {
                controlKeyStr = "Ctrl+" + (char)keys[i].getKeyCode();
                break;
            }
            if (mod != 8) continue;
            controlKeyStr = "Alt+" + (char)keys[i].getKeyCode();
            break;
        }
        return controlKeyStr;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        MultiLineToolTipUI.initialize();
        ToolTipManager.sharedInstance().setDismissDelay(100000);
        JButton button = new JButton("Hello, world");
        button.setToolTipText("Das ist ein\n test der testen soll\n ob diesesdumme\n ding auch\n funktioniert in world");
        f.getContentPane().add(button);
        f.setSize(300, 100);
        f.setVisible(true);
    }
}

