/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.swing.ui.visualizers.AbstractCompositeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractPagingView
extends AbstractCompositeView {
    private Hashtable _cachedPages;
    protected int _selectedPageIndex = 0;
    protected JPanel _pageContentPanel;
    protected JButton _nextButton;
    protected JButton _previousButton;
    protected JPanel _pagingNavPanel;

    public AbstractPagingView() {
    }

    public AbstractPagingView(Type context) {
        super(context);
    }

    protected void defaultBuild() {
        this.setLayout(new BorderLayout());
        this._pageContentPanel = new JPanel(new BorderLayout());
        this.add((Component)this._pageContentPanel, "Center");
        this.initPagingPanel();
    }

    protected Hashtable getCachedPages() {
        if (this._cachedPages == null) {
            this._cachedPages = new Hashtable();
        }
        return this._cachedPages;
    }

    private void initPagingPanel() {
        if (this.getTotalPageSize() > 1) {
            this._nextButton = new JButton(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowRight_16x16.gif"));
            this._nextButton.addActionListener(this);
            this._previousButton = new JButton(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowLeft_16x16.gif"));
            this._previousButton.addActionListener(this);
        }
        this.updatePagingNavigationPanel();
        this.drawPage();
    }

    protected void updatePagingNavigationPanel() {
        if (this._pagingNavPanel != null) {
            this.remove(this._pagingNavPanel);
        }
        this._pagingNavPanel = new JPanel(new BorderLayout());
        JPanel tempPanel = new JPanel();
        this._pagingNavPanel.add((Component)tempPanel, "West");
        JPanel buttonPanel = new JPanel();
        if (this._previousButton != null) {
            buttonPanel.add(this._previousButton);
        }
        if (this._nextButton != null) {
            buttonPanel.add(this._nextButton);
        }
        this._pagingNavPanel.add((Component)buttonPanel, "East");
        this.add((Component)this._pagingNavPanel, "North");
        int totalPages = this.getTotalPageSize();
        if (totalPages > 1) {
            JLabel pageLabel = null;
            JLabel arrowLabel = null;
            int pageIndex = 0;
            int arrowIndex = 0;
            String iconNameSmall = null;
            JPanel borderPanel = null;
            for (int i = 0; i < totalPages; ++i) {
                pageIndex = i + 1;
                iconNameSmall = TextTools.replace((String)"com/jaxfront/core/images/files/page-${x}.gif", (String)"${x}", (String)String.valueOf(pageIndex));
                String pagingTitle = this.getStyle().getPageTitle(this.getModel(), i);
                pageLabel = new JLabel(pagingTitle, JAXFrontProperties.getImageIcon((String)iconNameSmall), 4);
                borderPanel = new JPanel(new BorderLayout());
                pageLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                borderPanel.add(pageLabel);
                if (i == this._selectedPageIndex) {
                    borderPanel.setBorder(BorderFactory.createBevelBorder(1, Color.GRAY, Color.lightGray));
                }
                tempPanel.add(borderPanel);
                if (totalPages - pageIndex <= 0) continue;
                arrowIndex = pageIndex + 1;
                arrowLabel = new JLabel(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/nextArrow.gif"));
                ++pageIndex;
                tempPanel.add(arrowLabel);
            }
        }
    }

    protected abstract boolean drawPage();

    protected abstract int getTotalPageSize();

    public void setRequired(boolean aBoolean) {
    }
}

