/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.schema.SchemaSimpleType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.SimpleTypeVisualizer;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.xui.StyleDefinition;
import com.jaxfront.swing.ui.tools.FocusHelper;
import com.jaxfront.swing.ui.tools.HRefMouseAdapter;
import com.jaxfront.swing.ui.visualizers.AbstractView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public abstract class AbstractSimpleTypeView
extends AbstractView
implements ItemListener,
FocusListener,
SimpleTypeVisualizer,
KeyListener {
    protected JComponent _editorField;

    public AbstractSimpleTypeView() {
        this((Type)null);
    }

    public AbstractSimpleTypeView(Type context) {
        super(context);
    }

    private String getFixedValue() {
        if (this.getModel() != null && this.getModel().isSimple()) {
            return ((SimpleType)this.getModel()).getFixedValue();
        }
        return null;
    }

    public void setEditorField(JComponent editorField) {
        this._editorField = editorField;
    }

    protected abstract JComponent createEditorComponent();

    protected void defaultBuild() {
        StyleDefinition styleDef = this.getStyle();
        boolean isLabelVisible = styleDef.isLabelVisible();
        boolean isComponentVisible = styleDef.isEditorComponentVisible();
        boolean isComponentEditable = styleDef.isEditable();
        this.setLayout(new BorderLayout());
        if (isLabelVisible) {
            this.createLabel();
            Color labelColor = styleDef.getLabelColor();
            if (labelColor != null) {
                this.setLabelColor(labelColor);
            }
            this.showLabel(isLabelVisible);
        }
        if (isComponentVisible) {
            this._editorComponent = this.createEditorComponent();
            if (this._editorField != null) {
                if (ArrayUtil.contains((Object[])this._editorField.getFocusListeners(), (Object)this) < 0) {
                    this._editorField.addFocusListener(this);
                }
            } else if (ArrayUtil.contains((Object[])this._editorComponent.getFocusListeners(), (Object)this) < 0) {
                this._editorComponent.addFocusListener(this);
            }
            if (this._firstFocusableComponent == null) {
                this.setFirstFocusableComponent(this._editorField);
            }
            if (this.getModel().isSimple() && styleDef.isLeafComponentHRef()) {
                this._editorComponent.addMouseListener(new HRefMouseAdapter(this._editorComponent, ((SimpleType)this.getModel()).getValue()));
            }
            if (this.getEditorComponent() != null) {
                this._originalBorder = this.getEditorComponent().getBorder();
                if (this.getFixedValue() != null) {
                    this.getEditorComponent().setEnabled(false);
                }
            }
            this.setEditable(isComponentEditable);
        }
        this._visualizerPanel = this.createVisualizerPanel(this.getLabelPanel(this.getLabel()), this.getEditorComponentPanel(this.getEditorComponent()));
        this.add((Component)this.getCaptionPanel(this.getVisualizerPanel()), "Center");
        this.setParentTablePanel(this.getEditorComponentPanel());
    }

    protected short getWhiteSpaceType() {
        if (this.getModel().getSchemaType().isSimple()) {
            return ((SchemaSimpleType)this.getModel().getSchemaType()).getWhitespace();
        }
        return -1;
    }

    protected void initColor() {
        Color backGroundColor = this.getStyle().getBackgroundColor();
        Color foreGroundColor = this.getStyle().getForegroundColor();
        if (backGroundColor != null) {
            this.setBackground(backGroundColor);
        }
        if (foreGroundColor != null) {
            this.setForeground(foreGroundColor);
        }
    }

    protected double getDefaultComponentHeight() {
        StyleDefinition style = this.getStyle();
        if (style.isUsingPlugIn() || this.getModel().isList() && !style.isDialogMode() || style.isComponentMulti() || style.isLabelUnderlined() || style.isEnumerationAsRadioButton() && !style.isEnumerationOrientationHorizontal()) {
            return 0.0;
        }
        return super.getDefaultComponentHeight();
    }

    protected String getStringDefaultComponentHeight() {
        StyleDefinition style = this.getStyle();
        if (style.isUsingPlugIn() || this.getModel().isList() && !style.isDialogMode() || style.isComponentMulti() || style.isLabelUnderlined() || style.isEnumerationAsRadioButton() && !style.isEnumerationOrientationHorizontal()) {
            return "pref";
        }
        return super.getStringDefaultComponentHeight();
    }

    public void focusGained(FocusEvent e) {
        if (!e.isTemporary()) {
            JComponent view = (JComponent)e.getSource();
            this.checkHelp();
            if (view != null && this.isVisible()) {
                this.scrollToView(view);
            } else {
                this.transferFocus();
            }
        }
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.getFirstFocusableComponent() && this.getModel() != null) {
            this.populateModel();
            if (this.getEditor() != null) {
                this.getEditor().repaint();
            }
        }
    }

    public abstract String getText();

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this._optionalCheckBox) {
            SimpleType simpleType = (SimpleType)this.getModel();
            this.setEnabled(this._optionalCheckBox.isSelected(), false);
            simpleType.setSerializable(this._optionalCheckBox.isSelected());
            String defaultValue = simpleType.getDefaultValue();
            String codeset = ((SimpleType)this.getModel()).getStyle().getCodeSetName();
            if (codeset != null && defaultValue != null) {
                defaultValue = this.getDOM().getSchema().getCodeTables().getText(this.getModel(), codeset, defaultValue, this.getDOM().getLanguage());
            }
            simpleType.setValue((Object)this, defaultValue, true);
        }
    }

    public void markError() {
        FocusHelper.setBorderPanelStates(this, true);
        if (this.getEditorComponent() != null) {
            if (this._editorComponent.getBorder() == null) {
                if (this._editorComponent instanceof JTextComponent) {
                    ((JTextField)this._editorComponent).setForeground(this.getDOM().getErrorMarkingColor());
                } else {
                    Border border = BorderFactory.createEtchedBorder(this.getDOM().getErrorMarkingColor(), Color.lightGray);
                    this._editorComponent.setBorder(border);
                }
            } else {
                Border border = BorderFactory.createEtchedBorder(this.getDOM().getErrorMarkingColor(), Color.lightGray);
                this._editorComponent.setBorder(border);
            }
        }
    }

    public JComponent getEditorField() {
        if (this._editorField != null) {
            return this._editorField;
        }
        return this.getEditorComponent();
    }

    public void populateModel() {
        if (this.getModel() != null && !this.getModel().isReleased()) {
            String currentValue;
            String modelValue = ((SimpleType)this.getModel()).getValue();
            if (modelValue == null) {
                modelValue = "";
            }
            if (!modelValue.equals(currentValue = this.getText())) {
                ((SimpleType)this.getModel()).setValue((Object)this, currentValue, false);
                this.populateView();
                if (this.getEditor() != null) {
                    this.getEditor().repaint();
                }
            }
        }
    }

    public void removeLabel() {
        this._visualizerPanel = this.createVisualizerPanel(null, this.getEditorComponentPanel());
        this.removeAll();
        this.add((Component)this.getCaptionPanel(this.getVisualizerPanel()), "Center");
    }

    public void resetError() {
        if (this.getEditorComponent() != null) {
            if (this._editorComponent.getBorder() == null) {
                if (this._editorComponent instanceof JTextComponent) {
                    ((JTextField)this._editorComponent).setForeground(null);
                }
            } else if (this.getEditorComponent() instanceof JTextArea) {
                Border border = UIManager.getLookAndFeelDefaults().getBorder("TextField.border");
                this._editorComponent.setBorder(border);
            } else {
                this._editorComponent.setBorder(this._originalBorder);
            }
        }
    }

    public void setBackground(Color color) {
        if (color != null && this.getEditorField() != null) {
            this.getEditorField().setBackground(color);
        }
    }

    public void setForeground(Color color) {
        if (color != null && this.getEditorField() != null) {
            this.getEditorField().setForeground(color);
        }
    }

    public void setLabelColor(Color color) {
        if (color != null && this.getLabel() != null) {
            this.getLabel().setForeground(color);
        }
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, false);
        if (this._editorField != null) {
            this._editorField.setEnabled(enabled);
        }
    }

    public void setEditable(boolean editable) {
        if (this._editorField != null && this._editorField instanceof JTextComponent) {
            ((JTextComponent)this._editorField).setEditable(editable);
            if (editable) {
                ((JTextComponent)this._editorField).setOpaque(true);
                ((JTextComponent)this._editorField).setFocusable(true);
                this.initColor();
            } else {
                ((JTextComponent)this._editorField).setOpaque(false);
                ((JTextComponent)this._editorField).setFocusable(false);
            }
        }
    }

    private void handleAlternativeRequiredMarker(boolean required) {
        String reqErrorMarker = this.getDOM().getGlobalDefinition().getRequiredMandatoryMarker();
        if (reqErrorMarker != null && reqErrorMarker.length() > 0) {
            JComponent labcomp = this.getTableLabelComponent();
            if (labcomp == null) {
                labcomp = this.getLabel();
            }
            if (labcomp != null && labcomp instanceof JLabel) {
                String lText = ((JLabel)labcomp).getText();
                if (required) {
                    if (!lText.endsWith(reqErrorMarker)) {
                        ((JLabel)labcomp).setText(lText + reqErrorMarker);
                    }
                } else if (lText.endsWith(reqErrorMarker)) {
                    ((JLabel)labcomp).setText(lText.substring(0, lText.length() - reqErrorMarker.length()));
                }
            }
        }
    }

    public void setRequired(boolean required) {
        if (this.getEditorField() != null) {
            this.handleAlternativeRequiredMarker(required);
            if (this.getStyle().isEditable()) {
                if (this.getStyle().getBackgroundColor() != null) {
                    this.setBackground(this.getStyle().getBackgroundColor());
                } else if (required) {
                    if (this.getStyle().isApplicationRequired()) {
                        this.setBackground(this.getDOM().getApplicationFieldColor());
                    } else {
                        this.setBackground(this.getDOM().getSchemaRequiredFieldColor());
                    }
                } else {
                    this.setBackground(this.getDOM().getOptionalFieldColor());
                }
            }
        }
    }

    public void setApplicationRequired(boolean required) {
        super.setApplicationRequired(required);
        if (!required) {
            required = this.getModel().isRequired();
        }
        this.setRequired(required);
    }

    public void release() {
        this.removePropertyChangeListener(this);
        if (this._editorComponent != null) {
            this._editorComponent.removeFocusListener(this);
        }
        this._editorComponent = null;
        this._editorField = null;
        super.release();
    }

    public void setChoosenKeyContextValue(String xpathRelativeToChoosenKeyContext, String newValue) {
    }

    public SimpleType getSimpleModel() {
        return (SimpleType)this.getModel();
    }

    public void keyPressed(KeyEvent arg0) {
        boolean isLastChar = false;
        boolean isFirstChar = false;
        boolean isDeleting = false;
        int pos = -1;
        String newText = this.getText();
        if (this.getEditorField() != null && this.getText() != null && this.getEditorField() instanceof JTextComponent) {
            pos = ((JTextComponent)this.getEditorField()).getCaretPosition();
            isLastChar = pos == this.getText().length();
            isFirstChar = pos == 0;
            newText = StringUtil.insert((String)newText, (int)pos, (char)arg0.getKeyChar());
            newText = newText.trim();
        }
        boolean controlPressed = arg0.getModifiers() == 2;
        boolean dispatch = (arg0.getKeyCode() >= 31 || arg0.getKeyCode() == 0) && !arg0.isActionKey() && !controlPressed;
        switch (arg0.getKeyCode()) {
            case 9: {
                dispatch = true;
                break;
            }
            case 67: {
                if (!controlPressed) break;
                dispatch = false;
                break;
            }
            case 127: {
                dispatch = this.getText() != null && this.getText().length() > 0 && !isLastChar;
                isDeleting = true;
                break;
            }
            case 8: {
                if (this.getText() != null && this.getText().length() > 0 && !isFirstChar) {
                    dispatch = true;
                }
                isDeleting = true;
                break;
            }
            case 86: {
                if (!controlPressed) break;
                dispatch = true;
                break;
            }
            case 88: {
                if (!controlPressed || this.getText() == null || this.getText().length() <= 0) break;
                dispatch = true;
            }
        }
        if (this.getModel().isSimple() && this.getSimpleModel().isNumber()) {
            try {
                switch (this.getSimpleModel().getPrimitiveDataType()) {
                    case 6: {
                        if (this.getEditorComponent() instanceof JTextComponent) {
                            if (isDeleting) {
                                if (newText.equals("-INF")) {
                                    ((JTextComponent)this.getEditorComponent()).setText("");
                                    break;
                                }
                                if (newText.equals("INF")) {
                                    ((JTextComponent)this.getEditorComponent()).setText("");
                                    break;
                                }
                                if (!newText.equals("NaN")) break;
                                ((JTextComponent)this.getEditorComponent()).setText("");
                                break;
                            }
                            if (newText.toLowerCase().startsWith("-i")) {
                                ((JTextComponent)this.getEditorComponent()).setText("-INF");
                                break;
                            }
                            if (newText.toLowerCase().startsWith("i")) {
                                ((JTextComponent)this.getEditorComponent()).setText("INF");
                                break;
                            }
                            if (newText.toLowerCase().startsWith("n")) {
                                ((JTextComponent)this.getEditorComponent()).setText("NaN");
                                break;
                            }
                            Double.valueOf(newText);
                            break;
                        }
                        Double.valueOf(newText);
                        break;
                    }
                    case 4: {
                        new BigDecimal(newText);
                        break;
                    }
                    case 5: {
                        Float.valueOf(newText);
                        break;
                    }
                    case 30: 
                    case 34: {
                        Integer.valueOf(newText);
                        break;
                    }
                    case 33: {
                        Long.valueOf(newText);
                        break;
                    }
                    case 35: {
                        Short.valueOf(newText);
                        break;
                    }
                }
            }
            catch (Exception e) {
                dispatch = false;
            }
            if (this.getSimpleModel().isFloatingNumber() && arg0.getKeyChar() == this.getDOM().getGlobalDefinition().getDecimalSeparator()) {
                dispatch = true;
            }
        }
        if (dispatch) {
            this.getDOM().getController().fireDirtyChange();
        }
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void keyTyped(KeyEvent arg0) {
    }
}

