/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.type.ComplexGroupList;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleGroup;
import com.jaxfront.core.type.SimpleGroupList;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.ui.ListVisualizer;
import com.jaxfront.core.ui.TreeNode;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.StringTokenizer;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.visualizers.AbstractView;
import com.jaxfront.swing.ui.visualizers.ComplexGroupListView;
import com.jaxfront.swing.ui.visualizers.SimpleGroupListView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ContextView
extends AbstractView
implements ActionListener,
DOMChangeListener,
PropertyChangeListener {
    private JLabel _contextDescription;
    private JButton _contextButton;
    private JButton _goToButton;
    private JButton _cancelButton;
    private JDialog _contextListDialog;
    private String _contextLocation;
    private String _contextPathTypeName;
    private Type _keySelectorType;
    private Visualizer _contextListView;
    private FormulaExpression _contextFormEx;
    private boolean _isShowingContextButton;
    private String _okButtonAlignmentPath;
    private String _cancelButtonAlignmentPath;
    private int _okButtonPositionPath;
    private static final String LINK_TO_REFERENCE_PICTURE = "com/jaxfront/core/images/files/jump_16x16.gif";
    private static final String LINK_TO_LIST_PICTURE = "com/jaxfront/core/images/files/showList_16x16.gif";

    private void updateContextButton() {
        if (this._contextButton != null) {
            if (this.getContextList() != null) {
                if (this.getContextList().size() == 1) {
                    this._contextButton.setIcon(JAXFrontProperties.getImageIcon((String)LINK_TO_REFERENCE_PICTURE));
                    this._contextButton.setVisible(true);
                } else if (this.getContextList().size() > 1) {
                    this._contextButton.setIcon(JAXFrontProperties.getImageIcon((String)LINK_TO_LIST_PICTURE));
                    this._contextButton.setVisible(true);
                } else {
                    this._contextButton.setVisible(false);
                }
            } else {
                this._contextButton.setVisible(false);
            }
        }
    }

    public void release() {
        super.release();
        if (this.getDOM() != null) {
            this.getDOM().removeDOMChangeListener((DOMChangeListener)this);
            this.getDOM().getController().removePropertyChangeListener((PropertyChangeListener)this);
        }
        this._contextDescription = null;
        this._contextButton = null;
        this._goToButton = null;
        this._cancelButton = null;
        this._contextListDialog = null;
        this._contextLocation = null;
        this._contextPathTypeName = null;
        this._keySelectorType = null;
        this._contextListView = null;
        this._contextFormEx = null;
        this._isShowingContextButton = false;
    }

    private List getContextList() {
        if (this.getModel() != null) {
            return ((ListType)this.getModel()).getList();
        }
        return null;
    }

    public void domChanged(DOMChangeEvent event) {
        long type = event.getType();
        if (type == 4096L || type == 256L || type == 2L) {
            this.populateView();
        }
    }

    public ContextView() {
        this(false);
    }

    public ContextView(boolean showContextButton) {
        this(showContextButton, null);
    }

    public ContextView(boolean showContextButton, FormulaExpression contextFormEx) {
        this._isShowingContextButton = showContextButton;
        this._contextFormEx = contextFormEx;
    }

    protected JComponent createEditorComponent() {
        this.setLayout(new BorderLayout());
        String dialogButtonSequence = this.getStyle().getContextDialogButtonSequence();
        if (dialogButtonSequence != null && dialogButtonSequence.length() > 0) {
            String okButtonAlignment = "left";
            String cancelButtonAlignment = "right";
            int okButtonSequencePosition = 0;
            StringTokenizer tokenizer = new StringTokenizer(dialogButtonSequence, "[],");
            if (tokenizer.hasMoreTokens()) {
                String tempButtonName = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    String tempButtonAlignment = tokenizer.nextToken();
                    if (tempButtonName.equals("ok")) {
                        okButtonAlignment = tempButtonAlignment;
                        okButtonSequencePosition = 0;
                    } else {
                        cancelButtonAlignment = tempButtonAlignment;
                    }
                    if (tokenizer.hasMoreTokens()) {
                        tempButtonName = tokenizer.nextToken();
                        if (tokenizer.hasMoreTokens()) {
                            tempButtonAlignment = tokenizer.nextToken();
                            if (tempButtonName.equals("ok")) {
                                okButtonAlignment = tempButtonAlignment;
                                okButtonSequencePosition = 1;
                            } else {
                                cancelButtonAlignment = tempButtonAlignment;
                            }
                        }
                    }
                }
            }
            this._okButtonAlignmentPath = okButtonAlignment;
            this._cancelButtonAlignmentPath = cancelButtonAlignment;
            this._okButtonPositionPath = okButtonSequencePosition;
        }
        this._contextDescription = new JLabel();
        this.add((Component)this._contextDescription, "Center");
        if (this.isShowingContextButton()) {
            this._contextButton = new JButton();
            this._contextButton.addActionListener(this);
            this.add((Component)this._contextButton, "East");
        }
        this._editorComponent = this._contextDescription;
        return this._contextDescription;
    }

    public JComponent getEditorComponent() {
        return this._editorComponent;
    }

    public String getText() {
        return null;
    }

    protected void defaultBuild() {
        if (this.getDOM() != null) {
            this.getDOM().addDOMChangeListener((DOMChangeListener)this);
            this.getDOM().getController().addPropertyChangeListener((PropertyChangeListener)this);
            this.createEditorComponent();
        }
    }

    private boolean isShowingContextButton() {
        return this._isShowingContextButton;
    }

    public void markError() {
    }

    public void populateModel() {
    }

    public void populateView() {
        this.updateContextButton();
        this.updateLineInfo();
    }

    public void resetError() {
    }

    public void setLabelColor(Color color) {
    }

    public void setRequired(boolean aBoolean) {
    }

    public void setApplicationRequired(boolean aBoolean) {
    }

    public void showLabel(boolean show) {
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this._contextButton) {
            if (this.getContextList() != null) {
                if (this.getContextList().size() == 1) {
                    Type currentContext = (Type)this.getContextList().get(0);
                    this.jumpToReference(currentContext);
                } else if (this.getContextList().size() > 1) {
                    this.showContextListDialog();
                }
            }
        } else if (event.getSource() == this._goToButton) {
            boolean typeFound;
            Type selectedType = null;
            if (this._contextListView instanceof SimpleGroupListView) {
                selectedType = ((SimpleGroupListView)this._contextListView).getSelectedType();
            } else if (this._contextListView instanceof ComplexGroupListView) {
                selectedType = ((ComplexGroupListView)this._contextListView).getSelectedType();
            }
            if (selectedType != null && (typeFound = this.jumpToReference(selectedType))) {
                this.hideContextListDialog();
            }
        } else if (event.getSource() == this._cancelButton) {
            this.hideContextListDialog();
        }
    }

    private void showContextListDialog() {
        if (this.getDialog() != null) {
            this.getDialog().show();
        }
    }

    private void hideContextListDialog() {
        if (this.getDialog() != null) {
            this.getDialog().hide();
        }
    }

    private Type getReferenceTypeForContext(Type contextType) {
        Type contextPathType;
        if (contextType != null && this.getContextPathTypeName() != null && this.getContextPathTypeName().length() > 0 && (contextPathType = contextType.getChild(this.getContextPathTypeName())) != null && contextPathType.isSimple()) {
            return null;
        }
        return null;
    }

    private boolean jumpToReference(Type contextType) {
        boolean typeFound = false;
        Type referenceType = this.getReferenceTypeForContext(contextType);
        if (referenceType != null) {
            ListVisualizer listVisualizer;
            typeFound = true;
            this.hideContextListDialog();
            Type navigationElement = referenceType.getRepresentedTreeNodeParent();
            TreeNode moveToNode = this.getEditor().getTreeModel().getNode(navigationElement);
            this.getEditor().selectNode(moveToNode);
            if (referenceType.getParentList() != null && referenceType.getParentList().getXUIDefinition().getStyle().isDialogMode()) {
                Vector<JDialog> dialogsToShow = new Vector<JDialog>();
                for (Type parentType = referenceType.getParent(); parentType != null && parentType != navigationElement; parentType = parentType.getParent()) {
                    ListVisualizer listView;
                    if (parentType.getParent() == null || !parentType.getParent().isList() || (listView = (ListVisualizer)TypeVisualizerFactory.getInstance().getVisualizer(parentType.getParent())) == null) continue;
                    listView.selectType(parentType);
                    JDialog dialog = listView.getEditDialog(parentType, null);
                    if (dialog == null) continue;
                    dialogsToShow.add(0, dialog);
                }
                AbstractView referenceView = (AbstractView)TypeVisualizerFactory.getInstance().getVisualizer(referenceType);
                if (referenceView != null) {
                    referenceView.focusFirstComponent(false);
                }
                if (dialogsToShow.size() > 0) {
                    for (int a = 0; a < dialogsToShow.size(); ++a) {
                        JDialog dialog = (JDialog)dialogsToShow.get(a);
                        if (a != dialogsToShow.size() - 1) {
                            dialog.setModal(false);
                        }
                        dialog.show();
                    }
                }
            } else {
                AbstractView referenceView = (AbstractView)TypeVisualizerFactory.getInstance().getVisualizer(referenceType);
                if (referenceView != null) {
                    AbstractView viewToFocus = referenceView;
                    viewToFocus.focusFirstComponent(false);
                }
            }
            if (this.getModel().getParent() != null && this.getModel().getParent().getParentList() != null && (listVisualizer = (ListVisualizer)TypeVisualizerFactory.getInstance().getVisualizer((Type)this.getModel().getParent().getParentList())) != null && listVisualizer.getDataTable() != null) {
                listVisualizer.getDataTable().stopCellEditing();
            }
        }
        return typeFound;
    }

    private String getContextPathTypeName() {
        Type keySelectorType;
        if (this._contextPathTypeName == null && (keySelectorType = this.getKeySelectorType()) != null && this.getContextLocation() != null) {
            Type contextType;
            if (keySelectorType.isList()) {
                keySelectorType = ((ListType)keySelectorType).getEditingType();
            }
            if ((contextType = TypePathExecuter.getInstance().getTypeForXPath(keySelectorType, this.getContextLocation(), true, true)) != null) {
                this._contextPathTypeName = contextType.getName();
            }
        }
        return this._contextPathTypeName;
    }

    private String getContextLocation() {
        if (this._contextLocation == null && this.getKeySelectorType() != null) {
            this._contextLocation = this.getKeySelectorType().getXUIDefinition().getStyle().getKeyContextLocation();
        }
        return this._contextLocation;
    }

    private Type getKeySelectorType() {
        ListType keySelectorType;
        if (this._keySelectorType == null && this.getModel() != null && this.getModel().getParent() != null && this.getModel().getParent().getParentList() != null && (keySelectorType = this.getModel().getParent().getParentList()).isKey()) {
            this._keySelectorType = keySelectorType;
        }
        return this._keySelectorType;
    }

    public void setChoosenKeyValue(String xpathRelativeToChoosenKey, String newValue) {
    }

    public void setChoosenKeyContextValue(String xpathRelativeToChoosenKeyContext, String newValue) {
    }

    private FormulaExpression getContextFormEx() {
        return this._contextFormEx;
    }

    private void updateLineInfo() {
        if (this.getContextFormEx() != null) {
            try {
                this.getContextFormEx().setSource(this.getModel().getParent());
                String lineInfoValue = this.getContextFormEx().evaluate();
                if (lineInfoValue != null) {
                    this._contextDescription.setText(lineInfoValue);
                }
            }
            catch (FormulaException ex) {
                LogRegistry.getInstance().error(this.getClass(), "Could not evaluate formula expression: " + ex.getMessage());
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() != null && evt.getSource() instanceof Type && ((Type)evt.getSource()).isDerivedFrom(this.getModel())) {
            this.populateView();
        }
    }

    public void setFont(Font aFont) {
        if (aFont != null && this._contextDescription != null) {
            this._contextDescription.setFont(aFont);
        }
    }

    public void setBackground(Color color) {
        if (color != null) {
            super.setBackground(color);
            if (this._contextDescription != null) {
                this._contextDescription.setBackground(color);
            }
        }
    }

    public void setForeground(Color color) {
        if (color != null && this._contextDescription != null) {
            this._contextDescription.setForeground(color);
        }
    }

    private JDialog getDialog() {
        if (this._contextListDialog == null && this.getModel() != null) {
            Rectangle bounds;
            this._contextListDialog = GUITools.createDialogFor(this.getEditor().getWindow(), true);
            this._contextListDialog.getContentPane().setLayout(new BorderLayout());
            this._contextListDialog.addWindowListener(new WindowListener(){

                public void windowActivated(WindowEvent e) {
                }

                public void windowClosed(WindowEvent e) {
                }

                public void windowClosing(WindowEvent e) {
                }

                public void windowDeactivated(WindowEvent e) {
                }

                public void windowDeiconified(WindowEvent e) {
                }

                public void windowIconified(WindowEvent e) {
                }

                public void windowOpened(WindowEvent e) {
                }
            });
            if (this.getModel() instanceof SimpleGroupList) {
                this._contextListView = new SimpleGroupListView(this.getModel());
                ((SimpleGroupListView)this._contextListView).selectModel((SimpleGroup)this.getModel().getDirectChildren().get(0));
            } else if (this.getModel() instanceof ComplexGroupList) {
                this._contextListView = new ComplexGroupListView((ComplexGroupList)this.getModel());
            }
            if (this.getKeySelectorType() != null) {
                String title = this.getKeySelectorType().getXUIDefinition().getStyle().getKeyContextDialogLabel();
                if (title == null) {
                    title = this.getStyle().getLabelText();
                }
                this._contextListDialog.setTitle(title);
            }
            this._goToButton = new JButton(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_goto", "Go to"));
            this._cancelButton = new JButton(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_cancel", "Cancel"));
            this._goToButton.addActionListener(this);
            this._cancelButton.addActionListener(this);
            JPanel buttonPanel = new JPanel(new BorderLayout());
            if (this.getKeySelectorType() != null) {
                String okButtonAlignment = this._okButtonAlignmentPath;
                String cancelButtonAlignment = this._cancelButtonAlignmentPath;
                int okButtonPosition = this._okButtonPositionPath;
                if (okButtonAlignment.equalsIgnoreCase(cancelButtonAlignment)) {
                    JPanel buttonBoxPanel = new JPanel();
                    buttonBoxPanel.setLayout(new BoxLayout(buttonBoxPanel, 0));
                    if (okButtonPosition == 0) {
                        buttonBoxPanel.add(this._goToButton);
                        buttonBoxPanel.add(this._cancelButton);
                    } else {
                        buttonBoxPanel.add(this._cancelButton);
                        buttonBoxPanel.add(this._goToButton);
                    }
                    if (okButtonAlignment.equalsIgnoreCase("left")) {
                        buttonPanel.add((Component)buttonBoxPanel, "West");
                    } else if (okButtonAlignment.equalsIgnoreCase("right")) {
                        buttonPanel.add((Component)buttonBoxPanel, "East");
                    } else {
                        buttonPanel.add((Component)buttonBoxPanel, "Center");
                    }
                } else if (okButtonPosition == 0) {
                    if (okButtonAlignment.equalsIgnoreCase("left") && cancelButtonAlignment.equalsIgnoreCase("right")) {
                        buttonPanel.add((Component)this._goToButton, "West");
                        buttonPanel.add((Component)this._cancelButton, "East");
                    }
                } else if (okButtonAlignment.equalsIgnoreCase("right") && cancelButtonAlignment.equalsIgnoreCase("left")) {
                    buttonPanel.add((Component)this._cancelButton, "West");
                    buttonPanel.add((Component)this._goToButton, "East");
                }
            } else {
                buttonPanel.add((Component)this._goToButton, "West");
                buttonPanel.add((Component)this._cancelButton, "East");
            }
            Dimension dimension = new Dimension(600, 600);
            Point location = new Point(0, 0);
            if (this.getKeySelectorType() != null) {
                Point tempPoint = this.getKeySelectorType().getXUIDefinition().getStyle().getContextDialogLocation();
                Dimension tempDim = this.getKeySelectorType().getXUIDefinition().getStyle().getContextDialogSize();
                if (tempDim.getHeight() != -1.0 || tempDim.getWidth() != -1.0) {
                    dimension = tempDim;
                }
                if (tempPoint.getX() != -1.0 || tempPoint.getY() != -1.0) {
                    location = tempPoint;
                }
            }
            this._contextListDialog.setSize(dimension);
            if (location.getX() == 0.0 && location.getY() == 0.0) {
                bounds = this.getEditor().getWindow().getBounds();
                location.x = bounds.x + (bounds.width - this._contextListDialog.getSize().width) / 2;
                location.y = bounds.y + (bounds.height - this._contextListDialog.getSize().height) / 2;
            } else {
                bounds = this.getEditor().getBounds();
                location.x = (int)bounds.getX() + location.x;
                location.y = (int)bounds.getY() + location.y;
            }
            this._contextListDialog.setLocation(location);
            JScrollPane scroller = new JScrollPane((JComponent)this._contextListView);
            this._contextListDialog.getContentPane().add((Component)scroller, "Center");
            this._contextListDialog.getContentPane().add((Component)buttonPanel, "South");
        }
        return this._contextListDialog;
    }
}

