/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.Action;
import com.jaxfront.core.type.Type;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GeneralActionListener
implements ActionListener {
    private Action _action;
    private Type _source;
    private String _commandName;

    public GeneralActionListener(Type source, Class actionClass, String commandName) {
        this._source = source;
        this._commandName = commandName;
        this.init(actionClass);
    }

    private void init(Class actionClass) {
        try {
            if (Action.class.isAssignableFrom(actionClass)) {
                this._action = (Action)actionClass.newInstance();
                if (this._commandName != null) {
                    this._source.putClientProperty("ACTION_NAME", (Object)this._commandName);
                }
            } else if (LogRegistry.getInstance().logWarnings()) {
                LogRegistry.getInstance().warn(this.getClass(), "ActionClass: " + actionClass + " is not derived from com.jaxfront.core.rule.Action");
            }
        }
        catch (Throwable t) {
            LogRegistry.getInstance().warn(this.getClass(), "Error while creating instance-of: " + actionClass.getName() + " (reason: " + t.getLocalizedMessage() + ")");
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this._action != null) {
            if (this._commandName != null) {
                this._source.putClientProperty("ACTION_NAME", (Object)this._commandName);
            }
            this._action.perform(this._source, this._source);
        }
    }
}

