/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.type.ComplexGroup;
import com.jaxfront.core.type.ComplexGroupList;
import com.jaxfront.core.type.SimpleGroup;
import com.jaxfront.core.type.SimpleGroupList;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.SimpleTypeList;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.VirtualType;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.xui.PluginException;
import com.jaxfront.swing.ui.editor.AbstractEditorPanel;
import com.jaxfront.swing.ui.tooltip.MultiLineToolTipUI;
import com.jaxfront.swing.ui.visualizers.AbstractView;
import com.jaxfront.swing.ui.visualizers.ComplexGroupListView;
import com.jaxfront.swing.ui.visualizers.ComplexGroupView;
import com.jaxfront.swing.ui.visualizers.FormulaVisualizerView;
import com.jaxfront.swing.ui.visualizers.KeyRefView;
import com.jaxfront.swing.ui.visualizers.KeyView;
import com.jaxfront.swing.ui.visualizers.PagingView;
import com.jaxfront.swing.ui.visualizers.SimpleGroupListView;
import com.jaxfront.swing.ui.visualizers.SimpleGroupView;
import com.jaxfront.swing.ui.visualizers.SimpleTypeBooleanView;
import com.jaxfront.swing.ui.visualizers.SimpleTypeColorView;
import com.jaxfront.swing.ui.visualizers.SimpleTypeComboView;
import com.jaxfront.swing.ui.visualizers.SimpleTypeDateTimeView;
import com.jaxfront.swing.ui.visualizers.SimpleTypeDateView;
import com.jaxfront.swing.ui.visualizers.SimpleTypeDurationView;
import com.jaxfront.swing.ui.visualizers.SimpleTypeListSelectionView;
import com.jaxfront.swing.ui.visualizers.SimpleTypeListView;
import com.jaxfront.swing.ui.visualizers.SimpleTypeNumericView;
import com.jaxfront.swing.ui.visualizers.SimpleTypeRadioView;
import com.jaxfront.swing.ui.visualizers.SimpleTypeStringView;
import com.jaxfront.swing.ui.visualizers.SimpleTypeTimeView;
import com.jaxfront.swing.ui.visualizers.UIController;
import com.jaxfront.swing.ui.wrapper.RecursionWrapper;
import com.jaxfront.swing.ui.wrapper.SwingViewWrapper;
import com.sun.org.apache.xalan.internal.xsltc.runtime.Hashtable;
import java.awt.Component;
import java.util.List;
import java.util.Vector;

public class JavaSwingFactory
extends TypeVisualizerFactory {
    private static Hashtable _assignCache = new Hashtable(30);
    private final String RENDERER_ID = "JAVASWING";

    public JavaSwingFactory() {
        MultiLineToolTipUI.initialize();
    }

    public Visualizer createRecursiveView(Type type, Type context) {
        Visualizer vis = this.getVisualizerMapping(RecursionWrapper.class.getSimpleName(), type, context);
        vis = vis != null ? vis : new RecursionWrapper(type, context);
        return vis;
    }

    public Visualizer createView(ComplexGroup type, Type context) {
        Visualizer vis = null;
        if (type.getXUIDefinition().getStyle().isPagingLayout()) {
            vis = this.getVisualizerMapping(PagingView.class.getSimpleName(), (Type)type, context);
            if (vis == null) {
                vis = new PagingView(type, context);
            }
        } else {
            vis = this.getVisualizerMapping(ComplexGroupView.class.getSimpleName(), (Type)type, context);
            if (vis == null) {
                vis = new ComplexGroupView(type, context);
            }
        }
        return vis;
    }

    public Visualizer createView(ComplexGroupList type, Type context) {
        Visualizer vis = this.getVisualizerMapping(ComplexGroupListView.class.getSimpleName(), (Type)type, context);
        vis = vis != null ? vis : new ComplexGroupListView(type, context);
        return vis;
    }

    public Visualizer createView(SimpleGroup type, Type context) {
        Visualizer vis = null;
        vis = type.getXUIDefinition().getStyle().isPagingLayout() ? this.getVisualizerMapping(PagingView.class.getSimpleName(), (Type)type, context) : this.getVisualizerMapping(SimpleGroupView.class.getSimpleName(), (Type)type, context);
        if (vis == null) {
            vis = new SimpleGroupView(type, context);
        }
        return vis;
    }

    public Visualizer createView(SimpleGroupList type, Type context) {
        Visualizer vis = this.getVisualizerMapping(SimpleGroupListView.class.getSimpleName(), (Type)type, context);
        vis = vis != null ? vis : new SimpleGroupListView((Type)type, context);
        return vis;
    }

    public Visualizer createView(SimpleType type, Type context) {
        String fixedValue = type.getFixedValue();
        Visualizer vis = null;
        if (!(!type.getDOM().getGlobalDefinition().showAndSerializeFixedValues() && fixedValue != null)) {
            if (type.isKey()) {
                vis = this.getVisualizerMapping(KeyView.class.getSimpleName(), (Type)type, context);
                vis = vis != null ? vis : new KeyView(type, context);
            } else if (type.isKeyRef()) {
                vis = this.getVisualizerMapping(KeyRefView.class.getSimpleName(), (Type)type, context);
                vis = vis != null ? vis : new KeyRefView((Type)type, context);
            } else if (type.isColor()) {
                vis = this.getVisualizerMapping(SimpleTypeColorView.class.getSimpleName(), (Type)type, context);
                vis = vis != null ? vis : new SimpleTypeColorView((Type)type, context);
            } else if (type.isChoice()) {
                if (type.getXUIDefinition().getStyle().isEnumerationAsRadioButton()) {
                    vis = this.getVisualizerMapping(SimpleTypeRadioView.class.getSimpleName(), (Type)type, context);
                    vis = vis != null ? vis : new SimpleTypeRadioView(type, context);
                } else {
                    vis = this.getVisualizerMapping(SimpleTypeComboView.class.getSimpleName(), (Type)type, context);
                    vis = vis != null ? vis : new SimpleTypeComboView((Type)type, context);
                }
            } else if (type.isString()) {
                vis = this.getVisualizerMapping(SimpleTypeStringView.class.getSimpleName(), (Type)type, context);
                vis = vis != null ? vis : new SimpleTypeStringView(type, context);
            } else if (type.isBoolean()) {
                vis = this.getVisualizerMapping(SimpleTypeBooleanView.class.getSimpleName(), (Type)type, context);
                vis = vis != null ? vis : new SimpleTypeBooleanView(type, context);
            } else if (type.isNumber()) {
                vis = this.getVisualizerMapping(SimpleTypeNumericView.class.getSimpleName(), (Type)type, context);
                vis = vis != null ? vis : new SimpleTypeNumericView(type, context);
            } else if (type.isDate()) {
                vis = this.getVisualizerMapping(SimpleTypeDateView.class.getSimpleName(), (Type)type, context);
                vis = vis != null ? vis : new SimpleTypeDateView((Type)type, context);
            } else if (type.isDateTime()) {
                vis = this.getVisualizerMapping(SimpleTypeDateTimeView.class.getSimpleName(), (Type)type, context);
                vis = vis != null ? vis : new SimpleTypeDateTimeView(type, context);
            } else if (type.isTime()) {
                vis = this.getVisualizerMapping(SimpleTypeTimeView.class.getSimpleName(), (Type)type, context);
                vis = vis != null ? vis : new SimpleTypeTimeView(type, context);
            } else if (type.isDuration()) {
                vis = this.getVisualizerMapping(SimpleTypeDurationView.class.getSimpleName(), (Type)type, context);
                vis = vis != null ? vis : new SimpleTypeDurationView(type, context);
            } else {
                vis = this.getVisualizerMapping(SimpleTypeStringView.class.getSimpleName(), (Type)type, context);
                vis = vis != null ? vis : new SimpleTypeStringView(type, context);
            }
        }
        return vis;
    }

    public Visualizer createView(SimpleTypeList type, Type context) {
        Visualizer vis = null;
        if (type.isUsingPredefinedSelection()) {
            vis = this.getVisualizerMapping(SimpleTypeListSelectionView.class.getSimpleName(), (Type)type, context);
            vis = vis != null ? vis : new SimpleTypeListSelectionView((Type)type, context);
        } else {
            vis = this.getVisualizerMapping(SimpleTypeListView.class.getSimpleName(), (Type)type, context);
            vis = vis != null ? vis : new SimpleTypeListView(type, context);
        }
        return vis;
    }

    public Visualizer createView(VirtualType type, Type context) {
        Visualizer vis = this.getVisualizerMapping(FormulaVisualizerView.class.getSimpleName(), (Type)type, context);
        vis = vis != null ? vis : new FormulaVisualizerView(type, context);
        return vis;
    }

    public Visualizer getPluginFor(Type type, Type context) throws PluginException {
        Visualizer plugIn = super.getPluginFor(type, context);
        if (plugIn != null) {
            try {
                ((Component)plugIn).addFocusListener(UIController.getInstance());
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return plugIn;
    }

    public Visualizer createVisualizerFor(Type type, Type context) {
        Visualizer visualizer = super.createVisualizerFor(type, context);
        if (!this.isDerivedFromAbstractView(visualizer.getImplementation().getClass())) {
            return new SwingViewWrapper(visualizer);
        }
        return visualizer;
    }

    public boolean isDerivedFromAbstractView(Class to) {
        Object cObj = _assignCache.get((Object)to);
        if (cObj == AbstractView.class) {
            return true;
        }
        if (cObj == to) {
            return false;
        }
        if (AbstractView.class.isAssignableFrom(to)) {
            _assignCache.put((Object)to, (Object)AbstractView.class);
            return true;
        }
        _assignCache.put((Object)to, (Object)to);
        return false;
    }

    public void releaseCache(Document DOM) {
        this.releaseCache(DOM, true);
    }

    public void releaseCache(Document DOM, boolean releaseEditor) {
        AbstractEditorPanel editor;
        super.releaseCache(DOM, releaseEditor);
        if (releaseEditor && (editor = (AbstractEditorPanel)this.getEditor(DOM)) != null) {
            this.getEditors().remove(DOM);
            editor.release();
        }
    }

    public AbstractEditorPanel removeEditor(Document DOM) {
        return (AbstractEditorPanel)this.getEditors().remove(DOM);
    }

    public void removeVisualizerStructure(Visualizer vis, boolean includeRoot) {
        if (vis != null) {
            Vector vises = this.getVisualizerStructure(vis, includeRoot);
            if (includeRoot) {
                TypeVisualizerFactory.getInstance().releaseCache(vis.getModel());
            }
            for (int i = vises.size() - 1; i >= 0; --i) {
                Visualizer aVis = (Visualizer)vises.get(i);
                if (aVis.getModel() == null) continue;
                TypeVisualizerFactory.getInstance().releaseCache(aVis.getModel());
            }
        }
    }

    public void removeVisualizerStructure(Type visType, boolean includeRoot) {
        if (visType != null) {
            List childs = DOMHelper.getAllVisStructureChilds((Type)visType, (boolean)includeRoot);
            for (int i = childs.size() - 1; i >= 0; --i) {
                Type aChild = (Type)childs.get(i);
                TypeVisualizerFactory.getInstance().releaseCache(aChild);
            }
        }
    }

    public Vector getVisualizerStructure(Type start, boolean includingRoot) {
        List childs = DOMHelper.getAllVisStructureChilds((Type)start, (boolean)includingRoot);
        Vector vises = new Vector();
        for (int c = 0; c < childs.size(); ++c) {
            Type aChild = (Type)childs.get(c);
            this.getAllVisualizers(vises, aChild);
        }
        return vises;
    }

    public Vector getVisualizerStructure(Visualizer vis, boolean includingRoot) {
        Vector visis = this.getVisualizerStructure(vis.getModel(), includingRoot);
        return visis;
    }

    public boolean isSwingFactory() {
        return true;
    }

    public String getRendererID() {
        return "JAVASWING";
    }
}

